<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
class ReportesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(request $request)
    {
        //

        // return $request;
        // {"r":"7650149-1","fi":"2022-09-28","ff":"2022-09-29"}

        // $databases = App\bd_proveedores::selectDB();

        $rut = $request->r;
        $fecha_inicio =$request->fi;
        $fecha_fin =$request->ff;

        // foreach ($databases as $los_datos) {

        $instalaciones = DB::connection('kyocera')->table('instalacions')
        ->join("asignacion_instalacions","asignacion_instalacions.lista_instalacion_id","=","instalacions.id") 
        ->join("trabajadors","trabajadors.id","=","asignacion_instalacions.trabajadors_id")
        ->join("personas","personas.id","=","trabajadors.id_persona")
        ->select(
            DB::raw("'instalaciones' as tipo"), // Define el alias personalizado aquí
            'instalacions.sCliente' ,    
            'instalacions.proveedor_instalacion as proveedor',  
            'instalacions.sDireccion', 
            'instalacions.sEstado_instalacion as estado', 
           DB::raw("asignacion_instalacions.fecha_inicio as fechaAtencion"), // Define el alias personalizado aquí
           'instalacions.sModelo', 
           'instalacions.sSerie', 
           'instalacions.sSC', 
           'instalacions.sCiudad', 
       )
       ->where("personas.rut","=",$rut)
       ->whereBetween("asignacion_instalacions.fecha_inicio", [$fecha_inicio, $fecha_fin]);

       $retiros = DB::connection('kyocera')->table('retiros')
       ->join("asignacion_retiros","asignacion_retiros.retiros_id","=","retiros.id") 
       ->join("trabajadors","trabajadors.id","=","asignacion_retiros.trabajadors_idtecnico")
       ->join("personas","personas.id","=","trabajadors.id_persona")
       ->select(
            DB::raw("'retiros' as tipo"), // Define el alias personalizado aquí
           'retiros.sCliente' ,    
           'retiros.proveedor_retiro as proveedor',  
           'retiros.sDireccion', 
           'retiros.estado_retiro_Cord as estado',
           DB::raw("asignacion_retiros.fecha_retiro as fechaAtencion"), // Define el alias personalizado aquí
           'retiros.sModelo', 
           'retiros.sSerie', 
           DB::raw('null as sSC'),
           'retiros.sCiudad',
      )
      ->where("personas.rut","=",$rut)
      ->whereBetween("asignacion_retiros.fecha_retiro", [$fecha_inicio, $fecha_fin]);

      $solicitudes = DB::connection('kyocera')->table('api_solicitudes')
       ->join("asignacion_solicitudes","asignacion_solicitudes.api_solicitudes_id","=","api_solicitudes.id") 
       ->join("trabajadors","trabajadors.id","=","asignacion_solicitudes.trabajadors_id")
       ->join("personas","personas.id","=","trabajadors.id_persona")
       ->select(
            DB::raw("'solicitudes' as tipo"), // Define el alias personalizado aquí
           'api_solicitudes.sCliente',    
           'api_solicitudes.proveedor_servicio as proveedor',  
           'api_solicitudes.sDireccion', 
           'api_solicitudes.estado_interno as estado',
           DB::raw("asignacion_solicitudes.fecha_inicio as fechaAtencion"), // Define el alias personalizado aquí
           'api_solicitudes.sModelo', 
           'api_solicitudes.sSerie', 
           'api_solicitudes.sSC', 
           'api_solicitudes.sComuna	 as sCiudad', 
      )
      ->where("personas.rut","=",$rut)
      ->whereBetween("asignacion_solicitudes.fecha_inicio", [$fecha_inicio, $fecha_fin])
      ->union($instalaciones)

      ->union($retiros)->get();
     
      return $solicitudes;
        dd( $solicitudes);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
