@extends('menu/menu')
{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js%22%3E</script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>
{{-- <link  href="{{ asset('css/a&a_style.css') }}" href="a&a_style.css" rel="stylesheet" type="text/css"> --}}

<button class="mt-1" onclick="topFunction()" id="myBtn" title="Go to top">
  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-arrow-up-circle-fill" viewBox="0 0 16 16">
    <path d="M16 8A8 8 0 1 0 0 8a8 8 0 0 0 16 0zm-7.5 3.5a.5.5 0 0 1-1 0V5.707L5.354 7.854a.5.5 0 1 1-.708-.708l3-3a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1-.708.708L8.5 5.707V11.5z"/>
  </svg>
</button>

@section('content')

@if ( session('mensaje') )
    <div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

<div class="container mt-5">
  <div class="title-vista mt-4">Retiro</div>
</div>

<form action="{{route('go.filtrar_pdf_retiro')}}" method="get">
  <!--@csrf-->
  <div class="container mt-4">
    <div class="seccion-filtro">Filtrar por</div> 
    <hr class="separador">
    <!-- BARRA DE BUSQUEDA -->
      
    <div class="row">
      <!--AQUI SE CARGA EL SELECT DE PROYECTO-->
      <div class="col-sm-3 form-group">
        <label for="proyectos">Proyecto</label>
        <select id="proyectos" name="proyectos" class="custom-select mayuscula">
          <option value="" selected>seleccionar</option>
          @if(!empty($proyectos))
            @foreach ($proyectos  as $los_datos3)
              @if($los_datos3->id_proyecto == $proyectosRe)
              <option selected value="{{$los_datos3->id_proyecto}}">{{$los_datos3->nombre." (".$los_datos3->razon_social.")" }}  </option>
              @else
              <option value="{{$los_datos3->id_proyecto}}">{{$los_datos3->nombre." (".$los_datos3->razon_social.")" }}  </option>
              @endif
            @endforeach
          @endif
        </select>
      </div>

      <!--AQUI SE CARGA EL SELECT DE REGION-->
      <div class="col-sm-3 form-group">
        <label for="region">Region</label>
        <div class="input-group d-flex">
          <select  id="region" name="region" class="custom-select mayuscula">
            <option  selected disabled>seleccionar</option>
              @if (!empty($regiones))
              @foreach ($regiones as $datos1)
              @if ($datos1->sRegion != null)
              @if($datos1->sRegion == $region)
                <option  selected value="{{ $datos1->sRegion }}">{{ucfirst(strtolower($datos1->sRegion))}} </option>
              @else
                <option   value="{{ $datos1->sRegion }}">{{ucfirst(strtolower($datos1->sRegion))}} </option>
              @endif
              @endif
              @endforeach
            @endif
          </select>
          <div class="input-group-append">
            <a onclick="actualizar_regiones()" class="btn app-color">
              <span class="material-icons-round">refresh</span> 
            </a>
          </div>
        </div>
      </div>

      <!--AQUI SE CARGA EL SELECT DE COMUNA-->
      <div class="col-sm-3 form-group">
        <label for="comuna">Comuna</label>
        <select id="comuna" name="comuna" class="custom-select mayuscula">
          <option  selected disabled>seleccionar</option>
            @if (!empty($comunas))
            @foreach ($comunas as $datos2)
            @if ($datos2->sComuna != null)                    
            @if( $datos2->sComuna === $comuna)
              <option  selected value="{{ $datos2->sComuna }}">{{ucfirst(strtolower($datos2->sComuna))}}
            @else
              <option   value="{{ $datos2->sComuna }}">{{ucfirst(strtolower($datos2->sComuna))}}
            @endif
            @endif
          </option>
          @endforeach
          @endif
        </select>
      </div>

      <!--AQUI SE CARGA EL SELECT DE direccion-->
      <div class="col-sm-3 form-group">
        <label for="direccion">Dirección</label>
        <select  class="custom-select mayuscula" id="direccion" name="direccion">
          <option  selected disabled>seleccionar</option>
            @if (!empty($direcciones))
            @foreach ($direcciones as $datos2)
            @if ($datos2->sDireccion != null)                    
            @if( $datos2->sDireccion === $direccion)
              <option  selected value="{{ $datos2->sDireccion }}">{{ucfirst(strtolower($datos2->sDireccion))}}
            @else
              <option   value="{{ $datos2->sDireccion }}">{{ucfirst(strtolower($datos2->sDireccion))}}
            @endif
            @endif
          </option>
          @endforeach
          @endif
        </select>
      </div>

      <div class="col-sm-3 form-group">
        <label for="Serie">Serie</label>
        <input type="" class="form-control mayuscula" id="Serie" name="Serie" placeholder="Nº de Serie" value="{{$Serie ?? ''}}">
      </div>
    </div>
    <!-- FIN BARRA DE BUSQUEDA -->
  </div>

  <div class="container text-center">
    <button type="submit" class="btn btn-prim px-sm-5">Buscar</button>
  </div>  
</form>

  


<div class="container mt-5 p-0">
  <ul class="nav bg-export">
    <li class="clas-item">
      <a class="btn btn-ter" target="_blank" href="{{route('go.excel_retiro') ?? ''}}"> Exportar excel
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16" class="bi bi-file-earmark-excel-fill">
          <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM5.884 6.68 8 9.219l2.116-2.54a.5.5 0 1 1 .768.641L8.651 10l2.233 2.68a.5.5 0 0 1-.768.64L8 10.781l-2.116 2.54a.5.5 0 0 1-.768-.641L7.349 10 5.116 7.32a.5.5 0 1 1 .768-.64z"></path>
        </svg>
      </a>
    </li>
    <li>
      <button class="btn btn-ter" style="">
        @if(!empty($mostrarMenu))
          @if($mostrarMenu == "si")
            <a href="{{route('go.getalldonwload2',$urls ?? '')}}">
              <span class="material-icons-round">file_download</span> 
              Descargar
            </a>
          @endif
        @endif
    </button>
    </li>
  </ul>
</div>


<!-- TABLA DE RESULTADOS DE BUSQUEDA -->
<div class="container table-responsive p-sm-0">
    <table class="table table-striped table-hover table-bordered" id="gridData">
      <!-- ENCABEZADO -->
      <thead class="color-head">
        <tr>
          <th class="th-head border-th separador-v" colspan="1">Fecha de Retiro</th>
          <th class="th-head border-th separador-v" colspan="1">Estado (Kyocera)</th>
          <th class="th-head border-th separador-v" colspan="1">Estado Retiro</th>
          <th class="th-head border-th separador-v" colspan="1">Cliente</th>
          <th class="th-head border-th separador-v" colspan="1">Región</th>
          <th class="th-head border-th separador-v" colspan="1">Comuna</th>
          <th class="th-head border-th separador-v" colspan="1">Dirección</th>
          <th class="th-head border-th separador-v" colspan="1">CUI</th>
          <th class="th-head border-th separador-v" colspan="1">Serie</th>
          <th class="th-head border-th separador-v" colspan="1">PDF</th>
        </tr>
      </thead>
      <!-- FIN ENCABEZADO -->

      <!-- RESULTADOS -->
      <tbody id="myTable">
        @if(!empty($rutapdf))
        @foreach ($rutapdf as $datos)
        <tr>
          <td class="td-val">
            @if($datos->fecha_retiroCord != null )
            {{Carbon\Carbon::createFromDate($datos->fecha_retiroCord)->format('d-m-Y')}}
            @else 
              Sin Fecha
            @endif
          </td>
          <td class="td-val">{{$datos->sEstado}}<br>
            @if($datos->instalador != null)
            ( {{$datos->instalador}})
            @else 
            @endif
          </td>
          <td class="td-val"> {{$datos->estado_retiro_Cord}}</td>
          <td class="td-val"> {{$datos->sCliente}}</td>
          <td class="td-val"> {{$datos->sRegion}}</td>        
          <td class="td-val"> {{$datos->sComuna}}</td>
          <td class="td-val"> {{$datos->sDireccion}}</td>
          <td class="td-val"> {{$datos->sCui}}</td>
          <td class="td-val"> {{$datos->sSerie}}</td>
          <td class="td-val">
            <a class="btn-icon btn-icon-dd"  href="{{route('go.donwload2',$datos->url_pdf)}}">
              <span class="material-icons-round">picture_as_pdf</span>
            </a>
          </td>
        </tr>
      @endforeach
      @endif
    </tbody>
    <!-- FIN RESULTADOS -->
  </table>
  @if(!empty($retiros))
  {{ $retiros->appends(request()->query())->links() }}
  @endif
</div>
  <!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->

  </div>
  @endsection

  <script>
  $(document).ready(function(){
    $("#Serie").on("keyup", function() {
    var value = $(this).val().toLowerCase();
    $("#myTable tr").filter(function() {
      $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
    });
    });
  });
  </script>
<script>
  $(document).ready(function(){
    $('#vaciar').click(function() {
      $('#fecha').val("");
    });
  });

  function actualizar_regiones(){
           var _token = $('input[name="_token"]').val();

           $.ajax({
                  method:"GET",

                  url:"{{ route('go.actualizarregiones') }}",

                  data: {   _token:_token},

              success: function(data) {
                    alert("proceso Completado");
                    location.reload();

                },

              error: function(xhr, status) {
                  alert('Disculpe, ha ocurrido un problema, intente mas tarde');
               }

          });

}
</script>

<script>

    $(document).ready(function(){
  
     
  
      $("#region").change(function(){
             region = $('select[id=region]').val();
             var _token = $('input[name="_token"]').val();
  
             $.ajax({
                    method:"POST",
  
                    url:"{{ route('buscarComunasRetiros') }}",
  
                    data: { 'region': region,  _token:_token},
  
                success: function(data) {
                  $("#comuna").empty();
                  $("#direccion").empty();
                  $("#sucursal").empty();
                  $("#comuna").append('<option value="">Seleccionar</option>');
                  $("#direccion").append('<option value="">Seleccionar</option>');
                  $("#sucursal").append('<option value="">Seleccionar</option>');
                  $(data).each(function(i, v){ // indice, valor
                    //if(v.sComuna != null || v.sComuna != "null"  ){ 
                        $("#comuna").append('<option value="' + v.sComuna + '">' + v.sComuna + '</option>');
                          })
                   // }
  
                  },
  
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                 }
  
            });
    });
    $("#comuna").change(function(){
      comuna = $('select[id=comuna]').val();
             var _token = $('input[name="_token"]').val();
  
  
  
             $.ajax({
                    method:"POST",
  
                    url:"{{ route('buscarDireccionesRetiros') }}",
  
                    data: { 'comuna': comuna,  _token:_token},
  
                success: function(data) {
                  $("#direccion").empty();
                  $("#sucursal").empty();
                  $("#direccion").append('<option value="">Seleccionar</option>');
                  $("#sucursal").append('<option value="">Seleccionar</option>');
  
                  $(data).each(function(i, v){ // indice, valor
                    //if(v.sdireccion != null || v.sdireccion != "null"  ){ 
                        $("#direccion").append('<option value="' + v.sDireccion + '">' + v.sDireccion + '</option>');
                          })
                   // }
  
                  },
  
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                 }
  
            });
    });
  
 
  
      
  });
  
      </script>