@extends('menu/menu')

{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js"></script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>




@section('content')

@if ( session('mensaje') )
    <div class="alert alert-success">{{ session('mensaje') }}</div>
    {{-- <a class="dropdown-item" href="{{route('go_see_clien')}}" style="text-align: right"> <button class="btn btn-success">Clientes</button></a>  --}}

@endif
{{-- {{$api_instalaciones}} --}}

<div class="container mt-5">
  <div class="title-vista mt-4">CHECKLIST DE INSTALACIÓN DE EQUIPOS</div>
</div>

  
<!-- BARRA DE BUSQUEDA -->

<form action="{{route('create.checklist' , Crypt::encryptString($api_instalaciones[0]->id_instalacion)) }} " method="POST">
  @csrf
  <div class="container mt-5">
    <div class="seccion-filtro">Asignación</div> 
    <hr class="separador">

    <div class="row">
          
      <!-- Fila 1 ------------------------------------------------------>
      <div class="col-sm-6 form-group">
        <label for="">Técnico asignado</label>
        <select name="tecnico" class="custom-select mayuscula">
          <option value="" selected>SELECCIONE</option>
            @if(!empty($trabajadores))
            @foreach ($trabajadores   as $los_datos)
              <option value="{{$los_datos->id}}" >{{$los_datos->nombre_uno. " ".$los_datos->apellido_uno. " ".$los_datos->apellido_dos }}  </option>
            @endforeach
            @endif
        </select>
        @error('tecnico')
          <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
    
      <div class="col-sm-3 form-group">
        <label for="">Nº de visita</label>
        <input type="number" class="form-control mayuscula" id="" value="{{$total_dias}}" style="pointer-events: none"  readonly="readonly" placeholder="Nº DE VISITA" name="numero_visita">
        @error('numero_visita')
          <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>

      <div class="col-sm-3 form-group">
        <label for="">Tipo de visita</label>
        <select name="tipo_visita" class="custom-select mayuscula">
          <option value="" selected>SELECCIONE</option>
          @if(!empty($tipos_visitas))
            @foreach ($tipos_visitas   as $los_datos)
              <option value="{{$los_datos->id}}">{{$los_datos->descripcion}}  </option>
            @endforeach
          @endif
        </select>
        @error('tipo_visita')
          <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
      
      <!-- Fila 2 ------------------------------------------------------>
      <div class="col-sm-6 form-group">
        <label for="">Proyecto asociado</label>
        <select name="proyectos" class="custom-select mayuscula">
          <option value="" selected>SELECCIONE</option>
          @if(!empty($proyectos))
          @foreach ($proyectos   as $los_datos)
            <option value="{{$los_datos->id_proyecto}}">{{$los_datos->nombre." (".$los_datos->razon_social.")" }}  </option>
          @endforeach
          @endif
        </select>
        @error('proyectos')
          <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
        
      <div class="col-sm-6 form-group">
        <label for="">Fecha Instalación</label>
        <input type="date"  class="form-control mayuscula" id="" placeholder="FECHA" name="fecha_instalacion"  value="" name="">
        @error('proyectos')
          <div class="alert alert-danger">{{ $message }}</div>
        @enderror
      </div>
    </div>


    <div class="seccion-filtro">Detalle del Cliente</div> 
    <hr class="separador">

    <div class="row">
          
      <!-- Fila 2 ------------------------------------------------------>
      <div class="col-sm-3 form-group">
          <label for="">Cliente</label>
          <input type="" class="form-control mayuscula" id="" placeholder="CLIENTE" name="" style="pointer-events: none"  readonly="readonly" placeholder="DIRECCIÓN" value="{{$api_instalaciones[0]->sCliente}}" name="">
      </div>

      <div class="col-sm-3 form-group">
        <label for="">Fecha</label>
        <input type="" class="form-control mayuscula" id="" placeholder="FECHA" name=""  style="pointer-events: none"  readonly="readonly" placeholder="DIRECCIÓN" value="{{$api_instalaciones[0]->dFecha_instalacion}}" name="">
      </div>

      <div class="col-sm-3 form-group">
        <label for="">Hora de inicio</label>
        <input type="" class="form-control mayuscula" id="" placeholder="HORA DE INICIO" style="pointer-events: none" readonly="readonly" name="">
      </div>

      <div class="col-sm-3 form-group">
        <label for="">Hora de termino</label>
        <input type="" class="form-control mayuscula" id="" placeholder="HORA DE TERMINO" style="pointer-events: none" readonly="readonly" name="">
      </div>

      <!-- Fila 3 ------------------------------------------------------>
      <div class="col-sm-6 form-group">
        <label for="">Dirección</label>
        <input type="" class="form-control mayuscula" id="" style="pointer-events: none" readonly="readonly" placeholder="DIRECCIÓN" value="{{$api_instalaciones[0]->sDireccion}}" name="">
      </div>

      <div class="col-sm-3 form-group">
        <label for="">Comuna</label>
        <input type="" class="form-control mayuscula" id="" placeholder="COMUNA" name="" style="pointer-events: none" readonly="readonly" value="{{$api_instalaciones[0]->sComuna}}">
      </div>

      <!-- Fila 4 ------------------------------------------------------>
      <div class="col-sm-6 form-group">
        <label for="">Contacto</label>
        <input type="" class="form-control mayuscula" id="" placeholder="CONTACTO" name="" style="pointer-events: none" readonly="readonly" value="{{$api_instalaciones[0]->sContacto}}">
      </div>

      <div class="col-sm-3 form-group">
        <label for="">SC</label>
        <input type="" class="form-control mayuscula" id="" placeholder="SC" name=""  style="pointer-events: none" readonly="readonly" value="{{$api_instalaciones[0]->sSC}}">
      </div>

      <div class="col-sm-3 form-group">
        <label for="">CUI o Código Sucursal</label>
        <input type="" class="form-control mayuscula" id="" placeholder="CUI O CÓDIGO SUCURSAL" name=""   style="pointer-events: none" readonly="readonly" value="{{$api_instalaciones[0]->sCui}}">
      </div>
    </div>


    <div class="seccion-filtro">Detalle de Equipamiento</div> 
    <hr class="separador">

    <div class="row">
      <!-- Fila 5 ------------------------------------------------------>
      <div class="col-sm-3 form-group">
        <label for="">Marca</label>
        <input type="" class="form-control mayuscula" id="" placeholder="MARCA" name="" style="pointer-events: none" readonly="readonly">
      </div>

      <div class="col-sm-3 form-group">
        <label for="">Serie</label>
        <div class="input-group d-flex">
          <input type="" class="form-control mayuscula" id="idserie" placeholder="SERIE" name="" style="pointer-events: none" readonly="readonly" value="{{$api_instalaciones[0]->sSerie}}">
          <div class="input-group-append">
            <a class="btn app-color" href="" data-toggle="modal" data-target="#modalserie">
              <span class="material-icons-round">edit</span>
            </a>
          </div>
        </div>
      </div>

      <div class="col-sm-3 form-group">
        <label for="">Modelo</label>
        <div class="input-group d-flex">
          <input type="" class="form-control mayuscula" id="idmodelo" placeholder="MODELO" name="" style="pointer-events: none" readonly="readonly" value="{{$api_instalaciones[0]->sModelo}}">
          <div class="input-group-append">
            <a class="btn app-color" href="" data-toggle="modal" data-target="#modalmodelo">
              <span class="material-icons-round">edit</span>
            </a>
          </div>
        </div>
      </div>

      <div class="col-sm-3 form-group checkbox d-flex check-space mt-sm-3">
        <div class="custom-control custom-checkbox pr-sm-3">
          <input type="checkbox" class="custom-control-input" id="multi" name="multi" value="multifunsional" disabled>
          <label class="custom-control-label" for="multi">Multifuncional</label>
        </div>
        <div class="custom-control custom-checkbox">
          <input type="checkbox" class="custom-control-input" id="impre" name="impre" value="impresora" disabled>
          <label class="custom-control-label" for="impre">Impresora</label>
        </div>
      </div>

      <!-- Fila 6 ------------------------------------------------------>
      <div class="col-sm-3 form-group checkbox check-space mt-sm-3">
        <div class="custom-control custom-checkbox">
          <input type="checkbox" class="custom-control-input" class="custom-check mayuscula" id="cambio" name="cambio" disabled  readonly="readonly" value="cambio-de-serie">
          <label class="custom-control-label" for="cambio">Cambio de serie</label>
        </div>
      </div>

      <div class="col-sm-3 form-group">
        <label for="">Serie de remplazo</label>
        <input type="" class="form-control mayuscula" id="" placeholder="SERIE DE REMPLAZO" style="pointer-events: none" readonly="readonly" name="">
      </div>

      <div class="col-sm-3 form-group">
        <label for="">Modelo de remplazo</label>
        <input type="" class="form-control mayuscula" id="" placeholder="MODELO DE REMPLAZO"  style="pointer-events: none" readonly="readonly" name="">
      </div>
      
      <div class="col-sm-3 form-group">
        <label for="">IP</label>
        <input type="" class="form-control mayuscula" id="" placeholder="IP" name="" style="pointer-events: none" readonly="readonly" value="{{$api_instalaciones[0]->sIP}}">
      </div>

      <!-- Fila 7 ------------------------------------------------------>
      <div class="col-sm-3 form-group">
        <label for="">Software</label>
        <select name="comuna" class="custom-select mayuscula" style="pointer-events: none"  disabled>
          <option value="">Seleccionar</option>
        </select>
      </div>

      <div class="col-sm-3 form-group">
        <label for="">Mask</label>
        <input type="" class="form-control mayuscula" id="" placeholder="MASK" name="" style="pointer-events: none" readonly="readonly" value="{{$api_instalaciones[0]->sMsk}}">
      </div>

      <div class="col-sm-3 form-group">
        <label for="">Gateway</label>
        <input type="" class="form-control mayuscula" id="" placeholder="GATEWAY" name="" style="pointer-events: none" readonly="readonly" value="{{$api_instalaciones[0]->sGateway}}">
      </div>

      <div class="col-sm-3 form-group">
        <label for="">Contador B/N</label>
        <input type="" class="form-control mayuscula" id="" placeholder="CONTADOR B/N" name="" style="pointer-events: none" readonly="readonly" value="{{$api_instalaciones[0]->nContador}}">
      </div>

      <!-- Fila 8 ------------------------------------------------------>
      <div class="col-sm-3 form-group">
        <label for="">Contador color</label>
        <input type="" class="form-control mayuscula" id="" placeholder="CONTADOR COLOR" name="" style="pointer-events: none" readonly="readonly" value="{{$api_instalaciones[0]->nContador_color}}">
      </div>

      <div class="col-sm-9 form-group"></div>
    </div>



    <div class="row">
      <div class="col-sm-6">
        <div class="seccion-filtro">Accesorios</div> 
        <hr class="separador">

        <div class="row">
          <div class="col-md-6 form-group checkbox check-space mt-sm-3">
            @if($api_instalaciones[0]->sBandeja_adicional != "")
              <div class="custom-control custom-checkbox">
                <input type="checkbox" class="custom-control-input" checked  id="band-ad" name="band-ad" value="bandeja-adicional">                 
                <label class="custom-control-label" for="band-ad">Bandeja adicional</label>
              </div>
            @else
              <div class="custom-control custom-checkbox">
                <input type="checkbox" class=" custom-checkbox" disabled id="band-ad" name="band-ad" value="bandeja-adicional">                 
                <label for="band-ad">Bandeja adicional</label>
              </div>
            @endif 
          </div>

          <div class="col-sm-6 form-group ">
            <label for="">Modelo de bandeja</label>
            <input type="" class=" custom-select mayuscula" id="" placeholder="MODELO DE BANDEJA" name=""  style="pointer-events: none" readonly="readonly"  value="{{$api_instalaciones[0]->sBandeja_adicional}}">
          </div>

          <div class="col-sm-6 form-group checkbox check-space mt-sm-3">
            @if($api_instalaciones[0]->sMueble != "")
              <div class="custom-control custom-checkbox">
                <input type="checkbox" class="custom-control-input" checked id="band-ad" name="band-ad" value="bandeja-adicional">
                <label class="custom-control-label" for="band-ad">Mueble</label>
              </div>
            @else 
              <div class="custom-control custom-checkbox">
                <input type="checkbox" class="custom-control-input" id="band-ad" name="band-ad" value="bandeja-adicional">
                <label class="custom-control-label" for="band-ad">Mueble</label>
              </div>
            @endif    
          </div>

          <div class="col-sm-6 form-group check-space mt-sm-3">
            @if($api_instalaciones[0]->sCable_red != "")
              <div class="custom-control custom-checkbox">
                <input type="checkbox" class="custom-control-input" checked id="band-ad" name="band-ad" value="bandeja-adicional">
                <label class="custom-control-label" for="band-ad">Cable red</label>
              </div>
            @else 
              <div class="custom-control custom-checkbox">
                <input type="checkbox" class="custom-control-input" id="band-ad" name="band-ad" value="bandeja-adicional">
                <label class="custom-control-label" for="band-ad">Cable red</label>
              </div>
            @endif
          </div>

          <div class="col-sm-6 form-group check-space mt-sm-3">
            @if($api_instalaciones[0]->sMueble != "")
            <div class="custom-control custom-checkbox">
              <input type="checkbox" class="custom-control-input" id="band-ad" checked name="band-ad" value="bandeja-adicional">
              <label class="custom-control-label" for="band-ad">Kit lector</label>
            </div>
            @else 
            <div class="custom-control custom-checkbox">
                <input type="checkbox" class="custom-control-input" id="band-ad" name="band-ad" value="bandeja-adicional">
                <label class="custom-control-label" for="band-ad">Kit lector</label>
            </div>
            @endif    
          </div>

          <div class="col-sm-6 form-group check-space mt-sm-3">
            @if($api_instalaciones[0]->sCable_poder != "")
              <div class="custom-control custom-checkbox">
                <input type="checkbox" class="custom-control-input" checked id="band-ad" name="band-ad" value="bandeja-adicional">
                <label class="custom-control-label" for="band-ad">Cable de poder</label>
              </div>
            @else 
              <div class="custom-control custom-checkbox">
                <input type="checkbox" class="custom-control-input" id="band-ad" name="band-ad" value="bandeja-adicional">
                <label class="custom-control-label" for="band-ad">Cable de poder</label>
              </div>
            @endif
          </div>

          <div class="col-sm-6 form-group check-space mt-sm-3">
            @if($api_instalaciones[0]->sSD != "")
              <div class="custom-control custom-checkbox">
                <input type="checkbox" class="custom-control-input" checked id="band-ad" name="band-ad" value="bandeja-adicional">
                <label class="custom-control-label" for="band-ad">Memoria SD</label>
              </div>
            @else 
              <div class="custom-control custom-checkbox">
                <input type="checkbox" class="custom-control-input" id="band-ad" name="band-ad" value="bandeja-adicional">
                <label class="custom-control-label" for="band-ad">Memoria SD</label>
              </div>
            @endif
          </div>
        </div>
      </div>

      <div class="col-sm-6">
        <div class="seccion-filtro">Accesorios</div> 
        <hr class="separador">

        <div class="row">
          <div class="col-md-6 form-group">
            <label for="">Tipo de conexión</label>
            <select name="comuna" class="custom-select mayuscula" disabled>
            <option selected>SELECCIONE</option>
                <option value="F-A">F-A</option>
               <option value="F-B">F-B</option>
            <option value="F-C">F-C</option>
            </select>
          </div>

          <div class="col-md-6 form-group checkbox check-space mt-sm-3">
            <div class="custom-control custom-checkbox">
              <input type="checkbox" class="custom-control-input" id="band-ad" name="band-ad" value="bandeja-adicional" disabled>
              <label class="custom-control-label" for="band-ad">Conexión eléctrica</label>
            </div>
          </div>

          <div class=" col-md-6 form-group offset-lg-0">
            <label for="">Nombre servidor</label>
            <select name="comuna" class="custom-select mayuscula" disabled>
            <option selected>SELECCIONE</option>
                <option value="F-A">F-A</option>
               <option value="F-B">F-B</option>
            <option value="F-C">F-C</option>
            <option value="F-D">F-D</option>
            <option value="F-E">F-E</option>
            <option value="F-F">F-F</option>
            <option value="F-G">F-G</option>
            <option value="F-H">F-H</option>
            <option value="F-I">F-I</option>
               <option value="F-J">F-J</option>
            </select>
          </div>

          <div class="col-md-6 form-group checkbox check-space mt-sm-3">
            <div class="custom-control custom-checkbox">
              <input type="checkbox" class="custom-control-input" id="band-ad" name="band-ad" value="bandeja-adicional" disabled>
              <label class="custom-control-label" for="band-ad">Servidor de impresión</label>
            </div>
          </div>

          <div class="col-lg-3 form-group checkbox check-space mt-sm-3">
            <div class="custom-control custom-checkbox">
              <input type="checkbox" class="custom-control-input" id="band-ad" name="band-ad" value="bandeja-adicional" disabled>
              <label class="custom-control-label" for="band-ad">Config. SMB</label>
            </div>
          </div>
          <div class="col-lg-3 form-group checkbox check-space mt-sm-3">
            <div class="custom-control custom-checkbox">
              <input type="checkbox" class="custom-control-input" id="band-ad" name="band-ad" value="bandeja-adicional" disabled>
              <label class="custom-control-label" for="band-ad">Config. </label>
            </div>
          </div>

          <div class="col-lg-6 form-group checkbox bg-seccion-filtro check-space mt-sm-3">
            <div class="custom-control custom-checkbox">
              <input type="checkbox" class="custom-control-input" id="modo-U253" name="modo-U253" value="modo-U253" disabled>
              <label class="custom-control-label" for="modo-U253">modo U253</label>
            </div>
          </div>

          <div class="col-md-6 form-group checkbox check-space mt-sm-3">
            <div class="custom-control custom-checkbox">
              <input type="checkbox" class="custom-control-input" id="band-ad" name="band-ad" value="bandeja-adicional" disabled>
              <label class="custom-control-label" for="band-ad">Instalación de driver manual</label>
            </div>
          </div>

          <div class="col-md-6 form-group">
            <label for="">Cantidad de usuarios</label>
            <input type="" class="form-control mayuscula" id="" placeholder="Cantidad de usuarios" name="" disabled>
          </div>
        </div>
      </div>



      
 
        
   <div class="container form-group my-5">
    
   <!-- <a href="{{ url()->previous() }}" class="btn btn-default">Volver</a> -->

    <button type=submit class="btn btn-prim px-sm-5 float-sm-right guardar" type="button">GUARDAR</button>
      </div>
   
 
    </div>
  </div>
</form>   
<!-- Modal Serie-->
<div class="modal fade" id="modalserie" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="seccion-modal">Cambiar serie</h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador ml-4 mr-4">
      <div class="modal-body">
        <div class="container">
          <div class="row">
            <div class="col-sm-12 form-group">
              <input class="form-control mayuscula" type="text" id="serie_cambio" placeholder="{{$api_instalaciones[0]->sSerie}}">
              <input class=" form-control mayuscula" type="hidden" value="{{$api_instalaciones[0]->id_instalacion ?? ''}}" id="id_check">
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-prim w-25 mx-auto" id="cambiarserie">Guardar</button>
      </div>
    </div>
  </div>
</div>
<!-- Modal modelo-->
<div class="modal fade" id="modalmodelo" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="seccion-modal">Cambiar Modelo</h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador ml-4 mr-4">
      <div class="modal-body">
        <div class="container">
          <div class="row">
            <div class="col-sm-12 form-group">
              <input class="form-control mayuscula" type="text" id="modelo_cambio" placeholder="{{$api_instalaciones[0]->sModelo}}">
              <input class=" form-control mayuscula" type="hidden" value="{{$api_instalaciones[0]->id_instalacion ?? ''}}" id="id_check">
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-prim w-25 mx-auto" id="cambiarmodelo">Guardar</button>
      </div>
    </div>
  </div>
</div>
<!-- FIN BARRA DE BUSQUEDA -->
@endsection
<script>
  $(document).ready(function() {
        $("#cambiarserie").click(function() {
          serie = $("#serie_cambio").val();
          id_check = $("#id_check").val();
          var _token = $('input[name="_token"]').val();
          $.ajax({
            headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: "{{ route('cambiodeserieasignar') }}",
            type: "post",
            data: {
              'serie': serie,
              'id_check': id_check
            },
            success: function(response) {
              console.log(response);
              $("#idserie").val(response);
              $('#modalserie').modal('toggle');
            },
            error: function(xhr, status) {
              alert('Disculpe, ha ocurrido un problema, intente mas tarde');
            }
          })
        });
        $("#cambiarmodelo").click(function() {
          serie = $("#modelo_cambio").val();
          id_check = $("#id_check").val();
          var _token = $('input[name="_token"]').val();
          $.ajax({
            headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: "{{ route('cambiodemodeloasignar') }}",
            type: "post",
            data: {
              'serie': serie,
              'id_check': id_check
            },
            success: function(response) {
              console.log(response);
              $("#idmodelo").val(response);
              $('#modalmodelo').modal('toggle');
            },
            error: function(xhr, status) {
              alert('Disculpe, ha ocurrido un problema, intente mas tarde');
            }
          })
        });
      });
</script>
 
