<!--<script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js</script>--> 


<?php $__env->startSection('content'); ?>

<?php if( session('mensaje') ): ?>
<div class="alert alert-success"><?php echo e(session('mensaje')); ?></div>
<?php endif; ?>

<div class="container mt-5">
    <div class="title-vista mt-4">Mantenedor kilometros</div>
</div>

<div class="container">
    <!-- BARRA DE BUSQUEDA -->
    <form action="<?php echo e(route('filtros_mantenedor_kilometros')); ?>" method="GET">
        <?php echo csrf_field(); ?>
        
        <!-- Fila 1 Detalle de cliente ------------------------------------------------------>
        <div class="seccion-filtro">Filtrar por</div> 
        <hr class="separador">

        <div class="row">
            <!--AQUI SE CARGA EL SELECT DE CIUDAD BASE-->
            <div class="col-sm-4 form-group">
                <label for="clientes">Ciudad Base</label>
                <select name="ciudad_base" class="custom-select mayuscula" id="buscarciudades">
                    <option selected disabled>Seleccionar</option>
                    <?php $__currentLoopData = $ciudad_base; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datos_ciudad_base): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($datos_ciudad_base->id); ?>"><?php echo e(ucfirst(strtolower($datos_ciudad_base->ciudad_base))); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <!--AQUI SE CARGA EL SELECT DE CIUDAD DESTINO-->
            <div class="col-sm-4 form-group">
                <label for="ciudadesrelacionadas">Ciudad</label>
                <select name="ciudad_destino" class="custom-select mayuscula" id="ciudadesrelacionadas">
                    <option selected disabled>Seleccionar</option>
                    <?php $__currentLoopData = $ciudades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ciudad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($ciudad->ciudad); ?>"><?php echo e(ucfirst(strtolower($ciudad->ciudad))); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <!--FIN SELECT DE CLIENTE-->
            <div class="col-sm-12 text-center my-5">
                <button type="buscar" class="btn btn-prim w-25">Buscar</button>
            </div>
    </div>
    </form>
    <!-- FIN BARRA DE BUSQUEDA -->
    

</div>

<div class="container mt-5">
    <div class="container p-0 bg-export">
        <div class="clearfix">
            <button class="btn btn-ter py-2 px-3 float-right" data-toggle="modal" data-target="#modalCrear">
                <span class="material-icons-round icon-midle">note_add</span><strong>Crear registro</strong>
            </button>
        </div>
    </div>     

    <!-- TABLA DE RESULTADOS DE BUSQUEDA -->
    <div class="container table-responsive mb-5 p-sm-0">
        <div class="table table-striped table-hover">
            <table class="table table-striped table-hover text-center">

                <!-- ENCABEZADO -->
                <thead class="color-head">
                    <tr>
                        <th class="th-head border-th" colspan="1">#</th>
                        <th class="th-head border-th" colspan="1">iudad Base</th>
                        <th class="th-head border-th" colspan="1">Ciudad Destino</th>
                        <th class="th-head border-th" colspan="1">Kilometros</th>
                        <th class="th-head border-th" colspan="1"><span class="material-icons">settings</span></th>
                    </tr>
                </thead>
                <!-- FIN ENCABEZADO -->

                <!-- RESULTADOS -->
                <tbody>
                    <?php if(!empty($kilometros)): ?>
                    <?php $__currentLoopData = $kilometros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $los_datos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="td-val"><?php echo e($los_datos->id); ?></td>
                            <!-- CIUDAD BASES -->
                            <?php if($los_datos->id_ciudad_bases == 1): ?><td class="td-val">Iquique</td>
                            <?php elseif($los_datos->id_ciudad_bases == 2): ?><td class="td-val">Antofagasta</td>
                            <?php elseif($los_datos->id_ciudad_bases == 3): ?><td class="td-val">Copiapo</td>
                            <?php elseif($los_datos->id_ciudad_bases == 4): ?><td class="td-val">La Serena</td>
                            <?php elseif($los_datos->id_ciudad_bases == 5): ?><td class="td-val">Valparaiso</td>
                            <?php elseif($los_datos->id_ciudad_bases == 6 || $los_datos->id_ciudad_bases == 7): ?><td class="td-val">Talca</td>
                            <?php elseif($los_datos->id_ciudad_bases == 8): ?><td class="td-val">Concepción</td>
                            <?php elseif($los_datos->id_ciudad_bases == 9): ?><td class="td-val">Temuco</td>
                            <?php elseif($los_datos->id_ciudad_bases == 10): ?><td class="td-val">Osorno</td>
                            <?php elseif($los_datos->id_ciudad_bases == 11): ?><td class="td-val">Puerto Aysen</td>
                            <?php elseif($los_datos->id_ciudad_bases == 12): ?><td class="td-val">Punta Arenas</td>
                            <?php elseif($los_datos->id_ciudad_bases == 13): ?><td class="td-val">Santiago</td>
                            <?php elseif($los_datos->id_ciudad_bases == 14): ?><td class="td-val">Osorno</td>
                            <?php elseif($los_datos->id_ciudad_bases == 15): ?><td class="td-val">Arica</td>
                            <?php endif; ?>

                            <!-- CIUDAD DESTINO -->
                            <td class="td-val"><?php echo e($los_datos->ciudad); ?></td>

                            <!-- KILOMETROS -->
                            <td class="td-val"><?php echo e($los_datos->kilometros); ?></td>
                            <td class="td-val ">
                                <div class="d-flex justify-content-around">
                                    <a title="modificar" role="button" class="btn-icon btn-icon-dd ver_historial_instalacion editarkilometros" data-id="<?php echo e($los_datos->id); ?>">                               
                                        <span class="material-icons-round">edit</span>                         
                                    </a>                             
                                    <a class="btn-icon btn-icon-dd ver_historial" data-toggle="modal" data-target="#modalEliminar" data-idEliminar="<?php echo e($los_datos->id); ?>">                               
                                        <span class="material-icons">delete</span>                         
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                </tbody>
                <!-- FIN RESULTADOS -->
            </table>
            <div style="margin: 10px 0px 10px 300px;">
                <?php echo e($kilometros->links()); ?>

            </div>
        </div>
    </div>
<!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->
</div> 

<!-- Modal Eliminar-->
<div class="modal fade" id="modalEliminar" tabindex="-1" role="dialog" aria-labelledby="modalEliminarLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">

        <div class="modal-header">
          <div class="seccion-modal" id="modalEliminarLabel"></div>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <hr class="separador ml-4 mr-4">

        <div class="modal-body">
            <div class="text-center">¿Realmente desea eliminar este registro?</div>
        </div>
        <form action="<?php echo e(route('deleteRegistro')); ?>" method="GET">
            <input type="text" name="idkilometros" id="idKilometrosEliminar" style="display: none" hidden>
            <div class="modal-footer">
                <button type="submit" class="btn btn-prim w-25">Si, eliminar</button>
                <button type="button" class="btn btn-secundario w-25" data-dismiss="modal">Cancelar</button>
            </div>
        </form>
      </div>
    </div>
  </div>

<!-- Modal crear-->
<div class="modal fade" id="modalCrear" tabindex="-1" role="dialog" aria-labelledby="modalCrearLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">

            <div class="modal-header">
            <div class="seccion-modal" id="modalCrearLabel">Nuevo registro</div>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            </div>
            <hr class="separador ml-4 mr-4">

            <form action="<?php echo e(route('crearKilometros')); ?>" method="GET">
                <div class="modal-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-12 form-group">
                                <label for="cBase">Ciudad Base</label>
                                <select id="cBase" class="form-control mayuscula" name="cBase">
                                <?php $__currentLoopData = $ciudad_base; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $los_datos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option  value="<?php echo e($los_datos->id); ?>"><?php echo e($los_datos->ciudad_base); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            </div>
                            <div class="col-sm-12 form-group">
                                <label for="cOrigen">Ciuda Origen</label>
                                <input type="text" required class="form-control mayuscula" name="cOrigen" id="cOrigen">
                            </div>
                            <div class="col-sm-12 form-group">
                                <label for="crearKilometros">Kilometros</label>
                                <input type="text" required class="form-control mayuscula" id="crearKilometros" name="crearKilometros">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-prim w-50 mx-auto">Guardar cambios</button>
                </div>
            </form>
        </div>
    </div>
</div>



<!-- MODAL EDITAR KILOMETROS-->
<div class="modal" id="modalkilometros" data-backdrop="static">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form action="<?php echo e(route('go.editar_kilometros')); ?>" method="post">
            <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <div class="seccion-modal">Modificar costos</div>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <hr class="separador ml-4 mr-4">

                <div class="modal-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-12 form-group">
                                <input type="text" class="form-control mayuscula" id="kilometros" value="" placeholder="" name="kilometros" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;">
                                <input type="hidden" id="id_kilometro" name="id">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-prim w-25 mx-auto">Modificar</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<!-- FIN MODAL EDITAR KILOMETROS-->
<script src="<?php echo e(asset('js/jquery-3.4.1.min.js')); ?>" ></script>

<script>
    
    $(document).ready(function() {

        $('#buscarciudades').change(function() {
            var valorSeleccionado = $(this).val();
            console.log(valorSeleccionado);
            var _token = $('input[name="_token"]').val();
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                method: "POST",
                url: "<?php echo e(route('go.ver_datos_kilometros_filtros')); ?>",
                data: {
                    'id': valorSeleccionado,
                    _token: _token
                },
                success: function(data) {
                    // $("#kilometros").val(data.kilometros);
                    console.log("datas");

                    console.log(data);
                    $('#ciudadesrelacionadas').empty();
                $('#ciudadesrelacionadas').append(data);

                },
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                }
            });

            // Aquí puedes realizar cualquier acción que necesites con el valor seleccionado
        });
        
        $('.eliminarKilometros').click(function() {
            var id = $(this).attr("data-idEliminar");
            alert(id);
            $("#idKilometrosEliminar").val(id);
        });
        //editar kilometros
        $('.editarkilometros').click(function() {
            var id = $(this).attr("data-id");
            $("#id_kilometro").val(id);
            var _token = $('input[name="_token"]').val();
            $("#modalkilometros").modal('show');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                method: "POST",
                url: "<?php echo e(route('go.ver_datos_kilometros')); ?>",
                data: {
                    'id': id,
                    _token: _token
                },
                success: function(data) {
                    $("#kilometros").val(data.kilometros);
                },
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                }
            });
        });
    });
</script>
<?php echo $__env->make('menu/menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sistema/sistemacaja/resources/views/check/ver_mantenedor_kilometros.blade.php ENDPATH**/ ?>