<!DOCTYPE html>
<html lang="en">
<?php $mes = date('d/m/Y');
header('Content-type: application/vnd.ms-excel');
header("Content-Disposition: attachment; filename=InformeInstalacionesfecha$mes.xls");
header("Pragma: no-cache");
header("Expires: 0");  ?>

<body>
  <table class="table table-bordered table-responsive-lg table-striped table-hover" style="margin: 0" id="gridData">
    <!-- ENCABEZADO -->
    <thead>
      <tr>
        <th class="container-2">
          <h3>Cliente</h3>
        </th>
        <th class="container-1">
          <h3>Proyecto Asociado</h3>
        </th>
        <?php if(Auth::user()->tipo_usuario == "administrador" || Auth::user()->tipo_usuario == "coordinador"): ?>
        <th class="container-1">
          <h3>T&eacute;cnico</h3>
        </th>
        <?php endif; ?>
        <th class="container-1">
          <h3>Fecha de Recepci&oacute;n</h3>
        </th>
        <th class="container-1">
          <h3>Asignaci&oacute;n coordinadora</h3>
        </th>
        <th class="container-2">
          <h3>Fecha inicio</h3>
        </th>
        <th class="container-2">
          <h3>Fecha fin</h3>
        </th>
        <th class="container-2">
          <h3>Estado Despacho</h3>
        </th>
        <th class="container-2">
          <h3>Estado Instalaci&oacute;n</h3>
        </th>
        <th class="container-2">
          <h3>Regi&oacute;n</h3>
        </th>
        <th class="container-2">
          <h3>Comuna</h3>
        </th>
        <th class="container-2">
          <h3>Direcci&oacute;n | CUI</h3>
        </th><?php /*?>Agregue una nueva columna  - FITO<?php */ ?>
        <th class="container-2">
          <h3>Sede</h3>
        </th>
        <th class="container-2">
          <h3>Id sala</h3>
        </th>
        <th class="container-2">
          <h3>N&deg; de serie</h3>
        </th>
        <th class="container-2">
          <h3>Marca</h3>
        </th>
        <th class="container-2">
          <h3>Modelo</h3>
        </th>
     
        <!--SALIENTE-->
        <th class="container-2">
          <h3>N&deg; de serie saliente</h3>
        </th>
        <th class="container-2">
          <h3>Marca saliente</h3>
        </th>
        <th class="container-2">
          <h3>Modelo saliente</h3>
        </th>
        <th class="container-2">
          <h3>Observaci&oacute;n</h3>
        </th>
        
      </tr>
    </thead>
    <!-- FIN ENCABEZADO -->
    <!-- RESULTADOS -->
    <tbody>
      <?php if(!empty($instalaciones)): ?>
      <?php $__currentLoopData = $instalaciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $los_datos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
      <tr>
        <td><?php echo e($los_datos->sCliente ?? ''); ?></td>
        <?php
          $fechas = DB::table('asignacion_instalacions')
          ->join("checklist_instalacions","checklist_instalacions.asignacion_instalacion_retiro_id","=","asignacion_instalacions.id")
          ->join("trabajadors","trabajadors.id","=","asignacion_instalacions.trabajadors_id")
          ->join("personas","personas.id","=","trabajadors.id_persona")  
          ->select(
                  'checklist_instalacions.fecha_inicio',
                  'checklist_instalacions.fecha_fin',
                  'checklist_instalacions.CsSerie_es',
                  'checklist_instalacions.CsModelo_es',
                  'checklist_instalacions.CsMarca_es',
                  'checklist_instalacions.observacion',
                  'checklist_instalacions.Csmarca as marca_check',

                  

                  
                  'personas.nombre_uno','personas.apellido_uno'
          )
          ->where('asignacion_instalacions.lista_instalacion_id','=',$los_datos->id)
          ->orderBy('checklist_instalacions.id', 'desc')
          ->get();

          $fecha_inicio = "";
          $fecha_fin = "";
          $nombre_uno = "";
          $apellido_uno = "";
          $marca = "";
          if(count($fechas) != 0){
            if($fechas[0]->fecha_inicio != "" || $fechas[0]->fecha_fin != "" ){
              $fecha_inicio = Carbon\Carbon::createFromDate($fechas[0]->fecha_inicio)->format('d-m-Y H:i:s');
              $fecha_fin = Carbon\Carbon::createFromDate($fechas[0]->fecha_fin)->format('d-m-Y H:i:s');
            }
            $nombre_uno = $fechas[0]->nombre_uno;
            $apellido_uno = $fechas[0]->apellido_uno;

            $marca  =$fechas[0]->marca_check ?? '';

          }else{

            $marca  =    $los_datos->smarca ?? '';
          }
        ?>
        <?php if($los_datos->nombre == "Global"): ?>
        <td>No Asignado</td>
        <?php else: ?>
        <td><?php echo e($los_datos->nombre ?? ''); ?></td>
        <?php endif; ?>
        <?php if(Auth::user()->tipo_usuario == "administrador" || Auth::user()->tipo_usuario == "coordinador"): ?>
        <td><?php echo e($nombre_uno ?? ''); ?> <?php echo e($apellido_uno ?? ''); ?></td>
        <?php endif; ?>
        <?php if($los_datos->fecha_registrado != ""): ?>
        <td><?php echo e(Carbon\Carbon::createFromDate($los_datos->fecha_registrado)->format('d-m-Y')); ?></td>
        <?php else: ?>
        <td>No registra</td>
        <?php endif; ?>
        <?php if($los_datos->fecha_instalacion_coordinadora != ""): ?>
        <td><?php echo e(Carbon\Carbon::createFromDate($los_datos->fecha_instalacion_coordinadora)->format('d-m-Y')); ?></td>
        <?php else: ?>
        <td>No registra</td>
        <?php endif; ?>
        <td><?php echo e($fecha_inicio); ?></td>
        <td><?php echo e($fecha_fin); ?></td>
        <?php if($los_datos->sEstado_despacho != null || $los_datos->sEstado_despacho != ""): ?>
        <td style="text-transform: uppercase"> <?php echo e(ucfirst($los_datos->sEstado_despacho ?? 'no informado')); ?></td>
        <?php else: ?>
        <td></td>
        <?php endif; ?>
        <?php if($los_datos->sEstado_instalacion != null || $los_datos->sEstado_instalacion != ""): ?>
        <td style="text-transform: uppercase"> <?php echo e(ucfirst($los_datos->sEstado_instalacion ?? 'no informado')); ?></td>
        <?php else: ?>
        <td></td>
        <?php endif; ?>
        <td><?php echo e($los_datos->sRegion ?? ''); ?></td>
        <td><?php echo e($los_datos->sComuna ?? ''); ?></td>
        <td><?php echo e($los_datos->sDireccion ?? ''); ?></td>

        <?php if($los_datos->sTipo_sucursal != null || $los_datos->sTipo_sucursal != ""): ?>
        <td><?php echo e($los_datos->sTipo_sucursal ?? ''); ?></td>
        <?php else: ?>
        <td></td>
        <?php endif; ?>

        <?php if($los_datos->idSala != null || $los_datos->idSala != ""): ?>
        <td><?php echo e($los_datos->idSala ?? ''); ?></td>
        <?php else: ?>
        <td></td>
        <?php endif; ?>


        <?php if($los_datos->remplazo != null || $los_datos->remplazo != ""): ?>
        <td><?php echo e($los_datos->remplazo ?? ''); ?></td>
        <?php else: ?>
        <td><?php echo e($los_datos->sSerie ?? ''); ?></td>
        <?php endif; ?>
        <td><?php echo e($marca); ?></td>

        <td><?php echo e($los_datos->sModelo ?? ''); ?></td>

        <?php if(count($fechas) != 0): ?>
        <td><?php echo e($fechas[0]->CsSerie_es); ?></td>
        <?php endif; ?>
        <?php if(count($fechas) != 0): ?>
        <td><?php echo e($fechas[0]->CsModelo_es); ?></td>
        <?php endif; ?>
        <?php if(count($fechas) != 0): ?>
        <td><?php echo e($fechas[0]->CsMarca_es); ?></td>
        <?php endif; ?>
        <td><?php echo e($los_datos->observacion ?? $fechas[0]->observacion ?? ''); ?></td>

        
       


      </tr>
      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      <?php endif; ?>
    </tbody>
    <!-- FIN RESULTADOS -->
  </table>
</body>

</html><?php /**PATH /var/www/html/sistema/sistemacaja/resources/views/check/excel/excel_instalacioncordinadora.blade.php ENDPATH**/ ?>