<script src="<?php echo e(asset('js/jquery-3.4.1.min.js')); ?>"></script>
<link href="<?php echo e(asset('css/graficos-style.css')); ?>" rel="stylesheet">

<?php $__env->startSection('content'); ?>
<?php if( session('mensaje_error') ): ?>
<div class="alert alert-success"><?php echo e(session('mensaje_error')); ?></div>
<?php endif; ?>


<?php if(Auth::user()->tipo_usuario == "coordinador" || Auth::user()->tipo_usuario == "administrador"): ?>
<input type="hidden" class="tipoUsuario" value="coordinador">
<div class="posicion-seguimiento">
    <div class="container-seguimiento">
        <button type="button" class="btn btn-seguimiento" data-toggle="modal" data-target="#seguimiento">
            <img src="../sistemacaja/public/img/seguimiento_icon.svg" alt="" width="96">
            <span>HACER SEGUIMIENTO</span>
        </button>
    </div>
</div>
<?php endif; ?>

<div class="container mt-5">
    <div class="row pt-5 pt-lg-1 justify-content-center">
        <?php if(Auth::user()->tipo_usuario == "trabajador"): ?>
        <div class="col-sm-3 mb-2"><a class="btn btn-prim btn-block" href="<?php echo e(route('go_add_gastos')); ?>">Agregar un Gasto</a></div>
        <div class="col-sm-3 mb-2"><a class="btn btn-prim btn-block" href="<?php echo e(route('go_see_gastos')); ?>">Mis Gastos</a></div>
        <div class="col-sm-3 mb-2"><a class="btn btn-prim btn-block" href="<?php echo e(route('mis_depositos')); ?>">Depósitos</a></div>
        <div class="col-sm-3 mb-2"><a class="btn btn-prim btn-block" href="<?php echo e(route('mifirma')); ?>">Agregar Firma</a></div>
        <?php elseif(Auth::user()->tipo_usuario == "coordinador" || Auth::user()->tipo_usuario == "administrador"): ?>
        <div class="col-sm-3 mb-2"><a class="btn btn-prim btn-block" href="<?php echo e(route('home_ins_ret')); ?>">Instalacion/Retiros</a></div>
        <div class="col-sm-3 mb-2"><a class="btn btn-prim btn-block" href="<?php echo e(route('home_servicio')); ?>">Servicios</a></div>
        <?php endif; ?>
    </div>
</div>
<div class="container mt-2">
    <?php
    $proveedor_actual = DB::connection()->getDatabaseName();
    ?>
    <input type="hidden" value="<?php echo e($proveedor_actual); ?>" class="proveedoractual">
    <div class="seccion-filtro color-azul mt-4">Seccion Instalacion/Retiros</div>
    <hr class="separador">
    <div class="row">
        <div class="col-lg-6">
            <div class="row">
                <?php if(Auth::user()->tipo_usuario == "coordinador" || Auth::user()->tipo_usuario == "administrador"): ?>
                <div class="col-sm-6 mt-2">
                    <div class="card estado revisar_pendientes_coordinador" type="button" data-toggle="modal" data-target="#aPendientes" aria-readonly="">
                        <div class="card-body border-lg rounded-3">
                            <div class="seccion-filtro color-azul">Atenciones pendientes</div>
                            <hr class="separador">
                            <h5 class="cantidad-solicitud d-inline"><?php echo e($suma_pendientes_coordinador); ?></h5>
                            <h6 class="seccion-filtro mb-2 d-inline">Solicitudes</h6>
                            <button type="button" class="btn btn-ter d-block mx-auto mt-4 revisar_pendientes_coordinador" data-toggle="modal" data-target="#aPendientes">Revisar</button>
                        </div>
                    </div>
                </div>
                <?php elseif(Auth::user()->tipo_usuario == "trabajador"): ?>
                <div class="col-sm-6 mt-2">
                    <div class="card estado revisar_pendientes" type="button" data-toggle="modal" data-target="#aPendientes">
                        <div class="card-body border-lg rounded-3">
                            <div class="seccion-filtro color-azul">Atenciones pendientes</div>
                            <hr class="separador">
                            <h5 class="cantidad-solicitud d-inline"><?php echo e($suma_pendientes); ?></h5>
                            <h6 class="seccion-filtro mb-2 d-inline">Solicitudes</h6>
                            <button type="button" class="btn btn-ter d-block mx-auto mt-4 revisar_pendientes" data-toggle="modal" data-target="#aPendientes">Revisar</button>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php if(Auth::user()->tipo_usuario == "coordinador" || Auth::user()->tipo_usuario == "administrador"): ?>
                <div class="col-sm-6 mt-2 revisar_porasignar">
                    <div class="card estado" type="button" class="btn btn-ter d-block mx-auto mt-4" data-toggle="modal" data-target="#aporAsignar">
                        <div class="card-body border-lg rounded-3">
                            <div class="seccion-filtro color-azul">Atenciones por asignar</div>
                            <hr class="separador">
                            <h5 class="cantidad-solicitud d-inline"><?php echo e($suma_porasignar_coordinador); ?></h5>
                            <h6 class="seccion-filtro mb-2 d-inline">Solicitudes</h6>
                            <button type="button" class="btn btn-ter d-block mx-auto mt-4 revisar_porasignar" data-toggle="modal" data-target="#aporAsignar">Revisar</button>
                        </div>
                    </div>
                </div>
                <?php elseif(Auth::user()->tipo_usuario == "trabajador"): ?>
                <div class="col-sm-6 mt-2">
                    <div class="card estado revisar_rechazado" type="button" class="btn btn-ter d-block mx-auto mt-4" data-toggle="modal" data-target="#aRechazadas">
                        <div class="card-body border-lg rounded-3">
                            <div class="seccion-filtro color-azul">Atenciones rechazadas</div>
                            <hr class="separador">
                            <h5 class="cantidad-solicitud d-inline"><?php echo e($suma_rechazado); ?></h5>
                            <h6 class="seccion-filtro mb-2 d-inline">Solicitudes</h6>
                            <button type="button" class="btn btn-ter d-block mx-auto mt-4 revisar_rechazado">Revisar</button>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="col-lg-6">
            <div class="row">
                <?php if(Auth::user()->tipo_usuario == "coordinador" || Auth::user()->tipo_usuario == "administrador"): ?>
                <div class="col-sm-6 mt-2">
                    <div class="card estado revisar_encurso_coordinador" type="button" class="btn btn-ter d-block mx-auto mt-4" data-toggle="modal" data-target="#aenCurso">
                        <div class="card-body border-lg rounded-3">
                            <div class="seccion-filtro color-azul">Atenciones en curso</div>
                            <hr class="separador">
                            <h5 class="cantidad-solicitud d-inline"><?php echo e($suma_encursos_coordiandor); ?></h5>
                            <h6 class="seccion-filtro mb-2 d-inline">Solicitudes</h6>
                            <button type="button" class="btn btn-ter d-block mx-auto mt-4 revisar_encurso_coordinador" data-toggle="modal" data-target="#aenCurso">Revisar</button>
                        </div>
                    </div>
                </div>
                <?php elseif(Auth::user()->tipo_usuario == "trabajador"): ?>
                <div class="col-sm-6 mt-2">
                    <div class="card estado revisar_encurso" type="button" class="btn btn-ter d-block mx-auto mt-4" data-toggle="modal" data-target="#aenCurso">
                        <div class="card-body border-lg rounded-3">
                            <div class="seccion-filtro color-azul">Atenciones en curso</div>
                            <hr class="separador">
                            <h5 class="cantidad-solicitud d-inline"><?php echo e($suma_encursos); ?></h5>
                            <h6 class="seccion-filtro mb-2 d-inline">Solicitudes</h6>
                            <button type="button" class="btn btn-ter d-block mx-auto mt-4 revisar_encurso" data-toggle="modal" data-target="#aenCurso">Revisar</button>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php if(Auth::user()->tipo_usuario == "coordinador" || Auth::user()->tipo_usuario == "administrador"): ?>
                <div class="col-sm-6 mt-2">
                    <div class="card estado revisar_porreasignar" type="button" class="btn btn-ter d-block mx-auto mt-4" data-toggle="modal" data-target="#aparaReasignar">
                        <div class="card-body border-lg rounded-3">
                            <div class="seccion-filtro color-azul">Atenciones para reasignar</div>
                            <hr class="separador">
                            <h5 class="cantidad-solicitud d-inline"><?php echo e($suma_porreasignars_coordiandor); ?></h5>
                            <h6 class="seccion-filtro mb-2 d-inline">Solicitudes</h6>
                            <button type="button" class="btn btn-ter d-block mx-auto mt-4 revisar_porreasignar" data-toggle="modal" data-target="#aparaReasignar">Revisar</button>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="row">
        <div class="col-sm-12 mt-4">
            <div class="card">
                <div class="card-body border-lg rounded-3 shadow">
                    <div class="seccion-filtro color-azul">Gráfico de instalaciones</div>
                    <hr class="separador">
                    <div class="" style="text-align: center; display:none" id="id_div_grafico">
                        <div class="container table-responsive-lg">
                            <div class="row mt-3 d-flex justify-content-end">
                                
                                <div class=" div_oculto mt-2 " style="display:none">
                                    <label class="totalins" for="" id="lTotalintalaciones"> </label>
                                </div>
                                <div class=" div_oculto" style="display:none">
                                    <h2 class="total text-left" id="lTotal"></h2>
                                </div>
                            </div>
                            <div class="row d-flex justify-content-end mt-4 mb-4">
                                <div class="instalaciones" id="divColoruno"><label for="" id="label1"></label></div>
                                <div class="finalizados" id="divColordos"><label for="" id="label2"></label></div>
                            </div>
                            <div class="row mb-5">
                                <canvas id="chart-rea3" class="pie"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<!-- Modals    -->
<!-- Modal Atenciones Pendientes -->
<div class="modal fade" id="aPendientes" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <div class="seccion-modal">Atenciones Pendientes</div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <hr class="separador mx-4">
            <?php if(Auth::user()->tipo_usuario == "coordinador" || Auth::user()->tipo_usuario == "administrador"): ?>
            <div class="row px-4 container mb-4">
                <div class="col-md-4">
                    <label for="">Cliente</label>
                    <select name="" id="cliente" class="custom-select id_filtroPendiente">
                        <option value="" id="seleccionar" selected>Seleccionar</option>
                        <?php for($i=0;$i<(count($datos_clientes));$i++): ?> <?php $__currentLoopData = $datos_clientes[$i]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dato): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($dato->id); ?>"><?php echo e(strtoupper($dato->cliente)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endfor; ?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="">Tipo Asignacion</label>
                    <select name="" id="t_asignacion" class="custom-select id_filtroPendiente">
                        <option value="" selected>Seleccionar</option>
                        <option value="retiro">Retiros</option>
                        <option value="instalacion">Instalacion</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="">Técnico</label>
                    <select name="" id="tecnico" class="custom-select id_filtroPendiente">
                        <option value="" selected>Seleccionar</option>
                        <?php $__currentLoopData = $trabajadores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trabajador): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($trabajador->id); ?>"><?php echo e(strtoupper($trabajador->nombre_uno)); ?> <?php echo e(strtoupper($trabajador->apellido_uno)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <?php endif; ?>
            <hr class="separador mx-4">
            <div class="container mb-4 px-4">
                <table class="table table-lg table-bordered table-responsive-md table-striped table-hover mt-4">
                    <thead class="color-head">
                        <tr>
                            <th class="th-head border-th separador-v" colspan="1">TÉCNICO</th>
                            <th class="th-head border-th separador-v" colspan="1">ASIGNACIÓN</th>
                            <th class="th-head border-th separador-v" colspan="1">CLIENTE</th>
                            <th class="th-head border-th separador-v" colspan="1">REGIÓN</th>
                            <th class="th-head border-th separador-v" colspan="1">COMUNA</th>
                            <th class="th-head border-th separador-v" colspan="1">Nº DE SERIE</th>
                            <th class="th-head border-th separador-v" colspan="1">
                                <span class="material-icons">settings</span>
                            </th>
                        </tr>
                    </thead>
                    <tbody id="llenar_pendientes">
                        <!--AQUI SE LLENAN LAS ATENCIONES POR AJAX-->
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- Modal Atenciones Rechazadas -->
<div class="modal fade" id="aRechazadas" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <div class="seccion-modal">Atenciones Rechazadas</div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <hr class="separador mx-4">
            <div class="container mb-4 px-4">
                <table class="table table-lg table-bordered table-responsive-md table-striped table-hover mt-4">
                    <thead class="color-head">
                        <tr>
                            <th class="th-head border-th separador-v" colspan="1">TÉCNICO</th>
                            <th class="th-head border-th separador-v" colspan="1">ASIGNACIÓN</th>
                            <th class="th-head border-th separador-v" colspan="1">CLIENTE</th>
                            <th class="th-head border-th separador-v" colspan="1">REGIÓN</th>
                            <th class="th-head border-th separador-v" colspan="1">COMUNA</th>
                            <th class="th-head border-th separador-v" colspan="1">Nº DE SERIE</th>
                            <th class="th-head border-th separador-v" colspan="1">
                                <span class="material-icons">settings</span>
                            </th>
                        </tr>
                    </thead>
                    <tbody id="llenar_rechazadas">
                        <!--AQUI SE LLENAN LAS ATENCIONES POR AJAX-->
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!--MODAL'S INSTALACION RETIRO-->
<!-- Modal Atenciones por asignar -->
<div class="modal fade" id="aporAsignar" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <div class="seccion-modal">Atenciones por asignar</div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <hr class="separador mx-4">
            <?php if(Auth::user()->tipo_usuario == "coordinador" || Auth::user()->tipo_usuario == "administrador"): ?>
            <div class="row px-4 container mb-4">
                <div class="col-md-6">
                    <label for="">Cliente</label>
                    <select name="" id="cliente_porasignar" class="custom-select id_filtroporAsignar">
                        <option value="" selected>Seleccionar</option>
                        <?php for($i=0;$i<(count($datos_clientes_porasignar));$i++): ?> <?php $__currentLoopData = $datos_clientes_porasignar[$i]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dato): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($dato->sCliente); ?>"><?php echo e($dato->sCliente); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endfor; ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label for="">Tipo Asignacion</label>
                    <select name="" id="t_asignacion_porasignar" class="custom-select id_filtroporAsignar">
                        <option value="" selected>Seleccionar</option>
                        <option value="retiro">Retiros</option>
                        <option value="instalacion">Instalacion</option>
                    </select>
                </div>
            </div>
            <hr class="separador mx-4">
            <?php endif; ?>
            <div class="container mb-4 px-4">
                <table class="table table-lg table-bordered table-responsive-md table-striped table-hover mt-4">
                    <thead class="color-head">
                        <tr>
                            <th class="th-head border-th separador-v" colspan="1">PROVEEDOR</th>
                            <th class="th-head border-th separador-v" colspan="1">ASIGNACIÓN</th>
                            <th class="th-head border-th separador-v" colspan="1">CLIENTE</th>
                            <th class="th-head border-th separador-v" colspan="1">REGIÓN</th>
                            <th class="th-head border-th separador-v" colspan="1">COMUNA</th>
                            <th class="th-head border-th separador-v" colspan="1">Nº DE SERIE</th>
                            <th class="th-head border-th separador-v" colspan="1">
                                <span class="material-icons">settings</span>
                            </th>
                        </tr>
                    </thead>
                    <tbody id="llenar_porasginar"></tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- Modal Atenciones en curso -->
<div class="modal fade" id="aenCurso" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <div class="seccion-modal">Atenciones en curso</div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <hr class="separador mx-4">
            <?php if(Auth::user()->tipo_usuario == "coordinador" || Auth::user()->tipo_usuario == "administrador"): ?>
            <div class="row px-4 container mb-4">
                <div class="col-md-4">
                    <label for="">Cliente</label>
                    <select name="" id="cliente_encurso" class="custom-select id_filtroenCurso">
                        <option value="" selected>Seleccionar</option>
                        <?php for($i=0;$i<(count($datos_clientes));$i++): ?> <?php $__currentLoopData = $datos_clientes[$i]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dato): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($dato->id); ?>"><?php echo e(strtoupper($dato->cliente)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endfor; ?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="">Tipo Asignacion</label>
                    <select name="" id="t_asignacion_encurso" class="custom-select id_filtroenCurso">
                        <option value="" selected>Seleccionar</option>
                        <option value="retiro">Retiros</option>
                        <option value="instalacion">Instalacion</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="">Técnico</label>
                    <select name="" id="tecnico_encurso" class="custom-select id_filtroenCurso">
                        <option value="" selected>Seleccionar</option>
                        <?php $__currentLoopData = $trabajadores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trabajador): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($trabajador->id); ?>"><?php echo e(strtoupper($trabajador->nombre_uno)); ?> <?php echo e(strtoupper($trabajador->apellido_uno)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <?php endif; ?>
            <hr class="separador mx-4">
            <div class="container mb-4 px-4">
                <table class="table table-lg table-bordered table-responsive-md table-striped table-hover mt-4">
                    <thead class="color-head">
                        <tr>
                            <th class="th-head border-th separador-v" colspan="1">TÉCNICO</th>
                            <th class="th-head border-th separador-v" colspan="1">FECHA</th>
                            <th class="th-head border-th separador-v" colspan="1">CLIENTE</th>
                            <th class="th-head border-th separador-v" colspan="1">Nº DE SERIE</th>
                            <th class="th-head border-th separador-v" colspan="1">
                                <span class="material-icons">settings</span>
                            </th>
                        </tr>
                    </thead>
                    <tbody id="llenar_encurso"></tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- Modal Atenciones por reasignar -->
<div class="modal fade" id="aparaReasignar" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <div class="seccion-modal">Atenciones por reasignar</div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <hr class="separador mx-4">
            <?php if(Auth::user()->tipo_usuario == "coordinador" || Auth::user()->tipo_usuario == "administrador"): ?>
            <div class="row px-4 container mb-4">
                <div class="col-md-4">
                    <label for="">Cliente</label>
                    <select name="" id="cliente_porReasignar" class="custom-select id_filtroporReasignar">
                        <option value="" selected>Seleccionar</option>
                        <?php for($i=0;$i<(count($datos_clientes));$i++): ?> <?php $__currentLoopData = $datos_clientes[$i]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dato): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($dato->id); ?>"><?php echo e(strtoupper($dato->cliente)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endfor; ?>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="">Tipo Asignacion</label>
                    <select name="" id="t_asignacion_porReasignar" class="custom-select id_filtroporReasignar">
                        <option value="" id="seleccionado" selected>Seleccionar</option>
                        <option value="retiro">Retiros</option>
                        <option value="instalacion">Instalacion</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="">Técnico</label>
                    <select name="" id="tecnico_porReasignar" class="custom-select id_filtroporReasignar">
                        <option value="" selected>Seleccionar</option>
                        <?php $__currentLoopData = $trabajadores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trabajador): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($trabajador->id); ?>"><?php echo e(strtoupper($trabajador->nombre_uno)); ?> <?php echo e(strtoupper($trabajador->apellido_uno)); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <?php endif; ?>
            <hr class="separador mx-4">
            <div class="container mb-4 px-4">
                <table class="table table-lg table-bordered table-responsive-md table-striped table-hover mt-4">
                    <thead class="color-head">
                        <tr>
                            <th class="th-head border-th separador-v" colspan="1">TÉCNICO</th>
                            <th class="th-head border-th separador-v" colspan="1">FECHA</th>
                            <th class="th-head border-th separador-v" colspan="1">CLIENTE</th>
                            <th class="th-head border-th separador-v" colspan="1">Nº DE SERIE</th>
                            <th class="th-head border-th separador-v" colspan="1">
                                <span class="material-icons">settings</span>
                            </th>
                        </tr>
                    </thead>
                    <tbody id="llenar_porreasignar"></tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<!-- Modal Atenciones por reasignar -->
<div class="modal fade" id="aAlertaHome" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <div class="seccion-modal">Atencion</div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <hr class="separador mx-4">
            <div class="container mb-4 px-4">
                <?php if(Auth::user()->tipo_usuario == "coordinador" || Auth::user()->tipo_usuario == "administrador"): ?>
                Para gestionar creación de proveedor, agregar sucursal, crear cliente, crear proyecto. Así como también para designar instalaciones, retiros, revisar capacitaciones y resumen retiro. <strong>Debe ir a Cambiar <u> proveedor</u></strong>".
                <?php elseif(Auth::user()->tipo_usuario == "trabajador"): ?>
                "Para gestionar resumen retiro y capacitaciones es necesario <strong>elegir un <u>proveedor</u></strong>"
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="seguimiento" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <div class="seccion-modal">Consulta seguimiento</div>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <hr class="separador mx-4">

            <div class="container">
                <div class="row">
                    <div class="col-sm-6 form-group mx-auto">
                        <label for="">Numero de Serie</label>
                        <input class="form-control mayuscula" type="text" placeholder="Serie" id="serie_seguimiento">
                    </div>
                    <div class="col-sm-12 my-4 text-center">
                        <button class="btn btn-prim px-sm-5 hacer_seguimiento">Hacer seguimiento</button>
                    </div>
                </div>
            </div>
            <div class="container mb-4 px-4">
                <table class="table table-xl table-bordered table-responsive-md table-striped table-hover mt-4">
                    <thead class="color-head">
                        <tr>
                            <th class="th-head border-th separador-v" colspan="1">TÉCNICO</th>
                            <th class="th-head border-th separador-v" colspan="1">FECHA</th>
                            <th class="th-head border-th separador-v" colspan="1">CLIENTE</th>
                            <th class="th-head border-th separador-v" colspan="1">REGIÓN</th>
                            <th class="th-head border-th separador-v" colspan="1">COMUNA</th>
                            <th class="th-head border-th separador-v" colspan="1">Nº DE SERIE</th>
                            <th class="th-head border-th separador-v" colspan="1">T. ATENCIÓN</th>
                        </tr>
                    </thead>
                    <tbody id="llenar_seguimiento">
                    </tbody>
                </table>
            </div>
            
            <div class="container seguimiento my-5">
                <div class="barra mx-auto">
                    
                    <div class="d-flex justify-content-between container-puntos">
                        <div class="punto"></div>
                        <div class="punto"></div>
                        <div class="punto"></div>
                        <div class="punto"></div>
                        <div class="punto"></div>
                        <div class="punto"></div>
                    </div>
                    
                    <div class="d-flex justify-content-between container-puntos">
                        <div class="" id="punto-asignado"></div>
                        <div class="" id="punto-ruta"></div>
                        <div class="" id="punto-cliente"></div>
                        <div class="" id="punto-iniciar"></div>
                        <div class="" id="punto-revisar"></div>
                        <div class="" id="punto-final"></div>
                    </div>
                </div>
                
                <div class="d-line-flex justify-content-around mt-4">
                    <div class="row text-center">
                        <div class="col-sm active">Asignado</div>
                        <div class="col-sm">En Ruta</div>
                        <div class="col-sm">En Cliente</div>
                        <div class="col-sm">Iniciar Check</div>
                        <div class="col-sm">Estado revisar</div>
                        <div class="col-sm">Estado final del check</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Modal Historial instalacion-->
<div class="modal" id="modalver_historial_check_instalacion">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title"> Historial</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
                <div class="container">
                    <table class="table table-bordered table-responsive table-striped">
                        <thead>
                            <th scope="col">N° de atencion</th>
                            <th scope="col">Tecnico</th>
                            <th scope="col">Estado opción</th>
                            <th scope="col">N° de serie</th>
                            <th scope="col">Modelo </th>
                            <th scope="col">Direccion</th>
                            <th scope="col">Region</th>
                            <th scope="col">Comuna</th>
                            <th scope="col">Cliente</th>
                            <th scope="col">Fecha</th>
                            <th scope="col">Contador B/N</th>
                            <th scope="col">Contador Color</th>
                            <th scope="col">Tipo Visita</th>
                            <th scope="col">Observaciones</th>
                            <th scope="col">Accesorios</th>
                        </thead>
                        <tbody id="agregar_historial_instalacions"></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<!--Modal Historial retiro-->
<div class="modal" id="modalHistorialRetiro">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h4 class="modal-title"> Historial</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <div class="modal-body">
                <table class="table table-bordered table-responsive-lg table-striped">
                    <thead>
                        <th scope="col">N° de serie</th>
                        <th scope="col">Direccion</th>
                        <th scope="col">Cliente</th>
                        <th scope="col">Fecha</th>
                        <th scope="col">Contador B/N</th>
                        <th scope="col">Contador Color</th>
                        <th scope="col">Observaciones</th>
                    </thead>
                    <tbody id="agregar_historial_retiro"></tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<script src="<?php echo e(asset('js/chart.min.js')); ?>"></script>
<script>
    function historial_instalacion(a, b) {
        id = a
        if (b == 1) {
            proveedor = "comtecglobal"
        }
        if (b == 2) {
            proveedor = "kyocera"
        }
        if (b == 3) {
            proveedor = "upgrade"
        }
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: "<?php echo e(route('go.historial_check_instalacions_home')); ?>",
            data: {
                'id': id,
                'proveedor': proveedor
            },
            success: function(data) {
                console.log(data);
                $('#agregar_historial_instalacions').empty();
                $("#modalver_historial_check_instalacion").modal('show');
                $('#agregar_historial_instalacions').append(data)
            },
            error: function(xhr, status) {
                alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
            }
        })
    }

    function historial_retiro(a, b) {
        id = a
        if (b == 1) {
            proveedor = "kyocera"
        }
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: "<?php echo e(route('go.historial_check_retiro_home')); ?>",
            data: {
                'id': id,
                'proveedor': proveedor
            },
            success: function(data) {
                $('#agregar_historial_retiro').empty();
                $("#modalHistorialRetiro").modal('show');
                $('#agregar_historial_retiro').append(data);
            },
            error: function(xhr, status) {
                alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
            }
        })
    }
    function limpiar_imputs(){
        console.log("limpiar");
        //pendiente
        $("#cliente").val('');
        $('#t_asignacion').val('');
        $('#tecnico').val('');
        //por asignar
        $('#cliente_porasignar').val('');
        $('#t_asignacion_porasignar').val('');
        //en curso
        $('#cliente_encurso').val('');
        $('#t_asignacion_encurso').val('');
        $('#tecnico_encurso').val('');
        //reasignar
        $('#cliente_porReasignar').val('');
        $('#t_asignacion_porReasignar').val('');
        $('#tecnico_porReasignar').val('');
    }
    $(document).ready(function() {
        $('#aAlertaHome').modal("show");
        //FILTRO PENDIENTE
        $('.id_filtroPendiente').change(function() {
            cliente = $("#cliente").val();
            tipo_a = $("#t_asignacion").val();
            tecnico = $("#tecnico").val();
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('go.filtro_pendiente')); ?>",
                method: "GET",
                data: {
                    'cliente': cliente,
                    'tipo_a': tipo_a,
                    'tecnico': tecnico
                },
                success: function(data) {
                    $('#llenar_pendientes').empty();
                    $('#llenar_pendientes').append(data);
                }
            });
        })
        //FILTRO POR ASIGNAR
        $('.id_filtroporAsignar').change(function() {
            cliente = $("#cliente_porasignar").val();
            tipo_a = $("#t_asignacion_porasignar").val();
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('go.filtro_porasignar')); ?>",
                method: "GET",
                data: {
                    'cliente': cliente,
                    'tipo_a': tipo_a,
                },
                success: function(data) {
                    console.log(data);
                    $('#llenar_porasginar').empty();
                    $('#llenar_porasginar').append(data);
                }
            });
        })
        //FILTRO EN CURSO
        $('.id_filtroenCurso').change(function() {
            cliente = $("#cliente_encurso").val();
            tipo_a = $("#t_asignacion_encurso").val();
            tecnico = $('#tecnico_encurso').val();
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('go.filtro_encurso')); ?>",
                method: "GET",
                data: {
                    'cliente': cliente,
                    'tipo_a': tipo_a,
                    'tecnico': tecnico
                },
                success: function(data) {
                    console.log(data);
                    $('#llenar_encurso').empty();
                    $('#llenar_encurso').append(data);
                }
            });
        })
        //FILTRO POR REASIGNAR
        $('.id_filtroporReasignar').change(function() {
            cliente = $("#cliente_porReasignar").val();
            tipo_a = $("#t_asignacion_porReasignar").val();
            tecnico = $('#tecnico_porReasignar').val();
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('go.filtro_porreasignar')); ?>",
                method: "GET",
                data: {
                    'cliente': cliente,
                    'tipo_a': tipo_a,
                    'tecnico': tecnico
                },
                success: function(data) {
                    console.log(data);
                    $('#llenar_porreasignar').empty();
                    $('#llenar_porreasignar').append(data);
                }
            });
        })
        //COORDINADOR
        $('.hacer_seguimiento').click(function() {
            serie = $("#serie_seguimiento").val();
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('go.seguimiento')); ?>",
                method: "GET",
                data: {
                    'serie': serie
                },
                success: function(data) {
                    $('#llenar_seguimiento').empty();
                    $('#llenar_seguimiento').append(data[0].table);
                    $('#punto-ruta').removeClass("punto-active");
                    $('#punto-cliente').removeClass("punto-active");
                    $('#punto-iniciar').removeClass("punto-active");
                    $('#punto-revisar').removeClass("punto-active");
                    $('#punto-final').removeClass("punto-active");
                    $('#punto-asignado').removeClass("punto-active");
                    if (data[0].estado == "finalizado") {
                        $('#punto-final').addClass("punto-active");
                        console.log(data[0].estado);
                    }
                    if (data[0].estado == "asignado") {
                        $('#punto-asignado').addClass("punto-active");
                        console.log(data[0].estado);
                    }
                    if (data[0].estado == "revisar") {
                        $('#punto-revisar').addClass("punto-active");
                        console.log(data[0].estado);
                    }
                    if (data[0].estado_inicio == "activo") {
                        $('#punto-asignado').removeClass("punto-active");
                        $('#punto-iniciar').addClass("punto-active");
                        console.log(data[0].estado);
                    }
                }
            });
        });
        $('.revisar_porreasignar').click(function() {
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('revisar_porreasignar_coordinador')); ?>",
                method: "GET",
                data: {},
                success: function(data) {
                    limpiar_imputs();
                    $('#llenar_porreasignar').empty();
                    $('#llenar_porreasignar').append(data);
                }
            });
        });
        $('.revisar_encurso_coordinador').click(function() {
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('revisar_encurso_coordinador')); ?>",
                method: "GET",
                data: {},
                success: function(data) {
                    limpiar_imputs();
                    $('#llenar_encurso').empty();
                    $('#llenar_encurso').append(data);
                }
            });
        });
        $('.revisar_porasignar').click(function() {
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('revisar_porasignar')); ?>",
                method: "GET",
                data: {},
                success: function(data) {
                    limpiar_imputs();
                    $('#llenar_porasginar').empty();
                    $('#llenar_porasginar').append(data);
                }
            });
        });
        $('.revisar_pendientes_coordinador').click(function() {
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('revisar_pendientes_coordinador')); ?>",
                method: "GET",
                data: {},
                success: function(data) {
                    limpiar_imputs();
                    $('#llenar_pendientes').empty();
                    $('#llenar_pendientes').append(data);
                }
            });
        });
        //TECNICO
        $('.revisar_pendientes').click(function() {
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('revisar_pendientes_tecnicos')); ?>",
                method: "GET",
                data: {},
                success: function(data) {
                    limpiar_imputs();
                    $('#llenar_pendientes').empty();
                    $('#llenar_pendientes').append(data);
                }
            });
        });
        $('.revisar_rechazado').click(function() {
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('revisar_rechazados_tecnicos')); ?>",
                method: "GET",
                data: {},
                success: function(data) {
                    limpiar_imputs();
                    $('#llenar_rechazadas').empty();
                    $('#llenar_rechazadas').append(data);
                }
            });
        });
        $('.revisar_encurso').click(function() {
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('revisar_encurso_tecnicos')); ?>",
                method: "GET",
                data: {},
                success: function(data) {
                    limpiar_imputs();
                    $('#llenar_encurso').empty();
                    $('#llenar_encurso').append(data);
                }
            });
        });
    });
</script>
<script>
    var clientes = [];
    var valores = [];
    let myChart;
    var tipoUsuario = $(".tipoUsuario").val();
    var valoresFinalizados = [];
    let tipoGrafico;
    var proveedor = $(".proveedoractual").val();
    let labelUno;
    let labelDos;
    let lTotal;
    let maximo = 0;
    $(document).ready(function() {
        if ($(".tipoUsuario").val() === "coordinador") {
            clientes = [];
            valores = [];
            valoresFinalizados = [];
            provee = $(".proveedoractual").val();;
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('graficos_coordinadora')); ?>",
                method: "GET",
                data: {
                    proveedor: provee,
                },
                success: function(data) {
                    sum = 0;
                    $.each(data, function(i, item) {
                        clientes.push(convertir(item.cliente));
                        valores.push(item.totalInstalaciones);
                        sum = sum + item.totalInstalaciones;
                        valoresFinalizados.push(item.totalFinalizados);
                    });
                    lTotal = number_format(sum);
                    $("#lTotal").text(lTotal);
                    $("#lTotalintalaciones").text("Total Instalaciones");
                    $("#label1").text("Instalaciones");
                    $("#label2").text("Finalizados");
                    $("#divColoruno").css("display", "");
                    $("#divColordos").css("display", "");
                    labelUno = "instalaciones";
                    labelDos = "Finalizadas";
                    llenarGraficoBarrar(2);
                }
            });
        } else {
            clientes = [];
            valores = [];
            valoresFinalizados = [];
            provee = $(".proveedoractual").val();;
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "<?php echo e(route('graficos_tecnicos')); ?>",
                method: "GET",
                data: {
                    proveedor: provee,
                },
                success: function(data) {
                    sum = 0;
                    $.each(data, function(i, item) {
                        clientes.push(convertir(item.cliente));
                        valores.push(item.totalInstalaciones);
                        sum = sum + item.totalInstalaciones;
                        valoresFinalizados.push(item.totalFinalizados);
                    });
                    lTotal = number_format(sum);
                    $("#lTotal").text(lTotal);
                    $("#lTotalintalaciones").text("Total Instalaciones");
                    $("#label1").text("Instalaciones");
                    $("#label2").text("Finalizados");
                    $("#divColoruno").css("display", "");
                    $("#divColordos").css("display", "");
                    labelUno = "instalaciones";
                    labelDos = "Finalizadas";
                    llenarGraficoBarrar(2);
                }
            });
        }
    });

    function convertir(string) {
        console.log(string);
        if (string != null && string != "") {
            return string.toUpperCase();
        } else {
            return string;
        }
    }

    function number_format(nStr) {
        nStr += '';
        x = nStr.split('.');
        x1 = x[0];
        x2 = x.length > 1 ? '.' + x[1] : '';
        var rgx = /(\d+)(\d{3})/;
        while (rgx.test(x1)) {
            x1 = x1.replace(rgx, '$1' + '.' + '$2');
        }
        return x1 + x2;
    }

    function numeroMayor(arreglo) {
        mayor = 0;
        for (i = 0; i < arreglo.length; i++) {
            if (arreglo[i] > mayor) {
                mayor = arreglo[i];
            }
        }
        if (mayor < 100) {
            mayor = mayor + 5;
        } else if (mayor < 1000 && mayor > 100) {
            mayor = mayor + 50;
        } else if (mayor > 1000) {
            mayor = mayor + 100;
        }
        return mayor;
    }


    function llenarGraficoBarrar(graficos) {
        $(".div_oculto").css("display", "");
        $("#lProveedor").text(proveedor);
        var ctx = document.getElementById('chart-rea3').getContext('2d');
        if (myChart) {
            myChart.destroy();
        }
        if (graficos == 1) {
            datass = [{
                label: labelUno,
                data: valores,
                backgroundColor: [
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)',
                    'rgba(81,107,160,0.75)'
                ],
            }];
        } else if (graficos == 2) {
            datass = [{
                    label: labelUno,
                    data: valores,
                    backgroundColor: [
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)'
                    ],
                    borderColor: [
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)',
                        'rgba(81,107,160,0.75)'
                    ],
                    borderWidth: 1
                },
                {
                    label: labelDos,
                    data: valoresFinalizados,
                    backgroundColor: [
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)'
                    ],
                    borderColor: [
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)',
                        'rgba(226,113,36,0.75)'
                    ],
                    borderWidth: 1
                },
            ]
        }
        myChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: clientes,
                datasets: datass
            },
            options: {
                layout: {
                    padding: {
                        left: 500,
                        right: 0,
                        top: 0,
                        bottom: 0
                    },
                },
                scales: {
                    yAxes: [{
                        ticks: {
                            suggestedMin: 0,
                            suggestedMax: numeroMayor(valores),
                        }
                    }]
                },
                legend: {
                    display: false,
                    labels: {},
                },
                responsive: true,
                tooltips: {
                    enabled: false
                },
                layout: {
                    padding: {
                        left: 0,
                        right: 0,
                        top: 0,
                        bottom: 0
                    }
                },
                animation: {
                    onComplete: function(animation) {
                        var chartInstance = this.chart,
                            ctx = chartInstance.ctx;
                        ctx.font = Chart.helpers.fontString(Chart.defaults.global.defaultFontSize, Chart.defaults.global.defaultFontStyle, Chart.defaults.global.defaultFontFamily);
                        ctx.textAlign = 'center';
                        ctx.textBaseline = 'bottom';
                        this.data.datasets.forEach(function(dataset, i) {
                            var meta = chartInstance.controller.getDatasetMeta(i);
                            meta.data.forEach(function(bar, index) {
                                var data = dataset.data[index];
                                ctx.fillText(data, bar._model.x, bar._model.y - 1);
                            });
                        });
                    }
                }
            }
        });
        $("#id_div_grafico").css("display", "");
    }
</script>
<!--FIN SCRIPT INSTALACION-RETIRO-->

<?php echo $__env->make('menu/menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sistema/sistemacaja/resources/views/home_instalacionretiro.blade.php ENDPATH**/ ?>