<!DOCTYPE html>

<html lang="es">

<head>

  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- CSRF Token -->
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <title>AYA INGENIERIA</title>
  <!-- Scripts -->
  <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>
  <script src="<?php echo e(asset('js/funciones.js')); ?>" defer></script>
  <!-- Fonts -->
  <link rel="dns-prefetch" href="//fonts.gstatic.com">

  <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">

  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Lato:wght@100;300;400;700&display=swap" rel="stylesheet">

  <!-- Styles -->

  <link href="<?php echo e(asset('css/bootstrap-4.4.1.css')); ?>" rel="stylesheet">
  
  <link href="<?php echo e(asset('css/css.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset('css/a&a_style.css')); ?>" rel="stylesheet">
  <link href="<?php echo e(asset('css/a&a_btns_icons_style.css')); ?>" rel="stylesheet">

  <!-- Google icons -->
  <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Material+Icons+Round" rel="stylesheet">

  
  <link href="<?php echo e(asset('css/aya_style_2.0.css')); ?>" rel="stylesheet">

</head>



<body>
<?php
  $nombre_DB = DB::connection()->getDatabaseName();
  $nombre_proveedores = DB::table('config_usuarios')
    ->select('id', 'nombre_proveedor', 'name_bd')
    ->where('estado', '=', 1)
    ->get();
  ?>
  <nav class="navbar navbar-expand-lg navbar-dark bg-dark fixed-top">
    <a class="navbar-brand" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(asset('../sistemacaja/public/logo_aya_blanco.svg')); ?>" alt="Logotipo A&A Ingeniería"></a>

    <div class="container">


      <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="navbarSupportedContent">
        <ul class="navbar-nav mr-auto">

          <li class="nav-item">
            <a class="nav-link" href="<?php echo e(route('home')); ?>">Inicio</a>
          </li>

          <?php if(Auth::user()->tipo_usuario == "administrador"): ?>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Usuarios
            </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              <a class="dropdown-item" href="<?php echo e(route('go_add_traba')); ?>">Agregar usuario</a>
              <a class="dropdown-item" href="<?php echo e(route('go_see_traba')); ?>">Usuarios registrados</a>
            </div>
          </li>
          <?php endif; ?>

          <?php if(Auth::user()->tipo_usuario == "administrador" || Auth::user()->tipo_usuario == "coordinador"): ?>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Clientes
            </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              <a class="dropdown-item" href="<?php echo e(route('go_add_client')); ?>">Agregar clientes</a>
              <a class="dropdown-item" href="<?php echo e(route('go_add_sucur')); ?>">Agregar sucursal</a>
              <a class="dropdown-item" href="<?php echo e(route('go_see_clien')); ?>">Clientes registrados</a>
            </div>
          </li>
          <?php endif; ?>

          <li class="nav-item dropdown">
            <?php if(Auth::user()->tipo_usuario == "trabajador"): ?>
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Reembolsos y Gastos
            </a>
            <?php endif; ?>

            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              <?php if(Auth::user()->tipo_usuario == "trabajador"): ?>
              <a class="dropdown-item" href="<?php echo e(route('go_add_gastos')); ?>">Agregar gasto</a>
              <?php endif; ?>

              <?php if(Auth::user()->tipo_usuario == "trabajador"): ?>
              <a class="dropdown-item" href="<?php echo e(route('go_see_gastos')); ?>"> Mis gastos</a>
              <a class="dropdown-item" href="<?php echo e(route('mis_depositos')); ?>"> Mis depósitos</a>
              <?php endif; ?>

              <?php if(Auth::user()->tipo_usuario == "administrador"): ?>
              <?php endif; ?>
            </div>
          </li>

          <?php if(Auth::user()->tipo_usuario == "trabajador"): ?>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Tareas
            </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              <a class="dropdown-item" href="<?php echo e(route('go.resumen')); ?>"> Resumen Asignaciones </a>
              <a class="dropdown-item" href="<?php echo e(route('go.historial')); ?>"> Capacitaciones </a>
              <a class="dropdown-item" href="<?php echo e(route('go.historial_retiro')); ?>">Resumen Retiros </a>
              <a class="dropdown-item" href="<?php echo e(route('go.estadoEquipo')); ?>">Estado de Equipo </a>
              <a class="dropdown-item" href="<?php echo e(route('check.tecnico')); ?>">Asignaciones (instalaciones/retiros)</a>
            </div>
          </li>
          <?php endif; ?>

          <?php if(Auth::user()->tipo_usuario == "trabajador"): ?>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Informes
            </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              <a class="dropdown-item" href="<?php echo e(route('go.sol_dia')); ?>">Solicitar días</a>
              <a class="dropdown-item" href="<?php echo e(route('go.mis_solici')); ?>">Solicitudes enviadas</a>
              <a class="dropdown-item" href="<?php echo e(route('go.mis_dias_utilizados')); ?>">Días utilizados</a>
            </div>
          </li>
          <?php endif; ?>

          <?php if(Auth::user()->tipo_usuario == "administrador" || Auth::user()->tipo_usuario == "coordinador"): ?>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              API
            </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              <!--<a class="dropdown-item" href="<?php echo e(route('go.api_solicitudes')); ?>">Solicitudes</a>-->
              <a class="dropdown-item" href="<?php echo e(route('go.api_instalacion')); ?>">Instalación</a>
              <a class="dropdown-item" href="<?php echo e(route('go.api_retiros')); ?>">Retiros</a>
              <!--<a class="dropdown-item" href="<?php echo e(route('go.estados_equipo')); ?>">Estado Equipos</a>-->
              <a class="dropdown-item" href="<?php echo e(route('go.capas')); ?>">Capacitaciones</a>
              <!-- <a class="dropdown-item" href="<?php echo e(route('go.informes')); ?>">Informes</a> -->
              <a class="dropdown-item" href="<?php echo e(route('informes.graficos')); ?>">Graficos</a>
              <a class="dropdown-item" href="<?php echo e(route('go.historial_retiro_coordinadora')); ?>">Resumen Retiro</a>
              <a class="dropdown-item" href="<?php echo e(route('go.api_reportes')); ?>">Reportes</a>
            </div>
          </li>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Proyecto
            </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              <a class="dropdown-item" href="<?php echo e(route('go.crear_proyecto')); ?>">Crear Proyecto</a>
              <a class="dropdown-item" href="<?php echo e(route('go.siguientecrear_proyecto')); ?>">Editar Proyecto</a>
              <hr style="background-color: white">
              <a class="dropdown-item" href="<?php echo e(route ('go.all_checklist')); ?>">Prefacturación</a>
            </div>
          </li>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              Sistema
            </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              <a class="dropdown-item" href="<?php echo e(route('go.ver_mantenedor')); ?>">Mantenedor kilometros</a>
              <a class="dropdown-item" href="<?php echo e(route('go.ver_mantenedor_ciudadbase')); ?>">Mantenedor ciudad bases</a>
              <a class="dropdown-item" href="<?php echo e(route('go.accesorios')); ?>">Accesorios </a>
              <a class="dropdown-item" target="_blank" href="<?php echo e(url("importar")); ?>">Cargar Datos</a>
              <a class="dropdown-item" target="_blank" href="<?php echo e(url("proveedor")); ?>">Crear proveedor</a>
            </div>
          </li>
          <?php endif; ?>

          <?php if(Auth::user()->tipo_usuario == "Kyocera" || Auth::user()->tipo_usuario == "Banco" || Auth::user()->tipo_usuario == "externo"): ?>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              PORTAL
            </a>
            <div class="dropdown-menu" aria-labelledby="navbarDropdown">
              <a class="dropdown-item" href="<?php echo e(route('go.verinstalacionesKyocera')); ?>">Pdf's instalaciones</a>
              
              <a class="dropdown-item" href="<?php echo e(route('go.pdf_retiro')); ?>">Pdf's retiro</a>
              <a class="dropdown-item" href="<?php echo e(route('go.pdf_capacitacion')); ?>">Pdf's Capacitaciones</a>
              <a class="dropdown-item" href="<?php echo e(route('go.pdf_resumenretiro')); ?>">Pdf's Resumen Retiro</a>
              <a class="dropdown-item" href="<?php echo e(route('go.pdf_informes')); ?>">Pdf's Informes</a>
              <a class="dropdown-item" href="<?php echo e(route('informes.graficos')); ?>">Graficos</a>
            </div>
          </li>
          <?php endif; ?>
        </ul>

        <span style="color:white" class="username"> Bienvenido : <?php echo e(Auth::user()->usuario); ?> |</span>
        <?php if(auth()->guard()->guest()): ?>
        <?php else: ?>
        <a style=" padding:10px" class="btn text-white btn-sm" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                document.getElementById('logout-form').submit();">
          Salir
        </a>

        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
          <?php echo csrf_field(); ?>
        </form>
        <a class="pt-2 btn btn-cambiar-proveedor set_db">Cambiar proveedor</a>
        <div class="color-blanco ml-3">
          <?php if($nombre_DB == "bd_aya"): ?>
          PRINCIPAL
          <?php else: ?>
          <?php echo e($nombre_DB); ?>

          <?php endif; ?>
        </div>
        <?php endif; ?>
      </div>
    </div>
  </nav>
  
  <div id="app">
    <?php echo $__env->yieldContent('content'); ?>
  </div>
  <!--Modal Historial instalacion-->
  <div class="modal" id="modal_setdb">
    <div class="modal-dialog">
      <div class="modal-content">
        <!-- Modal Header -->
        <div class="modal-header">
          <div class="seccion-modal">Cambio de base de datos</div>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <hr class="separador mx-4">
        <div class="modal-body">
          <div class="container">
            <select name="proveedor" id="" class="custom-select mb-3 mayuscula opcionesSelect">
              <option value="" selected>Seleccionar</option>
              <?php if(Auth::user()->nombre_proveedor != ""): ?>
              <option value="<?php echo e(Auth::user()->nombre_proveedor); ?>"><?php echo e(Auth::user()->nombre_proveedor); ?></option>
              <?php else: ?>
              <?php $__currentLoopData = $nombre_proveedores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $datos): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($datos->name_bd); ?>"><?php echo e($datos->nombre_proveedor); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php endif; ?>
            </select>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
<?php echo $__env->yieldContent('graficos'); ?>
<?php echo $__env->yieldContent('scrypt'); ?>

</html>
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
<script src="http://code.jquery.com/jquery-1.10.2.min.js"></script>
<script>
  $(document).ready(function() {
    $('.set_db').click(function() {
      $("#modal_setdb").modal('show')
    })
    $(".opcionesSelect").change(function(e) {
      var proveedor = $(this).val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        url: "<?php echo e(route('identificacion_confirmacion')); ?>",
        type: "get",
        data: {
          'proveedor': proveedor
        },
        success: function(response) {
          alert("Logeado correctamente");
          $("#modal_setdb").modal('hide')
        },
        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      })
    })
  });
</script><?php /**PATH /var/www/html/sistema/sistemacaja/resources/views/menu/07-02menu.blade.php ENDPATH**/ ?>