@extends('menu/menu')
@section('content')
@if ( session('mensaje') )
<div class="alert alert-danger">{{ session('mensaje') }}</div>
@endif

<div class="container mt-5">
  <div class="title-vista mt-4">PREFACTURACIÓN</div>
</div>

<div class="container mt-4">
  <div class="seccion-filtro">Seleccione</div> 
  <hr class="separador">

  <div class="row">
    <div class="col-sm-6 form-group mx-auto">
      <label for="clientes">Seleccionar Proveedor</label>
      <select  class="custom-select mayuscula opcionesSele2" id="proveedor" name="proveedor" required>
        <option  selected  disabled>Seleccionar</option>
        @if (!empty($carga_selectProveedor))
          @foreach ($carga_selectProveedor as $proveedor)            
            <option  value="{{ $proveedor->proveedor_nombre }}">{{ucfirst(strtolower($proveedor->proveedor_nombre ))}}
            </option> 
          @endforeach
        @endif
      </select>
    </div>
  </div>

  <div class="row">
    <div class="col-sm-6 form-group mx-auto">
      <label for="clientes">Seleccionar Cliente</label>
      <select  class="custom-select mayuscula opcionesSele" id="clientes" name="clientes" required>
        <option  selected  disabled>Seleccionar</option>
      </select>
    </div>
  </div>
  
  <form action="{{route('go.allchecklist')}}" method="GET">
    <div class="row">
      <div class="col-sm-6 form-group mx-auto">
        <label for="proyectosSeleccionado">Proyectos Asociados</label>
        <select  class="custom-select mayuscula" id="detalle" name="proyectosSeleccionado" required>
          <option  selected  disabled>Seleccionar</option>
        </select>
      </div>
    </div>

    <div class="text-center mt-5">
      <input type="submit" class="btn btn-prim w-25"  value="Siguiente">
    </div>
    
  </form>
</div>







@endsection
<script src="//ajax.googleapis.com/ajax/libs/jquery/1.9.1/jquery.min.js"></script>
<script src="http://code.jquery.com/jquery-1.10.2.min.js"></script>
<script>
  $(document).ready(function() {
    $(".opcionesSele2").change(function(e) { 
      var idClientes = $(this).val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
        url:"{{ route('obtenerClientesAsociados2') }}",
        type: "post",
        data: {'idClientes': idClientes},
        success: function(response) {
          $("#clientes").empty();
          $("#clientes").append("<option value='0'>" + "Seleccionar"+ "</option>");
          $.each(response, function( index, value ) {             
		        $("#clientes").append("<option value="+value.id+">" + value.razon_social+ "</option>");
          });
          },
          error: function(xhr, status) {
            alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      })
    })    
    $(".opcionesSele").change(function(e) { 
      var idClientes = $(this).val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
        url:"{{ route('obtenerProyectosAsociados') }}",
        type: "post",
        data: {'idClientes': idClientes},
        success: function(response) {
          $("#detalle").empty();
          $("#detalle").append("<option value='0'>" + "Seleccionar"+ "</option>");
          $.each(response, function( index, value ) {             
		        $("#detalle").append("<option value="+value.id+">" + value.nombre+ "</option>");
          });
          },
          error: function(xhr, status) {
            alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      })
    })    
  })
</script>