@extends('menu/menu')

{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js"></script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>

{{-- {{$trabajadores}} --}}

@section('content')
    @if (session('mensaje'))
        <div class="alert alert-success">{{ session('mensaje') }}</div>
        <a class="dropdown-item text-right" href="{{ route('go_see_traba') }}">
            {{-- <button class="btn btn-prim w-25">Trabajadores</button> --}}
        </a>
    @endif

    <div class="container mt-5">
        <div class="title-vista mt-4">Editar usuario</div>
    </div>


    <div class="container">
        <form action="{{ route('actualizar.trabajador', Crypt::encryptString($trabajadores[0]->id_persona)) }}" method="POST">
            @csrf

            <div class="seccion-filtro">Datos personales</div>
            <hr class="separador">

            <div class="row">
                <div class="col-sm-3 form-group">
                    <label for="primer_nombre">Primer nombre</label>
                    <input type="text" class="form-control mayuscula" name="primer_nombre" id="primer_nombre"
                        value="{{ $trabajadores[0]->nombre_uno }}" placeholder="Primer Nombre">
                    @error('primer_nombre')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-sm-3 form-group">
                    <label for="segundo_nombre">Segundo nombre</label>
                    <input type="text" class="form-control mayuscula" name="segundo_nombre" id="segundo_nombre"
                        value="{{ $trabajadores[0]->nombre_dos }}" placeholder="Segundo Nombre">
                    @error('segundo_nombre')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-sm-3 form-group">
                    <label for="apellido_paterno">Apellido paterno</label>
                    <input type="text" class="form-control mayuscula" value="{{ $trabajadores[0]->apellido_uno }}"
                        name="apellido_paterno" id="apellido_paterno" placeholder="Apellido Paterno">
                    @error('apellido_paterno')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-sm-3 form-group">
                    <label for="apellido_materno">Apellido materno</label>
                    <input type="text" class="form-control mayuscula" value="{{ $trabajadores[0]->apellido_dos }}"
                        id="apellido_materno" name="apellido_materno" placeholder="Apellido Materno">
                    @error('apellido_materno')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-sm-3 form-group">
                    <label for="rut">Rut</label>
                    <input type="text" style="pointer-events: none;" name="rut" id="rut"
                        class="form-control mayuscula" maxlength="10" value="{{ $trabajadores[0]->rut }}"
                        change="guion,v_rut" placeholder="Rut">
                    @error('rut')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="seccion-filtro">Datos contacto</div>
            <hr class="separador">

            <div class="row">
                <div class="col-sm-3 form-group">
                    <label for="telefono">Teléfono</label>
                    <input type="tel" class="form-control mayuscula" value="{{ $trabajadores[0]->telefono1 }}"
                        id="telefono" name="telefono" placeholder="Telefono">
                    @error('telefono')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-sm-3 form-group">
                    <label for="telefono_opcional">Segundo teléfono (Opcional)</label>
                    <input type="tel" class="form-control mayuscula" value="{{ $trabajadores[0]->telefono2 }}"
                        name="telefono_opcional" id="telefono_opcional" placeholder="Telefono Opcional">
                    @error('telefono_opcional')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-sm-3 form-group">
                    <label for="correo">Correo</label>
                    <input type="email" class="form-control mayuscula" name="correo" id="correo"
                        value="{{ $trabajadores[0]->correo1 }}" change="correo" placeholder="Correo">
                    @error('correo')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-sm-3 form-group">
                    <label for="correo_opcional">Segundo correo (Opcional)</label>
                    <input type="text" class="form-control mayuscula" name="correo_opcional" id="correo_opcional"
                        value="{{ $trabajadores[0]->correo2 }}" change="correo_opcional" placeholder="Correo Opcional">
                    @error('correo_opcional')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="seccion-filtro">Dirección</div>
            <hr class="separador">

            <div class="row">
                <div class="col-sm-3 form-group">
                    <label for="">Región</label>
                    <select class="custom-select mayuscula" name="region" id="region_usuario">
                        @foreach ($regiones as $region)
                            @if ($region->id == $trabajadores[0]->id_region)
                                <option selected value="{{ $region->id }}"
                                    {{ old('region') == $region->id ? 'selected' : '' }}>{{ $region->des_region }}</option>
                            @else
                                <option value="{{ $region->id }}" {{ old('region') == $region->id ? 'selected' : '' }}>
                                    {{ $region->des_region }}</option>
                            @endif
                        @endforeach
                    </select>
                    @error('region')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-sm-3 form-group">
                    <label for="">Comuna</label>
                    <select class="custom-select mayuscula" name="comuna" id="comuna_usuarios">
                        @foreach ($comunas as $comuna)
                            @if ($comuna->id == $trabajadores[0]->id_comuna)
                                <option selected value="{{ $comuna->id }}"
                                    {{ old('comuna') == $comuna->id ? 'selected' : '' }}>{{ $comuna->des_comuna }}</option>
                            @else
                                <option value="{{ $comuna->id }}" {{ old('comuna') == $comuna->id ? 'selected' : '' }}>
                                    {{ $comuna->des_comuna }}</option>
                            @endif
                        @endforeach
                    </select>
                    @error('comuna')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-sm-6 form-group">
                    <label for="">Calle</label>
                    <input type="text" name="calle" class="form-control mayuscula"
                        value="{{ $trabajadores[0]->descripcion_direccion }}" placeholder="Calle">
                    @error('calle')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="seccion-filtro">Login</div>
            <hr class="separador">

            <div class="row">
                <div class="col-sm-3 form-group" style="display:">
                    <label for="">Tipo Usuario</label>
                    <select class="custom-select mayuscula" name="tipo_usu" id="tipos_usuarios">
                        @if ($trabajadores[0]->tipo_usuario == 'trabajador' && $trabajadores[0]->remoto == 0 )
                            <option selected value="Comun" {{ old('tipo_usu') == 'trabajador' ? 'selected' : '' }}>Tecnico
                            </option>
                            <option value="Coordinador">Coodinador</option>
                            <option value="remoto">Tecnico Remoto</option>
                            <option value="Comun">Tecnico</option>
                        @elseif($trabajadores[0]->tipo_usuario == 'trabajador' && $trabajadores[0]->remoto == 1 )
                            <option selected value="remoto" {{ old('tipo_usu') == 'trabajador' ? 'selected' : '' }}>Tecnico
                                Remoto</option>
                            <option value="Comun">Tecnico</option>

                            <option value="Coordinador">Coodinador</option>
                        @else
                            <option value="coordinador" {{ old('tipo_usu') == 'coordinador' ? 'selected' : '' }}>Coordinador
                            </option>
                            <option value="Comun">Tecnico</option>
                            <option value="remoto">Tecnico Remoto</option>
                        @endif
                    </select>
                    @error('tipo_usu')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
{{-- {{$trabajadores[0]->zona}} --}}
                <div class="col-sm-3 form-group" style="display:">
                    <label for="">Zona Usuario</label>
                    <select class="form-control mayuscula" name="userzona" id="zonausuario">
                        <option class="mayuscula" value="interno" {{ $trabajadores[0]->zona === 'interno' ? 'selected' : '' }}>Interno</option>
                        <option class="mayuscula" value="norte" {{ $trabajadores[0]->zona === 'norte' ? 'selected' : '' }}>Norte</option>
                        <option class="mayuscula" value="centro" {{ $trabajadores[0]->zona === 'centro' ? 'selected' : '' }}>Centro</option>
                        <option class="mayuscula" value="sur" {{ $trabajadores[0]->zona === 'sur' ? 'selected' : '' }}>Sur</option>
                    </select>
                    @error('userzona')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>

                <div class="col-sm-3 form-group" id="" style="display:">
                    {{-- <div class="col-sm-3 form-group" id="div_permisosExtras" style="display:none"> --}}

                    <label for="">Permisos Extras</label>
                    {{-- {{ $trabajadores[0]->coord_is_remoto }}
                    {{ $trabajadores[0]->coord_is_tecnico }}
                    {{ $trabajadores[0]->coord_is_coord }} --}}
                    <div>
                        {{-- <input type="checkbox" name="coord_remoto" id="coord_remoto"  style="display:"  value="si"> Remoto --}}


                        @if ($trabajadores[0]->coord_is_remoto == 1)
                            <div id="coord_remoto" style="display: inline-block;">
                                <input type="checkbox" name="coord_remoto" checked id="coord_remoto_cb" value="si">
                                <label for="coord_remoto_cb">Remoto</label>
                            </div>
                        @else
                            <div id="coord_remoto" style="display: inline-block;">
                                <input type="checkbox" name="coord_remoto" id="coord_remoto_cb" value="si">
                                <label for="coord_remoto_cb">Remoto</label>
                            </div>
                        @endif

                        @if ($trabajadores[0]->coord_is_tecnico == 1)
                            <div id="coord_tecnico" style="display: inline-block;">
                                <input type="checkbox" name="coord_tecnico" checked id="coord_tecnico_cb" value="si">
                                Tecnico
                            </div>
                        @else
                            <div id="coord_tecnico" style="display: inline-block;">
                                <input type="checkbox" name="coord_tecnico"  id="coord_tecnico_cb" value="si">
                                Tecnico
                            </div>
                        @endif


                        @if($trabajadores[0]->coord_is_coord == 1)
                            <div id="coord_coordinador" style="display: inline-block;">
                                <input type="checkbox" checked name="coord_coordinador" id="coord_coordinador_cb" value="si">
                                Coordinador
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-3 form-group">
                    <label for="">Usuario</label>
                    <input type="text" class="form-control mayuscula" value="{{ $trabajadores[0]->usuario }}"
                        name="usuario" placeholder="Usuario">
                    @error('usuario')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-sm-3 form-group">
                    <label for="">Password</label>
                    <input type="password" class="form-control" value="{{ @old('password') }}" name="password"
                        placeholder="Password">
                    @error('password')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
                <div class="col-sm-3 form-group">
                    <label for="">Password</label>
                    <input type="password" class="form-control" value="{{ @old('password_2') }}" name="password_2"
                        placeholder="Password">
                    @error('password_2')
                        <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12 text-center">
                    <button type="submit" class="btn btn-success">Actualizar usuario</button>
                </div>
            </div>
        </form>
    </div>
@endsection
<script>
    $(function() {
        $('#region_trabajo').on('change', function() {
            var valor = $('#region_trabajo option:selected').val();

            var texto = $('#region_trabajo option:selected').text();
            var texto = '<label id=' + valor + "-" + valor + '>' + texto + '</label>';
            $('#opciones_dos').append('<input type="checkbox"  checked id="' + valor +
                '" name="selecionados[]" value="' + valor + '">' + texto + '<br> ');
            console.log(valor, texto);
            $("#region_trabajo").find("option[value='" + valor + "']").remove();
        });


        $(document).on('change', 'input[type="checkbox"]', function(e) {


            if (this.checked == false) {


                // $('#region_trabajo').append('<option value="'+this.value+'" >'+ $("#"+this.value+"-"+this.value+"").text()+'</option>');


                // $("#"+this.value+"").remove();
                // $("#"+this.value+"-"+this.value+"").text("");
                //   $('checkbox[value="'+this.value+'"]').remove();


            }

        });
    });
</script>
<script>
    $(function() {
        $('#tipos_usuarios').on('change', function() {
            var valor = $('#tipos_usuarios option:selected').val();
            (valor);

            if (valor == "Comun") {
                $('#region_trabajo').css('display', '');
                $('#label_region').css('display', '');
                $('#coord_remoto').css('display', '');
                $('#coord_tecnico').css('display', 'none');

            } else if (valor == "remoto") {
                $('#coord_remoto').css('display', 'none');
                $('#coord_tecnico').css('display', 'inline-block');
            } else {
                $('#region_trabajo').css('display', 'none');
                $('#label_region').css('display', 'none');

            }
            if ((valor == "Coordinador" || valor == "coordinador") && valor != "Comun") {
                $('#coord_remoto').css('display', 'inline-block');
                $('#coord_tecnico').css('display', 'inline-block');



            } else {
                $('#div_permisosExtras').css('display', 'none');

            }
            // if(valor == "Comun"){
            //   $('#div_comunas_trabajador').css('display','');

            // }else{
            //   $('#div_comunas_trabajador').css('display','none');

            // }

        });
    });

    $(document).ready(function() {



        $('#region_usuario').change(function() {
            buscar_comuna($("#region_usuario option:selected").val(), "#comuna_usuarios", "../");
            // alert("hols");
        })
        // ************************RUT*****************************************
        //validar rut  
        $("#rut").change(function() {
            checkRut($("#rut").val());
        });
        //agregar digito al rut
        $('#rut').on('input', function() {
            var valor = $("#rut").val().replace('.', '');
            valor = valor.replace('-', '');
            cuerpo = valor.slice(0, -1);
            dv = valor.slice(-1).toUpperCase();
            rut = cuerpo + '-' + dv;
            $("#rut").val(rut);
        });


        $('#correo').change(function() {

            validarEmail($("#correo").val());
        });

    });

    function validarEmail(valor) {
        if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3,4})+$/.test(valor)) {
            //  alert("La dirección de email " + valor + " es correcta.");
            console.log("listo");
        } else {
            //  alert("La dirección de email es incorrecta." + valor);
            //  $("#correo").val("");
        }
    }

    function checkRut(rut) {
        // Despejar Puntos
        var valor = rut.replace('.', '');
        // Despejar Guión
        valor = valor.replace('-', '');

        // Aislar Cuerpo y Dígito Verificador
        cuerpo = valor.slice(0, -1);
        dv = valor.slice(-1).toUpperCase();

        // Formatear RUN
        rut.value = cuerpo + '-' + dv

        // Si no cumple con el mínimo ej. (n.nnn.nnn)
        if (cuerpo.length < 7) {
            alert("Rut Incorrecto");
            $("#rut").val('');
        } else {

            // Calcular Dígito Verificador
            suma = 0;
            multiplo = 2;

            // Para cada dígito del Cuerpo
            for (i = 1; i <= cuerpo.length; i++) {

                // Obtener su Producto con el Múltiplo Correspondiente
                index = multiplo * valor.charAt(cuerpo.length - i);

                // Sumar al Contador General
                suma = suma + index;

                // Consolidar Múltiplo dentro del rango [2,7]
                if (multiplo < 7) {
                    multiplo = multiplo + 1;
                } else {
                    multiplo = 2;
                }

            }

            // Calcular Dígito Verificador en base al Módulo 11
            dvEsperado = 11 - (suma % 11);

            // Casos Especiales (0 y K)
            dv = (dv == 'K') ? 10 : dv;
            dv = (dv == 0) ? 11 : dv;

            // Validar que el Cuerpo coincide con su Dígito Verificador
            if (dvEsperado != dv) {
                alert("Rut incorrecto");
                $("#rut").val('');
            }
        }

    }
</script>
