<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDepositoMensualsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('deposito_mensuals', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('titulo_deposito');
            $table->text('descripcion_deposito');
            $table->double('total');
            $table->timestamp('fecha_realizado');
            $table->unsignedBigInteger('id_administrado'); // Relación 
            $table->foreign('id_administrado')->references('id')->on('administradors');
            $table->unsignedBigInteger('id_billetera'); // Relación 
            $table->foreign('id_billetera')->references('id')->on('billetera_virtuals');
            $table->unsignedBigInteger('id_tipo_cuenta'); // Relación 
            $table->foreign('id_tipo_cuenta')->references('id')->on('tipos_cuentas_bancos');
            $table->unsignedBigInteger('id_banco'); // Relación 
            $table->foreign('id_banco')->references('id')->on('cuentas_bancos');
            // $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('deposito_mensuals');
    }
}
