<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMisCuentasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('mis_cuentas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('nombre_persona_cuenta');
            $table->string('apellido_persona_cuenta');
            $table->string('correo_bancario');
            $table->string('numero_cuenta');
            $table->integer('total_cuentas'); //maximo dos cuentas, puede tener
            $table->unsignedBigInteger('id_trabajador'); // Relación 
            $table->foreign('id_trabajador')->references('id')->on('trabajadors');
            $table->unsignedBigInteger('id_tipo_cuenta'); // Relación 
            $table->foreign('id_tipo_cuenta')->references('id')->on('tipos_cuentas_bancos');
            // $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mis_cuentas');
    }
}
