<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSolicitudesReembolsosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('solicitudes_reembolsos', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->date('fecha_solicitada');
            $table->time('hora_solicitada');
            $table->integer('estado_solicitud');
            $table->unsignedBigInteger('id_trabajador'); // Relación 
            $table->foreign('id_trabajador')->references('id')->on('trabajadors');
            $table->unsignedBigInteger('gasto_historial'); // Relación 
            $table->foreign('gasto_historial')->references('id')->on('gastos_historials');
            // $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('solicitudes_reembolsos');
    }
}
