<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePersonasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('regions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('des_region',60);

            // $table->timestamps();
        });

        Schema::create('comunas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('des_comuna',60);
            $table->unsignedBigInteger('id_region'); // Relación 
            $table->foreign('id_region')->references('id')->on('regions');
        });

        Schema::create('direccions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('descripcion_direccion');
            $table->unsignedBigInteger('id_region'); // Relación 
            $table->foreign('id_region')->references('id')->on('regions');
            $table->unsignedBigInteger('id_comuna'); // Relación 
            $table->foreign('id_comuna')->references('id')->on('comunas');
            // $table->timestamps();
        });

        Schema::create('personas', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('rut', 45);
            $table->string('nombre_uno', 45);
            $table->string('nombre_dos', 45);
            $table->string('apellido_uno', 45);
            $table->string('telefono1', 45);
            $table->string('telefono2', 45)->nullable();
            $table->string('correo1', 45);
            $table->string('correo2', 45)->nullable();

            $table->unsignedBigInteger('id_direccion'); // Relación 
            $table->foreign('id_direccion')->references('id')->on('direccions');

            // $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('regions');
        Schema::dropIfExists('comunas');
        Schema::dropIfExists('direccions');
        Schema::dropIfExists('personas');
    }
}
