<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEstadoFinalSolicitudesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('estado_final_solicitudes', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->text('descripcion');
            $table->date('fecha_respondido');
            $table->date('fecha_depositado');
            $table->integer('estado_actual'); //1 aceptado, 2 rechasado
            $table->unsignedBigInteger('id_administrado'); // Relación 
            $table->foreign('id_administrado')->references('id')->on('administradors');
            $table->unsignedBigInteger('id_solicitud_reembolsos'); // Relación 
            $table->foreign('id_solicitud_reembolsos')->references('id')->on('solicitudes_reembolsos');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('estado_final_solicitudes');
    }
}
