<?php
    namespace App\Mail;

    use Illuminate\Bus\Queueable;
    use Illuminate\Contracts\Queue\ShouldQueue;
    use Illuminate\Mail\Mailable;
    use Illuminate\Queue\SerializesModels;
    use App\solicitudes_remotas;
    use App\banco_api_solicitudes;
    use App\asignacion_banco_api_solis;
    use App\api_solicitudes;
    use Carbon\Carbon;


    class correoPdfServicioFinalizadoRemoto extends Mailable{
        use Queueable, SerializesModels;
        public $idRemoto;
        public $nombrePdf;

        public $hora_inicio; 
        public $cliente; 
        public $contacto;
        public $comuna; 
        public $region;
        public $tipo_visita; 
        public $descripcion_cliente;
        public $sc; 
        public $ip;
        public $inc;
        public $modelo; 
        public $estado_instalacion; 
        public $observacion_tecnico;


        // public $Sc;
        // public $proveedor;


        public function __construct($idRemoto,$nombrePdf){
            $this->idRemoto = $idRemoto;
            $this->nombrePdf = $nombrePdf;
            // $this->Sc = $Sc;
            // $this->proveedor = $proveedor;


            }
        public function build()
        {


            $idremoto =$this->idRemoto;
            
                                
            $solicitudes_remotas = solicitudes_remotas::where('id', '=', $idremoto)->first();
            $api_solicitudes = api_solicitudes::where('id_solicitudes_remotas', '=', $idremoto)->first();
            $asignacion_banco_api_solis = asignacion_banco_api_solis::where('id_solicitud_remota', '=', $idremoto)->first();


            $hora_con_minutos = Carbon::parse($solicitudes_remotas->fecha_registrada)->format('H:i');

            
             $this->hora_inicio =  $hora_con_minutos.":00 Hrs";

             $this->cliente = $api_solicitudes->sCliente; 
             $this->contacto =$api_solicitudes->sContacto; 
             $this->comuna = $api_solicitudes->sComuna; 
             $this->region = $api_solicitudes->sRegion; 
             $this->tipo_visita = "SERVICIO"; 
             $this->descripcion_cliente = $solicitudes_remotas->observaciones; 
             $this->sc = $api_solicitudes->sSC; 
             $this->ip = $api_solicitudes->sIP; 
             $this->inc = $api_solicitudes->inc; 
             $this->modelo = $api_solicitudes->sModelo; 
             $this->estado_instalacion = $api_solicitudes->estado_interno; 
             $this->observacion_tecnico = $asignacion_banco_api_solis->observacion_tecnico; 




            return $this->subject("SC".$this->sc)->view('solicitudes_servicios.remote.envioCorreoMail')
            ->with([
                'hora_inicio' => $this->hora_inicio, 
                'cliente' => $this->cliente ,
                'contacto' => $this->contacto,
                'comuna' => $this->comuna ,
                'region' => $this->region,
                'tipo_visita' => $this->tipo_visita ,
                'descripcion_cliente' => $this->descripcion_cliente,
                'sc' => $this->sc ,
                'ip' => $this->ip,
                'inc' => $this->inc,
                'modelo' => $this->modelo ,
                'estado_instalacion' => $this->estado_instalacion ,
                'observacion_tecnico' => $this->observacion_tecnico
            ])

            ->attach(storage_path('app/public/pdfServicio/' .  $this->nombrePdf));



            return $this->subject($asunto)->view('solicitudes_servicios.remote.pdfSolicitudRemota')->with([
                'idRemoto' => $this->idRemoto, //this works without queue

            ]);
        }
    }