<?php
    namespace App\Mail;

    use Illuminate\Bus\Queueable;
    use Illuminate\Contracts\Queue\ShouldQueue;
    use Illuminate\Mail\Mailable;
    use Illuminate\Queue\SerializesModels;
    use App\solicitudes_remotas;
    use App\banco_api_solicitudes;
    use App\asignacion_banco_api_solis;
    use App\api_solicitudes;
    use Carbon\Carbon;
    class TestMail extends Mailable{
        use Queueable, SerializesModels;
        public $details;
        public $sc;
        public $nSerie;
        public $idRemoto;

        public $hora_inicio;
        public $ip;
        public $inc;


        public function __construct($details,$sc,$nSerie,$size,$idRemoto = "",$fechaInicioAsignacionn = ""){
            $this->details = $details;
            $this->sc = $sc;
            $this->nSerie = $nSerie;
            $this->size = $size;
            $this->idRemoto = $idRemoto;
            $this->fechaInicioAsignacionn = $fechaInicioAsignacionn;
        }
        public function build()
        {
            $sc = $this->sc;
            $nSerie = $this->nSerie;
            $size = $this->size;
            $idRemoto = $this->idRemoto;
            $fechaInicioAsignacionn = $this->fechaInicioAsignacionn;
            

                    
            $solicitudes_remotas = solicitudes_remotas::where('id', '=', $this->idRemoto)->first();
            $api_solicitudes = api_solicitudes::where('id_solicitudes_remotas', '=', $this->idRemoto)->first();
            $asignacion_banco_api_solis = asignacion_banco_api_solis::where('id_solicitud_remota', '=', $this->idRemoto)->first();
            $hora_con_minutos = Carbon::parse($fechaInicioAsignacionn)->format('H:i');


            $this->hora_inicio =  $hora_con_minutos.":00 Hrs";
            $this->sc  = $api_solicitudes->sSC; 
            $this->ip = $api_solicitudes->sIP; 
            $this->inc =  $api_solicitudes->inc; 



            if (!empty($sc)) {
                if ($size >= 20000000) {
                    return $this->subject($sc)->view('email.TestEmail')->with([
                        'hora_inicio' => $this->hora_inicio, 
                        'sc' => $this->sc ,
                        'ip' => $this->ip,
                        'inc' => $this->inc,
                      
                    ]);
                }else{
                    return $this->subject($sc)->view('email.TestEmail')->with([
                        'hora_inicio' => $this->hora_inicio, 
                        'sc' => $this->sc ,
                        'ip' => $this->ip,
                        'inc' => $this->inc,
                      
                    ])->attach(storage_path('app/public/pdfServicio/' . $sc . 'servicio.pdf'));
                }
            }else{
                if ($size >= 20000000) {
                    return $this->subject($nSerie)->view('email.TestEmail')->with([
                        'hora_inicio' => $this->hora_inicio, 
                        'sc' => $this->sc ,
                        'ip' => $this->ip,
                        'inc' => $this->inc,
                      
                    ]);
                } else {
                    return $this->subject($nSerie)->view('email.TestEmail')->with([
                        'hora_inicio' => $this->hora_inicio, 
                        'sc' => $this->sc ,
                        'ip' => $this->ip,
                        'inc' => $this->inc,
                      
                    ])->attach(storage_path('app/public/pdfinstalacion/' . $nSerie . 'instalacion.pdf'));
                }            
            }
        }
    }