<?php

namespace App\Http\Controllers\reportes;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\emailCheck;
use App\Mail\emailDiario;
use App\Mail\emailServicioDiario;
use DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Config;
use App\bd_proveedores;


class reportesController extends Controller
{
    public function enviarreporte()
    {
        // $databases = $this->nombre_database();
        $databases = bd_proveedores::selectDB();

        foreach ($databases as $los_datos) {

            $clientesProyectos =  DB::connection(strtolower($los_datos->Database))->select('
            SELECT 
                clientes.razon_social as cliente,
                proyectos.url_logo,
                proyectos.nombre as nombre_proyecto,
                proyectos.proveedor_nombre as proveedor,
                proyectos.id as id_proyecto 
                FROM `clientes` 
                INNER JOIN proyectos on clientes.id = proyectos.clientes_id 
                WHERE proyectos.enviar_reporte_diario = 1
                AND clientes.id != 4');

            foreach ($clientesProyectos as $los_datos_cliente) {
                // = '."'".Carbon::now()->subDay(1)->toDateString()->subDay(2)."'".'  and 
                
                
                
                $instalaciones =  DB::connection(strtolower($los_datos->Database))->select('
                SELECT 
                    count(instalacions.sEstado_instalacion) as cantidad 
                FROM `instalacions`
                WHERE (instalacions.sEstado_instalacion LIKE "%asignad%" or instalacions.sEstado_instalacion LIKE "%revisar%" or instalacions.sEstado_instalacion LIKE "%pendiente%" or instalacions.sEstado_instalacion LIKE "%rechazado%" or  instalacions.sEstado_instalacion LIKE "%finalizado%" or  instalacions.sEstado_instalacion LIKE "%cancelado%")
                AND fecha_instalacion_coordinadora = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '  
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');

                if (empty($instalaciones)) {
                    $ins = 0;
                } else {
                    $ins = $instalaciones[0]->cantidad;
                }

                //TOTALES
    
                // $instalacionesT =  DB::connection(strtolower($los_datos->Database))->select('
                // SELECT 
                //     count(instalacions.sEstado_instalacion) as cantidad 
                // FROM `instalacions`
                // WHERE  tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');
 $instalacionesT =  DB::connection(strtolower($los_datos->Database))->select('SELECT count(instalacions.sEstado_instalacion) as cantidad FROM `instalacions` WHERE instalacions.sCliente = "Registro Civil" ');

                if (empty($instalacionesT)) {
                    $insT = 0;
                } else {
                    $insT = $instalacionesT[0]->cantidad;
                }

                    //

                $instalacionesFinalizadas =  DB::connection(strtolower($los_datos->Database))->select('
                SELECT 
                    count(instalacions.sEstado_instalacion) as cantidad FROM `instalacions`
                WHERE fecha_instalacion_coordinadora = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '  
                AND instalacions.sEstado_instalacion LIKE "%finalizado%" 
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');

                if (empty($instalaciones)) {
                    $ins_f = 1;
                } else {
                    $ins_f = $instalacionesFinalizadas[0]->cantidad;
                }
//totales finalizadas

                $instalacionesFinalizadasT =  DB::connection(strtolower($los_datos->Database))->select('
                SELECT 
                    count(instalacions.sEstado_instalacion) as cantidad FROM `instalacions`
                WHERE  
                 instalacions.sEstado_instalacion LIKE "%finalizado%" 
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');

                if (empty($instalacionesT)) {
                    $ins_f_t = 1;
                } else {
                    $ins_f_t = $instalacionesFinalizadasT[0]->cantidad;
                }
//

$instalacionesPendientes =  DB::connection(strtolower($los_datos->Database))->select('
SELECT 
    count(instalacions.sEstado_instalacion) as cantidad 
FROM `instalacions`
WHERE fecha_instalacion_coordinadora = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '  
AND instalacions.sEstado_instalacion LIKE "%revisar%" 
AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');

if (empty($instalaciones)) {
    $ins_p  = 1;
} else {
    $ins_p = $instalacionesPendientes[0]->cantidad;
}

//totales pendientes


                $instalacionesPendientesT =  DB::connection(strtolower($los_datos->Database))->select('
                SELECT 
                    count(instalacions.sEstado_instalacion) as cantidad 
                FROM `instalacions`
                WHERE  instalacions.sEstado_instalacion LIKE "%revisar%" 
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');

                if (empty($instalacionesT)) {
                    $ins_pT  = 1;
                } else {
                    $ins_pT = $instalacionesPendientesT[0]->cantidad;
                }
    //            



                $instalacionesCanceladas =  DB::connection(strtolower($los_datos->Database))->select('
                SELECT 
                    count(instalacions.sEstado_instalacion) as cantidad 
                FROM `instalacions`
                WHERE fecha_instalacion_coordinadora = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . ' 
                AND instalacions.sEstado_instalacion LIKE "%cancelado%" 
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');

                if (empty($instalaciones)) {
                    $ins_c  = 1;
                } else {
                    $ins_c = $instalacionesCanceladas[0]->cantidad;
                }

                // TOTALES CANCELADAS

                $instalacionesCanceladasT =  DB::connection(strtolower($los_datos->Database))->select('
                SELECT 
                    count(instalacions.sEstado_instalacion) as cantidad 
                FROM `instalacions`
                WHERE instalacions.sEstado_instalacion LIKE "%cancelado%" 
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');

                if (empty($instalaciones)) {
                    $ins_cT  = 1;
                } else {
                    $ins_cT = $instalacionesCanceladasT[0]->cantidad;
                }
                //

                $instalacionesAsignadas =  DB::connection(strtolower($los_datos->Database))->select('
                SELECT 
                    count(instalacions.sEstado_instalacion) as cantidad 
                FROM `instalacions`
                WHERE fecha_instalacion_coordinadora = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '  
                AND instalacions.sEstado_instalacion LIKE "%asignad%" 
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');

                if (empty($instalaciones)) {
                    $ins_a = 1;
                } else {
                    $ins_a =    $instalacionesAsignadas[0]->cantidad;
                }                       // print_r( $instalaciones);



                    //TOTALES ASIGNADAS

                    $instalacionesAsignadasT =  DB::connection(strtolower($los_datos->Database))->select('
                    SELECT 
                        count(instalacions.sEstado_instalacion) as cantidad 
                    FROM `instalacions`
                    WHERE instalacions.sEstado_instalacion LIKE "%asignad%" 
                    AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');

                    if (empty($instalaciones)) {
                        $ins_aT = 1;
                    } else {
                        $ins_aT =    $instalacionesAsignadasT[0]->cantidad;
                    }  

                    //

                $instalacionesRevisar =  DB::connection(strtolower($los_datos->Database))->select('
                SELECT 
                    count(instalacions.sEstado_instalacion) as cantidad 
                FROM `instalacions`
                WHERE fecha_instalacion_coordinadora = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '  
                AND instalacions.sEstado_instalacion LIKE "%revisar%" 
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');

                if (empty($instalaciones)) {
                    $ins_re = 1;
                } else {
                    $ins_re =    $instalacionesRevisar[0]->cantidad;
                }



                 //TOTALES REVISAR
                 $instalacionesRevisarT =  DB::connection(strtolower($los_datos->Database))->select('
                 SELECT 
                     count(instalacions.sEstado_instalacion) as cantidad 
                 FROM `instalacions`
                 WHERE instalacions.sEstado_instalacion LIKE "%revisar%" 
                 AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');
 
                 if (empty($instalaciones)) {
                     $ins_reT = 1;
                 } else {
                     $ins_reT =    $instalacionesRevisarT[0]->cantidad;
                 }
 
                 //



                $instalacionesRechazado =  DB::connection(strtolower($los_datos->Database))->select('
                SELECT 
                    count(instalacions.sEstado_instalacion) as cantidad
                FROM `instalacions`
                WHERE fecha_instalacion_coordinadora = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '  
                AND instalacions.sEstado_instalacion LIKE "%rechazado%" 
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');

                if (empty($instalaciones)) {
                    $ins_rech = 1;
                } else {
                    $ins_rech =   100;
                }


                //TOTALS RECHAZADAS

                $instalacionesRechazadoT =  DB::connection(strtolower($los_datos->Database))->select('
                SELECT 
                    count(instalacions.sEstado_instalacion) as cantidad
                FROM `instalacions`
                WHERE instalacions.sEstado_instalacion LIKE "%rechazado%" 
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');

                if (empty($instalaciones)) {
                    $ins_rechT = 1;
                } else {
                    $ins_rechT =    $instalacionesRechazadoT[0]->cantidad;
                }
                //

                $saliente = DB::connection(strtolower($los_datos->Database))->select('
                SELECT 
                    count(instalacions.Csserie_es) as cantidad 
                FROM `instalacions`
                WHERE fecha_instalacion_coordinadora = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '  
                AND instalacions.Csserie_es IS NOT NULL 
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)');

                if (empty($instalaciones)) {
                    $ins_sa = 0;
                } else {
                    $ins_sa =    $saliente[0]->cantidad;
                }

                $instalacionesFinalizadasComunas = DB::connection(strtolower($los_datos->Database))->select('
                SELECT 
                    count(instalacions.sEstado_instalacion) as cantidad, 
                    sComuna 
                FROM `instalacions`
                WHERE fecha_instalacion_coordinadora = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '  
                AND (instalacions.sEstado_instalacion LIKE "%finalizado%" or  instalacions.sEstado_instalacion LIKE "%cancelado%") 
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1) group by sComuna');

                $grafico1[] =
                    [
                        'proveedores' => $los_datos->Database,
                        'cliente' => $los_datos_cliente->cliente,
                        'proyectos' => $los_datos_cliente->nombre_proyecto,
                        'proveedor' => $los_datos_cliente->proveedor,
                        'instalaciones' => $ins,
                        'cancelados' => $ins_c,
                        'pendientes' => $ins_p,
                        'asignados' => $ins_a,
                        'revisar' => $ins_re,
                        'finalizados' => $ins_f,
                        'rechazado' => $ins_rech,
                        'fecha_actual' =>  Carbon::now()->subDay(1)->toDateString(),
                        'total' => $ins,
                        'logo_cliente' => $los_datos_cliente->url_logo,
                        'ins_sa' => $ins_sa,
                        'id_proyecto' => $los_datos_cliente->id_proyecto,
                        'database' =>  $los_datos->Database,
                        //  'modelos_instalados'=>  $modelosInstalados,
                        //  'tipo_conexion'=>  $tipoConexion,
                        //  'namecarpetas'=> 'arielas',
                    ];
                    //GRAFICO TOTALES

                    $graficoTotales[] =
                    [
                        'proveedores' => $los_datos->Database,
                        'cliente' => $los_datos_cliente->cliente,
                        'proyectos' => $los_datos_cliente->nombre_proyecto,
                        'proveedor' => $los_datos_cliente->proveedor,
                        'instalaciones' => $insT,
                        'cancelados' => $ins_cT,
                        'pendientes' => $ins_pT,
                        'asignados' => $ins_aT,
                        'revisar' => $ins_reT,
                        'finalizados' => $ins_f_t,
                        'rechazado' => $ins_rechT,
                        'fecha_actual' =>  Carbon::now()->subDay(1)->toDateString(),
                        'total' => $insT,
                        'logo_cliente' => $los_datos_cliente->url_logo,
                        'ins_sa' => $ins_sa,
                        'id_proyecto' => $los_datos_cliente->id_proyecto,
                        'database' =>  $los_datos->Database,
                        //  'modelos_instalados'=>  $modelosInstalados,
                        //  'tipo_conexion'=>  $tipoConexion,
                        //  'namecarpetas'=> 'arielas',
                    ];


                //GRAFICO NUMERO DOS
                $modelosInstalados = DB::connection(strtolower($los_datos->Database))->select('
                SELECT instalacions.sModelo,
                    count(instalacions.sModelo) as cantidad  
                FROM `instalacions`
                WHERE (instalacions.sEstado_instalacion LIKE "%finalizado%" or instalacions.sEstado_instalacion LIKE "%cancelado%") 
                AND instalacions.sModelo IS NOT NULL 
                AND fecha_instalacion_coordinadora = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '  
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' and  tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1) GROUP BY sModelo');

                $descripcion;
                $cantidad;
                foreach ($modelosInstalados as $datos3) {
                    $descripcion[]  = $datos3->sModelo;
                    $cantidad[]  = $datos3->cantidad;
                }

                if (empty($descripcion)) {
                    $descripcion[] = "sin datos";
                }
                if (empty($cantidad)) {
                    $cantidad[] = 1;
                }

                $grafico2[] =
                    [
                        'proveedores' => $los_datos->Database,
                        'cliente' => $los_datos_cliente->cliente,
                        'proyectos' => $los_datos_cliente->nombre_proyecto,
                        'proveedor' => $los_datos_cliente->proveedor,
                        'fecha_actual' =>  Carbon::now()->subDay(1)->toDateString(),
                        'total' => $instalaciones[0]->cantidad,
                        'logo_cliente' => $los_datos_cliente->url_logo,
                        'modelos_instalados' =>  $descripcion,
                        'cantidad_instalados' =>  $cantidad,
                        //  'namecarpetas'=> 'arielas',
                    ];

                unset($descripcion);
                unset($cantidad);
                //return $los_datos_cliente->id_proyecto;

                //FGRAFICO NUMERO 3
                $tipoConexion = DB::connection(strtolower($los_datos->Database))->select('
                    SELECT
                        checklist_instalacions.tipo_equipo,
                        COUNT(checklist_instalacions.tipo_equipo) as cantidad 
                    FROM instalacions
                    INNER JOIN asignacion_instalacions ON asignacion_instalacions.lista_instalacion_id = instalacions.id 
                    INNER JOIN checklist_instalacions ON checklist_instalacions.asignacion_instalacion_retiro_id = asignacion_instalacions.id 
                    WHERE (asignacion_instalacions.estado_asignacion LIKE "%finalizado%" or asignacion_instalacions.estado_asignacion LIKE "%cancelado%") 
                    AND (instalacions.sEstado_instalacion LIKE "%finalizado%" or instalacions.sEstado_instalacion LIKE "%cancelado%") 
                    AND checklist_instalacions.tipo_equipo IS NOT NULL
                    AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' and tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)
                    AND asignacion_instalacions.fecha_instalacion  = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . ' GROUP BY tipo_equipo');
                //    $redusb =  DB::connection(strtolower($los_datos->Database))->select('SELECT checklist_instalacions.CUsb_red, COUNT( checklist_instalacions.CUsb_red) as cantidad FROM `instalacions` INNER JOIN asignacion_instalacions ON asignacion_instalacions.lista_instalacion_id = instalacions.id INNER JOIN checklist_instalacions ON asignacion_instalacions.id = checklist_instalacions.asignacion_instalacion_retiro_id WHERE (  asignacion_instalacions.estado_asignacion LIKE "%finalizado%" or  instalacions.estado_asignacion LIKE "%cancelado%") and checklist_instalacions.CUsb_red IS NOT NULL and tracker_idtracker = (SELECT tracker.id FROM tracker WHERE   tracker.proyecto_id = '.$los_datos_cliente->id_proyecto.' and  tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)  and fecha_instalacion_coordinadora  = '."'".Carbon::now()->subDay(1)->toDateString()."'".' GROUP BY CUsb_red');
                $descripcion2;
                $cantidad2;

                foreach ($tipoConexion as $datos4) {
                    $descripcion2[]  = $datos4->tipo_equipo;
                    $cantidad2[]  = $datos4->cantidad;
                }
                if (empty($descripcion2)) {
                    $descripcion2[] = "sin datos";
                }
                if (empty($cantidad2)) {
                    $cantidad2[] = 1;
                }

                $grafico3[] =
                    [
                        'proveedores' => $los_datos->Database,
                        'cliente' => $los_datos_cliente->cliente,
                        'proyectos' => $los_datos_cliente->nombre_proyecto,
                        'proveedor' => $los_datos_cliente->proveedor,
                        'fecha_actual' =>  Carbon::now()->subDay(1)->toDateString(),
                        'total' => $instalaciones[0]->cantidad,
                        'logo_cliente' => $los_datos_cliente->url_logo,
                        'tipo_conexion' =>  $descripcion2,
                        'cantidad_instalados' =>  $cantidad2,
                        //  'namecarpetas'=> 'arielas',
                    ];

                unset($descripcion2);
                unset($cantidad2);

                //GRAFICO NUMERO 4
                $redusb = DB::connection(strtolower($los_datos->Database))->select('
                SELECT
                    tipo_conexiones.descripcion, 
                    COUNT(tipo_conexiones.descripcion) as cantidad 
                FROM `instalacions` 
                INNER JOIN asignacion_instalacions ON asignacion_instalacions.lista_instalacion_id = instalacions.id 
                INNER JOIN checklist_instalacions ON asignacion_instalacions.id = checklist_instalacions.asignacion_instalacion_retiro_id 
                INNER JOIN tipo_conexiones ON tipo_conexiones.id = checklist_instalacions.tipo_conexiones_id
                WHERE (asignacion_instalacions.estado_asignacion LIKE "%finalizado%" or asignacion_instalacions.estado_asignacion LIKE "%cancelado%") 
                AND (instalacions.sEstado_instalacion LIKE "%finalizado%" or instalacions.sEstado_instalacion LIKE "%cancelado%") 
                AND tipo_conexiones.descripcion IS NOT NULL 
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $los_datos_cliente->id_proyecto . ' and tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1)  
                AND fecha_instalacion_coordinadora = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . ' GROUP BY descripcion');

                $descripcion5;
                $cantidad5;

                foreach ($redusb as $datos5) {
                    $descripcion5[]  = $datos5->descripcion;
                    $cantidad5[]  =  $datos5->cantidad;
                }

                if (empty($descripcion5)) {
                    $descripcion5[] = "sin datos";
                }
                if (empty($cantidad5)) {
                    $cantidad5[] = 1;
                }

                $grafico5[] =
                    [
                        'proveedores' => $los_datos->Database,
                        'cliente' => $los_datos_cliente->cliente,
                        'proyectos' => $los_datos_cliente->nombre_proyecto,
                        'proveedor' => $los_datos_cliente->proveedor,
                        'fecha_actual' =>  Carbon::now()->subDay(1)->toDateString(),
                        'total' => $instalaciones[0]->cantidad,
                        'logo_cliente' => $los_datos_cliente->url_logo,
                        'tipo_conexion' =>  $descripcion5,
                        'cantidad_instalados' =>  $cantidad5,
                        //  'namecarpetas'=> 'arielas',
                    ];

                unset($descripcion5);
                unset($cantidad5);
            }
        } //FIN FOREACH
        return view('reportes.graficodiario', compact('grafico1', 'grafico2', 'grafico3', 'grafico5','graficoTotales'));
    }

    public function pruebatabla()
    {

        $proveedor = "KYOCERA";
        //$fecha = Carbon::now()->subDay(1)->toDateString();
         $destinatario = ["ariel@globati.com","cristobal@globati.com","jlopez@synergy.cl","mvalenzuela@synergy.cl","rc_evidencia_habilitacion@synergy.cl","rvidal@synergy.cl","avelosoj@ayaingenieria.cl"];
        //$destinatario = ["ariel@globati.com","cristobal@globati.com"];

        $logo = "kyocera.png";
        //return view('reportes.reportecheck', compact('proveedor','fecha'));
        Mail::to($destinatario)->send(new emailCheck($proveedor, $logo));
    }

    public function crearimagen(request $req)
    {
        $jj = 0;
        foreach ($req->data_url2 as $datos) {
            //   $this->uploadImgBase64 ($datos['url'],$datos['nombre']);
            $finalizados_t = $req->datos_gtotales[$jj]['finalizados'];
            $total_t = $req->datos_gtotales[$jj]['total'];
            $asignados_t = $req->datos_gtotales[$jj]['asignados'];
            $pendientes_t = $req->datos_gtotales[$jj]['pendientes'];
            $cancelados_t = $req->datos_gtotales[$jj]['cancelados'];


            $cliente = $req->data_url[$jj]['cliente'];
            $proyecto = $req->data_url[$jj]['proyecto'];
            $proveedor = $req->data_url[$jj]['proveedor'];
            $cancelados = $req->data_url[$jj]['cancelados'];
            $pendientes = $req->data_url[$jj]['pendientes'];
            $revisar = $req->data_url[$jj]['revisar'];
            $finalizados = $req->data_url[$jj]['finalizados'];
            $rechazado = $req->data_url[$jj]['rechazado'];
            $asignados = $req->data_url[$jj]['asignados'];
            $id_proyecto = $req->data_url[$jj]['id_proyecto'];
            $database = $req->data_url[$jj]['database'];
            $total = $req->data_url[$jj]['total'];
            $total_saliente = $req->data_url[$jj]['total_saliente'];
            $fechaactual = $req->data_url[$jj]['fecha'];
            $logo_cliente = $req->data_url[$jj]['logo_cliente'];
            $g1 =  $req->data_url[$jj]['nombre'];
            $u1 =  $req->data_url[$jj]['url'];
            $g2 = $req->data_url2[$jj]['nombre'];
            $u2 =  $req->data_url2[$jj]['url'];
            $g3 = $req->data_url3[$jj]['nombre'];
            $u3 =  $req->data_url3[$jj]['url'];
            $g5 = $req->data_url5[$jj]['nombre'];
            $u5 =  $req->data_url5[$jj]['url'];
            $gt = $req->datos_gtotales[$jj]['nombre'];
            $ut =  $req->datos_gtotales[$jj]['url'];
            $this->uploadImgBase64($u1, $g1);
            $this->uploadImgBase64($u2, $g2);
            $this->uploadImgBase64($u3, $g3);
            $this->uploadImgBase64($u5, $g5);
            $this->uploadImgBase64($ut, $gt);

            if ($req->data_url3[$jj]['cantidad_instalados'] != 0) {

                $instalacionesFinalizadasComunas = DB::connection(strtolower($database))->select('
                SELECT 
                    count(instalacions.sEstado_instalacion) as cantidad, 
                    sComuna 
                FROM `instalacions`
                WHERE fecha_instalacion_coordinadora = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . ' 
                AND (instalacions.sEstado_instalacion LIKE "%asignad%" or instalacions.sEstado_instalacion LIKE "%revisar%" or instalacions.sEstado_instalacion LIKE "%pendiente%" or instalacions.sEstado_instalacion LIKE "%rechazado%" or  instalacions.sEstado_instalacion LIKE "%finalizado%" or  instalacions.sEstado_instalacion LIKE "%cancelado%") 
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1) group by sComuna');

                $instalacionesSalientesComunas = DB::connection(strtolower($database))->select('
                SELECT 
                    count(instalacions.Csserie_es) as cantidad, 
                    sComuna 
                FROM `instalacions`
                WHERE fecha_instalacion_coordinadora = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '  
                AND instalacions.Csserie_es IS NOT NULL
                AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1) group by sComuna');
               
               //TOTALES
               $insta_com_fina_tota = DB::connection(strtolower($database))->select('
               SELECT 
                   count(instalacions.sEstado_instalacion) as cantidad, 
                   sComuna 
               FROM `instalacions`
               WHERE (instalacions.sEstado_instalacion LIKE "%asignad%" or instalacions.sEstado_instalacion LIKE "%revisar%" or instalacions.sEstado_instalacion LIKE "%pendiente%" or instalacions.sEstado_instalacion LIKE "%rechazado%" or  instalacions.sEstado_instalacion LIKE "%finalizado%" or  instalacions.sEstado_instalacion LIKE "%cancelado%") 
               AND tracker_idtracker = (SELECT tracker.id FROM tracker WHERE tracker.proyecto_id = ' . $id_proyecto . ' AND tracker.tipo_tracker = "instalacion" ORDER BY id ASC limit 1) group by sComuna');

                //  ,"ssepulveda@ayaingenieria.cl"
                //$destinatario = ["ariel@globati.com", "cristobal@globati.com"];
                $destinatario = ["ariel@globati.com","cristobal@globati.com","jlopez@synergy.cl","mvalenzuela@synergy.cl","rc_evidencia_habilitacion@synergy.cl","rvidal@synergy.cl","avelosoj@ayaingenieria.cl"];
                //$destinatario = ["cristobal@globati.com","ariel@globati.com"];
               
                //$destinatario = ["ariel@globati.com", "cristobal@globati.com", "avelosoj@ayaingenieria.cl", "ariel@globati.com","projas@globati.com"];
                Mail::to($destinatario)->send(new emailDiario($cancelados_t,$pendientes_t,$asignados_t,$total_t,$finalizados_t,$insta_com_fina_tota,$gt,$g1, $g2, $g3, $g5, $cliente, $proyecto, $total, $fechaactual, $logo_cliente, $total_saliente, $asignados, $rechazado, $finalizados, $revisar, $pendientes, $cancelados, $id_proyecto, $database, $instalacionesFinalizadasComunas, $instalacionesSalientesComunas, $proveedor));
                //Mail::to($destinatario)->send(new emailCheck($proveedor,$logo_cliente));
            }
            $jj++;
        }
        return $req;
    }

    function uploadImgBase64($base64, $name)
    {
        $datosBase64 = base64_decode(str_replace('data:image/png;base64,', '', $base64));
        // $capturaLimpia = str_replace("data:image/png;base64,", "", urldecode($base64));
        // $imagenDecodificada = base64_decode($capturaLimpia);
        //optimixar para poder subir imagenes
        $path = $_SERVER['DOCUMENT_ROOT'] . '/aya/rendicion/fotos/fotos_reportes/' . $name . ".png";

        // guardamos la imagen en el server
        if (!file_put_contents($path, $datosBase64)) {
            // retorno si falla
            return "0";
        } else {
            // retorno si todo fue bien
            return "1";
        }
    }

    private function nombre_database()
    {
        $tables = DB::select('SHOW DATABASES WHERE `Database` NOT LIKE ' . '"' . '%max%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%aya%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%gas%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%schema%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%php%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%prueba%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%admin%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%fusion%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%sql%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%probando%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%soporte%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%sys%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%13octubre%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%nueva%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%rendicion%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%test%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%web%' . '"' . ' AND `Database` NOT LIKE ' . '"' . '%ofimundo%' . '"');
        return $tables;
    }

    public function formatoServicio()
    {
        //return view('reportes.reporteServicio');

        Config::set('database.connections.mysql.database', 'KYOCERA');
        DB::reconnect();

        $fechaactual = Carbon::now()->subDay(1)->toDateString();

        $servicioRevisar = DB::select('
            SELECT
                count(api_solicitudes.estado_interno) as cantidad
            FROM api_solicitudes
            WHERE api_solicitudes.estado_interno = "REVISAR"
            AND fecha_estado = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'");

        if (empty($servicioRevisar)) {
            $s_revisar = 0;
        } else {
            $s_revisar = $servicioRevisar[0]->cantidad;
        }

        $servicioSolicitarRepuesto = DB::select('
            SELECT
                count(api_solicitudes.estado_interno) as cantidad
            FROM api_solicitudes
            WHERE api_solicitudes.estado_interno = "Solicitar Repuestos"
            AND api_solicitudes.estado_externo != "Repuesto en Tránsito"
            AND fecha_estado = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'");

        if (empty($servicioSolicitarRepuesto)) {
            $s_solicitudRepuesto = 0;
        } else {
            $s_solicitudRepuesto = $servicioSolicitarRepuesto[0]->cantidad;
        }

        $servicioRespuestoTransito = DB::select('
            SELECT
                count(api_solicitudes.estado_externo) as cantidad
            FROM api_solicitudes
            WHERE api_solicitudes.estado_externo = "Repuesto en tránsito"
            AND fecha_estado = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'");

        if (empty($servicioRespuestoTransito)) {
            $s_respuestoTransito = 0;
        } else {
            $s_respuestoTransito = $servicioRespuestoTransito[0]->cantidad;
        }

        $servicioFinalizado = DB::select('
            SELECT
                count(api_solicitudes.estado_interno) as cantidad
            FROM api_solicitudes
            WHERE api_solicitudes.estado_interno = "FINALIZADO"
            AND fecha_estado = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'");

        if (empty($servicioFinalizado)) {
            $s_finalizado = 0;
        } else {
            $s_finalizado = $servicioFinalizado[0]->cantidad;
        }

        $total = $s_finalizado + $s_respuestoTransito + $s_solicitudRepuesto + $s_revisar;

        /**GRAFICO 1**/
        $modelosServicios = DB::select('
        SELECT api_solicitudes.sModelo,
            count(api_solicitudes.sModelo) as cantidad
        FROM api_solicitudes
        WHERE (api_solicitudes.estado_interno = "Solicitar Repuestos" or api_solicitudes.estado_interno = "REVISAR" or api_solicitudes.estado_interno = "FINALIZADO" or api_solicitudes.estado_interno = "Repuesto en tránsito")
        AND api_solicitudes.sModelo IS NOT NULL 
        AND fecha_estado = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '
        GROUP BY sModelo');

        if (!empty($modelosServicios)) {
            foreach ($modelosServicios as $datos) {
                $descripcion[]  = $datos->sModelo;
                $cantidad[]  = $datos->cantidad;
            }
        } else {
            $descripcion[]  = 0;
            $cantidad[]  = 0;
        }

        $grafico1[] = [
            'modelos_instalados' => $descripcion,
            'modelos_cantidad' => $cantidad,
            's_revisar' => $s_revisar,
            's_solicitudRepuesto' => $s_solicitudRepuesto,
            's_respuestoTransito' => $s_respuestoTransito,
            's_finalizado' => $s_finalizado,
            'total' => $total,
            'fecha_actual' => $fechaactual
        ];

        /**GRAFICO 2**/
        $coneccionServicios = DB::select('
        SELECT check_formulario_solicitudes.usb,
            count(check_formulario_solicitudes.usb) AS cantidad
        FROM api_solicitudes
        INNER JOIN asignacion_solicitudes ON asignacion_solicitudes.api_solicitudes_id = api_solicitudes.id 
        INNER JOIN check_formulario_solicitudes ON check_formulario_solicitudes.id = asignacion_solicitudes.check_formulario_solicitudes_id
        WHERE (api_solicitudes.estado_interno = "Solicitar Repuestos" AND asignacion_solicitudes.estado_interno = "Solicitar Repuestos")
        AND api_solicitudes.fecha_estado = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '
        OR api_solicitudes.estado_interno = "REVISAR" 
        AND api_solicitudes.fecha_estado = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '
        OR (api_solicitudes.estado_interno = "FINALIZADO" AND asignacion_solicitudes.estado_interno = "FINALIZADO") 
        AND api_solicitudes.fecha_estado = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '
        OR api_solicitudes.estado_interno = "Repuesto en tránsito"
        AND api_solicitudes.fecha_estado = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '
        AND check_formulario_solicitudes.usb IS NOT NULL 
        AND api_solicitudes.fecha_estado = ' . "'" . Carbon::now()->subDay(1)->toDateString() . "'" . '
        GROUP BY check_formulario_solicitudes.usb');

        if (!empty($coneccionServicios)) {
            foreach ($coneccionServicios as $datos2) {
                $descripcion2[]  = $datos2->usb;
                $cantidad2[]  = $datos2->cantidad;
            }
        } else {
            $descripcion2[]  = 0;
            $cantidad2[]  = 0;
        }

        $grafico2[] = [
            'coneccion_instalados' => $descripcion2,
            'coneccion_cantidad' => $cantidad2,
            'total' => $total
        ];

        return view('reportes.graficoServicio', compact('grafico1', 'grafico2', 'fechaactual', 's_revisar', 's_solicitudRepuesto', 's_respuestoTransito', 's_finalizado', 'fechaactual'));
    }
    public function reporteServicio(request $request)
    { 
        Config::set('database.connections.mysql.database', 'KYOCERA');
        DB::reconnect();

        $nombre = $request->data1[0]['nombre'];
        $url = $request->data1[0]['url'];
        $nombre2 = $request->data2[0]['nombre'];
        $url2 = $request->data2[0]['url'];
        $total = $request->data1[0]['total'];
        $fecha = $request->data1[0]['fecha'];
        $s_revisar = $request->data1[0]['s_revisar'];
        $s_solicitudRepuesto = $request->data1[0]['s_solicitudRepuesto'];
        $s_respuestoTransito = $request->data1[0]['s_respuestoTransito'];
        $s_finalizado = $request->data1[0]['s_finalizado'];
        $this->guardarGraficoServicio($url, $nombre);
        $this->guardarGraficoServicio($url2, $nombre2);

        $r_revisar = array();
        $r_solicitar = array();
        $r_transito = array();
        $r_finalizados = array();
        $regiones = [['XV'], ['I'], ['II'], ['III'], ['IV'], ['V'], ['RM'], ['VI'], ['VII'], ['XVI'], ['XVIII'], ['IX'], ['XIV'], ['X'], ['XI'], ['XII']];

        foreach ($regiones as $a) {

            $servicioR_revisar = DB::table('api_solicitudes')
                ->select('estado_interno')
                ->where('sRegion', '=', $a)
                ->where('estado_interno', '!=', null)
                ->where('estado_interno', '=', 'REVISAR')
                ->where('fecha_estado','=',Carbon::now()->subDay(1)->toDateString())
                ->get();

            array_push($r_revisar, count($servicioR_revisar));

            $servicioR_solicitar = DB::table('api_solicitudes')
                ->select('estado_interno')
                ->where('sRegion', '=', $a)
                ->where('estado_interno', '!=', null)
                ->where('estado_interno', '=', 'Solicitar Repuestos')
                ->where('estado_externo', '!=', 'Repuesto en Tránsito')
                ->where('fecha_estado','=',Carbon::now()->subDay(1)->toDateString())
                ->get();

            array_push($r_solicitar, count($servicioR_solicitar));

            $servicioR_transito = DB::table('api_solicitudes')
                ->select('estado_interno')
                ->where('sRegion', '=', $a)
                ->where('estado_interno', '!=', null)
                ->where('estado_externo', '=', 'Repuesto en tránsito')
                ->where('fecha_estado','=',Carbon::now()->subDay(1)->toDateString())
                ->get();

            array_push($r_transito, count($servicioR_transito));

            $serviciosR_finalizados = DB::table('api_solicitudes')
                ->select('estado_interno')
                ->where('sRegion', '=', $a)
                ->where('estado_interno', '!=', null)
                ->where('estado_interno', '=', 'FINALIZADO')
                ->where('fecha_estado','=',Carbon::now()->subDay(1)->toDateString())
                ->get();

            array_push($r_finalizados, count($serviciosR_finalizados));
        }

        //$destinatario = ["ariel@globati.com","cristobal@globati.com","jlopez@synergy.cl","mvalenzuela@synergy.cl","rc_evidencia_habilitacion@synergy.cl","rvidal@synergy.cl","avelosoj@ayaingenieria.cl"];
        $destinatario = ["ariel@globati.com", "cristobal@globati.com", "avelosoj@ayaingenieria.cl", "ariel@globati.com","projas@globati.com"];
        //$destinatario = ["ariel@globati.com"];

        Mail::to($destinatario)->send(new emailServicioDiario($r_revisar, $r_solicitar, $r_transito, $r_finalizados, $total, $fecha, $s_revisar, $s_solicitudRepuesto, $s_respuestoTransito, $s_finalizado, $nombre, $nombre2));
    }
    function guardarGraficoServicio($base64, $name)
    {
        $datosBase64 = base64_decode(str_replace('data:image/png;base64,', '', $base64));
        //optimixar para poder subir imagenes
        $path = $_SERVER['DOCUMENT_ROOT'] . '/aya/rendicion/fotos/fotos_reportesServicio/' . $name . ".png";

        // guardamos la imagen en el server
        if (!file_put_contents($path, $datosBase64)) {
            // retorno si falla
            return "0";
        } else {
            // retorno si todo fue bien
            return "1";
        }
        return "a";
    }
}
