<?php

namespace App\Http\Controllers\gastosreembolsos;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use App;
use Carbon\Carbon;
use Crypt;

class CrearProyectoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $carga_selectClientes = DB::table('clientes')
            ->select('razon_social', 'id')
            ->orderBy('razon_social', 'asc')
            ->where('estado', '=', '1')
            ->distinct()
            ->get();

        $proveedores =  DB::table('users')
            ->select('nombre_proveedor')
            ->orderBy('nombre_proveedor', 'asc')
            ->where('nombre_proveedor', '!=', '')
            ->distinct()
            ->get();

        return view('gastos.crear_proyectos', compact('carga_selectClientes', 'proveedores'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        return DB::transaction(function () use ($request) {


            if (!empty($request->cargafoto1)) {

                $file = $request->file('cargafoto1');
                //obtenemos el nombre del archivo
                $nombre =  time() . "_" . $file->getClientOriginalName();
                $extencion =  time() . "_" . $file->getClientOriginalExtension();
                //sacamos la exxtencion por medio de _
                $extencionArray = explode("_", $extencion);
                $nombreGuardar1 = rand(0, 1500) . "logo_" . trim($request->nombre_proyecto) . "." . $extencionArray[1];
                //indicamos que queremos guardar un nuevo archivo en el disco local
                \Storage::disk('fotos_logo_proyectos')->put($nombreGuardar1,  \File::get($file));
            }

            //nuevo
            $id_cliente = $request->clientes;
            $nombre_proyecto = $request->nombre_proyecto;
            $capacitacion = $request->capacitacion;
            $cantidad_equipos = $request->cantidad_equipos;
            $costo_proyecto = $request->costo_proyecto;
            $costo_usuarioadicional = $request->costo_usuarioadicional;

            //primer visita//
            $costo_habilitacion = $request->costo_habilitacion;
            $costo_instalacion = $request->costo_instalacion;
            $costo_capacitacion = $request->costo_capacitacion;
            $costo_retiro = $request->costo_retiro;
            $costo_actualizacion = $request->costo_actualizacion;
            //segunda visita//
            $costo_cortesia = $request->costo_cortesia;
            $costo_garantia = $request->costo_garantia;
            $costo_manteminiento = $request->costo_mantenimiento;
            $costo_capacitacionadicional = $request->costo_capacitacionadicional;
            $costo_retiroadicional = $request->costo_retiroadicional;

            $valorKilometro = $request->valorKilometro;

            if (!empty($request->cargafoto1)) {
                $crear_proyecto = new App\proyectos();
                $crear_proyecto->nombre = $nombre_proyecto;
                $crear_proyecto->capacitacion = $capacitacion;
                $crear_proyecto->costo_usuarioadicional = $costo_usuarioadicional;
                $crear_proyecto->valor_kilometro = $valorKilometro;
                $crear_proyecto->cantidad_equipos = $cantidad_equipos;
                $crear_proyecto->estado_proyecto = 'activo';
                $crear_proyecto->clientes_id = $id_cliente;
                $crear_proyecto->costo_proyecto = $costo_proyecto;
                $crear_proyecto->fecha_inicio = $request->fechaInicioProyecto;
                $crear_proyecto->fecha_termino = $request->fechaFinProyecto;
                $crear_proyecto->fecha_terminado = $request->fechaFinProyecto;
                $crear_proyecto->url_logo = $nombreGuardar1;
                $crear_proyecto->proveedor_nombre = strtolower(DB::connection()->getDatabaseName());
                $crear_proyecto->estado = 1;
                $crear_proyecto->timestamps = false;
                $crear_proyecto->save();
            } else {
                $crear_proyecto = new App\proyectos();
                $crear_proyecto->nombre = $nombre_proyecto;
                $crear_proyecto->capacitacion = $capacitacion;
                $crear_proyecto->costo_usuarioadicional = $costo_usuarioadicional;
                $crear_proyecto->valor_kilometro = $valorKilometro;
                $crear_proyecto->cantidad_equipos = $cantidad_equipos;
                $crear_proyecto->estado_proyecto = 'activo';
                $crear_proyecto->clientes_id = $id_cliente;
                $crear_proyecto->costo_proyecto = $costo_proyecto;
                $crear_proyecto->fecha_inicio = $request->fechaInicioProyecto;
                $crear_proyecto->fecha_termino = $request->fechaFinProyecto;
                $crear_proyecto->fecha_terminado = $request->fechaFinProyecto;
                $crear_proyecto->url_logo = "";
                $crear_proyecto->proveedor_nombre = strtolower(DB::connection()->getDatabaseName());
                //$crear_proyecto->proveedor_nombre = "prueba";
                $crear_proyecto->estado = 1;
                $crear_proyecto->timestamps = false;
                $crear_proyecto->save();
            }


            // $ultimo_id = proyectos::latest('id')->first('id');
            $crear_costoproyecto = new App\costos_proyectos();

            $total  = $costo_habilitacion + $costo_instalacion + $costo_capacitacion + $costo_retiro + $costo_actualizacion +  $costo_cortesia +  $costo_garantia;

            $crear_costoproyecto->proyecto_id = $crear_proyecto->id;
            $crear_costoproyecto->costo_descripcion = "primera visita";
            $crear_costoproyecto->costo_total = $total;
            $crear_costoproyecto->costo_habilitacion = $costo_habilitacion;
            $crear_costoproyecto->costo_instalacionaccesorios = $costo_instalacion;
            $crear_costoproyecto->costo_capacitacion = $costo_capacitacion;
            $crear_costoproyecto->costo_retiro = $costo_retiro;
            $crear_costoproyecto->costo_actualizacionfirmware = $costo_actualizacion;
            $crear_costoproyecto->costo_cortesia = $costo_cortesia;
            $crear_costoproyecto->costo_garantia = $costo_garantia;
            $crear_costoproyecto->costo_mantenimiento = $costo_manteminiento;
            $crear_costoproyecto->numero_visita = 1;
            $crear_costoproyecto->timestamps = false;
            $crear_costoproyecto->save();



            $crear_tracker = new App\tracker();
            $crear_tracker->tipo_tracker = "instalacion";
            $crear_tracker->estado_tracker = "activo";
            $crear_tracker->proyecto_id = $crear_proyecto->id;
            $crear_tracker->timestamps = false;
            $crear_tracker->save();

            $crear_tracker2 = new App\tracker();
            $crear_tracker2->tipo_tracker = "retiro";
            $crear_tracker2->estado_tracker = "activo";
            $crear_tracker2->proyecto_id = $crear_proyecto->id;
            $crear_tracker2->timestamps = false;
            $crear_tracker2->save();

            $crear_tracker2 = new App\tracker();
            $crear_tracker2->tipo_tracker = "servicios";
            $crear_tracker2->estado_tracker = "activo";
            $crear_tracker2->proyecto_id = $crear_proyecto->id;
            $crear_tracker2->timestamps = false;
            $crear_tracker2->save();

            return back()->with('mensaje', 'proyecto agregado');
        }, 5);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function Siguiente_CrearProyecto()
    {

        // //Cargar Select Clientes
        // $carga_selectClientes = DB::table('proyectos')
        //     ->select('proyectos.nombre','proyectos.id')
        //     ->orderBy('proyectos.id', 'asc')
        //     ->where('proyectos.estado', '=', 1)
        //     ->distinct()
        //     ->get();

        // return view('gastos.siguiente_crearproyectos', compact('carga_selectClientes'));
        //Cargar Select Clientes
        $carga_selectClientes = DB::table('clientes')
            ->select('clientes.razon_social', 'clientes.id')
            ->orderBy('clientes.razon_social', 'asc')
            ->distinct()
            ->get();

        return view('gastos.siguiente_crearproyectos', compact('carga_selectClientes'));
    }
    public function editarcosto($id)
    {

        $contactos = App\proyectos::findOrFail($id);
        return view('gastos.editarcostos_proyectos', compact('contactos'));
    }

    public function ver_datos(request $request)
    {

        $costosproyectos_id = $request->id;
        $datoscostos = App\costos_proyectos::where('id', '=', $costosproyectos_id)->first();
        return $datoscostos;
    }
    public function prueba(request $request)
    {


        $proyectosSeleccionado = $request->proyectosSeleccionado;
        $razonSocialCliente = "";
        $nombreProyecto = "";
        $fechaInicio = "";


        $nombrecliente = DB::table('proyectos')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->join('direccions', 'direccions.id', '=', 'clientes.id_direccion')
            ->join('regions', 'regions.id', '=', 'id_region')
            ->join('comunas', 'comunas.id', '=', 'direccions.id_comuna')
            ->select(
                'proyectos.id',
                'proyectos.nombre',
                'proyectos.cantidad_equipos',
                'proyectos.costo_proyecto',
                'proyectos.costo_usuarioadicional',

                'proyectos.valor_kilometro',
                'proyectos.fecha_inicio',
                'proyectos.fecha_termino',
                'proyectos.url_logo',
                'proyectos.capacitacion',

                'direccions.descripcion_direccion',
                'clientes.razon_social',
                'regions.des_region',
                'comunas.des_comuna'
            )
            ->take(1)
            ->where('proyectos.id', '=', $proyectosSeleccionado)
            ->get();


        $razonSocialCliente = $nombrecliente[0]->razon_social;
        $nombreProyecto = $nombrecliente[0]->nombre;
        $fechaInicio = $nombrecliente[0]->fecha_inicio;

        $datoscostos = DB::table('costos_proyectos')
            ->join('proyectos', 'proyectos.id', '=', 'costos_proyectos.proyecto_id')
            ->join('clientes', 'clientes.id', '=', 'proyectos.clientes_id')
            ->select(
                'costos_proyectos.id',
                'costos_proyectos.costo_habilitacion',
                'costos_proyectos.costo_instalacionaccesorios',
                'costos_proyectos.costo_capacitacion',
                'costos_proyectos.costo_retiro',
                'costos_proyectos.costo_actualizacionfirmware',
                'costos_proyectos.costo_cortesia',
                'costos_proyectos.costo_garantia',
                'costos_proyectos.numero_visita',
                'costos_proyectos.fecha_registro',
                'costos_proyectos.costo_descripcion'
            )
            ->where('proyectos.id', '=', $proyectosSeleccionado)
            ->get();

        $ultimavisita = DB::table('costos_proyectos')
            ->join('proyectos', 'proyectos.id', '=', 'costos_proyectos.proyecto_id')
            ->select('numero_visita')
            ->where('proyectos.id', '=', $proyectosSeleccionado)
            ->take(1)
            ->orderBy('numero_visita', 'desc')
            ->get();

        return view('gastos.update_proyectos', compact('nombrecliente', 'proyectosSeleccionado', 'datoscostos', 'ultimavisita', 'razonSocialCliente', 'nombreProyecto', 'fechaInicio'));
    }

    public function updateProyecto(request $request)
    {
        try {
            $idProyecto =   Crypt::decryptString($request->proyectoid);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
        $capacitacion = $request->capacitacion;
        $cantidad_equipos = $request->cantidad_equipos;
        $costo_proyecto = $request->costo_proyecto;
        $costo_usuarioadicional = $request->costo_usuarioadicional;
        $valorKilometro = $request->valorKilometro;


        if (!empty($request->cargafoto1)) {
            $file = $request->file('cargafoto1');
            //obtenemos el nombre del archivo
            $nombre =  time() . "_" . $file->getClientOriginalName();
            $extencion =  time() . "_" . $file->getClientOriginalExtension();
            //sacamos la exxtencion por medio de _
            $extencionArray = explode("_", $extencion);
            $nombreGuardar1 = rand(0, 1500) . "logo_" . trim($request->nombre_proyecto) . "." . $extencionArray[1];
            //indicamos que queremos guardar un nuevo archivo en el disco local
            \Storage::disk('fotos_logo_proyectos')->put($nombreGuardar1,  \File::get($file));

            $proyectos = App\proyectos::findOrFail($idProyecto);

            $proyectos->capacitacion = $capacitacion;
            $proyectos->costo_usuarioadicional = $costo_usuarioadicional;
            $proyectos->valor_kilometro = $valorKilometro;
            $proyectos->cantidad_equipos = $cantidad_equipos;

            $proyectos->costo_proyecto = $costo_proyecto;
            $proyectos->fecha_inicio = $request->fechaInicioProyecto;
            $proyectos->fecha_termino = $request->fechaFinProyecto;
            $proyectos->url_logo = $nombreGuardar1;
            $proyectos->timestamps = false;
            $proyectos->save();
        } else {



            $proyectos = App\proyectos::findOrFail($idProyecto);

            $proyectos->capacitacion = $capacitacion;
            $proyectos->costo_usuarioadicional = $costo_usuarioadicional;
            $proyectos->valor_kilometro = $valorKilometro;
            $proyectos->cantidad_equipos = $cantidad_equipos;

            $proyectos->costo_proyecto = $costo_proyecto;
            $proyectos->fecha_inicio = $request->fechaInicioProyecto;
            $proyectos->fecha_termino = $request->fechaFinProyecto;

            $proyectos->timestamps = false;


            $proyectos->save();
        }







        return back()->with('mensaje', 'Proyecto Modificado');
    }


    public function cambiarcantidadequipos(request $request)
    {
        $id = $request->id_check;
        $cantidadequipos = $request->cantidadequipos;

        $proyectos =  App\proyectos::findOrfail($id);
        $proyectos->cantidad_equipos = $cantidadequipos;
        $proyectos->timestamps = false;
        $proyectos->save();

        return $cantidadequipos;
    }

    public function cambiarusuarioadicional(request $request)
    {
        $id = $request->id_check;
        $usuarioadicional = $request->usuarioadicional;

        $proyectos =  App\proyectos::findOrfail($id);
        $proyectos->costo_usuarioadicional = $usuarioadicional;
        $proyectos->timestamps = false;
        $proyectos->save();

        return $usuarioadicional;
    }

    public function cambiarcostos(request $request)
    {

        try {
            $idProyecto =   Crypt::decryptString($request->idProyecto);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $id_visita = $request->id_visita;
        $id = $idProyecto;
        $costototal = $request->costototal;
        $costohabilitacion = $request->costo_habilitacion;
        $costoinstalacion = $request->costo_instalacion;
        $costocapacitacion = $request->costo_capacitacion;
        $costoretiro = $request->costo_retiro;
        $costoactualizacion = $request->costo_actualizacion;
        $costocortesia = $request->costo_cortesia;
        $costogarantia = $request->costo_garantia;
        $costootros = $request->costo_otros;
        $costomantenimiento = $request->costo_mantenimiento;

        // $proyectos = App\proyectos::findOrFail($id);
        // $proyectos->costo_proyecto = $costototal;
        // $proyectos->timestamps = false;
        // $proyectos->save();



        $total  = $costohabilitacion + $costoinstalacion + $costocapacitacion + $costoretiro + $costoactualizacion +  $costocortesia +  $costogarantia + $costomantenimiento;


        //$costo_proyectos = App\costos_proyectos::where('costo_descripcion', "primera visita")->where('proyecto_id', $proyectos->id)->firstOrFail();
        $costo_proyectos = App\costos_proyectos::where('id', '=', $id_visita)->firstOrFail();
        $costo_proyectos->costo_total = $total;
        $costo_proyectos->costo_habilitacion = $costohabilitacion;
        $costo_proyectos->costo_instalacionaccesorios = $costoinstalacion;
        $costo_proyectos->costo_capacitacion = $costocapacitacion;
        $costo_proyectos->costo_retiro = $costoretiro;
        $costo_proyectos->costo_actualizacionfirmware = $costoactualizacion;
        $costo_proyectos->costo_cortesia = $costocortesia;
        $costo_proyectos->costo_garantia = $costogarantia;
        $costo_proyectos->costo_mantenimiento = $costomantenimiento;
        $costo_proyectos->costo_otros = $costootros;
        $costo_proyectos->timestamps = false;
        $costo_proyectos->save();

        //$costo_proyecto = App\costos_proyectos::where('costo_descripcion', "segunda visita")->where('proyecto_id', $proyectos->id)->firstOrFail();
        //$costo_proyecto->costo_total = $costototal;
        //$costo_proyecto->costo_cortesia = $costocortesia;
        //$costo_proyecto->costo_garantia = $costogarantia;
        //$costo_proyecto->costo_capacitacionadicional = $costocapacitacionadicional;
        //$costo_proyecto->costo_retiroadicional = $costoretiroadicional;
        //$costo_proyecto->timestamps = false;
        //$costo_proyecto->save();

        return "Listo";
    }

    public function añadirvisita(request $request)
    {

        try {
            $idProyecto =   Crypt::decryptString($request->id_proyeecto);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }




        $id = $idProyecto;
        $costo_proyecto = $request->costo_proyecto;
        $costo_habilitacion = $request->costo_habilitacion;
        $costo_instalacion = $request->costo_instalacion;
        $costo_capacitacion = $request->costo_capacitacion;
        $costo_retiro = $request->costo_retiro;
        $costo_actualizacion = $request->costo_actualizacion;
        $costo_cortesia = $request->costo_cortesia;
        $costo_garantia = $request->costo_garantia;
        $costo_capacitacionadicional = $request->costo_capacitacionadicional;
        $costo_retiroadicional = $request->costo_retiroadicional;
        $numero_visita = $request->numero_visita;
        $costo_otros = $request->costo_otros;

        $descripcion_visita = "";
        if ($numero_visita == 2) {
            $descripcion_visita = "segunda visita";
        } elseif ($numero_visita == 3) {
            $descripcion_visita = "tercera visita";
        } elseif ($numero_visita == 4) {
            $descripcion_visita = "cuarta visita";
        } elseif ($numero_visita == 5) {
            $descripcion_visita = "quinta visita";
        } elseif ($numero_visita == 6) {
            $descripcion_visita = "sexta visita";
        }

        $total  = $costo_habilitacion + $costo_instalacion + $costo_capacitacion + $costo_retiro + $costo_actualizacion +  $costo_cortesia +  $costo_garantia;


        $crear_costoproyecto = new App\costos_proyectos();
        $crear_costoproyecto->proyecto_id = $id;
        $crear_costoproyecto->costo_descripcion = $descripcion_visita;
        $crear_costoproyecto->costo_total = $total;
        $crear_costoproyecto->costo_habilitacion = $costo_habilitacion;
        $crear_costoproyecto->costo_instalacionaccesorios = $costo_instalacion;
        $crear_costoproyecto->costo_capacitacion = $costo_capacitacion;
        $crear_costoproyecto->costo_retiro = $costo_retiro;
        $crear_costoproyecto->costo_actualizacionfirmware = $costo_actualizacion;
        $crear_costoproyecto->costo_cortesia = $costo_cortesia;
        $crear_costoproyecto->costo_garantia = $costo_garantia;
        $crear_costoproyecto->costo_otros = $costo_otros;
        $crear_costoproyecto->numero_visita = $numero_visita;
        $crear_costoproyecto->fecha_registro = Carbon::now();
        $crear_costoproyecto->timestamps = false;
        $crear_costoproyecto->save();

        $descripcion_visita = "";
        $numero_visita = "";

        return back()->with('mensaje', 'visita agregada');
    }
}
