<?php

namespace App\Http\Controllers\formulario;

use App\Http\Controllers\Controller; 
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\ClientesExport;
use App\Imports\ClientesImport;
use App\Models\clientes;
use App\Models\regions;
use App\Models\comunas;
use App\Models\tipo_usuarios;
use App\Models\User;
use App\Models\user_clientes;
use App\Models\orden_trabajos;


use Illuminate\Support\Facades\Hash;
use App\Models\contactos;
use DB;
use Crypt;
use App;
use Config;
use DateTime;
use DateInterval;
use DatePeriod;
use Carbon\Carbon;

use Illuminate\Support\Facades\Mail;
use App\Mail\correoFormularioServicios;
class formularioController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function validarOt(Request $request)
    {

        

        // {numeroot: '56546', proveedor: 'DEIRA'}

            if (  $datos_retiros = DB::connection(strtolower($request->proveedor))->table('api_solicitudes')
            ->where('api_solicitudes.sSC', '=', $request->numeroot)->exists()){ 

                return "si";
        } else {
            // El usuario noss existe en la base de datos
            return "no";
        }

    }
    
       
    public function generarOt(Request $request)
    {

        //rand de 6 digitos
        $random_number = rand(100000, 999999);

        // busca si el número generado ya existe en la tabla correspondiente
        while (DB::connection(strtolower($request->proveedor))->table('api_solicitudes')->where('sSC', $random_number)->exists()) {
            $random_number = rand(100000, 999999);// genera otro número aleatorio si el primero ya existe
        }

        return $random_number;
    }
    
        // El usuario existe en la base de datos
    
    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
   

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        return DB::transaction(function() use($request)
        { 
              $comuna =   App\comuna::select('des_comuna')->where('id', $request->comuna)->get();
              $region =   App\region::select('num_r')->where('id', $request->region)->get();
              $correos_formularios =   App\correos_formularios::select('correo')->where('estado', 0)->where('proveedor', strtoupper($request->proveedor))->get();

              $resultadosArray = $correos_formularios->toArray();
              $concatenado = "";

              $arrayCorreos = [];
              
              array_push($arrayCorreos,"coordinacion@ayaingenieria.cl");


              foreach ($resultadosArray as $resultado) {
                //   $concatenado .= '"'.implode(',', $resultado).'"' . ',';
                array_push($arrayCorreos,implode(',', $resultado));
              }
            //   $correosString = substr($concatenado, 0, -1);
//    $arrayCorreos;
    
              Config::set('database.connections.mysql.database', strtoupper($request->proveedor));
              DB::reconnect();


              $dFechaFab = date('Y-m-d H:i:s');
              $dFechaCreacion = date('Y-m-d H:i:s');
              $dFechaModif = date('Y-m-d H:i:s');
      

              $api_solicitudes = new App\api_solicitudes;
              $api_solicitudes->proveedor_servicio	     = strtoupper($request->proveedor); //dejaarlo asi mientras
              $api_solicitudes->sSC= $request->ot;
              $api_solicitudes->sRegion= $region[0]->num_r;
              $api_solicitudes->sComuna= $comuna[0]->des_comuna;
              $api_solicitudes->Ssucursal= $request->sucursal;
              $api_solicitudes->sDireccion= $request->direccion;
              $api_solicitudes->sCliente= $request->cliente;
              $api_solicitudes->equipos= $request->equipo;
              $api_solicitudes->sModelo= $request->modelo_equipo;
              $api_solicitudes->sSerie= $request->numero_serie;
              $api_solicitudes->sTelefono= $request->contacto;
              $api_solicitudes->sContacto= $request->nombre_contacto;
              $api_solicitudes->dFechaFab = $dFechaFab;
              $api_solicitudes->dFechaCreacion = $dFechaCreacion;
              $api_solicitudes->dFechaModif = $dFechaModif;

              $api_solicitudes->sProveedor	     = strtoupper($request->proveedor); //dejaarlo asi mientras
              
              $api_solicitudes->sDescripcion= $request->descripcion;
              $api_solicitudes->estado_externo= "Sin Asignar";
              $api_solicitudes->Smarca=  $request->marca;

              
              
              $api_solicitudes->sContacto= $request->nombre_contacto;

              $api_solicitudes->timestamps = false;
              $api_solicitudes->save();
             
             
            

    //   $destinatario = [$correosString];
        //    "ariel@globati.com","cristobal@globati.com"
        //   $destinatario = [$correosString];
        //   return $destinatario;
      Mail::to($arrayCorreos)->send(new correoFormularioServicios($api_solicitudes, $request->ot,strtoupper($request->proveedor)));
            
       
         return back()->with('mensaje', 'Registro Completo');

    }, 5);

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request ,$id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
