@extends('menu/menu')
{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js%22%3E</script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>
{{-- <link  href="{{ asset('css/a&a_style.css') }}" href="a&a_style.css" rel="stylesheet" type="text/css"> --}}

@section('content')

@if ( session('mensaje') )
    <div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

<div class="container mt-5">
  <div class="title-vista mt-4">Informes</div>
</div>

<form action="{{route ('go.filtrar_pdf_informe')}}" method="post">
  @csrf
  <div class="container mt-4">
    <div class="seccion-filtro">Filtrar por</div> 
    <hr class="separador">

    <div class="row">
      <!--AQUI SE CARGA EL SELECT DE PROYECTO-->
      <div class="col-sm-3 form-group">
        <label for="datepicker">Fecha Sugerida</label>
        <input type="date" class="form-control mayuscula" id="datepicker" name="datepicker">
      </div>
    </div>
    <!--FIN SELECT DE PROYECTO-->
   
    <!-- FIN BARRA DE BUSQUEDA -->
  </div>

  <div class="container text-center my-4">
    <button type="submit" class="btn btn-prim px-sm-5">Buscar</button>
  </div>
  
  </form>


<!-- TABLA DE RESULTADOS DE BUSQUEDA -->
<div class="container table-responsive p-sm-0 mb-5">
  <table class="table table-bordered table-responsive-lg table-striped table-hover" id="gridData">
    <!-- ENCABEZADO -->
    <thead class="color-head">
      <tr>
        <th class="th-head border-th separador-v" colspan="1">Fecha</th>
        <th class="th-head border-th separador-v" colspan="1">PDF</th>
      </tr>
    </thead>

    <!-- RESULTADOS -->
    <tbody>
      @if(!empty($rutapdf))
      @foreach ($rutapdf as $datos)
      <tr>
        <td> {{Carbon\Carbon::createFromDate($datos->fecha)->format('d-m-Y')}}</td>
        <td class="td-val text-center">
          <a class="btn-icon btn-icon-dd" href="{{route('go.donwload5',$datos->url_pdf)}}">
            <span class="material-icons-round">picture_as_pdf</span></a>
        </td>
      </tr>
      @endforeach
      @endif
    </tbody>
    <!-- FIN RESULTADOS -->
  </table>
</div>
<!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->
 
@endsection
