@extends('menu/menu')
<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>

@section('content')

    <hr class="separador mb-5">


    <div class="card p-5"  >
   
        <div class="row" > 
         <div class="container">
        
            <!-- Agregar ruta del controlador reemplazando por registro.php y descomentar lineas 
                <form action="registro.php" method="post">-->
   <form action="{{route('registrar.formulario') }}" method="POST" class="needs-validation" >
    @csrf

                    <div class="alert alert-danger" style="display:none" id="alertErrorDiv">
                        <strong >Error!</strong> <label id="mensajeError"></label>
                      </div>
                      @if ( session('mensaje') )
                        <div class="alert alert-success">{{ session('mensaje') }}</div>
                        @endif

                

        <div class="mt-4">
            <h3 class="form-label">FORMULARIO DE REGISTRO
            </h3>
        </div>
        <div class="mb-3 row mt-1">
                <div class="col">
                    <label for="proveedor" class="form-label">Mandante:</label>
                    <select name="proveedor" required class="custom-select mayuscula" id="proveedor">
                        <option value="" selected>SELECCIONE</option>
                          @if(!empty($databases))
                          @foreach ($databases   as $los_datos)
                            <option value="{{$los_datos->Database}}" >{{$los_datos->Database }}  </option>
                          @endforeach
                          @endif
                      </select>
                </div>
                {{-- <label for="mandante" class="form-label">Mandante:<span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="mandante" name="mandante" required> --}}
            <div class="col">
                <label for="ot" class="form-label">Orden  de Trabajo:</label>
                <a style="cursor: pointer" onclick="generarot()">
                  <span><svg xmlns="http://www.w3.org/2000/svg" height="24" width="24"><path d="M12.025 19.775q-3.275 0-5.537-2.263Q4.225 15.25 4.225 12q0-3.25 2.263-5.513 2.262-2.262 5.537-2.262 1.7 0 3.25.7t2.65 2.05v-2.75H19.8v6.725h-6.725V9.075h4.075q-.8-1.4-2.162-2.188-1.363-.787-2.963-.787-2.475 0-4.2 1.725T6.1 12q0 2.45 1.725 4.175 1.725 1.725 4.2 1.725 1.875 0 3.4-1.075t2.15-2.85h1.975q-.675 2.575-2.775 4.188-2.1 1.612-4.75 1.612Z"/></svg></span>

                </a>
                <input type="text" required class="form-control" id="ot" name="ot" placeholder="#####" value="">
                
            </div>
        </div>
        <div class="mb-3 row">

            <div class="col">
                <label for="region" class="form-label">Región:</label>
                <select name="region" required id="region" class="form-control">
                        <option value="" selected>SELECCIONE</option>
                          @if(!empty($regions))
                          @foreach ($regions   as $los_datos)
                            <option value="{{$los_datos->id}}" >{{strtoupper($los_datos->des_region) }}  </option>
                          @endforeach
                          @endif
                      </select>              
            </div>
            <div class="col">
                <label for="comuna" class="form-label">Comuna:</label>
                <select name="comuna" required id="comuna" class="form-control">
                    <option disabled value="">Primero seleccione una region</option>
                </select>
            </div>
        </div>
        <div class="mb-3 row">

            <div class="col">
                <label for="cliente" class="form-label">Cliente:</label>
                <input type="text"required  maxlength="35" class="form-control" id="cliente" name="cliente">
            </div>
            <div class="col">
                <label for="sucursal" class="form-label">Sucursal:</label>
                <input type="text" required maxlength="35" class="form-control" id="sucursal" name="sucursal">
            </div>
        </div>
        <div class="mb-3 row">

            <div class="col">
                <label for="direccion" class="form-label">Direccion:</label>
                <input type="text" required maxlength="50"  class="form-control" id="direccion" name="direccion">
            </div>
            <div class="col">
                <label for="equipo" class="form-label">Equipo:</label>
                <input type="text" maxlength="20"  required class="form-control" id="equipo" name="equipo">
            </div>
        </div>
        <div class="mb-3 row">

            <div class="col">
                <label for="modelo_equipo" class="form-label">Modelo de equipo:</label>
                <input type="text" required  maxlength="30" class="form-control" id="modelo_equipo" name="modelo_equipo">
            </div>
            <div class="col">
                <label for="numero_serie" class="form-label">Número de serie:</label>
                <input type="text" required maxlength="20"  class="form-control" id="numero_serie" name="numero_serie">
            </div>
        </div>
        <div class="mb-3 row">

            <div class="col">
                <label for="contacto" class="form-label">Contacto:
                </label>
                <div class="input-group">
                    <span class="input-group-text">+</span>
                    <input type="number" required maxlength="4" class="form-control" id="codigo_celular" name="codigo_celular" placeholder="56" value="56">
                    <input type="number" required  maxlength="10" class="form-control" id="contacto" name="contacto" style= "width: 75%;" placeholder="">
                </div>
            </div>
            <div class="col">
                <label for="descripcion" class="form-label">Descripción:</label>
                <textarea class="form-control" required  id="descripcion" name="descripcion" placeholder="Inserte una descripción..."></textarea>
            </div>
        </div>
        <div class="mb-3 row">
            <div class="col text-center">
                <button type="submit" name="" class="btn btn-primary">Guardar</button>
            </div>
            <div class="col text-center">
                {{-- <button type="button" class="btn btn-danger">Cancelar</button> --}}
            </div>
        </div>
    </div>
</form>
</div>



@endsection
<script>



    $(document).ready(function(){
        
        
        
        $('#region').change(function() {    
         buscar_comuna($("#region option:selected").val(),"#comuna","../");  
        // alert("hols");
     })
          
     $('#proveedor').change(function() {    
        if($("#proveedor option:selected").val() != "" || $("#proveedor option:selected").val() != null){
            $("#alertErrorDiv").css("display","none")

        } 
        // alert("hols");
     })
          
     

     $('#ot').change(function() {    

          // alert("asd{asd");
          numeroot = $("#ot").val();
          proveedor = $("#proveedor").val();

 

          if(proveedor == "" || proveedor == null){


            $("#alertErrorDiv").css("display","")
            $("#mensajeError").text("Debe de seleccionar un proveedor, para validar la OT")
             $("#ot").val("");

          }else{
                $.ajax({

                        headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },

                        type: 'POST',

                        url: "{{ route('go.validarot') }}",

                        data: { 'numeroot': numeroot,'proveedor':proveedor },

                        success: function(data) {

                            console.log(data);

                            if(data == "si"){
                                $("#alertErrorDiv").css("display","")
                                    $("#mensajeError").text("La OT "+ numeroot+", ya se encuentra registrada")
                                    $("#ot").val("");
                            }else if(data=="no"){
                                $("#alertErrorDiv").css("display","none")
                               
                            }
                            // $('#tabla_sucursal').empty();
                            // $('#id_trabajador').val(id_trabajador);
                            // console.log(data);
                            // $('#tabla_sucursal').append(data);
                            // $('#modal_banco').modal('show');
                            // // $('#modal_ver_sucur').modal('show');

                        },

                        error: function(xhr, status) {

                            alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');

                        }

                });

          }
     
     })
     
  });


  function generarot(){

          // alert("asd{asd");
          numeroot = $("#ot").val();
          proveedor = $("#proveedor").val();
   
            if(proveedor == "" || proveedor == null){


                    $("#alertErrorDiv").css("display","")
                    $("#mensajeError").text("Debe de seleccionar un proveedor, para generar una OT")
                    $("#ot").val("");

            }else{

                    $.ajax({

                        headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },

                        type: 'POST',

                        url: "{{ route('go.generarOt') }}",

                        data: { 'proveedor':proveedor },

                        success: function(data) {

                            console.log(data);

                           
                                $("#alertErrorDiv").css("display","none")
                                numeroot = $("#ot").val(data);

                            // $('#tabla_sucursal').empty();
                            // $('#id_trabajador').val(id_trabajador);
                            // console.log(data);
                            // $('#tabla_sucursal').append(data);
                            // $('#modal_banco').modal('show');
                            // // $('#modal_ver_sucur').modal('show');

                        },

                        error: function(xhr, status) {

                            alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');

                        }

                        });


            }
  }
  </script>