<!DOCTYPE html>
<html lang="es">
<?php $mes = date('d/m/Y');
header('Content-type: application/vnd.ms-excel charset=utf-8');
header("Content-Disposition: attachment; filename=InformecheckInstalacionesfecha$mes.xls");
header("Pragma: no-cache");
header("Expires: 0");  ?>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
</head>

<body>
    <table class="table table-bordered table-responsive-lg table-striped table-hover" style="margin: 0" id="gridData">
        <!-- ENCABEZADO -->
        <thead>
            <tr>
                <th class="container-2">
                    <h3>Cliente</h3>
                </th>
                <th class="container-1">
                    <h3>Proyecto Asociado</h3>
                </th>
                @if(Auth::user()->tipo_usuario == "administrador" || Auth::user()->tipo_usuario == "coordinador")
                <th class="container-1">
                    <h3>Tecnico</h3>
                </th>
                @endif
                <th class="container-1">
                    <h3>Asignaci&#243;n cordinadora</h3>
                </th>
                <th class="container-1">
                    <h3>Fecha inicio</h3>
                </th>
                <th class="container-1">
                    <h3>Fecha fin</h3>
                </th>
                <th class="container-2">
                    <h3>Estado Despacho</h3>
                </th>
                <th class="container-2">
                    <h3>Estado Final</h3>
                </th>
                <th class="container-2">
                    <h3>Estado check</h3>
                </th>
                <th class="container-2">
                    <h3>Cantidad de Usuarios</h3>
                </th>
                <th class="container-2">
                    <h3>Region</h3>
                </th>
                <th class="container-2">
                    <h3>Comuna</h3>
                </th>
                <th class="container-2">
                    <h3>Sucursal</h3>
                </th>
                <th class="container-2">
                    <h3>Id sala</h3>
                </th>
                <th class="container-2">
                    <h3>Direcci&#243;n | CUI</h3>
                </th><?php /*?>Agregue una nueva columna  - FITO<?php */ ?>
                <th class="container-2">
                    <h3>Nº de serie</h3>
                </th>
                <th class="container-2">
                    <h3>Modelo equipo</h3>
                </th>
                <th class="container-2">
                    <h3>Ip</h3>
                </th>
                <th class="container-2">
                    <h3>Contador</h3>
                </th>
                <th class="container-2">
                    <h3>Contador Color</h3>
                </th>
                <th class="container-2">
                    <h3>Nº de serie saliente</h3>
                </th>
                <th class="container-2">
                    <h3>Modelo equipo saliente</h3>
                </th>
                <th class="container-2">
                    <h3>Marca equipo saliente</h3>
                </th>   
                <th class="container-2">
                    <h3>Observaci&#243;n</h3>
                </th>
                <th class="container-2">
                    <h3>Estados Opci&#243;n</h3>
                </th>
                <th class="container-2">
                    <h3>Respuestos solicitados</h3>
                </th>
                <th class="container-2">
                    <h3>Nombre de parte</h3>
                </th>
                <th class="container-2">
                    <h3>S/N</h3>
                </th>
                <th class="container-2">
                    <h3>Cantidad</h3>
                </th>
            </tr>
        </thead>
        <!-- FIN ENCABEZADO -->
        <!-- RESULTADOS -->
        <tbody>
            @if(!empty($instalaciones))
            @foreach ($instalaciones as $los_datos)
            <tr>
                <td>{{$los_datos->sCliente ?? ''}}</td>
                @if ($los_datos->nombre == "Global")
                <td>No Asignado</td>
                @else
                <td>{{$los_datos->nombre ?? ''}}</td>
                @endif
                @if(Auth::user()->tipo_usuario == "administrador" || Auth::user()->tipo_usuario == "coordinador")
                <td>{{$los_datos->nombre_uno ?? ''}} {{$los_datos->apellido_uno ?? ''}}</td>
                @endif
                <td>{{Carbon\Carbon::createFromDate($los_datos->fecha_instalacion)->format('d-m-Y')}}</td>
                @php
                $fechas = DB::table('asignacion_instalacions')
                ->join("checklist_instalacions","checklist_instalacions.asignacion_instalacion_retiro_id","=","asignacion_instalacions.id")
                ->select('checklist_instalacions.fecha_inicio','checklist_instalacions.fecha_fin')
                ->where('asignacion_instalacions.id','=',$los_datos->id_asig)
                ->orderBy('checklist_instalacions.id', 'desc')
                ->get();

                $fecha_inicio = "";
                $fecha_fin = "";
                if(count($fechas) != 0){
                if($fechas[0]->fecha_inicio != "" || $fechas[0]->fecha_fin != "" ){
                $fecha_inicio = Carbon\Carbon::createFromDate($fechas[0]->fecha_inicio)->format('d-m-Y H:i:s');
                $fecha_fin = Carbon\Carbon::createFromDate($fechas[0]->fecha_fin)->format('d-m-Y H:i:s');
                }
                }
                @endphp
                <td>{{$fecha_inicio}}</td>
                <td>{{$fecha_fin}}</td>
                @if($los_datos->sEstado_despacho != null || $los_datos->sEstado_despacho != "")
                <td style="text-transform: uppercase"> {{ucfirst($los_datos->sEstado_despacho ?? '')}}</td>
                @else
                <td></td>
                @endif
                @if($los_datos->sEstado_instalacion != null || $los_datos->sEstado_instalacion != "")
                <td style="text-transform: uppercase"> {{ucfirst($los_datos->sEstado_instalacion ?? '')}}</td>
                @else
                <td></td>
                @endif
                <td> {{ucfirst($los_datos->estado_asignacion ?? '')}}</td>
                <td style="text-transform: uppercase"> {{ucfirst($los_datos->Cscantidad_usuarios ?? '')}}</td>
                <td>{{$los_datos->sRegion ?? ''}}</td>
                <td>{{($los_datos->sComuna)}}</td>
                <td>{{$los_datos->Cstipo_sucursal ?? ''}}</td>
                @if($los_datos->idSala != null || $los_datos->idSala != "")
                <td>{{$los_datos->idSala ?? ''}}</td>
                @else
                <td></td>
                @endif
                <td>{{$los_datos->sDireccion ?? ''}}</td>
                @if($los_datos->remplazo != null || $los_datos->remplazo != "")
                <td>{{$los_datos->remplazo?? ''}}</td>
                @else
                <td>{{$los_datos->sSerie ?? ''}}</td>
                @endif
                <td>{{$los_datos->CsModelo ?? ''}}</td>
                <td>{{$los_datos->CsIP ?? ''}}</td>
                <td>{{$los_datos->CnContador ?? ''}}</td>
                <td>{{$los_datos->CnContador_color ?? ''}}</td>
                <!--SALIENTE-->
                <td>{{$los_datos->CsSerie_es ?? ''}}</td>
                <td>{{$los_datos->CsModelo_es ?? ''}}</td>
                <td>{{$los_datos->CsMarca_es ?? ''}}</td>

                <td>{{$los_datos->observacion ?? ''}}</td>
                <td>{{$los_datos->opcion_estado_instalacion ?? ''}}</td>
                @php
                $accesorios = DB::table('checklist_accesorios')
                ->join('accesorios', 'accesorios.id', '=', 'checklist_accesorios.id_accesorio')
                ->select('accesorios.descripcion', 'accesorios.articulo', 'checklist_accesorios.cantidad', 'accesorios.id as ID', 'checklist_accesorios.serie_parte')
                ->where('checklist_accesorios.id_checklist_instalacion', '=', $los_datos->id_checklist)
                ->get();
                @endphp
                <td>
                    @foreach($accesorios as $key => $solicitados)
                    {{$key+1}} - {{$solicitados->descripcion}} <br>
                    @endforeach
                </td>
                <td>
                    @foreach($accesorios as $key => $solicitados)
                    {{$key+1}} - {{$solicitados->articulo}} <br>
                    @endforeach
                </td>
                <td>
                    @foreach($accesorios as $key => $solicitados)
                    {{$key+1}} - {{$solicitados->serie_parte}} <br>
                    @endforeach
                </td>
                <td>
                    @foreach($accesorios as $key => $solicitados)
                    {{$key+1}} => {{$solicitados->cantidad}} <br>
                    @endforeach
                </td>
            </tr>
            @endforeach
            @endif
        </tbody>
        <!-- FIN RESULTADOS -->
    </table>
</body>

</html>