@extends('menu/menu')

{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js"></script> --}}

<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>





@section('content')



@if ( session('mensaje_error') )

    <div class="alert alert-danger">{{ session('mensaje_error') }}</div>

@endif





<div class="container table-responsive"> 

  <br>

  <h2>Usuarios registrados  </h2>

  <div class="container mar-btm" style="margin-top:30px">
    <form action="{{route('filtro_see_trabajador')}}" method="GET">
    <div class="col-md-12" id="form-container">
    
        <h4>Nombre trabajador</h4>
        <div class="input-group mb-3">
            <input type="text" name="nombre_trabajador"  value="{{@old('nombre_trabajador')}}"   class="form-control mayuscula" id="nombre_trabajador" placeholder="...">
           
          </div>
    </div>
          <div class="col-md-12" id="btn-container">

                    <div class="col-md-1 pull-right text-right">
                              
                              <div class="input-group-append">
                                          <button class="btn btn-success bs"  type="submit">
                              
                                   
                              
                                          @if($opcion != "1")
                                                  Buscar
                                              
                                              @else
                                                  Todos
                                              
                                              @endif
                               
                                            
                              
                                          </button>
                            </div>
                    </div>
            
          </div>
     

  </form>
  </div>



 
<div class="tbl-bg table-responsive">

  <table class="table  table-bordered table-hover"  id="mitable" style="color:#4c4c4c;font-weight:200;">

    <thead>

      <tr style="color:#516ba0;">

        <th class="th-head" style="border-right:1px solid #b2b2b2 ;border-bottom:1px solid transparent;" colspan="3">Datos personales</th>
        <th class="th-head" style="border-right:1px solid #b2b2b2 ;border-bottom:1px solid transparent;" colspan="2">Billetera virtual</th>
        <th class="th-head" style="border-right:1px solid #b2b2b2 ;border-bottom:1px solid transparent;">Administrar cuenta bancaria</th>
        <th class="th-head" style="border-bottom:1px solid transparent;"> Acciones</th>

      </tr>
      <tr style="color:#516ba0;">
       <th class="th-subhead"><strong>Nombre </strong></th>
       <th class="th-subhead"><strong>Teléfonos </strong></th>
       <th class="th-subhead" style="border-right:1px solid #b2b2b2;"><strong>Correos</strong></th>
       <th class="th-subhead" style="border:1px solid #dee2e6;"><strong>Cuenta</strong></th>
       <th class="th-subhead" style="border-right:1px solid #b2b2b2;"><strong>F. Actualizado</strong></th>
       <th class="th-subhead" style="border-right:1px solid #b2b2b2;"><strong>Total Billetera</strong></th>
       <th ></th>
     </tr>

    </thead> 

    <tbody>



      @foreach ($trabajadores as $los_datos)
      <tr style="color:#CAC8C8;">
        <td class="td-val">{{$los_datos->nombre_uno}}  {{$los_datos->apellido_uno}} {{$los_datos->apellido_dos}}</td>
        <td class="td-val">{{$los_datos->telefono1}} - {{$los_datos->telefono2}}</td>
        <td class="td-val" style="border-right:1px solid #b2b2b2 ;">{{$los_datos->correo1}} - {{$los_datos->correo2}}</td>
        <td class="td-val">${{number_format($los_datos->total_acumulado,0,',','.')}} <br>  ${{number_format($los_datos->total_gastos,0,',','.')}}</td>
        <td class="td-val" style="border-right:1px solid #b2b2b2 ">{{ Carbon\Carbon::createFromDate($los_datos->fecha_actualizado_acumulado ?? '')->format('d-m-Y')}} <br> {{ Carbon\Carbon::createFromDate($los_datos->fecha_actualizado_gasto ?? '')->format('d-m-Y')}}</td>
     
      
      <td class="td-val" style="border-right:1px solid #b2b2b2;">
        <span class="v-left">${{number_format($los_datos->total_acumulado -  $los_datos->total_gastos,0,',','.')}}</span>
        <span class="v-right">
          <a   class="billetera_modal" data-id_trabajador ="{{$los_datos->id_trabajador}}" style="cursor: pointer"><img title="Editar" src="{{ asset('Botones/Botones/Ver.png') }}"></a> 
        </span>
        
      </td>



      <td class="td-val actions" >
        <form>
       <div class="btn-group">
          <a   href="{{route('update.trabajador',$los_datos->id_trabajador)}}"><img title="Editar" src="{{ asset('Botones/Botones/Editar.png') }}"></a>

        @csrf
        <a   href="{{route('eliminar.trabajador',$los_datos->id_trabajador)}}" onclick="return confirm('¿Desea eliminar el registro?')"><img title="Eliminar" src="{{ asset('Botones/Botones/Eliminar.png') }}"></a>
     
        <a   href="{{route('go.add_suc_trabajador',$los_datos->id_trabajador)}}"><img title="Agregar" src="{{ asset('Botones/Botones/Agregar.png') }}"></a>

      </div>   
     </form>
      </td>
      </tr>
          

     

      @endforeach

    </tbody>

  </table>
</div>
  @if(!empty($trabajadores))
  {{-- {{$solicitudes->Links()}} --}}
  {{ $trabajadores->appends(request()->query())->links() }}

@endif 

  {{-- {{$datos_empresa->Links()}} --}}

</div>



  <!-- Modal -->
  <div class="modal fade" id="modal_banco" role="dialog">
    <div class="modal-dialog  modal-lg">
      <div class="modal-content">
        <div class="modal-header">
            <h4>Agregar cuenta</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>

        </div>
        <div class="modal-body">       
            <div class="container table-responsive">  

              <div class="row" style="text-align:center;" >
                <div class="btn-group" >
                  {{-- <button type="button" id="agregar_cuenta" class="btn btn-primary">Agregar cuenta</button> --}}
                  {{-- <button type="button" id="agregar_banco" class="btn btn-success">Agregar banco</button>                  --}}
                </div>  
              </div>

              <div>
                
{{-- ******************************ocultar agregar**************************************************************** --}}
                  <div><button  class="agregar btn btn-primary">Agregar cuenta</button></div><br>
                <div style="display:none" id="ocultar_agrega">
                <form action="{{route('create.mi_cuenta')}}" method="POST">
                  {{-- <form action="" method="POST"> --}}
                    @csrf


                <div class="row">
                     <div class="col-sm-4 form-group" >
                                <label for="">Bancos</label>
                      <select class="form-control mayuscula" name="bancos" id="sucursal_bancos" >
                          <option value="">Seleccionar</option>
                          @if ($bancos  == "" )
                          
                            @else 
                            @foreach($bancos  as $banco)
                            {{-- <option value="{{$region->id}}">{{$region->des_region}}</option> --}}
                            <option value="{{$banco->id}}" {{(old('region')==$banco->id)? 'selected':''}}>{{$banco->nombre_banco}}</option>
                            @endforeach
                            @endif        
                          </select>
                          @error('bancos')
                          <div class="alert alert-danger">{{ $message }}</div>
                          @enderror
                    </div>
          
                      <input style="display:none" type="text" name="id_trabajador" id="id_trabajador"  value="">
                      {{-- {{$tipos_cuentas_bancos}} --}}
                      {{-- <div class="col-sm-4 form-group" >
                        <label for="tipo_cuenta" class="" >Tipo cuenta</label>
                        <select class="form-control mayuscula" name="tipo_cuenta" id="tipo_cuenta" >
                          <option value="">Seleccionar</option>
                        </select>
                        @error('tipo_cuenta')
                        <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                      </div>   --}}

                      
                    <div class="col-sm-4 form-group" >
                      <label for="tipo_cuenta" class="" >Tipo cuenta</label>
                      <select class="form-control mayuscula" name="tipo_cuenta" id="tipo_cuentas" >
                        @foreach($tipos_cuentas_bancos  as $tipo_cuenta)
                        {{-- <option value="{{$region->id}}">{{$region->des_region}}</option> --}}
                        <option value="{{$tipo_cuenta->id}}" {{(old('region')==$tipo_cuenta->id)? 'selected':''}}>{{$tipo_cuenta->tipo_cuenta}}</option>
                        @endforeach
                      </select>
                      @error('tipo_cuenta')
                      <div class="alert alert-danger">{{ $message }}</div>
                      @enderror
                    </div>  
                    <div class="col-sm-4 form-group" >
                      <label for="numero_cuenta" class="" >Número cuenta</label>
                      <input type="text" class="form-control mayuscula" value="{{@old('numero_cuenta')}}"   name="numero_cuenta"  id="numero_cuenta" placeholder="Número Cuenta">
                      @error('numero_cuenta')
                      <div class="alert alert-danger">{{ $message }}</div>
                      @enderror
                    </div>               
                </div>

                <div class="row">
                  <div class="col-sm-4 form-group" >
                    <label for="nombre_cliente" class="" >Nombre (dueño cuenta)</label>
                    <input type="text" class="form-control mayuscula" value="{{@old('nombre_cliente')}}"   name="nombre_cliente"  id="nombre_cliente" placeholder="Nombre">
                    @error('nombre_cliente')
                    <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                  </div>
                  <div class="col-sm-4 form-group" >
                    <label for="apellido_cliente" class="" >Apellido (dueño cuenta)</label>
                    <input type="text" class="form-control mayuscula" value="{{@old('apellido_cliente')}}"   name="apellido_cliente"  id="apellido_cliente" placeholder="Apellido">
                    @error('apellido_cliente')
                    <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                  </div>
                  <div class="col-sm-4 form-group" >
                    <label for="correo_bancario" class="" >Correo bancario</label>
                    <input type="email" class="form-control mayuscula" value="{{@old('correo_bancario')}}"   name="correo_bancario"  id="correo_bancario" placeholder="Correo">
                    @error('correo_bancario')
                    <div class="alert alert-danger">{{ $message }}</div>
                    @enderror
                  </div>
                </div>


                
                <div class="card-body" style="text-align: right" >
                  <button type="submit" class="btn btn-primary agregar_cuenta ">Guardar</button>  
               </div>
                </form>
              </div><br>
                <table class="table table-hover" id="tabla_sucursal">

                  <thead>
                    <th>Cuenta</th>
                    <th>Número</th>
                  </thead>
                  <tbody>

                  </tbody>

                </table>

              </div>
    
          </div>
        </div>
      </div>
    </div>
  </div>
</div>





    

@endsection





<script>

  function eliminar_cuenta(id){

    // alert(id);
    
    var result = confirm("¿Desea eliminar?");
      if (result) {
         //Logic to delete the item
         location.href = 'eliminar_cuenta_/'+id;
      
      
      }

  }

$(document).ready(function() {

  

  $(".agregar").click(function() {
 
    $('#ocultar_agrega').css('display','')
    
}); 

$(".billetera_modal").click(function() {
  
  $('#ocultar_agrega').css('display','none')

  var id_trabajado = $(this).attr("data-id_trabajador"); 
  // alert(id_trabajado);
    modal_villetera(id_trabajado);
}); //fin de la funcion


$('#sucursal_bancos').change(function() {   

  id_selec = "#tipo_cuenta";
  // alert($("#sucursal_bancos option:selected").val()); 
  buscar_sucursales_banco($("#sucursal_bancos option:selected").val(),id_selec);
          //  buscar_comuna($("#region_empresa option:selected").val(),"#comuna_empresa","../");  
       })

}); 

  function confirmation() 

{

   if(confirm("¿Desea continuar?"))

{

return true;

}

else

{

return false;

}

}




</script>
