<?php

namespace App\Http\Controllers\client;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;


use App;
use App\direccion;
use App\persona;
use App\User;
use DB;
use Crypt;

use Carbon\Carbon;

use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
class sucursal extends Controller
{
    public function __construct()

    {

        $this->middleware('auth');

    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        
        $rules = [
            'clientes' => 'required|max:100',
            'nombre' => 'required|max:50',
            'telefono' => 'required|max:10',
            'correo' => 'required|max:50',
            'region' => 'required|max:50',
            'comuna' => 'required|max:50',
            'calle' => 'required|max:200',
  
        ];

        $this->validate($request, $rules);

        $direccion = new App\direccion;
        $direccion->descripcion_direccion = $request->calle;
        $direccion->id_region= $request->region;
        $direccion->id_comuna = $request->comuna;
        $direccion->timestamps = false;  
        $direccion->save();

        
        $sucursal = new App\sucursal;
        $sucursal->nombre = $request->nombre;
        $sucursal->estado = 1;
        $sucursal->telefono = $request->telefono;
        $sucursal->correo = $request->correo;
        $sucursal->id_direccion = $direccion->id;
        $sucursal->id_cliente = $request->clientes;
        $sucursal->timestamps = false;  
        $sucursal->save();

        return back()->with('mensaje', 'Sucursal Agregada');   
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {


        if($request->id_dire == "" || $request->calle == "" || $request->region =="" ||  $request->comuna == "" 
           || $request->nombre == "" || $request->telefono =="" || $request->correo == ""  || $request->clientes == "")
        {
            return back()->with('mensaje_error', 'Debe De Agregar todos Los Campos'); 
        }

        // $direccion = new App\direccion;
        $direccion =  App\direccion::findOrfail($request->id_dire);
        $direccion->descripcion_direccion = $request->calle;
        $direccion->id_region= $request->region;
        $direccion->id_comuna = $request->comuna;
        $direccion->timestamps = false;  
        $direccion->save();

        
        $sucursal =  App\sucursal::findOrfail($request->id_sucur);
        $sucursal->nombre = $request->nombre;  
        $sucursal->telefono = $request->telefono;
        $sucursal->correo = $request->correo;
        $sucursal->id_cliente = $request->clientes;
        $sucursal->timestamps = false;  
        $sucursal->save();



        // return $request;

        return back()->with('mensaje', 'Sucursal Editada');   
        
    }

    public function edit_sucur(Request $request)
    {

         $sucursales =  App\sucursal::findOrfail($request->id_suc);
         $sucursales->estado = "0"; 
         $sucursales->timestamps = false; 
         $sucursales->save();
        # code...
        return "Eliminado";
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        //
    }

    public function editar_sucurlal(Request $request)
    {


    
         $sucursales = DB::table('sucursals')
        ->join('direccions','direccions.id','=','sucursals.id_direccion')
        ->join('regions','regions.id','=','direccions.id_region')
        ->join('comunas','comunas.id','=','direccions.id_comuna')
        ->join('clientes','clientes.id','=','sucursals.id_cliente')
        ->select('direccions.descripcion_direccion','direccions.id as id_direccion','regions.des_region','regions.id as id_region','comunas.des_comuna','comunas.id as id_comuna',
        'sucursals.nombre','sucursals.telefono','sucursals.correo','sucursals.id as id_sucursal','clientes.id as id_cliente_ban','clientes.razon_social')
        ->where('sucursals.id','=',$request->id_suc)
        ->where('sucursals.estado','=',1)
        ->get();

        return $sucursales;
    }

    function buscar_sucursales(Request $request){

        $id_cliente = $request->id_cliente;
        // $clientes =  App\sucursals::findOrfail($id_cliente);
        // $sucursales =  App\sucursal::where('id_cliente',$id_cliente)
        // ->join('regions','regions.id','=','direccions.id_region')
        // ->get();  

        
        
        $sucursales = DB::table('sucursals')
        ->join('direccions','direccions.id','=','sucursals.id_direccion')
        ->join('regions','regions.id','=','direccions.id_region')
        ->join('comunas','comunas.id','=','direccions.id_comuna')
        ->select('direccions.descripcion_direccion','regions.des_region','comunas.des_comuna',
        'sucursals.nombre','sucursals.telefono','sucursals.correo','sucursals.id as id_sucursal')
        ->where('sucursals.id_cliente','=',$id_cliente)
        ->where('sucursals.estado','=',1)
        ->get();




        if(count($sucursales) >= 1){

            $table = "";

            $table = "<thead>";
            $table .= "<tr style='color:#516ba0;'>";
            $table .= "<th class='th-head' style='border-right:1px solid #b2b2b2 ;border-bottom:1px solid transparent;'>Nombre</th>";
            $table .= "  <th class='th-head' style='border-right:1px solid #b2b2b2 ;border-bottom:1px solid transparent;' colspan='2'>Contacto</th>";
            $table .= " <th class='th-head' style='border-right:1px solid #b2b2b2 ;border-bottom:1px solid transparent;' colspan='3'>Dirección</th>";
            $table .= "  <th class='th-head' style='border-bottom:1px solid transparent;'>Acciones</th>   ";
            $table .= "</tr>         ";
            
            $table .= "<tr style='color:#516ba0;'>";
            $table .= "<th class='th-subhead' style='border-right:1px solid #b2b2b2 ;'></th>";
            $table .= "  <th class='th-subhead'>Teléfono</th>";
            $table .= "  <th class='th-subhead' style='border-right:1px solid #b2b2b2 ;'>Correo</th>";
            $table .= " <th class='th-subhead'>Región</th>";
            $table .= " <th class='th-subhead'>Comuna</th>";
            $table .= " <th class='th-subhead' style='border-right:1px solid #b2b2b2 ;'>Calle</th>";
            $table .= "  <th class='th-subhead'></th>   ";
            $table .= "</tr>         ";
            
            $table .= " </thead>";


            for($j = 0 ; $j < count($sucursales); $j++){
                for($i = 0 ; $i < 1; $i++){
                    $table .= "<tr style='color:#CAC8C8;'>";
                        $table .= "<td class='td-val' style='border-right:1px solid #b2b2b2 ;'>".$sucursales[$j]->nombre."</td>";
                        $table .= "<td class='td-val'>"."<strong>F: </strong>".$sucursales[$j]->telefono."</td>";
                    $table .="<td class='td-val' style='border-right:1px solid #b2b2b2 ;'>".$sucursales[$j]->correo."</td>";
                        $table .= "<td class='td-val'>"
                                   .$sucursales[$j]->des_region."</td>";
                    $table .="<td class='td-val'>".$sucursales[$j]->des_comuna."</td>";
                     $table .="<td class='td-val' style='border-right:1px solid #b2b2b2 ;'>".$sucursales[$j]->descripcion_direccion
                     ."</td>";
                        $table .= "<td class='td-val'>".
                                "<div class='btn-group' role='group'>".
                                   "<a onclick='editar_sucursal(".$sucursales[$j]->id_sucursal.")'><img title='Editar' src='http://35.232.42.155/rendicion/Botones/Botones/Editar.png'></a>".
                                    "<a onclick='eliminar_sucursal(".$sucursales[$j]->id_sucursal.")'><img title='Eliminar !' src='http://35.232.42.155/rendicion/Botones/Botones/Eliminar.png'></a>".
                                "</div>"
                                    ."</td>";
               
                    $table .= "</tr>";
        
    
                }
            }

            return $table;
        }else{
            return "Sin Sucursales";
        }
           
    
    }

    
}
