@extends('menu/menu')
{{-- <script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js"></script> --}}
<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>

<button class="mt-1" onclick="topFunction()" id="myBtn" title="Go to top">
  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-arrow-up-circle-fill" viewBox="0 0 16 16">
    <path d="M16 8A8 8 0 1 0 0 8a8 8 0 0 0 16 0zm-7.5 3.5a.5.5 0 0 1-1 0V5.707L5.354 7.854a.5.5 0 1 1-.708-.708l3-3a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1-.708.708L8.5 5.707V11.5z" />
  </svg>
</button>

@section('content')

@if ( session('mensaje') )
<!--<div class="alert alert-success">{{ session('mensaje') }}</div>
    <a class="dropdown-item" href="{{route('go_see_clien')}}" style="text-align: right"> <button class="btn btn-success">Clientes</button></a> -->
@endif

<div class="container mt-5">
  <div class="title-vista mt-4">Solicitudess</div>
</div>

@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
<!-- <a class="dropdown-item" href="{{route('go_see_clien')}}" style="text-align: right"></a>  -->
@endif

<form action="{{route('go.filtros_solicitudes_proveedores')}}" method="GET">
  <div class="container mt-5">
    <div class="seccion-filtro">Firltrar por</div>
    <hr class="separador">

    <div class="row">
      <!--AQUI SE CARGA EL SELECT DE FECHA INICIO-->
      <div class="col-sm-3 form-group">
        <label for="datepicker">Fecha de inicio</label>
        <div class="input-group d-flex">
          <input type="date" class="form-control mayuscula" id="datepicker" value="{{$fecha ?? ''}}" name="datepicker">
          <div class="input-group-append">
            <button type="button" class="btn app-color" id="vaciar_fecha1" title="Borrar">
              <span class="material-icons-round">cancel</span>
            </button>
          </div>
        </div>
      </div>
      <!--AQUI SE CARGA EL SELECT DE FECHA FINAL-->
      <div class="col-sm-3 form-group">
        <label for="datepicker2">Fecha final</label>
        <div class="input-group d-flex">
          <input type="date" class="form-control mayuscula" id="datepicker2" value="{{$fecha2 ?? ''}}" name="datepicker2">
          <div class="input-group-append">
            <button type="button" class="btn app-color" id="vaciar_fecha1" title="Borrar">
              <span class="material-icons-round">cancel</span>
            </button>
          </div>
        </div>
      </div>
   


    </div>

    <div class="row">
      <!--AQUI SE CARGA EL SELECT DE CLIENTE-->
  
      <!--AQUI SE INGRESA LA SERIE-->
      <div class="col-sm-3 form-group">
        <label for="serie">Nº de Serie</label>
        <input type="" class="form-control mayuscula" id="serie" name="serie" value="{{$serie ?? ''}}" placeholder="Nº de Serie">
      </div>
      <!--AQUI SE INGRESA EL SC-->
      <div class="col-sm-3 form-group">
        <label for="sc">sSC</label>
        <input type="" class="form-control mayuscula" id="sSC" placeholder="SC" value="{{$sc ?? ''}}" name="sSC">
      </div>
            <!--AQUI SE CARGA EL SELECT DE ESTADO-->
       
    </div>

    <div class="row bg-seccion-filtro rounded">
      <!--AQUI SE CARGA EL SELECT DE REGION-->
      <div class="col-sm-3 form-group">
        <label for="region">Región</label>
        <select id="region" name="region" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          <option value="">Todos</option>
          @if (!empty($carga_selectRegion))
          @foreach ($carga_selectRegion as $regiones)
          @if ($regiones->sRegion != null)
          @if($regiones->sRegion == $region)
          <option selected value="{{ $regiones->sRegion }}">{{ucfirst(strtolower($regiones->sRegion))}} </option>
          @else
          <option value="{{ $regiones->sRegion }}">{{ucfirst(strtolower($regiones->sRegion))}} </option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE COMUNA-->
      <div class="col-sm-3 form-group">
        <label for="comuna">Comuna</label>
        <select id="comuna" name="comuna" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          <option value="">Todos</option>
          @if (!empty($carga_selectComuna))
          @foreach ($carga_selectComuna as $comunas)
          @if ($comunas->sComuna != null)
          @if($comunas->sComuna == $comuna)
          <option selected value="{{ $comunas->sComuna }}">{{ucfirst(strtolower($comunas->sComuna))}}</option>
          @else
          <option value="{{ $comunas->sComuna }}">{{ucfirst(strtolower($comunas->sComuna))}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE DIRECCION-->
      <div class="col-sm-3 form-group">
        <label for="direccion">Dirección</label>
        <select id="direccion" name="direccion" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          <option value="">Todos</option>
          @if (!empty($direccionTemporal))
          @foreach ($direccionTemporal as $direcciones)
          @if ($direcciones->descripcion_direccion != null)
          @if ($direcciones->descripcion_direccion == $direccion)
          <option selected value="{{ $direcciones->descripcion_direccion }}">{{ucfirst(strtolower($direcciones->descripcion_direccion))}}</option>
          @else
          <option value="{{ $direcciones->descripcion_direccion }}">{{ucfirst(strtolower($direcciones->descripcion_direccion))}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE SUCURSAL-->


    </div>
  </div>

  {{-- BOTON BUSCAR --}}
  <div class="text-center mb-5 mt-5">
    <button type="buscar" class="btn btn-pill btn-prim w-25">Buscar</button>
  </div>
  {{ session(['url_cordinadora' => url()->full()])     }}
</form>

{{ session(['url_proveedor' => url()->full()]) }}
<div class="container mt-5 p-0">
  <ul class="nav bg-export">
    <li class="clas-item">
      <a class="btn btn-ter" target="_blank" href="{{route('go.excel_exportarservicoscoordinador',Crypt::encryptString(url()->full())) ?? ''}}"> Exportar excel
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" viewBox="0 0 16 16" class="bi bi-file-earmark-excel-fill">
          <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM5.884 6.68 8 9.219l2.116-2.54a.5.5 0 1 1 .768.641L8.651 10l2.233 2.68a.5.5 0 0 1-.768.64L8 10.781l-2.116 2.54a.5.5 0 0 1-.768-.641L7.349 10 5.116 7.32a.5.5 0 1 1 .768-.64z"></path>
        </svg>
      </a>
    </li>
    <li class="clas-item">
    <a class="btn btn-ter" target="_blank" href="{{route('go.excel_proveedor_servicio_checklist',Crypt::encryptString(url()->full())) ?? ''}}"> 
          Exportar Excel con Checklist
          <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-excel" viewBox="0 0 16 16">
            <path d="M5.884 6.68a.5.5 0 1 0-.768.64L7.349 10l-2.233 2.68a.5.5 0 0 0 .768.64L8 10.781l2.116 2.54a.5.5 0 0 0 .768-.641L8.651 10l2.233-2.68a.5.5 0 0 0-.768-.64L8 9.219l-2.116-2.54z" />
            <path d="M14 14V4.5L9.5 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2zM9.5 3A1.5 1.5 0 0 0 11 4.5h2V14a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h5.5v2z" />
          </svg>
        </a>
      </li>

    <li>
      <button class="btn btn-ter" style="">
        @if(!empty($mostrarMenu))
          @if($mostrarMenu == "si")
            <a href="{{route('go.getalldownload',$urls ?? '')}}">
              <span class="material-icons-round">file_download</span> 
              Descargar
            </a>
          @endif
        @endif
    </button>
    </li>
  </ul>

  <!-- chcklist -->
  
</div>



<div class="container table-responsive mb-5 p-sm-0">
  <table class="table table-striped table-hover" id="mitable">
    <thead class="color-head">
      <tr>
        <th colspan="1" class="th-head border-th">Fecha de Recepción</th>
        <th colspan="1" class="th-head border-th">Fecha Instalacion</th>
        <th colspan="1" class="th-head border-th">Estado Despacho </th>
        <th colspan="1" class="th-head border-th">Estado </th>
        <th colspan="1" class="th-head border-th">Cliente</th>
        <th colspan="1" class="th-head border-th">Región</th>
        <th colspan="1" class="th-head border-th">Comuna</th>
        <th colspan="1" class="th-head border-th">Dirección | CUI</th><?php /*?>Agregue una nueva columna  - FITO<?php */ ?>
        <th colspan="1" class="th-head border-th">SSC</th>
        <th colspan="1" class="th-head border-th">Serie</th>
        <th colspan="1" class="th-head border-th">PDF</th>
      </tr>
    </thead>

    <tbody>
      @foreach ($Api_solicitudes as $los_datos)
      <tr>
        <td class="td-val">{{Carbon\Carbon::createFromDate($los_datos->fecha_recepcion)->format('d-m-Y')}}</td>
        <td class="td-val">{{Carbon\Carbon::createFromDate($los_datos->fecha_asignada)->format('d-m-Y')}}</td>
        <td class="td-val">{{$los_datos->estado_externo}}</td>
        @if($los_datos->estado_interno == "tarea_asignada")
        <td class="td-val">ASIGNADO</td>
        @else
        <td class="td-val">{{$los_datos->estado_interno}}</td>
        @endif

        <td class="td-val">{{$los_datos->sCliente ?? 'no informado'}}</td>
        <td class="td-val">{{$los_datos->sRegion ?? 'no informado'}}</td>
        <td class="td-val">{{$los_datos->sComuna}}</td>
        <td class="td-val">{{$los_datos->sDireccion ?? 'no informado'}}</td>

        <td class="td-val">{{$los_datos->sSC}}</td>
        <td class="td-val">{{$los_datos->sSerie}}</td>
        <td style="td-val">
          <!-- {{$los_datos->id ?? '--'}} -->
          {{-- <a class="btn-icon btn-icon-dd" href="{{route('generar.pdfProveedorServicios',Crypt::encryptString($los_datos->idAsignacion ?? ''))}}"><span class="material-icons-round">picture_as_pdf</span></a> --}}
          <a role="button" class="btn-icon btn-icon-dd ver_historial" title="Historial" data-id="{{Crypt::encryptString($los_datos->id ?? '')}}" data-estado="{{$los_datos->estado_interno?? ''}}">
            <span class="material-icons">history</span>
          </a>

          {{-- <button class="btn btn-light" style="margin-left: 73.5%;">
        
                    <a  href="{{route('generar.pdfProveedorServicios',Crypt::encryptString($los_datos->idAsignacion ?? ''))}}"><img src="{{ asset('img/Descargar PDF.png') }}" alt=""> Descargar</a>
          </button> --}}
        </td>
      </tr>
    </tbody>
    @endforeach
  </table>
</div>
{{-- /////////////////////////MODALLLL//////////// --}}
{{-- MODALs --}}
{{-- /////////////////////////MODALLLL//////////// --}}
<div class="modal fade" id="modal_historial_solicitud" role="dialog">
  <div class="modal-dialog  modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <div class="seccion-header">Historial de checklist</div>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador ml-4 mr-4">

      <div class="modal-body">
        <div class="container text-center">

        
        </div>
        <!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->

        <!-- TABLA DE RESULTADOS DE BUSQUEDA -->
        <div class="container mt-5 mb-5">
          <table class="table table-sm table-bordered table-responsive-md table-striped table-hover mt-4" style="margin: 0" id="dataGrid">
            <!-- ENCABEZADO -->
            <thead class="color-head">
              <tr>
                <th class="th-head border-th separador-v" colspan="1">CODIGO</th>
                <th class="th-head border-th separador-v" colspan="1">NUMERO VISITA</th>
                <th class="th-head border-th separador-v" colspan="1">TECNICO</th>
                <th class="th-head border-th separador-v" colspan="1">ESTADO</th>
                <th class="th-head border-th"><span class="material-icons">
                    settings
                  </span></th>
              </tr>
            </thead>
            <!-- FIN ENCABEZADO -->
            <!-- RESULTADOS -->
            <tbody id="cuerpo_tabla">
            </tbody>
            <!-- FIN RESULTADOS -->
          </table>
        </div>
      </div>
    </div>
  </div>
</div>


<script>
  $(document).ready(function() {
    $('.ver_historial_servicio').click(function() {
      id = $(this).attr("data-id");
      $.ajax({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        type: 'POST',
        url: "{{ route('go.historial_check_servicio') }}",
        data: {
          'id': id
        },
        success: function(data) {
          console.log(data);
          $('#agregar_historial_instalacion').empty();
          $("#modalver_historial_check").modal('show');
          $('#agregar_historial_instalacion').append(data)
        },
        error: function(xhr, status) {
          alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
        }
      })
    })
    $('.ver_historial').click(function() {
      // alert("hola");
      $("#modal_historial_solicitud").modal('show');
      var id_solicitud = $(this).attr("data-id");
      $("#m_id_solicitud").val(id_solicitud)
      var _token = $('input[name="_token"]').val();
      $.ajax({
        method: "POST",
        url: "{{ route('solicitudes.asociadosproveedor') }}",
        data: {
          'id_solicitud': id_solicitud,
          _token: _token
        },
        success: function(data) {
          console.log(data);
          $(cuerpo_tabla).empty();
          $(cuerpo_tabla).append(data);
          //validacion del boton
          var toma2 = "";
          //estado con boton
          var cancel = "cancelado";
          //estados sin boton
          var pend = "pendiente";
          var revis = "revisado";
          var asigna = "asignado";
          var fina = "finalizado";
          var recha = "rechazado";
          //funcion para botener el estado de la primera fila
          $.each($("#dataGrid:eq(0)"), function() {
            toma2 = $(this).find('td').eq(3).html();
            console.log(toma2);
            //estados sin boton
            if (toma2 == 'cancelado' || toma2 == "Cancelado") {
              $('#btnview').show();
            } else if (toma2 == pend || toma2 == "Pendiente") {
              $('#btnview').show();
            } else if (toma2 == fina || toma2 == "Finalizado") {
              $('#btnview').hide();
            } else if (toma2 == asigna || toma2 == "Asignado") {
              $('#btnview').hide();
            } else if (toma2 == revis || toma2 == "Revisado") {
              $('#btnview').hide();
            } else if (toma2 == recha || toma2 == "Rechazado") {
              $('#btnview').hide();
            } else if (toma2 == "revisar" || toma2 == "Revisar") {
              $('#btnview').hide();
            } else if (toma2 == "tarea_asignada" || toma2 == "Tarea_asignada" || toma2 == "Tarea Asignada") {
              $('#btnview').hide();
            } else if (data == '<tr><td>Sin Datos</td></tr>') {
              $('#btnview').show();
            }
          });
        },
        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      });
    })
  })
</script>

<script>
  $(document).ready(function() {


    $("#region").change(function() {


      region = $('select[id=region]').val();

      var _token = $('input[name="_token"]').val();

      $.ajax({
        method: "POST",

        url: "{{ route('buscarComunasSolicitud') }}",

        data: {
          'region': region,
          _token: _token,
          'cliente': $("#clientes").val()
        },

        success: function(data) {


          $("#comuna").empty();
          $("#direccion").empty();
          $("#sucursal").empty();

          $("#comuna").append('<option value="">Seleccionar</option>');
          $("#direccion").append('<option value="">Seleccionar</option>');
          $("#sucursal").append('<option value="">Seleccionar</option>');
          $(data).each(function(i, v) { // indice, valor
            //if(v.sComuna != null || v.sComuna != "null"  ){ 
            $("#comuna").append('<option value="' + v.sComuna + '">' + v.sComuna + '</option>');
          })
          // }

        },

        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }

      });
    });
    $("#comuna").change(function() {
      comuna = $('select[id=comuna]').val();
      var _token = $('input[name="_token"]').val();



      $.ajax({
        method: "POST",

        url: "{{ route('buscardireccionessolicitudes') }}",

        data: {
          'comuna': comuna,
          _token: _token,
          'cliente': $("#clientes").val()
        },

        success: function(data) {
          $("#direccion").empty();
          $("#sucursal").empty();
          $("#direccion").append('<option value="">Seleccionar</option>');
          $("#sucursal").append('<option value="">Seleccionar</option>');

          $(data).each(function(i, v) { // indice, valor
            //if(v.sdireccion != null || v.sdireccion != "null"  ){ 
            $("#direccion").append('<option value="' + v.sDireccion + '">' + v.sDireccion + '</option>');
          })
          // }

        },

        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }

      });
    });

    $("#direccion").change(function() {
      direccion = $('select[id=direccion]').val();
      var _token = $('input[name="_token"]').val();


      $.ajax({
        method: "POST",

        url: "{{ route('buscarsucursales') }}",

        data: {
          'direccion': direccion,
          _token: _token,
          'cliente': $("#clientes").val()
        },

        success: function(data) {
          $("#sucursal").empty();
          $("#sucursal").append('<option value="">Seleccionar</option>');

          $(data).each(function(i, v) { // indice, valor
            //if(v.ssucursal != null || v.ssucursal != "null"  ){ 
            $("#sucursal").append('<option value="' + v.sTipo_sucursal + '">' + v.sTipo_sucursal + '</option>');
          })
          // }

        },

        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }

      });
    });

    $('.ver_historial_instalacion').click(function() {
      var id_instalacion = $(this).attr("data-id");
      $("#m_id_instalacion").val(id_instalacion)


      var _token = $('input[name="_token"]').val();
      $("#modal_historial_detalle").modal('show');
      $.ajax({
        method: "POST",

        url: "{{ route('datos_instalacion') }}",

        data: {
          'id_instalacion': id_instalacion,
          _token: _token
        },

        success: function(data) {
          console.log(data);
          $.each(data, function(i, item) {

            $("#folioretiro").val(item.nFolio);
            $("#guiaretiro").val(item.nGuia);
            $("#clienteretiro").val(item.sCliente);
            $("#rutretiro").val(item.sRut);
            $("#regionretiro").val(item.sRegion);
            $("#ciudadretiro").val(item.sCiudad);
            $("#direccionretiro").val(item.sDireccion);
            $("#comunaretiro").val(item.sComuna);
            $("#codigoretiro").val(item.sCui);
            $("#comunaretiro").val(item.sComuna);
            $("#serieretiro").val(item.sSerie);
            $("#modeloretiro").val(item.sModelo);
            $("#contadorretiro").val(item.nContador);
            $("#colorcontadorretiro").val(item.nContador_color);
            $("#obs").val(item.sObservacion);
          });

        },

        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }

      });


    });
  });
</script>

<script>
  //Get the button
  var mybutton = document.getElementById("myBtn");

  // When the user scrolls down 20px from the top of the document, show the button
  window.onscroll = function() {
    scrollFunction()
  };

  function scrollFunction() {
    if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
      mybutton.style.display = "block";
    } else {
      mybutton.style.display = "none";
    }
  }

  // When the user clicks on the button, scroll to the top of the document
  function topFunction() {
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;
  }
</script>



@endsection