@extends('menu/menu')
<!--<script src="https://ajax.aspnetcdn.com/ajax/jQuery/jquery-3.4.1.min.js</script>--> 


@section('content')

@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif

<div class="container mt-5">
    <div class="title-vista mt-4">Mantenedor kilometros</div>
</div>

<div class="container">
    <!-- BARRA DE BUSQUEDA -->
    <form action="{{route('filtros_mantenedor_kilometros')}}" method="GET">
        @csrf
        
        <!-- Fila 1 Detalle de cliente ------------------------------------------------------>
        <div class="seccion-filtro">Filtrar por</div> 
        <hr class="separador">

        <div class="row">
            <!--AQUI SE CARGA EL SELECT DE CIUDAD BASE-->
            <div class="col-sm-4 form-group">
                <label for="clientes">Ciudad Base</label>
                <select name="ciudad_base" class="custom-select mayuscula" id="buscarciudades">
                    <option selected disabled>Seleccionar</option>
                    @foreach ($ciudad_base as $datos_ciudad_base)
                        <option value="{{$datos_ciudad_base->id}}">{{ucfirst(strtolower($datos_ciudad_base->ciudad_base))}}</option>
                    @endforeach
                </select>
            </div>

            <!--AQUI SE CARGA EL SELECT DE CIUDAD DESTINO-->
            <div class="col-sm-4 form-group">
                <label for="ciudadesrelacionadas">Ciudad</label>
                <select name="ciudad_destino" class="custom-select mayuscula" id="ciudadesrelacionadas">
                    <option selected disabled>Seleccionar</option>
                    @foreach ($ciudades as $ciudad)
                        <option value="{{$ciudad->ciudad}}">{{ucfirst(strtolower($ciudad->ciudad))}}</option>
                    @endforeach
                </select>
            </div>
            <!--FIN SELECT DE CLIENTE-->
            <div class="col-sm-12 text-center my-5">
                <button type="buscar" class="btn btn-prim w-25">Buscar</button>
            </div>
    </div>
    </form>
    <!-- FIN BARRA DE BUSQUEDA -->
    

</div>

<div class="container mt-5">
    <div class="container p-0 bg-export">
        <div class="clearfix">
            <button class="btn btn-ter py-2 px-3 float-right" data-toggle="modal" data-target="#modalCrear">
                <span class="material-icons-round icon-midle">note_add</span><strong>Crear registro</strong>
            </button>
        </div>
    </div>     
{{-- {{$kilometros}} --}}
    <!-- TABLA DE RESULTADOS DE BUSQUEDA -->
    <div class="container table-responsive mb-5 p-sm-0">
        <div class="table table-striped table-hover">
            <table class="table table-striped table-hover text-center">

                <!-- ENCABEZADO -->
                <thead class="color-head">
                    <tr>
                        <th class="th-head border-th" colspan="1">#</th>
                        <th class="th-head border-th" colspan="1">iudad Base</th>
                        <th class="th-head border-th" colspan="1">Ciudad Destino</th>
                        <th class="th-head border-th" colspan="1">Kilometros</th>
                        <th class="th-head border-th" colspan="1"><span class="material-icons">settings</span></th>
                    </tr>
                </thead>
                <!-- FIN ENCABEZADO -->

                <!-- RESULTADOS -->
                <tbody>
                    @if(!empty($kilometros))
                    @foreach ($kilometros as  $key => $los_datos)
                        <tr>
                            <td class="td-val">{{$los_datos->id}}</td>
                            <!-- CIUDAD BASES -->
                            @if($los_datos->id_ciudad_bases == 1)<td class="td-val">Iquique</td>
                            @elseif($los_datos->id_ciudad_bases == 2)<td class="td-val">Antofagasta</td>
                            @elseif($los_datos->id_ciudad_bases == 3)<td class="td-val">Copiapo</td>
                            @elseif($los_datos->id_ciudad_bases == 4)<td class="td-val">La Serena</td>
                            @elseif($los_datos->id_ciudad_bases == 5)<td class="td-val">Valparaiso</td>
                            @elseif($los_datos->id_ciudad_bases == 6 || $los_datos->id_ciudad_bases == 7)<td class="td-val">Talca</td>
                            @elseif($los_datos->id_ciudad_bases == 8)<td class="td-val">Concepción</td>
                            @elseif($los_datos->id_ciudad_bases == 9)<td class="td-val">Temuco</td>
                            @elseif($los_datos->id_ciudad_bases == 10)<td class="td-val">Osorno</td>
                            @elseif($los_datos->id_ciudad_bases == 11)<td class="td-val">Puerto Aysen</td>
                            @elseif($los_datos->id_ciudad_bases == 12)<td class="td-val">Punta Arenas</td>
                            @elseif($los_datos->id_ciudad_bases == 13)<td class="td-val">Santiago</td>
                            @elseif($los_datos->id_ciudad_bases == 14)<td class="td-val">Osorno</td>
                            @elseif($los_datos->id_ciudad_bases == 15)<td class="td-val">Arica</td>
                            @endif

                            <!-- CIUDAD DESTINO -->
                            <td class="td-val">{{$los_datos->ciudad}}</td>

                            <!-- KILOMETROS -->
                            <td class="td-val">{{$los_datos->kilometros}}</td>
                            <td class="td-val ">
                                <div class="d-flex justify-content-around">
                                    <a title="modificar" role="button" class="btn-icon btn-icon-dd ver_historial_instalacion editarkilometros" data-id="{{$los_datos->id}}">                               
                                        <span class="material-icons-round">edit</span>                         
                                    </a>                             
                                    <a class="btn-icon btn-icon-dd ver_historial" data-toggle="modal" data-target="#modalEliminar" data-idEliminar="{{$los_datos->id}}">                               
                                        <span class="material-icons">delete</span>                         
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    @endif
                </tbody>
                <!-- FIN RESULTADOS -->
            </table>
            <div style="margin: 10px 0px 10px 300px;">
                {{$kilometros->links()}}
            </div>
        </div>
    </div>
<!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->
</div> 

<!-- Modal Eliminar-->
<div class="modal fade" id="modalEliminar" tabindex="-1" role="dialog" aria-labelledby="modalEliminarLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">

        <div class="modal-header">
          <div class="seccion-modal" id="modalEliminarLabel"></div>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <hr class="separador ml-4 mr-4">

        <div class="modal-body">
            <div class="text-center">¿Realmente desea eliminar este registro?</div>
        </div>
        <form action="{{route('deleteRegistro')}}" method="GET">
            <input type="text" name="idkilometros" id="idKilometrosEliminar" style="display: none" hidden>
            <div class="modal-footer">
                <button type="submit" class="btn btn-prim w-25">Si, eliminar</button>
                <button type="button" class="btn btn-secundario w-25" data-dismiss="modal">Cancelar</button>
            </div>
        </form>
      </div>
    </div>
  </div>

<!-- Modal crear-->
<div class="modal fade" id="modalCrear" tabindex="-1" role="dialog" aria-labelledby="modalCrearLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">

            <div class="modal-header">
            <div class="seccion-modal" id="modalCrearLabel">Nuevo registro</div>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            </div>
            <hr class="separador ml-4 mr-4">

            <form action="{{route('crearKilometros')}}" method="GET">
                <div class="modal-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-12 form-group">
                                <label for="cBase">Ciudad Base</label>
                                <select id="cBase" class="form-control mayuscula" name="cBase">
                                @foreach ($ciudad_base as  $key => $los_datos)
                                    <option  value="{{$los_datos->id}}">{{$los_datos->ciudad_base}}</option>
                                @endforeach
                            </select>
                            </div>
                            <div class="col-sm-12 form-group">
                                <label for="cOrigen">Ciuda Origen</label>
                                <input type="text" required class="form-control mayuscula" name="cOrigen" id="cOrigen">
                            </div>
                            <div class="col-sm-12 form-group">
                                <label for="crearKilometros">Kilometros</label>
                                <input type="text" required class="form-control mayuscula" id="crearKilometros" name="crearKilometros">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-prim w-50 mx-auto">Guardar cambios</button>
                </div>
            </form>
        </div>
    </div>
</div>



<!-- MODAL EDITAR KILOMETROS-->
<div class="modal" id="modalkilometros" data-backdrop="static">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <form action="{{route('go.editar_kilometros')}}" method="post">
            @csrf
                <div class="modal-header">
                    <div class="seccion-modal">Modificar costos</div>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <hr class="separador ml-4 mr-4">

                <div class="modal-body">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-12 form-group">
                                <input type="text" class="form-control mayuscula" id="kilometros" value="" placeholder="" name="kilometros" onKeypress="if (event.keyCode < 45 || event.keyCode > 57) event.returnValue = false;">
                                <input type="hidden" id="id_kilometro" name="id">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-prim w-25 mx-auto">Modificar</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection
<!-- FIN MODAL EDITAR KILOMETROS-->
<script src="{{ asset('js/jquery-3.4.1.min.js') }}" ></script>

<script>
    
    $(document).ready(function() {

        $('#buscarciudades').change(function() {
            var valorSeleccionado = $(this).val();
            console.log(valorSeleccionado);
            var _token = $('input[name="_token"]').val();
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                method: "POST",
                url: "{{route('go.ver_datos_kilometros_filtros')}}",
                data: {
                    'id': valorSeleccionado,
                    _token: _token
                },
                success: function(data) {
                    // $("#kilometros").val(data.kilometros);
                    console.log("datas");

                    console.log(data);
                    $('#ciudadesrelacionadas').empty();
                $('#ciudadesrelacionadas').append(data);

                },
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                }
            });

            // Aquí puedes realizar cualquier acción que necesites con el valor seleccionado
        });
        
        $('.eliminarKilometros').click(function() {
            var id = $(this).attr("data-idEliminar");
            alert(id);
            $("#idKilometrosEliminar").val(id);
        });
        //editar kilometros
        $('.editarkilometros').click(function() {
            var id = $(this).attr("data-id");
            $("#id_kilometro").val(id);
            var _token = $('input[name="_token"]').val();
            $("#modalkilometros").modal('show');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                method: "POST",
                url: "{{route('go.ver_datos_kilometros')}}",
                data: {
                    'id': id,
                    _token: _token
                },
                success: function(data) {
                    $("#kilometros").val(data.kilometros);
                },
                error: function(xhr, status) {
                    alert('Disculpe, ha ocurrido un problema, intente mas tarde');
                }
            });
        });
    });
</script>