<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="UTF-8">
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<meta http-equiv="X-UA-Compatible" content="ie=edge">
	<title>Document</title>
	<style type="text/css">
		body {
			margin: 30px 0px;
		}

		h1,
		h2,
		h3,
		h4,
		h5,
		h6,
		p {
			font-family: Gotham, "Helvetica Neue", Helvetica, Arial, sans-serif;
			margin: 5px 0;
		}
	</style>
</head>

<body>
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
		<tbody>
			<tr>
				<td>
					@if ($proyecto_asociado[0]->proveedor_nombre == "kyocera")
					<img src="{{ asset ("img/logo/Kyocera_New_HP_Logo.jpg" ) }}" width="300" height="34">
					@elseif($proyecto_asociado[0]->proveedor_nombre == "upgrade")
					<img src="{{ asset ("img/logo/logo_upgrade.png" ) }}" width="200" height="90">
					@elseif($proyecto_asociado[0]->proveedor_nombre == "comtecglobal")
					<img src="{{ asset ("img/logo/comtecglobal_logo.jpeg" ) }}" width="200" height="90">
					@else
					@endif
				</td>
				<td>&nbsp;</td>
				<td>
					@if ($proyecto_asociado[0]->proveedor_nombre == "kyocera")
					@if($proyecto_asociado[0]->url_logo == "" || $proyecto_asociado[0]->url_logo == null)

					@else
					<img src="{{ asset ("img/logo/".$proyecto_asociado[0]->url_logo ?? '') }}" width="200" height="100" style="text-align: right">
					@endif
					@else
					@if($proyecto_asociado[0]->url_logo == "" || $proyecto_asociado[0]->url_logo == null)

					@else
					<img style="margin-left: 110px" src="{{ asset ("img/logo/".$proyecto_asociado[0]->url_logo ?? '') }}" width="200" height="100" style="text-align: right">
					@endif
					@endif
				</td>
			</tr>
		</tbody>
	</table>
	<br>
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
		<tbody>
			<tr>
				<td>
					@if($tipo_visita->descripcion == "Mantenimiento")
					<h2 align="center">Checklist de Mantenimiento</h2>
					@else
					<h2 align="center">Checklist de instalación</h2>
					@endif
				</td>
			</tr>
		</tbody>
	</table>
	<hr style="margin: 20px 0">
	<h3><strong>Asignación</strong></h3>
	<table width="100%" border="0" cellpadding="0" cellspacing="0">
		<tbody>
			<tr align="center">
				<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Nº de visita</strong></h4>
				</td>
				<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Tipo de visita</strong></h4>
				</td>
				<td width="25%" colspan="3"></td>
				<td width="25%" colspan="3"></td>
			</tr>
			<tr>
				<td height="40" colspan="3">
					<p style="text-transform:uppercase;text-align:center;"><span>{{$datos_asignacion[0]->numero_visita ?? ''}}</span></p>
				</td>
				<td height="40" colspan="3">
					<p style="text-transform:uppercase;text-align:center;">{{$tipo_visita->descripcion ?? ''}}</p>
				</td>
				<td height="40" colspan="3"></td>
				<td height="40" colspan="3"></td>
			</tr>
		</tbody>
	</table>

	<hr style="margin: 10px 0">

	<h3><strong>Detalle del Cliente</strong></h3>
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
		<tbody>
			<tr align="center">
				<td bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4>Cliente</h4>
				</td>
				<td bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4>Fecha Asignada</h4>
				</td>
				<td bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4>Hora Inicio</h4>
				</td>
				<td bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4>Hora Final</h4>
				</td>
			</tr>
			<tr>
				@if(strtoupper($datos_asignacion[0]->Cscliente) == "KYOCERA" || $con_razonSocial == "si")
				<td>
					<p style="text-transform:uppercase;text-align:center;"><span>{{$proyecto_asociado[0]->razonSocial ?? ''}}</span></p>
				</td>
				@else
				<td>
					<p style="text-transform:uppercase;text-align:center;"><span>{{$proyecto_asociado[0]->razon_social ?? ''}}</span></p>
				</td>
				@endif
				<td>
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{Carbon\Carbon::createFromDate($datos_asignacion[0]->fecha_instalacion ?? '')->format('d-m-Y')}}</p>
					</span>
				</td>
				<td>
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{Carbon\Carbon::createFromDate($datos_asignacion[0]->fecha_inicio ?? '')->format('d-m-Y H:i:s')}}</p>
					</span>
				</td>
				<td>
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{Carbon\Carbon::createFromDate($datos_asignacion[0]->fecha_fin ?? '')->format('d-m-Y H:i:s')}}</p>
					</span>
				</td>
			</tr>
		</tbody>
	</table>

	<table width="100%" border="0" cellspacing="0" cellpadding="0">
		<tbody>
			<tr>
				<td align="center" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Dirección</strong></h4>
				</td>
				@if (strtolower($proyecto_asociado[0]->proveedor_nombre) != "santotomas")
					<td align="center" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Sede</strong></h4>
					</td>
				@endif
				<td align="center" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Contacto</strong></h4>
				</td>

				
				@if (strtolower($proyecto_asociado[0]->proveedor_nombre) == "santotomas")
				<td align="center" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Id sala</strong></h4>
				</td>
				<td align="center" bgcolor="#002859" style="color: white;">
					<h4><strong>Sede</strong></h4>
				</td>
				@else
					<td align="center" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>SC</strong></h4>
					</td>
					<td align="center" bgcolor="#002859" style="color: white;">
						<h4><strong>CUI o Código Sucursal</strong></h4>
					</td>
				@endif	


			</tr>
			<tr>
				<td>
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->Csdireccion ?? ''}}</p>
					</span>
				</td>
				@if (strtolower($proyecto_asociado[0]->proveedor_nombre) != "santotomas")
					<td>
						<span>
							<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->Cstipo_sucursal ?? ''}}</p>
						</span>
					</td>
				@endif
				<td>
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->Cscontacto ?? ''}}</p>
					</span>
				</td>
				@if ($proyecto_asociado[0]->proveedor_nombre == "santotomas")
				<td>
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->idSala ?? ''}}</p>
					</span>
				</td>
				<td>
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->Cstipo_sucursal ?? ''}}</p>
					</span>
				</td>
				@else

					<td>
						<span>
							<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->idSala ?? ''}}</p>
						</span>
					</td>
					<td>
						<span>
							<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->Cstipo_sucursal ?? ''}}</p>
						</span>
					</td>
				@endif


			</tr>
		</tbody>
	</table>

	<hr style="margin: 20px 0">

	<h3><strong>Detalle de Equipamiento</strong></h3>
	<table width="100%" border="0" cellpadding="0" cellspacing="0">
		<tbody>
			<tr align="center">
				<td bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Marca</strong></h4>
				</td>
				<td bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Serie</strong></h4>
				</td>
				<td bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Modelo</strong></h4>
				</td>
				<td bgcolor="#002859" style="color: white;">
					<h4><strong>Tipo</strong></h4>
				</td>
			</tr>
			<tr>
				<td>
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->Csmarca ?? ''}}</p>
					</span>
				</td>
				<td>
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->CsSerie ?? ''}}</p>
					</span>
				</td>
				<td>
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->CsModelo ?? ''}}</p>
					</span>
				</td>
				
				<td>
					<span>
						@if (strtolower($proyecto_asociado[0]->proveedor_nombre) != "santotomas")

								<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->tipo_equipo}}</p>
						@else
									<p style="text-transform:uppercase;text-align:center;">Tablet</p>
						@endif		
					</span>
				</td>
			</tr>
		</tbody>
	</table>

	<table width="100%" border="0" cellpadding="0" cellspacing="0">
		<tbody>
			<tr align="center">
				<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Cambio de Serie</strong></h4>
				</td>
				<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Serie de remplazo</strong></h4>
				</td>
				<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Modelo de remplazo</strong></h4>
				</td>
				@if (strtolower($proyecto_asociado[0]->proveedor_nombre) != "santotomas")

				<td width="25%" colspan="3" bgcolor="#002859" style="color: white;">
					<h4><stron>Id sala</strong></h4>
					</td>
				@else
				<td width="25%" colspan="3"></td>
	
				@endif

			</tr>
			<tr>
				<td height="40" colspan="3" align="center">
					@if($datos_asignacion[0]->Cscambio_serie == "si")
					<input checked type="checkbox" id="cambio" name="cambio" value="cambio-de-serie">
					@else
					<input type="checkbox" id="cambio" name="cambio" value="cambio-de-serie">
					@endif
					<label for="cambio"></label>
				</td>
				<td height="40" colspan="3">
					<p style="text-transform:uppercase;text-align:center;"><span>{{$datos_asignacion[0]->Csserie_remplazo ?? ''}}</span></p>
				</td>
				<td height="40" colspan="3">
					<p style="text-transform:uppercase;text-align:center;"><span>{{$datos_asignacion[0]->Csmodelo_remplazo ?? ''}}</span></p>
				</td>
				@if (strtolower($proyecto_asociado[0]->proveedor_nombre) != "santotomas")
				<td height="40" colspan="3">
					<p style="text-transform:uppercase;text-align:center;"><span>{{$datos_asignacion[0]->idSala ?? ''}}</span></p>
				</td>
				@else{
					<td height="40" colspan="3"></td>

				}
				@endif



			</tr>
		</tbody>
	</table>

	<hr style="margin: 10px 0">

	<table width="100%" border="0" cellpadding="0" cellspacing="0">
		<tbody>
			<tr align="center">
				<td bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Ip</strong></h4>
				</td>
				<td bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Software</strong></h4>
				</td>
				<td bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Mask</strong></h4>
				</td>
				<td bgcolor="#002859" style="color: white;">
					<h4><strong>Gateway</strong></h4>
				</td>
			</tr>
			<tr>
				<td>
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->CsIP ?? ''}}</p>
					</span>
				</td>
				<td>
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->nombre_software ?? ''}}</p>
					</span>
				</td>
				<td>
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->CsMsk ?? ''}}</p>
					</span>
				</td>
				<td>
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->CsGateway ?? ''}}</p>
					</span>
				</td>
			</tr>
		</tbody>
	</table>
	@if (strtolower($proyecto_asociado[0]->proveedor_nombre) != "santotomas")

			<table width="100%" border="0" cellpadding="0" cellspacing="0">
				<tbody>
					<tr align="center">
						<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
							<h4><strong>Contador B/N</strong></h4>
						</td>
						<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
							<h4><strong>Contador color</strong></h4>
						</td>
						<td width="25%" colspan="3"></td>
						<td width="25%" colspan="3"></td>
					</tr>
					<tr>
						<td height="40" colspan="3">
							<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->CnContador ?? '' }}</p>
						</td>
						<td height="40" colspan="3">
							<p style="text-transform:uppercase;text-align:center;">{{$datos_asignacion[0]->CnContador_color ?? 0 ?? ''}}</p>
						</td>
						<td height="40" colspan="3"></td>
						<td height="40" colspan="3"></td>
					</tr>
				</tbody>
			</table>
			<hr style="margin-top: 60px;">

			@else
			<hr style="margin-top: 100px;">

@endif

	<h3 style="margin: 10px 0"><strong>Accesorios</strong></h3>
	<table width="100%" border="0" cellpadding="0" cellspacing="0">
		<tbody>
			<tr align="center">

				@if (strtolower($proyecto_asociado[0]->proveedor_nombre) != "santotomas")

				<td width="17%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Bandeja adicional</strong></h4>
				</td>
				<td width="16%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Mueble</strong></h4>
				</td>

			@endif
				<td width="17%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Kit Lector</strong></h4>
				</td>
				<td width="16%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Memoria SD</strong></h4>
				</td>
				<td width="17%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Cable de red</strong></h4>
				</td>
				<td width="17%" colspan="3" bgcolor="#002859" style="color: white;">
					<h4><strong>Cable de poder</strong></h4>
				</td>
			</tr>
			<tr>
				@if (strtolower($proyecto_asociado[0]->proveedor_nombre) != "santotomas")

					<td height="40" colspan="3" align="center">
						@if ($datos_asignacion[0]->CsBandeja_adicional == 'si')
						<input type="checkbox" id="band_ad" name="band_ad" align="center" checked="checked" value="bandeja-adicional" {{ !empty(old('band_ad')) ? 'checked' : '' }}>
						@else
						<input type="checkbox" id="band_ad" name="band_ad" align="center" value="bandeja-adicional" {{ !empty(old('band_ad')) ? 'checked' : '' }}>
						@endif
					</td>
					<td height="40" colspan="3" align="center">
						@if ($datos_asignacion[0]->CsMueble == 'si')
						<input type="checkbox" required id="mueble" name="mueble" align="center" checked="checked" value="si" {{ !empty(old('mueble')) ? 'checked' : '' }}>
						@else
						<input type="checkbox" required id="mueble" name="mueble" align="center" value="si" {{ !empty(old('mueble')) ? 'checked' : '' }}>
						@endif
					</td>
					@endif
	
				<td height="40" colspan="3" align="center">
					@if ($datos_asignacion[0]->CsKit_lector == 'si')
					<input type="checkbox" required id="kit_lector" name="kit_lector" align="center" checked="checked" value="si" {{ !empty(old('kit_lector')) ? 'checked' : '' }}>
					@else
					<input type="checkbox" required id="kit_lector" name="kit_lector" align="center" value="si" {{ !empty(old('kit_lector')) ? 'checked' : '' }}>
					@endif
				</td>
				<td height="40" colspan="3" align="center">
					@if ($datos_asignacion[0]->CsSD == 'si')
					<input type="checkbox" required id="memoria_sd" name="memoria_sd" align="center" checked="checked" value="si" {{ !empty(old('memoria_sd')) ? 'checked' : '' }}>
					@else
					<input type="checkbox" required id="memoria_sd" name="memoria_sd" align="center" value="si" {{ !empty(old('memoria_sd')) ? 'checked' : '' }}>
					@endif
				</td>
				<td height="40" colspan="3" align="center">
					@if ($datos_asignacion[0]->CsCable_red == 'si')
					<input type="checkbox" required id="cable_red" checked="checked" align="center" name="cable_red" value="si" {{ !empty(old('cable_red')) ? 'checked' : '' }}>
					@else
					<input type="checkbox" required id="cable_red" align="center" name="cable_red" value="si" {{ !empty(old('cable_red')) ? 'checked' : '' }}>
					@endif
				</td>
				<td height="40" colspan="3" align="center">
					@if ($datos_asignacion[0]->CsCable_poder == 'si')
					<input type="checkbox" required id="cable_poder" name="cable_poder" align="center" value="si" {{ !empty(old('cable_poder')) ? 'checked' : '' }}>
					@else
					<input type="checkbox" required id="cable_poder" align="center" name="cable_poder" value="si" {{ !empty(old('cable_poder')) ? 'checked' : '' }}>
					@endif
				</td>
			</tr>
		</tbody>
	</table>

	<hr style="margin: 10px 0">


	{{-- ****************** --}}
	<h3><strong>Configuración</strong></h3>
	<table width="100%" border="0" cellpadding="0" cellspacing="0">
		<tbody>
			<tr align="center">
				<td width="17%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Tipo de conexión</strong></h4>
				</td>
				<td width="16%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Conexión eléctrica</strong></h4>
				</td>
				@if (strtolower($proyecto_asociado[0]->proveedor_nombre) != "santotomas")

					<td width="17%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Nombre servidor</strong></h4>
					</td>
					<td width="16%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Servidor de impresión</strong></h4>
					</td>
					<td width="17%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Config. SMB</strong></h4>
					</td>
					<td width="17%" colspan="3" bgcolor="#002859" style="color: white;">
						<h4><strong>Config. Email</strong></h4>
					</td>
				@endif	
			</tr>
			<tr>
				<td height="40" colspan="3">
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{ $datos_asignacion[0]->nombre_conexion }}</p>
					</span>
				</td>
				<td height="40" colspan="3" style="text-transform:uppercase;text-align:center;">
					@if ($datos_asignacion[0]->Csconexion_electrica == 'si')
					<input type="checkbox" required id="conexion_electrica" checked="checked" name="conexion_electrica" value="si" {{ !empty(old('conf_smb')) ? 'checked' : '' }}>
					@else
					<input type="checkbox" required id="conexion_electrica" name="conexion_electrica" value="si" {{ !empty(old('conf_smb')) ? 'checked' : '' }}>
					@endif
				</td>
				@if (strtolower($proyecto_asociado[0]->proveedor_nombre) != "santotomas")
	
					<td height="40" colspan="3">
						<span>
							<p style="text-transform:uppercase;text-align:center;">{{ $datos_asignacion[0]->nombre_servidor }}</p>
						</span>
					</td>
					<td height="40" colspan="3" style="text-transform:uppercase;text-align:center;">
						@if ($datos_asignacion[0]->Csservidor_impresion == 'si')
						<input type="checkbox" required id="servidor_impresion" checked="checked" name="servidor_impresion" value="si" {{ !empty(old('servidor_impresion')) ? 'checked' : '' }}>
						@else
						<input type="checkbox" required id="servidor_impresion" name="servidor_impresion" value="si" {{ !empty(old('servidor_impresion')) ? 'checked' : '' }}>
						@endif
					</td>
					<td height="40" colspan="3" style="text-transform:uppercase;text-align:center;">
						@if ($datos_asignacion[0]->Csconfig_smb == 'si')
						<input type="checkbox" required id="conf_smb" checked="checked" name="conf_smb" value="si" {{ !empty(old('conf_smb')) ? 'checked' : '' }}>
						@else
						<input type="checkbox" required id="conf_smb" name="conf_smb" value="si" {{ !empty(old('conf_smb')) ? 'checked' : '' }}>
						@endif
					</td>
					<td height="40" colspan="3" style="text-transform:uppercase;text-align:center;">
						@if ($datos_asignacion[0]->Csconfig_email == 'si')
						<input type="checkbox" required id="conf_email" checked="checked" name="conf_email" value="si" {{ !empty(old('conf_email')) ? 'checked' : '' }}>
						@else
						<input type="checkbox" required id="conf_email" name="conf_email" value="si" {{ !empty(old('conf_email')) ? 'checked' : '' }}>
						@endif
					</td>
				@endif	
			</tr>
		</tbody>
	</table>

	<table width="100%" border="0" cellpadding="0" cellspacing="0" style="margin: 30px 0 ">
		<tbody>
			<tr align="center">
				@if (strtolower($proyecto_asociado[0]->proveedor_nombre) != "santotomas")

					<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Modo U253</strong></h4>
					</td>
				@endif	
				<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Instalación de driver manual</strong></h4>
				</td>
				<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Cantidad de usuarios</strong></h4>
				</td>
				@if (strtolower($proyecto_asociado[0]->proveedor_nombre) == "santotomas")

				<td width="25%" colspan="3" bgcolor="#002859" style="color: white;">
					<h4><strong>Estado canaleta</strong></h4>
					</td>
				@else
				  <td width="25%" colspan="3"></td>

				@endif	
			</tr>
			<tr>
				@if (strtolower($proyecto_asociado[0]->proveedor_nombre) != "santotomas")

					<td height="40" colspan="3">
						<span>
							<p style="text-transform:uppercase;text-align:center;">
								@if ($datos_asignacion[0]->modo_U253 ?? '' == 'si')
								<input type="checkbox" required id="modo-U253" checked="checked" name="modo-U253" value="si" {{ !empty(old('conf_email')) ? 'checked' : '' }}>
								@else
								<input type="checkbox" required id="modo-U253" name="modo-U253" value="si" {{ !empty(old('conf_email')) ? 'checked' : '' }}>
								@endif
							</p>
						</span>
					</td>
				@endif
				<td height="40" colspan="3">
					<span>
						<p style="text-transform:uppercase;text-align:center;">
							@if ($datos_asignacion[0]->ins_driver ?? '' == 'si')
							<input type="checkbox" required id="band-ad" checked="checked" name="band-ad" value="si" {{ !empty(old('conf_email')) ? 'checked' : '' }}>
							@else
							<input type="checkbox" required id="band-ad" name="band-ad" value="si" {{ !empty(old('conf_email')) ? 'checked' : '' }}>
							@endif
						</p>
					</span>
				</td>
				<td height="40" colspan="3"><span>
						<p style="text-transform:uppercase;text-align:center;">{{ $datos_asignacion[0]->Cscantidad_usuarios }}</p>
					</span></td>
					@if (strtolower($proyecto_asociado[0]->proveedor_nombre) == "santotomas")
				{{-- para santo tomas el nombre del servidor registra el estado de canaleta, que seria operativa o defectuosa --}}
					<td height="40" colspan="3"><span>
						<p style="text-transform:uppercase;text-align:center;">{{ $datos_asignacion[0]->nombre_servidor }}</p>
					</span></td>
					@else
					<td height="40" colspan="3"></td>
				    @endif	

			</tr>
		</tbody>
	</table>

	@if($datos_asignacion[0]->CsMarca_es != "" || $datos_asignacion[0]->CsMarca_es != null)
	<hr style="margin: 10px 0">
	<!--EQUIPO SALIENTE-->
	<h3><strong>Equipo saliente</strong></h3>
	<table width="100%" border="0" cellpadding="0" cellspacing="0" style="word-wrap: break-word;">
		<tbody>
			<tr align="center">
				<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Equipo de remplazo</strong></h4>
				</td>
				<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Marca</strong></h4>
				</td>
				<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Serie</strong></h4>
				</td>
				<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Modelo</strong></h4>
				</td>
			</tr>
			<tr>
				<td height="40" colspan="3" align="center">
					<input type="checkbox" id="cambio_es" checked name="cambio_es" value="cambio-de-serie-es">
				</td>
				<td height="40" colspan="3">
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{ $datos_asignacion[0]->CsMarca_es }}</p>
					</span>
				</td>
				<td height="40" colspan="3">
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{ $datos_asignacion[0]->CsSerie_es ?? '' }}</p>
					</span>
				</td>
				<td height="40" colspan="3">
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{ $datos_asignacion[0]->CsModelo_es }}</p>
					</span>
				</td>
			</tr>
		</tbody>
	</table>
	@endif

	@if (strtolower($proyecto_asociado[0]->proveedor_nombre) != "santotomas")

	<table width="100%" border="0" cellpadding="0" cellspacing="0" style="margin: 30px 0 ">
		<tbody>
			<tr align="center">
				<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Tipo Equipo</strong></h4>
				</td>
				<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h4><strong>Contador B/N</strong></h4>
				</td>
				<td width="25%" colspan="3" bgcolor="#002859" style="color: white;">
					<h4><strong>Contador Color</strong></h4>
				</td>
				<td width="25%" colspan="3"></td>
			</tr>
			<tr>
				<td height="40" colspan="3">
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{ $datos_asignacion[0]->CsTipoequipo_es }}</p>
					</span>
				</td>
				<td height="40" colspan="3">
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{ $datos_asignacion[0]->CsContador_es }}</p>
					</span>
				</td>
				<td height="40" colspan="3">
					<span>
						<p style="text-transform:uppercase;text-align:center;">{{ $datos_asignacion[0]->CsContadorcolor_es }}</p>
					</span>
				</td>
			</tr>
		</tbody>
	</table>
@endif	
	<!--FIN EQUIPO SALIENTE-->
	<!--SOLICITUD ACCESORIOS-->
	@if (strtolower($proyecto_asociado[0]->proveedor_nombre) != "santotomas")

				@if($datos_asignacion[0]->motivo != "" || $datos_asignacion[0]->motivo != null)
				<hr style="margin: 10px 0">
				<h3><strong>Solicitud de partes</strong></h3>
				<table width="100%" border="0" cellpadding="0" cellspacing="0" style="word-wrap: break-word;">
					<tbody>
						<tr align="center">
							<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
								<h4><strong>Solicitud de partes</strong></h4>
							</td>
							<td width="25%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
								<h4><strong>Motivo</strong></h4>
							</td>
						</tr>
						<tr>
							<td height="40" colspan="3" align="center">
								<input type="checkbox" id="solicitud" checked name="solicitud" value="solicitud_de_piezas">
							</td>
							<td height="40" colspan="3">
								<span>
									<p style="text-transform:uppercase;text-align:center;">{{ $datos_asignacion[0]->motivo }}</p>
								</span>
							</td>
						</tr>
					</tbody>
				</table>
				@if($datos_asignacion[0]->motivo != "Garantia")
				<h3><strong>Partes Dañadas</strong></h3>
				<table width="100%" border="0" cellpadding="0" cellspacing="0" style="word-wrap: break-word;">
					<tbody>
						<tr align="center">
							<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
								<h4><strong>ID</strong></h4>
							</td>
							<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
								<h4><strong>Número de pieza</strong></h4>
							</td>
							<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
								<h4><strong>Nombre de la pieza</strong></h4>
							</td>
							<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
								<h4><strong>Serie parte</strong></h4>
							</td>
							<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
								<h4><strong>Cantidad</strong></h4>
							</td>
						</tr>
						@foreach($accesorios_dañados as $accesorios_dañados1)
						<tr>
							<td height="40" colspan="3"><span>
									<p style="text-transform:uppercase;text-align:center;">{{$accesorios_dañados1->id}}</p>
								</span></td>
							<td height="40" colspan="3"><span>
									<p style="text-transform:uppercase;text-align:center;">{{$accesorios_dañados1->articulo}}</p>
								</span></td>
							<td height="40" colspan="3"><span>
									<p style="text-transform:uppercase;text-align:center;">{{$accesorios_dañados1->descripcion}}</p>
								</span></td>
							<td height="40" colspan="3"><span>
									<p style="text-transform:uppercase;text-align:center;">{{$accesorios_dañados1->serie_parte}}</p>
								</span></td>
							<td height="40" colspan="3"><span>
									<p style="text-transform:uppercase;text-align:center;">{{$accesorios_dañados1->cantidad}}</p>
								</span></td>
						</tr>
						@endforeach
					</tbody>
				</table>
				@else
				<table width="100%" border="0" cellpadding="0" cellspacing="0" style="margin-top: 4px; word-wrap: break-word;">
					<tbody>
						<tr>
							<td width="100%" colspan="4" bgcolor="#002859" style="border-right: solid 2px #fff; padding-left: 10px">
								<h3><strong>Fotografías de garantia</strong></h3>
							</td>
						</tr>
						<tr>
							<td>
								@foreach($fotos_accesorios as $fotos2)
								<img src="{{ asset ("fotos/".$fotos2->url) ?? ''}}" style="margin:5px;" alt="cajas" width="300" height="300">
								@endforeach
							</td>
						</tr>
					</tbody>
				</table>
		@endif
		<h3><strong>Partes Solicitadas</strong></h3>
		<table width="100%" border="0" cellpadding="0" cellspacing="0" style="word-wrap: break-word;">
			<tbody>
				<tr align="center">
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>ID</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Número de pieza</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Nombre de la pieza</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Serie parte</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Cantidad</strong></h4>
					</td>
				</tr>
				@foreach($datos_accesorios as $accesorios)
				<tr>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->id}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->articulo}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->descripcion}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->serie_parte}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->cantidad}}</p>
						</span></td>
				</tr>
				@endforeach
			</tbody>
		</table>
		<h3><strong>Partes Solicitadas Manualmente</strong></h3>
		<table width="100%" border="0" cellpadding="0" cellspacing="0" style="word-wrap: break-word;">
			<tbody>
				<tr align="center">
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Nombre de parte</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Número de parte</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>S/N parte</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Cantidad</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Observaciones</strong></h4>
					</td>
				</tr>
				@foreach($accesorios_manuales as $accesorios)
				<tr>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->nombre_parte}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->numero_parte}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->serie_parte}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->cantidad}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->observacion}}</p>
						</span></td>
				</tr>
				@endforeach
			</tbody>
		</table>
		@endif
		<!--FIN SOLICITUD ACCESORIOS-->
		<hr style="margin: 10px 0">
		<!--INSTALACION DE ACCESORIOS-->
		<h3><strong>Partes Instaladas</strong></h3>
		<table width="100%" border="0" cellpadding="0" cellspacing="0" style="word-wrap: break-word;">
			<tbody>
				<tr align="center">
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>ID</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Número de pieza</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Nombre de la pieza</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Serie parte</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Cantidad</strong></h4>
					</td>
				</tr>
				@foreach($instalacion_accesorios as $accesorios)
				<tr>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->id}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->articulo}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->descripcion}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->serie_parte}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->cantidad}}</p>
						</span></td>
				</tr>
				@endforeach
			</tbody>
		</table>
		<h3><strong>Partes Instaladas Manualmente</strong></h3>
		<table width="100%" border="0" cellpadding="0" cellspacing="0" style="word-wrap: break-word;">
			<tbody>
				<tr align="center">
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Nombre de parte</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Número de parte</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>S/N parte</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Cantidad</strong></h4>
					</td>
					<td width="20%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
						<h4><strong>Observaciones</strong></h4>
					</td>
				</tr>
				@foreach($instalacion_accesorios_manuales as $accesorios)
				<tr>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->nombre_parte}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->numero_parte}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->serie_parte}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->cantidad}}</p>
						</span></td>
					<td height="40" colspan="3"><span>
							<p style="text-transform:uppercase;text-align:center;">{{$accesorios->observacion}}</p>
						</span></td>
				</tr>
				@endforeach
			</tbody>
		</table>
@endif	
	<!--FIN INSTALACION DE ACCESORIOS-->
	<hr style="margin: 10px 0">

	<table width="100%" border="0" cellpadding="0" cellspacing="0" style="word-wrap: break-word;">
		<tbody>
			<tr align="left">
				<td width="100%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff; padding-left: 10px;text-transform:uppercase;color: white;">
					<h3><strong>Observaciones</strong></h3>
				</td>
			</tr>
			<tr>
				<td height="40" colspan="3">
					<div name="obsercaviones" name="observaciones" style="word-wrap: break-word;font-family:'Roboto', Sans-Serif;text-transform:uppercase;">
						{{ old('obsercaviones') }}{{ $datos_asignacion[0]->observacion }}
					</div>
				</td>
			</tr>
		</tbody>
	</table>

	<hr style="margin: 10px 0">

	<table width="100%" border="0" cellpadding="0" cellspacing="0">
		<tbody>
			<tr align="center">
				<td width="50%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff;color: white;">
					<h3><strong>Datos del Técnico</strong></h3>
				</td>
				<td width="50%" colspan="3" bgcolor="#002859" style="color: white;">
					<h3><strong>Datos del Contacto</strong></h3>
				</td>
			</tr>
			<tr>
				<td height="40" colspan="3"><span>
						<p>{{$datos_asignacion[0]->apellidouno.' '.$datos_asignacion[0]->nombrepersona }}</p>
					</span></td>
				<td height="40" colspan="3"><span>
						<p>{{ $datos_asignacion[0]->nombre_contactoF }}</p>
					</span></td>
			</tr>
		</tbody>
	</table>
	<table width="100%" border="0" cellpadding="0" cellspacing="0">
		<tbody>
			<tr align="center">
				<td>
				</td>
				<td class="title-table" width="50%" colspan="3">
					<h4><strong>Rut del Contacto</strong></h4>
				</td>
			</tr>
			<tr>
				<td></td>
				<td height="40" colspan="3"><span>
						<p>{{ $datos_asignacion[0]->rut_contactoF }}</p>
					</span></td>
			</tr>
		</tbody>
	</table>


	<table width="100%" border="0" cellpadding="0" cellspacing="0">
		<tbody>
			<tr>
				<td width="50%" colspan="3">
					<h3><strong>Firma Técnico</strong></h3>
				</td>
				<td width="50%" colspan="3">
					<h3><strong>Firma Contacto</strong></h3>
				</td>
			</tr>
			<tr>
				<td height="40" colspan="3" style="text-align: center;" align="center">
					<img src="{{ asset ("fotos/".$firmatrabajador[0]->url_firma ?? '')}}" alt="" width="100" height="100">
				</td>
				<td height="40" colspan="3" style="text-align: center;" align="center">
					@if($datos_asignacion[0]->url_firma == "" || $datos_asignacion[0]->url_firma == null )
					Cliente se niega a firmar
					@else
					<img src="{{ asset ("fotos/".$datos_asignacion[0]->url_firma)}}" alt="" width="100" height="100">
					@endif
				</td>
			</tr>
		</tbody>
	</table>

	<table width="100%" border="0" cellspacing="0" cellpadding="0" style="margin-top: 20px">
		<tbody>
			<tr>
				<td style="text-align: center;">

					<img src="{{ asset ("img/logo/A&A-logo.png" ) }}" alt="" width="100" height="100" />
				</td>
			</tr>
		</tbody>
	</table>

	<table width="100%" border="0" cellpadding="0" cellspacing="0" style="margin-top: 30px">
		<tbody>
			<tr>
				<td width="100%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff; padding-left: 10px;color: white;">
					<h3><strong>Fotografía de la página de estado</strong></h3>
				</td>
			</tr>
			<tr>
				<td height="600" colspan="3" style="padding-top: 30px; text-align: center;">
					@if(count($fotos) > 0)
					@php
					$extencion = explode(".",$fotos[0]->url);
					if($extencion[1] == "jpeg" || $extencion[1] == "jpg"){
						$a = imagecreatefromjpeg(("/var/www/html/aya/rendicion/fotos/".$fotos[0]->url ?? ''));
						$calidad = 50;
						$nuevo = imagejpeg($a,("/var/www/html/aya/rendicion/fotos/".$fotos[0]->url), $calidad);
					}else{
					}
					@endphp
					<img src="{{ asset ("fotos/".$fotos[0]->url ?? '') }}" alt="cajas" width="700" height="700">
					@endif
				</td>

			</tr>
		</tbody>
	</table>

	<table width="100%" border="0" cellpadding="0" cellspacing="0" style="margin-top: 40px">
		<tbody>
			<tr>
				<td width="100%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff; padding-left: 10px;color: white;">
					<h3><strong>Fotografía del panel de la máquina</strong></h3>
				</td>
			</tr>
			<tr>
				<td height="600" colspan="3" style="padding-top: 30px; text-align: center">
					@if(count($fotos) > 0)
					@if(count($fotos) > 1)
					@php
					$extencion = explode(".",$fotos[1]->url);
					if($extencion[1] == "jpeg" || $extencion[1] == "jpg"){
						$a = imagecreatefromjpeg(("/var/www/html/aya/rendicion/fotos/".$fotos[1]->url ?? ''));
						$calidad = 50;
						$nuevo = imagejpeg($a,("/var/www/html/aya/rendicion/fotos/".$fotos[1]->url), $calidad);
					}else{
						//$a = imagecreatefrompng(("/var/www/html/aya/rendicion/fotos/".$fotos[1]->url ?? ''));
						//$calidad = 50;
						//$nuevo = imagepng($a,("/var/www/html/aya/rendicion/fotos/".$fotos[1]->url), $calidad);
					}
					@endphp
					<img src="{{ asset ("fotos/".$fotos[1]->url ?? '') }}" alt="cajas" width="700" height="v">
					@endif
					@endif
				</td>
			</tr>
		</tbody>
	</table>






	<table width="100%" border="0" cellpadding="0" cellspacing="0" style="margin-top: 40px; padding-top: 20px">
		<tbody>
			<tr>
				<td width="100%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff; padding-left: 10px;color: white;">
					<h3><strong>Fotografía a 2 metros del equipo</strong></h3>
				</td>
			</tr>
			<tr>
				<td height="600" colspan="3" style="padding-top: 30px; text-align: center;">
					@if(count($fotos) > 0)
					@if(count($fotos) > 2)
					@php
					$extencion = explode(".",$fotos[2]->url);
					if($extencion[1] == "jpeg" || $extencion[1] == "jpg"){
						$a = imagecreatefromjpeg(("/var/www/html/aya/rendicion/fotos/".$fotos[2]->url ?? ''));
						$calidad = 50;
						$nuevo = imagejpeg($a,("/var/www/html/aya/rendicion/fotos/".$fotos[2]->url), $calidad);
					}else{
						//$a = imagecreatefrompng(("/var/www/html/aya/rendicion/fotos/".$fotos[2]->url ?? ''));
						//$calidad = 50;
						//$nuevo = imagepng($a,("/var/www/html/aya/rendicion/fotos/".$fotos[2]->url), $calidad);
					}
					@endphp
					<img src="{{ asset ("fotos/".$fotos[2]->url ?? '') }}"" alt=" cajas" width="700" height="700">
					@endif
					@endif
				</td>
			</tr>
		</tbody>
	</table>
	<table width="100%" border="0" cellpadding="0" cellspacing="0" style="margin-top: 40px; padding-top: 20px">
		<tbody>
			<tr>
				<td width="100%" colspan="3" bgcolor="#002859" style="border-right: solid 2px #fff; padding-left: 10px ">
					<h3><strong>Fotos adicionales</strong></h3>
				</td>
			</tr>
			@for($i = 3; $i < 13; $i++) @if(count($fotos)> $i)
				<tr>
					<td height="600" colspan="3" style="padding-top: 30px; text-align: center;">
						@if(count($fotos) > 0)
						@php
						$extencion = explode(".",$fotos[$i]->url);
						if($extencion[1] == "jpeg" || $extencion[1] == "jpg"){
							$a = imagecreatefromjpeg(("/var/www/html/aya/rendicion/fotos/".$fotos[$i]->url ?? ''));
							$calidad = 50;
							$nuevo = imagejpeg($a,("/var/www/html/aya/rendicion/fotos/".$fotos[$i]->url), $calidad);
						}else{
							//$a = imagecreatefrompng(("/var/www/html/aya/rendicion/fotos/".$fotos[$i]->url ?? ''));
							//$calidad = 50;
							//$nuevo = imagepng($a,("/var/www/html/aya/rendicion/fotos/".$fotos[$i]->url), $calidad);
						}
						@endphp
						<img src="{{ asset ("fotos/".$fotos[$i]->url ?? '') }}"" alt=" cajas" width="700" height="700">
						@endif
					</td>
				</tr>
				@endif
				@endfor

		</tbody>
	</table>
</body>
</html>