<?php

namespace App\Http\Controllers\checklist\excel;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Contracts\Encryption\DecryptException;
use Crypt;

use App; 
 
use Illuminate\Support\Facades\Storage;

use App\direccion;

use App\persona; 

use App\User; 
use App\checklist_instalacions; 

use Auth;
use Session;


use DB; 

use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
class excel_retirocoordinadoraController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return "funciona";
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($url){

        try {
            $url = Crypt::decryptString($url);
    
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $buscando = strpos($url, "/filtros_retiro?");
        
        if ($buscando === false) {
            // $resultado = "http://35.232.42.155/aya/rendicion/filtros_instalacionexport";
            $resultado = str_replace("/ver_api_retiros", "/filtros_retiroexport", $url);

        //  return "sinfiiltro";
        } else {
            $resultado = str_replace("/filtros_retiro?", "/filtros_retiroexport?", $url);
        //  return "confiltro";

        }
       
        return redirect( $resultado);  

       

        $retiros =  DB::table('retiros')
        ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
        ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
        ->select('retiros.dFecharegistrado', 'retiros.instalador','retiros.id', 'retiros.sEstado', 'retiros.sCliente','retiros.sRegion', 'retiros.sComuna', 'retiros.sSerie','sDireccion','fecha_retiroCord','estado_retiro_Cord')
        //->where('proyectos.id', '=', 1)
        ->orderBy('retiros.dFecharegistrado', 'desc')
       
        ->get();  
        return view('check.excel.excel_retirocoordinadora',compact('retiros'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function filtros_retiroExport(Request $request){
        

        $id_persona = $request->tecnicos;
        $estado = $request->estado;
        $clientes = $request->clientes;
        $region = $request->region;
        $comuna = $request->comuna;
        $serie = $request->serie;
        $sc = $request->sc;  


    //si los datos son estan vacios no carga filtros
        if($id_persona == "" &&  $estado == "" &&  $clientes == "" &&  $region == "" &&  $comuna == ""  && $serie == "" &&  $sc == "" &&  $request->datepicker == "" && $request->datepicker2 == "" ){
    

            // $retiros =  DB::table('retiros')
            // ->join('tracker', 'tracker.id', '=', 'retiros.tracker_id')
            // ->join('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            // ->lefjoin('proyectos', 'proyectos.id', '=', 'tracker.proyecto_id')
            // ->select('retiros.dFecharegistrado', 'retiros.instalador','retiros.id', 'retiros.sEstado', 'retiros.sCliente','retiros.sRegion', 'retiros.sComuna', 'retiros.sSerie','sDireccion','fecha_retiroCord','estado_retiro_Cord')
            // //->where('proyectos.id', '=', 1)
            // ->orderBy('retiros.dFecharegistrado', 'desc')
        
            // ->get(); 

            $retiros = DB::select('select checklist_retiros.cnContador_color,checklist_retiros.cnContador,retiros.sEstado,checklist_retiros.observacion,retiros.estado_retiro_Cord,retiros.fecha_retiroCord,retiros.id,retiros.estado_retiro_Cord
            ,retiros.sCliente,retiros.sRegion,retiros.sComuna,retiros.sSerie,retiros.instalador,retiros.sDireccion FROM retiros LEFT JOIN asignacion_retiros ON retiros.id = asignacion_retiros.retiros_id LEFT JOIN checklist_retiros ON checklist_retiros.asignacion_retiros_id = asignacion_retiros.id  '." group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");
            
            //retorna a los datos sin filtro
            return view('check.excel.excel_retirocoordinadora',compact('retiros'));
        }

        $where  = "";
 
         if($request->datepicker != "" && $request->datepicker2 != "" ){
            $fecha = Carbon::createFromDate($request->datepicker)->format('Y-m-d');
            $fecha2 = Carbon::createFromDate($request->datepicker2)->format('Y-m-d');
            $where = $where." and retiros.fecha_retiroCord"." BETWEEN "."'".$fecha."'"." and "."'".$fecha2."'";
        }
        if($estado != ""){
        
            if($where == ""){
                $where = $where." retiros.estado_retiro_Cord"." = "."'".$estado."'";
        
            }else{
                $where = $where." and retiros.estado_retiro_Cord"." = "."'".$estado."'";
        
            }
        
        }
        if($clientes != ""){
        
            if($where == ""){
                $where = $where." retiros.sCliente = "."'".$clientes."'";
        
            }else{
                $where = $where." and retiros.sCliente = "."'".$clientes."'";
        
            }
        
        }
        if($region != ""){
 
            if($where == ""){
                $where = $where."  retiros.sRegion  = "."'".$region."'";
        
            }else{
                $where = $where." and  retiros.sRegion  = "."'".$region."'";
        
            }
        
            }
        if($comuna != ""){
        
            if($where == ""){
                $where = $where."  retiros.sComuna  = "."'".$comuna."'";
        
            }else{
                $where = $where." and  retiros.sComuna  = "."'".$comuna."'";
        
            }
        
            }
        
        if($serie != ""){
            if($where == ""){
                $where = $where." retiros.sSerie  = "."'".$serie."'";
        
            }else{
                $where = $where." and  retiros.sSerie  = "."'".$serie."'";
        
            }
        
        }
        // if($sc != ""){
        // $where = $where." and  retiros.sSC  = "."'".$sc."'";
        // }
        
        if($id_persona != "" ){
        
                    
            $id_trabajador =  DB::table('trabajadors')
            ->select('trabajadors.id')
            ->where('trabajadors.id_persona', '=', $id_persona)            
            ->get(); 
            
            $id_tra =  $id_trabajador[0]->id ;
                
            /* $where = $where." and  asignacion_retiros.trabajadors_idtecnico  = "."'".$id_tra."'"; */
        
            if($where == ""){
                $where = $where."   asignacion_retiros.trabajadors_idtecnico  = "."'".$id_tra."'";
        
            }else{
                $where = $where." and  asignacion_retiros.trabajadors_idtecnico  = "."'".$id_tra."'";
        
            }
        
            $retiros = DB::select('select checklist_retiros.cnContador_color,checklist_retiros.cnContador,retiros.sEstado,checklist_retiros.observacion,retiros.estado_retiro_Cord,retiros.fecha_retiroCord,retiros.id
            ,retiros.sCliente,retiros.sRegion,retiros.sComuna,retiros.sSerie,retiros.instalador,retiros.sDireccion FROM retiros LEFT JOIN asignacion_retiros ON retiros.id = asignacion_retiros.retiros_id LEFT JOIN checklist_retiros ON checklist_retiros.asignacion_retiros_id = asignacion_retiros.id  where '.$where. " group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");
            
        }else{
        
            $retiros = DB::select('select checklist_retiros.cnContador_color,checklist_retiros.cnContador,retiros.sEstado,checklist_retiros.observacion,retiros.estado_retiro_Cord,retiros.fecha_retiroCord,retiros.id,retiros.estado_retiro_Cord
            ,retiros.sCliente,retiros.sRegion,retiros.sComuna,retiros.sSerie,retiros.instalador,retiros.sDireccion FROM retiros LEFT JOIN asignacion_retiros ON retiros.id = asignacion_retiros.retiros_id LEFT JOIN checklist_retiros ON checklist_retiros.asignacion_retiros_id = asignacion_retiros.id where '.$where . " group by  retiros.sSerie order by retiros.fecha_retiroCord asc ");
        
        }

        return view('check.excel.excel_retirocoordinadora',compact('retiros'));

    }


    //CREACION EXCEL DE HISTORIAL RESUMEN DE RETIROS
    public function create_excelHrr($url){
        
        try{
            $url = Crypt::decryptString($url);

        } catch (DecryptException $e){

            return "No Puede Realizar Esta Accion";
        }
        $buscando = strpos($url, "/filtros_historial_retiro?");
        
        if ($buscando === false) {
            // $resultado = "http://35.232.42.155/aya/rendicion/filtros_instalacionexport";
            $resultado = str_replace("/historial_retiro_coordinadora", "/filtros_historialretiroexport", $url);

        //  return "sinfiiltro";
        } else {
            $resultado = str_replace("/filtros_historial_retiro?", "/filtros_historialretiroexport?", $url);
        //  return "confiltro";

        }
       
        return redirect( $resultado); 

        $resumen_retiros =  DB::table('resumen_retiros')
        ->select('fecha_resumen', 'suma_embalados', 'suma_sinembalar', 'cantidad_bultos', 'comuna', 'cliente','direccion','cuisucursal','descripcion_motivo')
        ->orderBy('fecha_resumen')
    
        ->get();  
        return view('check.excel.excel_historialretirocoordinadora',compact('resumen_retiros'));
    }

    //EXPORTAR HISTORIAL RETIRO CON FILTROS
    public function filtros_historialretiroExport(Request $request){
        

    $clientes = $request->clientes;
    $comuna = $request->comuna;
    $direccion = $request->direccion;
    $cuisucursal = $request->cuisucursal;


    //si los datos son estan vacios no carga filtros
        if($clientes == "" &&  $comuna == "" &&  $direccion == ""  &&  $cuisucursal == ""){
    

            $resumen_retiros =  DB::table('resumen_retiros')
            ->select('fecha_resumen', 'suma_embalados', 'suma_sinembalar', 'cantidad_bultos', 'comuna', 'cliente','direccion','cuisucursal','descripcion_motivo')
            ->orderBy('fecha_resumen')
            ->get(); 
            
            //retorna a los datos sin filtro
            return view('check.excel.excel_historialretirocoordinadora',compact('resumen_retiros'));
        }

        $where  = "";
 
        if($clientes != ""){
 
            if($where == ""){
                $where = $where." resumen_retiros.cliente = "."'".$clientes."'";
        
            }else{
                $where = $where." and resumen_retiros.cliente = "."'".$clientes."'";
        
            }
        
        }
        if($direccion != ""){
        
           if($where == ""){
               $where = $where."  resumen_retiros.direccion  = "."'".$direccion."'";
       
           }else{
               $where = $where." and  resumen_retiros.direccion  = "."'".$direccion."'";
       
           }
       
        }
        if($comuna != ""){
        
            if($where == ""){
                $where = $where."  resumen_retiros.comuna  = "."'".$comuna."'";
        
            }else{
                $where = $where." and  resumen_retiros.comuna  = "."'".$comuna."'";
        
            }
        
        }
        if($cuisucursal != ""){
        
            if($where == ""){
                $where = $where."  resumen_retiros.cuisucursal  = "."'".$cuisucursal."'";
                
            }else{
                $where = $where." and  resumen_retiros.cuisucursal  = "."'".$cuisucursal."'";
        
            }
        
            
        }
        $resumen_retiros = DB::select('select 
            resumen_retiros.id,
            resumen_retiros.fecha_resumen,
            resumen_retiros.cantidad_bultos,
            resumen_retiros.suma_embalados,
            resumen_retiros.suma_sinembalar,
            resumen_retiros.cliente,
            resumen_retiros.comuna,
            resumen_retiros.direccion,
            resumen_retiros.cuisucursal,
            resumen_retiros.descripcion_motivo
            from resumen_retiros where '.$where . "" );

        return view('check.excel.excel_historialretirocoordinadora',compact('resumen_retiros'));
    }

}
