<?php

    namespace App\Http\Controllers\api;
    use DB;
    use GuzzleHttp\Client;
    use Illuminate\Http\Request;
    use App\Http\Controllers\Controller;
    use Illuminate\Support\Facades\Http;
    use Illuminate\Support\Facades\Crypt;
    use GuzzleHttp\Exception\RequestException;
    use Carbon\Carbon;
    use DateTime;
    use App;
class ConsumirRetiroController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index($idasig)
    {
        try {
                  $id_asignacion = Crypt::decryptString($idasig);

              } catch (DecryptException $e) {
                  //
                  return "No Puede Realizar Esta Accion";
              }

        
              $mi_asignacion = DB::table('asignacion_retiros')
              ->where('asignacion_retiros.id','=',$id_asignacion)
              ->get();


              $id_trabajador = $mi_asignacion[0]->trabajadors_idtecnico;

        $datos_asignacion = DB::table('asignacion_retiros')
                               ->join('checklist_retiros','checklist_retiros.asignacion_retiros_id','=','asignacion_retiros.id')
                               ->join('trabajadors','trabajadors.id','=','asignacion_retiros.trabajadors_idtecnico')
                               ->join('personas','personas.id','=','trabajadors.id_persona')
                               ->select(
                                   'asignacion_retiros.numero_visita',
                                   'asignacion_retiros.id',
                                   'checklist_retiros.csDireccion',
                                   'checklist_retiros.csComuna',
                                   'checklist_retiros.csCui',
                                       'checklist_retiros.csSerie',
                                       'checklist_retiros.csModelo',
                                       'checklist_retiros.cnFolio',
                                       'checklist_retiros.csRegion',
                                       'checklist_retiros.csRut',
                                       'checklist_retiros.csCliente',
                                       'checklist_retiros.csCliente',
                                       'checklist_retiros.cnContador',
                                       'checklist_retiros.cnContador_color',
                                       'checklist_retiros.csEstado',
                                       'checklist_retiros.csObservacion',
                                       'checklist_retiros.nombre_contacto',
                                       'checklist_retiros.bandeja_adicional',
                                       'checklist_retiros.cnGuia',
                                       'checklist_retiros.csCiudad',
                                       'checklist_retiros.mueble',
                                       'checklist_retiros.kitlector',
                                       'checklist_retiros.memoriasd',
                                       'checklist_retiros.nId_Solicitud',
                                       'checklist_retiros.cablered',
                                       'checklist_retiros.cablepoder',
                                       'checklist_retiros.equipoensucursal',
                                       'checklist_retiros.equipoembalado',
                                       'checklist_retiros.cliente_firma',
                                       'personas.nombre_uno','personas.apellido_uno','personas.apellido_dos',
                                       'asignacion_retiros.fecha_termino',
                                       'asignacion_retiros.fecha_inicio',
                                       'asignacion_retiros.fecha_asignado',
                                       'asignacion_retiros.fecha_retiro',
                                       'checklist_retiros.id as idCheckRetiros',
                                       'checklist_retiros.url_firma',
                                       'trabajadors.id as id_trabajador'
                                       
                                       )

                               ->where('asignacion_retiros.id','=',$id_asignacion)
                               ->get();

                               //agregar esto para generar los pdf's de retiro

                        $datos_trabajador = DB::table('trabajadors')
                        ->where('trabajadors.id','=',$datos_asignacion[0]->id_trabajador)
                        ->get();


                        $firmatrabajador = DB::table('firma_clientes')
                        ->where('firma_clientes.id_tecnico','=', $datos_trabajador[0]->id_login)
                        ->get();

                    $proyectos =  DB::table('asignacion_retiros')
                    ->join('retiros','retiros.id','=','asignacion_retiros.retiros_id')
                    ->join('tracker','tracker.id','=','retiros.tracker_id')
                    ->join('proyectos','proyectos.id','=','tracker.proyecto_id')
                    ->join('clientes','clientes.id','=','proyectos.clientes_id')

                    ->select('clientes.razon_social','proyectos.nombre','proveedor_retiro','proyectos.url_logo','proyectos.proveedor_nombre')
                    ->where('asignacion_retiros.id','=',$id_asignacion)
                    ->get();


                    $fotos = DB::table('fotos_retiros')
                    ->where('fotos_retiros.checklist_retiros_id','=',$datos_asignacion[0]->idCheckRetiros)
                    ->get();

                       //sacar datos para generar nombre pdf
                        $CsSerie = $datos_asignacion[0]->csSerie;
                        $id_para_pdf = $datos_asignacion[0]->id;


                        $proveedor =$proyectos[0]->proveedor_retiro;
        
        try {
            if($proveedor == "kyocera" || $proveedor == "Kyocera" || $proveedor == "KYOCERA"){    
                    $client = new Client([
                        // Base URI is used with relative requests
                        'base_uri' => 'http://190.153.241.162:3017/wsaya/',
                        // You can set any number of default request options.
                        'timeout'  => 2.0,
                    ]);


            
            $response = $client->request('GET', 'updatetrackerretbchile', [

                'form_params' => [
                    'api_key' => 'v3r1z0l4ll3v4',
                    "data"=>[
                        "nId_Solicitud"=>$datos_asignacion[0]->nId_Solicitud,
                        "nFolio"=>$datos_asignacion[0]->cnFolio,
                        "sRegion"=>$datos_asignacion[0]->csRegion,
                        "sRut"=>$datos_asignacion[0]->csRut,
                        "sCliente"=>$datos_asignacion[0]->csCliente,
                        "sCiudad"=>$datos_asignacion[0]->csCiudad,
                        "sComuna"=>$datos_asignacion[0]->csComuna,
                        "sDireccion"=>$datos_asignacion[0]->csDireccion,
                        "sSerie"=>$datos_asignacion[0]->csSerie,
                        "sModelo"=>$datos_asignacion[0]->csModelo,
                        "nContador"=>$datos_asignacion[0]->cnContador,
                        "nContador_color"=>$datos_asignacion[0]->cnContador_color,
                        "nGuia"=>$datos_asignacion[0]->cnGuia,
                        "sEstado"=> strtoupper("Finalizado"), //mayuscula
                        "sObservacion"=>$datos_asignacion[0]->csObservacion,
                        "sCui"=>$datos_asignacion[0]->csCui
                    ]
                   
                ]


             ] );
         }


            // $var = json_decode($response->getBody()->getContents());
            \PDF::setOptions(['isHtml5ParserEnabled' => true, 'isRemoteEnabled' => true])
            ->loadView('check/pdf.pdfretiroCoordinadora',compact('datos_asignacion','proyectos','fotos','firmatrabajador'))
            ->save(storage_path('app/public/pdfRetiro/') . $CsSerie.$id_para_pdf.'retiro.pdf')
            ->stream();

            $buscar_asignacion = App\asignacion_retiros::where('id', '=', $id_para_pdf)->first();
            $buscar_asignacion->url_pdf = $CsSerie.$id_para_pdf."retiro.pdf";
            $buscar_asignacion->estado_asignacion = "Finalizado";
            $buscar_asignacion->timestamps = false;
            $buscar_asignacion->save();

            $actualizar_ins =  App\retiros::findOrfail($buscar_asignacion->retiros_id);
            $actualizar_ins->timestamps = false;
            $actualizar_ins->estado_retiro_Cord = "Finalizado";
            $actualizar_ins->save();
            

            return redirect(session('url_retiro'))->with('mensaje', 'Respuestas Enviada ');   
            
                dd($response->getBody()->getContents());
                
        }  catch (RequestException $e) {
            return redirect(session('url_retiro'))->with('mensaje', 'Error, Api Kyocera No Encontrada ');   
         }
         catch (FatalThrowableError $e) {
           
            return redirect(session('url_retiro'))->with('mensaje', 'Error, Api Kyocera No Encontrada ');   
       }
           // dd($response->getBody()->getContents());
          // return json_decode($response->getBody()->getContents());
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
