@extends('menu/menu')
<style>
  #myBtn {
    display: none;
    position: fixed;
    bottom: 20px;
    right: 30px;
    z-index: 99;
    border: none;
    outline: none;
    background-color: #2d2f6f;
    color: white;
    cursor: pointer;
    padding: 15px;
    border-radius: 35px;
  }

  #myBtn:hover {
    background-color: #bf4e2b;
  }
</style>
<script src="{{ asset('js/jquery-3.4.1.min.js') }}"></script>
<button class="mt-1" onclick="topFunction()" id="myBtn" title="Go to top">
  <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-arrow-up-circle-fill" viewBox="0 0 16 16">
    <path d="M16 8A8 8 0 1 0 0 8a8 8 0 0 0 16 0zm-7.5 3.5a.5.5 0 0 1-1 0V5.707L5.354 7.854a.5.5 0 1 1-.708-.708l3-3a.5.5 0 0 1 .708 0l3 3a.5.5 0 0 1-.708.708L8.5 5.707V11.5z" />
  </svg>
</button>
@section('content')

<div class="container mt-5">
  <div class="title-vista mt-4">Solicitudes</div>
</div>
@php
$nombre_DB = DB::connection()->getDatabaseName();
@endphp
@if($nombre_DB != "KYOCERA")
<div class="container">
  <a class="btn btn-ter reload" target="_blank" href="http://34.176.85.189/sistema/rendicion/correo/readMail.php">
  Para actualizar los registros de la tabla, presione aquí
  <!--<span class="material-icons">
    autorenew
  </span-->
</a>
</div>
@endif
@if ( session('mensaje') )
<div class="alert alert-success">{{ session('mensaje') }}</div>
@endif
<form action="{{route('go.filtros_solicitudes')}}" method="GET">
  <div class="container mt-2">
    <div class="seccion-filtro">Firltrar por</div>
    <hr class="separador">
    <div class="row">
      <!--AQUI SE CARGA EL SELECT DE FECHA INICIO-->
      <div class="col-sm-3 form-group">
        <label for="datepicker">Fecha de inicio</label>
        <div class="input-group d-flex">
          <input type="date" class="form-control mayuscula" id="datepicker" value="{{$fecha ?? ''}}" name="datepicker">
          <div class="input-group-append">
            <button type="button" class="btn app-color" id="vaciar_fecha1" title="Borrar">
              <span class="material-icons-round">cancel</span>
            </button>
          </div>
        </div>
      </div>
      <!--AQUI SE CARGA EL SELECT DE FECHA FINAL-->
      <div class="col-sm-3 form-group">
        <label for="datepicker2">Fecha final</label>
        <div class="input-group d-flex">
          <input type="date" class="form-control mayuscula" id="datepicker2" value="{{$fecha2 ?? ''}}" name="datepicker2">
          <div class="input-group-append">
            <button type="button" class="btn app-color" id="vaciar_fecha1" title="Borrar">
              <span class="material-icons-round">cancel</span>
            </button>
          </div>
        </div>
      </div>
      <!--AQUI SE CARGA EL SELECT DE COMUNA-->
      <div class="col-sm-3 form-group">
        <label for="tecnicos">Técnico</label>
        <select id="tecnicos" name="tecnicos" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          @if (!empty($tecnico))
          @foreach ($tecnico as $tecnicos)
          @if ($tecnicos->nombre_uno != null)
          @if($tecnicos->id == $id_persona )
          <option selected value="{{ $tecnicos->id }}">{{ucfirst(strtolower($tecnicos->nombre_uno))}} {{ucfirst(strtolower($tecnicos->apellido_uno))}}
            @else
          <option value="{{ $tecnicos->id }}">{{ucfirst(strtolower($tecnicos->nombre_uno))}} {{ucfirst(strtolower($tecnicos->apellido_uno))}}
            @endif
            @endif
            @endforeach
            @endif
        </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE ESTADO-->
      <div class="col-sm-3 form-group">
        <label for="estado">Estado de Solicitud</label>
        <select id="estado" name="estado" class="custom-select mayuscula">
          <option selected value="">seleccionar</option>
          @if (!empty($carga_selectEstado))
          @foreach ($carga_selectEstado as $estados)
          @if ($estados->estado_externo != null)
          @if ($estados->estado_externo == $estado)
          <option selected value="{{ $estados->estado_externo }}">{{ucfirst(strtolower($estados->estado_externo))}}</option>
          @else
          <option value="{{ $estados->estado_externo }}">{{ucfirst(strtolower($estados->estado_externo))}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
    </div>

    <div class="row">
      <!--AQUI SE CARGA EL SELECT DE CLIENTE-->
      <div class="col-sm-3 form-group">
        <label for="clientes">Cliente</label>
        <div class="input-group d-flex">
          <select class="custom-select mayuscula" id="clientes" name="clientes">
            <option selected value="">Seleccionar</option>
            @if (!empty($carga_selectClientes))
            @foreach ($carga_selectClientes as $clientes)
            @if ($clientes->sCliente != null)
            @if ($clientes->sCliente == $cliente)
            <option selected value="{{ $clientes->sCliente }}">{{ucfirst(strtolower($clientes->sCliente))}}</option>
            @else
            <option value="{{ $clientes->sCliente }}">{{ucfirst(strtolower($clientes->sCliente))}}</option>
            @endif
            @endif
            @endforeach
            @endif
          </select>

        </div>
      </div>

      <!--AQUI SE INGRESA LA SERIE-->
      <div class="col-sm-3 form-group">
        <label for="serie">Nº de Serie</label>
        <input type="" class="form-control mayuscula" id="serie" name="serie" value="{{$serie ?? ''}}" placeholder="Nº de Serie">
      </div>
      <!--AQUI SE INGRESA EL SC-->
      <div class="col-sm-3 form-group">
        <label for="sc">sSC</label>
        <input type="" class="form-control mayuscula" id="sSC" placeholder="SC" value="{{$sc ?? ''}}" name="sSC">
      </div>
      <div class="col-sm-3 form-group">
        <label for="estado">Estado de Opcional</label>
        <select id="estado" name="estado_opcional" class="custom-select mayuscula">
          <option value="" selected>Seleccionar</option>
          <option value="con.por.horario">Cont Por Horario</option>
          <option value="esp.repuesto">Esperando Repuesto</option>
          <option value="terminado">Terminado</option>
        </select>
      </div>
    </div>
    <!--AQUI SE CARGA EL SELECT DE ESTADO-->
    <div class="row bg-seccion-filtro rounded">
      <!--AQUI SE CARGA EL SELECT DE REGION-->
      <div class="col-sm-3 form-group">
        <label for="region">Región</label>
        <select id="region" name="region" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          <option value="">Todos</option>
          @if (!empty($carga_selectRegion))
          @foreach ($carga_selectRegion as $regiones)
          @if ($regiones->sRegion != null)
          @if($regiones->sRegion == $region)
          <option selected value="{{ $regiones->sRegion }}">{{ucfirst(strtolower($regiones->sRegion))}} </option>
          @else
          <option value="{{ $regiones->sRegion }}">{{ucfirst(strtolower($regiones->sRegion))}} </option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE COMUNA-->
      <div class="col-sm-3 form-group">
        <label for="comuna">Comuna</label>
        <select id="comuna" name="comuna" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          <option value="">Todos</option>
          @if (!empty($carga_selectComuna))
          @foreach ($carga_selectComuna as $comunas)
          @if ($comunas->sComuna != null)
          @if($comunas->sComuna == $comuna)
          <option selected value="{{ $comunas->sComuna }}">{{ucfirst(strtolower($comunas->sComuna))}}</option>
          @else
          <option value="{{ $comunas->sComuna }}">{{ucfirst(strtolower($comunas->sComuna))}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE DIRECCION-->
      <div class="col-sm-3 form-group">
        <label for="direccion">Dirección</label>
        <select id="direccion" name="direccion" class="custom-select mayuscula">
          <option selected value="">Seleccionar</option>
          <option value="">Todos</option>
          @if (!empty($direccionTemporal))
          @foreach ($direccionTemporal as $direcciones)
          @if ($direcciones->descripcion_direccion != null)
          @if ($direcciones->descripcion_direccion == $direccion)
          <option selected value="{{ $direcciones->descripcion_direccion }}">{{ucfirst(strtolower($direcciones->descripcion_direccion))}}</option>
          @else
          <option value="{{ $direcciones->descripcion_direccion }}">{{ucfirst(strtolower($direcciones->descripcion_direccion))}}</option>
          @endif
          @endif
          @endforeach
          @endif
        </select>
      </div>
      <!--AQUI SE CARGA EL SELECT DE SUCURSAL-->
    </div>
  </div>
  {{-- BOTON BUSCAR --}}
  <div class="text-center mb-5 mt-5">
    <button type="buscar" class="btn btn-pill btn-prim w-25">Buscar</button>
  </div>
  {{ session(['url_cordinadora' => url()->full()])     }}
</form>

<div class="container mt-5 p-0">
  {{-- EXPORTAR --}}
  <ul class="nav bg-export">
    <li class="clas-item">
      <a class="btn btn-ter" target="_blank" href="{{route('go.excel_servicioCordinadora',Crypt::encryptString(url()->full()))}}">
        Exportar excel
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-excel-fill" viewBox="0 0 16 16">
          <path d="M9.293 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V4.707A1 1 0 0 0 13.707 4L10 .293A1 1 0 0 0 9.293 0zM9.5 3.5v-2l3 3h-2a1 1 0 0 1-1-1zM5.884 6.68 8 9.219l2.116-2.54a.5.5 0 1 1 .768.641L8.651 10l2.233 2.68a.5.5 0 0 1-.768.64L8 10.781l-2.116 2.54a.5.5 0 0 1-.768-.641L7.349 10 5.116 7.32a.5.5 0 1 1 .768-.64z" />
        </svg>
      </a>
    </li>
    <li class="clas-item">
      <a class="btn btn-ter " target="_blank" href="{{route('exportar_serviciochecklist',Crypt::encryptString(url()->full()))}}">
        Exportar Excel con Checklist
        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-excel" viewBox="0 0 16 16">
          <path d="M5.884 6.68a.5.5 0 1 0-.768.64L7.349 10l-2.233 2.68a.5.5 0 0 0 .768.64L8 10.781l2.116 2.54a.5.5 0 0 0 .768-.641L8.651 10l2.233-2.68a.5.5 0 0 0-.768-.64L8 9.219l-2.116-2.54z" />
          <path d="M14 14V4.5L9.5 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2zM9.5 3A1.5 1.5 0 0 0 11 4.5h2V14a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h5.5v2z" />
        </svg>
      </a>
    </li>
    <li class="m-auto">
    </li>
  </ul>
</div>
<div class="container table-responsive mb-5 p-sm-0">
  <table class="table table-striped table-hover" id="mitable">
    <thead class="color-head">
      <tr>
        <th colspan="1" class="th-head border-th">Fecha de Recepción</th>
        <th colspan="1" class="th-head border-th">Fecha Solicitud</th>
        <th colspan="1" class="th-head border-th">Fecha Inicio</th>
        <th colspan="1" class="th-head border-th">Fecha Fin</th>
        <th colspan="1" class="th-head border-th">Estado Despacho </th>
        <th colspan="1" class="th-head border-th">Estado </th>
        <th colspan="1" class="th-head border-th">Cliente</th>
        <th colspan="1" class="th-head border-th">Región</th>
        <th colspan="1" class="th-head border-th">Comuna</th>
        <th colspan="1" class="th-head border-th">Dirección | CUI</th><?php /*?>Agregue una nueva columna  - FITO<?php */ ?>
        <th colspan="1" class="th-head border-th">SSC</th>
        <th colspan="1" class="th-head border-th">MARCA</th>

        <th colspan="1" class="th-head border-th">Serie</th>
        <th colspan="1" class="th-head border-th">Estado opcion</th>
        <th colspan="1" class="th-head border-th">Acciones</th>
      </tr>
    </thead>
    <tbody>
      @foreach ($Api_solicitudes as $los_datos)
      <tr>
        <td class="td-val">{{Carbon\Carbon::createFromDate($los_datos->fecha_recepcion)->format('d-m-Y')}}</td>
        <td class="td-val">{{Carbon\Carbon::createFromDate($los_datos->fecha_asignada)->format('d-m-Y')}}</td>
        @php
        $fechas = DB::table('asignacion_solicitudes')
        ->select('asignacion_solicitudes.fecha_inicio','asignacion_solicitudes.fecha_fin')
        ->where('asignacion_solicitudes.api_solicitudes_id','=',$los_datos->id)
        ->orderBy('id','DESC')
        ->get();

        $fecha_inicio = "";
        $fecha_fin = "";
        if(count($fechas) != 0){
        if($fechas[0]->fecha_inicio != "" || $fechas[0]->fecha_fin != "" ){
        $fecha_inicio = Carbon\Carbon::createFromDate($fechas[0]->fecha_inicio)->format('d-m-Y H:i:s');
        $fecha_fin = Carbon\Carbon::createFromDate($fechas[0]->fecha_fin)->format('d-m-Y H:i:s');
        }
        }
        @endphp
        <td>{{$fecha_inicio}}</td>
        <td>{{$fecha_fin}}</td>
        <!--ESTADO EXTERNO-->
        @if($los_datos->estado_externo == "EN ESPERA")
        <td class="td-val">En cliente</td>
        @elseif($los_datos->estado_externo == "EN TRANSITO")
        <td class="td-val">En ruta</td>
        @else
        <td class="td-val">{{$los_datos->estado_externo}}</td>
        @endif
        @if($los_datos->estado_interno == "tarea_asignada")
        <td class="td-val asignado">ASIGNADO</td>
        @elseif($los_datos->estado_interno == "REVISAR")
        <td class="td-val terminado">{{$los_datos->estado_interno}}</td>
        @elseif($los_datos->estado_interno == "Solicitar Repuestos")
        <td class="td-val s_repuesto">{{$los_datos->estado_interno}}</td>
        @elseif($los_datos->estado_externo == "Repuesto en tránsito")
        <td class="td-val r_transito">Repuesto en tránsito</td>
        @else
        <td class="td-val">{{$los_datos->estado_interno}}</td>
        @endif
        <td class="td-val">{{$los_datos->sCliente ?? 'no informado'}}</td>
        <td class="td-val">{{$los_datos->sRegion ?? 'no informado'}}</td>
        <td class="td-val">{{$los_datos->sComuna}}</td>
        <td class="td-val">{{$los_datos->sDireccion ?? 'no informado'}}</td>
        <td class="td-val">{{$los_datos->sSC}}</td>
        <td class="td-val">{{$los_datos->Smarca ?? ''}}</td>

        <td class="td-val">{{$los_datos->sSerie}}</td>
        @php
        $estado = DB::table('asignacion_solicitudes')
        ->join('api_solicitudes','api_solicitudes.id','=','asignacion_solicitudes.api_solicitudes_id')
        ->join('check_formulario_solicitudes','check_formulario_solicitudes.id','=','asignacion_solicitudes.check_formulario_solicitudes_id')
        ->select('check_formulario_solicitudes.estado_seleccionado')
        ->where('asignacion_solicitudes.api_solicitudes_id','=',$los_datos->id)
        ->orderBy('check_formulario_solicitudes.id','DESC')
        ->get();
        @endphp
        <td class="td-val">{{$estado[0]->estado_seleccionado ?? ''}}</td>
        <td class="td-val">
          <div class="dropdown dropleft" style="text-align: center;">

            <button type="button" class="btn-dropdown" data-toggle="dropdown">
              <span class="material-icons">more_vert</span>
            </button>
            <div class="dropdown-menu mostrar shadow">
              <div class="d-flex justify-content-around">
                <!--a role="button" class="btn-icon btn-icon-dd ver_historial_instalacion" title="Ver Detalle" data-id="{{Crypt::encryptString($los_datos->id ?? '')}}">
                  <span class="material-icons">visibility</span>
                </a-->
                <a role="button" class="btn-icon btn-icon-dd ver_historial" title="Historial" data-id="{{Crypt::encryptString($los_datos->id ?? '')}}" data-estado="{{$los_datos->sEstado_despacho?? ''}}">
                  <span class="material-icons">history</span>
                </a>
                <a role="button" title="Historial" data-id="{{Crypt::encryptString($los_datos->id)}}" class="ver_historial_servicio">
                  <span class="material-icons-round">
                    info
                  </span>
                </a>
              </div>
            </div>
          </div>
        </td>

      </tr>
    </tbody>@endforeach
  </table>
</div>


{{-- MODALs --}}
{{-- /////////////////////////MODALLLL//////////// --}}
<div class="modal fade" id="modal_historial_solicitud" role="dialog">
  <div class="modal-dialog  modal-lg modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <div class="seccion-header">Historial de checklist</div>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <hr class="separador ml-4 mr-4">

      <div class="modal-body">
        <div class="container text-center d-flex justify-content-center">
          {{-- <form action="{{route('actualizar.trabajador',Crypt::encryptString($trabajadores[0]->id_persona))}}" method="POST"> --}}
          <form action="{{route('go.asignar_check_servicios')}}" method="get">
            {{-- / @csrf --}}
            <input type="hidden" style="display: none" name="url_filtro" value="{{url()->full()}}">
            <button type="submit" class="btn btn-prim px-sm-4" id="btnview">
              <input type="text" value="" id="m_id_solicitud" name="idSolicitud" style="display:none">Asignar
            </button>
          </form>
          <div class="ml-1 mr-1"></div>
          <form action="{{route('go.asignar_check_servicios_sinvisita')}}" method="get">
            {{-- / @csrf --}}
            <input type="hidden" style="display: none" name="url_filtro" value="{{url()->full()}}">
            <button type="submit" class="btn btn-prim px-sm-4" id="btnview">
              <input type="text" value="" id="m_id_solicituds" name="idSolicituds" style="display:none">Cambio tecnico
            </button>
          </form>
        </div>
        <!-- FIN TABLA DE RESULTADOS DE BUSQUEDA -->

        <!-- TABLA DE RESULTADOS DE BUSQUEDA -->
        <div class="container mt-5 mb-5">
          <table class="table table-sm table-bordered table-responsive-md table-striped table-hover mt-4" style="margin: 0" id="dataGrid">
            <!-- ENCABEZADO -->
            <thead class="color-head">
              <tr>
                <th class="th-head border-th separador-v" colspan="1">CODIGO</th>
                <th class="th-head border-th separador-v" colspan="1">FECHA ASIGNADA</th>
                <th class="th-head border-th separador-v" colspan="1">TECNICO</th>
                <th class="th-head border-th separador-v" colspan="1">ESTADO</th>
                <th class="th-head border-th"><span class="material-icons">
                    settings
                  </span></th>
              </tr>
            </thead>
            <!-- FIN ENCABEZADO -->
            <!-- RESULTADOS -->
            <tbody id="cuerpo_tabla">
            </tbody>
            <!-- FIN RESULTADOS -->
          </table>
        </div>



      </div>
    </div>
  </div>
</div>
<!--Modal Historial instalacion-->
<div class="modal" id="modalver_historial_check">
  <div class="modal-dialog modal-xl modal-3xl modal-dialog-scrollable">
    <div class="modal-content">
      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title"> Historial</h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        <div class="container">
          <table class="table table-bordered table-responsive table-striped">
            <thead>
              <th scope="col">N° Visita</th>
              <th scope="col">Tecnico</th>
              <th scope="col">N° de serie</th>
              <th scope="col">Marca </th>

              <th scope="col">Modelo </th>
              <th scope="col">Direccion</th>
              <th scope="col">Region</th>
              <th scope="col">Comuna</th>
              <th scope="col">Cliente</th>
              <th scope="col">Fecha</th>
              <th scope="col">Contador B/N</th>
              <th scope="col">Contador Color</th>
              <th scope="col">Observaciones</th>
              <th scope="col">Estado opcion</th>
              <th scope="col">Accesorios</th>
            </thead>
            <tbody id="agregar_historial_instalacion"></tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<script>
  //Get the button
  var mybutton = document.getElementById("myBtn");
  // When the user scrolls down 20px from the top of the document, show the button
  window.onscroll = function() {
    scrollFunction()
  };

  function scrollFunction() {
    if (document.body.scrollTop > 20 || document.documentElement.scrollTop > 20) {
      mybutton.style.display = "block";
    } else {
      mybutton.style.display = "none";
    }
  }
  // When the user clicks on the button, scroll to the top of the document
  function topFunction() {
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;
  }
</script>
<script>
  $(document).ready(function() {
    $('.ver_historial_servicio').click(function() {
      id = $(this).attr("data-id");
      $.ajax({
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        type: 'POST',
        url: "{{ route('go.historial_check_servicio') }}",
        data: {
          'id': id
        },
        success: function(data) {
          console.log(data);
          $('#agregar_historial_instalacion').empty();
          $("#modalver_historial_check").modal('show');
          $('#agregar_historial_instalacion').append(data)
        },
        error: function(xhr, status) {
          alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
        }
      })
    })
    $('.ver_historial').click(function() {
      // alert("hola");
      $("#modal_historial_solicitud").modal('show');
      var id_solicitud = $(this).attr("data-id");
      $("#m_id_solicitud").val(id_solicitud)
      $("#m_id_solicituds").val(id_solicitud)
      var _token = $('input[name="_token"]').val();
      $.ajax({
        method: "POST",
        url: "{{ route('solicitudes.asociados') }}",
        data: {
          'id_solicitud': id_solicitud,
          _token: _token
        },
        success: function(data) {
          console.log(data);
          $(cuerpo_tabla).empty();
          $(cuerpo_tabla).append(data);
          //validacion del boton
          var toma2 = "";
          //estado con boton
          var cancel = "cancelado";
          //estados sin boton
          var pend = "pendiente";
          var revis = "revisado";
          var asigna = "asignado";
          var fina = "finalizado";
          var recha = "rechazado";
          //funcion para botener el estado de la primera fila
          $.each($("#dataGrid:eq(0)"), function() {
            toma2 = $(this).find('td').eq(3).html();
            console.log(toma2);
            //estados sin boton
            if (toma2 == 'cancelado' || toma2 == "Cancelado") {
              $('#btnview').show();
            } else if (toma2 == pend || toma2 == "Pendiente") {
              $('#btnview').show();
            } else if (toma2 == fina || toma2 == "Finalizado") {
              $('#btnview').hide();
            } else if (toma2 == asigna || toma2 == "Asignado") {
              $('#btnview').hide();
            } else if (toma2 == revis || toma2 == "Revisado") {
              $('#btnview').hide();
            } else if (toma2 == recha || toma2 == "Rechazado") {
              $('#btnview').hide();
            } else if (toma2 == "revisar" || toma2 == "Revisar") {
              $('#btnview').hide();
            } else if (toma2 == "tarea_asignada" || toma2 == "Tarea_asignada" || toma2 == "Tarea Asignada") {
              $('#btnview').hide();
            } else if (data == '<tr><td>Sin Datos</td></tr>') {
              $('#btnview').show();
            }
          });
        },
        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      });
    })
  })
</script>
<script>
  $(document).ready(function() {
    $("#region").change(function() {
      region = $('select[id=region]').val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        method: "POST",
        url: "{{ route('buscarComunasSolicitud') }}",
        data: {
          'region': region,
          _token: _token,
          'cliente': $("#clientes").val()
        },
        success: function(data) {
          $("#comuna").empty();
          $("#direccion").empty();
          $("#sucursal").empty();
          $("#comuna").append('<option value="">Seleccionar</option>');
          $("#direccion").append('<option value="">Seleccionar</option>');
          $("#sucursal").append('<option value="">Seleccionar</option>');
          $(data).each(function(i, v) { // indice, valor
            //if(v.sComuna != null || v.sComuna != "null"  ){ 
            $("#comuna").append('<option value="' + v.sComuna + '">' + v.sComuna + '</option>');
          })
          // }
        },
        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      });
    });
    $("#comuna").change(function() {
      comuna = $('select[id=comuna]').val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        method: "POST",
        url: "{{ route('buscardireccionessolicitudes') }}",
        data: {
          'comuna': comuna,
          _token: _token,
          'cliente': $("#clientes").val()
        },
        success: function(data) {
          $("#direccion").empty();
          $("#sucursal").empty();
          $("#direccion").append('<option value="">Seleccionar</option>');
          $("#sucursal").append('<option value="">Seleccionar</option>');
          $(data).each(function(i, v) { // indice, valor
            //if(v.sdireccion != null || v.sdireccion != "null"  ){ 
            $("#direccion").append('<option value="' + v.sDireccion + '">' + v.sDireccion + '</option>');
          })
          // }
        },
        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }

      });
    });
    $(".reload").click(function() {
      setTimeout(() => {
      location.reload();
    }, "1000")
    });
    $("#direccion").change(function() {
      direccion = $('select[id=direccion]').val();
      var _token = $('input[name="_token"]').val();
      $.ajax({
        method: "POST",
        url: "{{ route('buscarsucursales') }}",
        data: {
          'direccion': direccion,
          _token: _token,
          'cliente': $("#clientes").val()
        },
        success: function(data) {
          $("#sucursal").empty();
          $("#sucursal").append('<option value="">Seleccionar</option>');

          $(data).each(function(i, v) { // indice, valor
            //if(v.ssucursal != null || v.ssucursal != "null"  ){ 
            $("#sucursal").append('<option value="' + v.sTipo_sucursal + '">' + v.sTipo_sucursal + '</option>');
          })
          // }
        },
        error: function(xhr, status) {
          alert('Disculpe, ha ocurrido un problema, intente mas tarde');
        }
      });
    });
  });
</script>
@endsection

<style>
.modal-3xl{
        max-width: 1900 !important;
  
}
</style>