const express = require('express');
const mysql = require('mysql2');
// const cors = require('cors'); // Importa el middleware cors

const app = express();

// Habilita CORS para todas las solicitudes
// app.use(cors());

// Crear una conexión a MySQL
function createConnection() {
    return mysql.createConnection({
        host: 'localhost', // Cambia esto según tu configuración
        user: 'root', // Cambia esto según tu configuración
        password: '', // Cambia esto según tu configuración
        database: "system_nebiolo"
    });
}

// Ruta para cargar ventas agrupadas según el parámetro de sucursal
app.get('/cargarventasagrupadas/:sucursal/:tipodocumento/:rutcliente/:fecha/:cliente', (req, res) => {
    const sucursal = atob(req.params.sucursal);
    var tipodocumento = atob(req.params.tipodocumento);
    const rutcliente = atob(req.params.rutcliente);
    const fechas = atob(req.params.fecha);
    const cliente = atob(req.params.cliente);

    // Crea una conexión a la base de datos
    const connection = createConnection();

    // Consulta SQL base
    let sqlTemplate = `
    SELECT 
        s.descripcion AS nombre_sucursal,
        ot_facturadas.numero_ot,
        ot_facturadas.id AS id_ot_facturada,
        ot_facturadas.fecha_facturada,
        clientes.id AS id_cliente,
        clientes.rut AS rut_cliente,
        clientes.razon_social AS razon_social_cliente,
        ot_facturadas.factura,
        ot_facturadas.url_dte_factura,
        ot_facturadas.boleta,
        ot.total,
        ot.sub_total,
        ot.iva,
        ot.descuento_pesos,
        
        ot_facturadas.url_dte_boleta
        
    FROM 
        ot_facturadas
    JOIN
        clientes ON ot_facturadas.id_cliente = clientes.id
    JOIN
        ordenes_trabajos ot ON ot_facturadas.id_ot_facturada = ot.id
    JOIN
        sucursales s ON ot.sucursales_id = s.id
    WHERE
        ot_facturadas.id IN (
            SELECT MAX(id) 
            FROM ot_facturadas 
            GROUP BY numero_ot
        )
    `;

    // Condiciones adicionales según los parámetros recibidos
    const conditions = [];
    const params = [];


    if (fechas !== 'sinvalor') {
        // Dividir la cadena de fechas en fecha de inicio y fecha de fin
        // let [fechaInicio, fechaFin] = fechas.split(" - ");
        // Dividir el rango de fechas en fecha de inicio y fecha de fin y convertirlas al formato YYYY-MM-DD
        let [fechaInicio, fechaFin] = fechas.split(' - ').map(date => {
            const [day, month, year] = date.split('-');
            return `${year}-${month}-${day}`;
        });

        // Ajustar el formato de las fechas para que coincida con el de la base de datos
        fechaInicio += " 00:00:00";
        fechaFin += " 23:59:59";

        // Agregar la condición para el rango de fechas
        conditions.push("ot_facturadas.fecha_facturada BETWEEN ? AND ?");
        params.push(fechaInicio);
        params.push(fechaFin);
    }

    if (cliente !== 'sinvalor') {
        conditions.push("clientes.razon_social = ?");
        params.push(cliente);
    }

    if (sucursal !== 'sinvalor') {
        conditions.push("ot.sucursales_id = ?");
        params.push(sucursal);
    }

    if (tipodocumento !== 'sinvalor') {

        if (tipodocumento == "boleta") {
            tipodocumento = "1";
            conditions.push("ot_facturadas.boleta = ?");
            params.push(tipodocumento);
        } else if (tipodocumento == "factura") {
            tipodocumento = "1";

            conditions.push("ot_facturadas.factura = ?");
            params.push(tipodocumento);
        }

    }

    if (rutcliente !== 'sinvalor') {
        conditions.push("clientes.rut = ?");
        params.push(rutcliente);
    }

    // Agregar las condiciones a la consulta base
    if (conditions.length > 0) {
        sqlTemplate += " AND " + conditions.join(" AND ");
    }

    // Imprime la consulta en la consola
    console.log('Consulta SQL:', mysql.format(sqlTemplate, params));

    // Ejecuta la consulta SQL
    connection.query(sqlTemplate, params, (error, results, fields) => {
        // Cierra la conexión a la base de datos
        connection.end();

        // Si hay un error, envía un mensaje de error al cliente
        if (error) {
            return res.status(500).json({ error: 'Error al recuperar las sucursales.', details: error });
        }

        // Si no hay resultados, envía un mensaje al cliente indicando que no se encontraron sucursales
        if (!results.length) {
            return res.status(404).json({ message: 'No se encontraron sucursales.', query: sqlTemplate });
        }

        // Si hay resultados, envía los datos de las sucursales al cliente
        res.status(200).json({ dataOt: results, query: sqlTemplate });
    });
});


// Escucha en el puerto 5800
const PORT = process.env.PORT || 5800;
app.listen(PORT, () => {
    console.log(`Servidor escuchando en el puerto ${PORT}`);
});