{{-- @extends('layouts.app') --}}
@extends('layouts.sidebar')

@section('content')
 <!-- content -->
<div class="titulos"> 
    <h2>Nuevo Cliente</h2>
    <hr />

</div>

<div class="container">
     
  <form action="{{route('clientes.store')}}" method="POST">  
    @csrf
       <div class="row">

        {{-- datos personales --}}
        <div class="mb-3 col-6" >
          <label for="razon_social" class="form-label">razon_social</label>
          <input type="text" required class="form-control" id="razon_social" placeholder="" name="razon_social">
          @error('razon_social')
          <div class="alert alert-danger">{{ $message }}</div>
          @enderror
        </div>
          <div class="mb-3  col-6">
            <label for="rut" class="form-label">rut</label>
            <input type="text" required class="form-control" id="rut" placeholder="" name="rut">
            @error('rut')
            <div class="alert alert-danger">{{ $message }}</div>
            @enderror
          </div>
      
          <div class="mb-3  col-6">
            <label for="giro" class="form-label">giro</label>
            <input type="text" required class="form-control" id="giro" placeholder="" name="giro">
             @error('giro')
          <div class="alert alert-danger">{{ $message }}</div>
          @enderror
            
            
          </div>
          <div class="mb-3 col-6" >
            <label for="telefono" class="form-label">telefono</label>
            <input type="text" required class="form-control" id="telefono" placeholder="" name="telefono">
             @error('telefono')
          <div class="alert alert-danger">{{ $message }}</div>
          @enderror
            
            
          </div>
          <div class="mb-3  col-6">
            <label for="correo" class="form-label">correo</label>
            <input type="email" required class="form-control" id="correo" placeholder="" name="correo">
            @error('correo')
            <div class="alert alert-danger">{{ $message }}</div>
            @enderror
          
          </div>
          <div class="mb-3 col-6" >
            <label for="direccion" class="form-label">direccion</label>
            <input type="text" required class="form-control" id="direccion" placeholder="" name="direccion">
            @error('direccion')
            <div class="alert alert-danger">{{ $message }}</div>
            @enderror
            
            
          </div>
          <div class="mb-3 col-6" >
            <label for="region" class="form-label">region</label>
            <select  required class="form-control mayuscula" name="region" id="region">
              <option value="">Seleccionar</option>
              @foreach($regiones as $region)

                @if(!empty($idregion)) 

                  @if($region->id == $idregion)
                     <option selected value="{{$region->id}}" {{(old('region')==$region->id)? 'selected':''}}>{{$region->des_region}}</option>
                  @else
                     <option value="{{$region->id}}" {{(old('region')==$region->id)? 'selected':''}}>{{$region->des_region}}</option>

                  @endif
                @else
                     <option value="{{$region->id}}" {{(old('region')==$region->id)? 'selected':''}}>{{$region->des_region}}</option>

                @endif

                 @endforeach
            </select>
          </div>
          <div class="mb-3 col-6" >
            <label for="comuna" class="form-label">comuna</label>
            <select required class="form-control mayuscula" name="comuna" id="comuna">
              <option value="">Seleccionar</option>

                @if(!empty($comunasporregion))

                    @foreach($comunasporregion as $data)

                        @if(!empty($idcomuna ))

                          @if($data->id == $idcomuna)
                               <option selected value="{{$data->id}}" {{(old('comuna')==$data->id)? 'selected':''}}>{{$data->des_comuna}}</option>
                          @else
                                <option value="{{$data->id}}" {{(old('comuna')==$data->id)? 'selected':''}}>{{$data->des_comuna}}</option>

                          @endif
                        @else
                            <option value="{{$data->id}}" {{(old('comuna')==$data->id)? 'selected':''}}>{{$data->des_comuna}}</option>

                        @endif

                    @endforeach
                @endif

            </select>          </div>
          <div class="mb-3 col-6" >
            <label for="observacion" class="form-label">observacion</label>
         <textarea name="observacion" id="" required cols="10" class="form-control" rows="10"></textarea>
         @error('observacion')
         <div class="alert alert-danger">{{ $message }}</div>
         @enderror
          </div>
       </div>
        {{-- -- --}}

        
       
      
<div style="text-align: right">
    <button type="submit"  class="btn btn-danger">Volver</button>

    <button type="submit"  class="btn btn-success">Guardar</button>
</div>
      </form>
 
    
    {{--INICIO FORMULARIO --}}
   

    {{-- FIN FORMULARIO --}}

</div>


<script>
  $(document).ready(function(){
   //traemos las comunas de la region seleccionada
   $("#region").change(function(){
        buscar_comuna($("#region option:selected").val(),"#comuna");
    });

//Validar rut
$("#rut").change(function(){
    //esta funcion (checkRut) se encuentra en funciones.js
      var resultado = checkRut( $("#rut").val());
        if(resultado == "Rut incorrecto"){
            $("#rut").val('');
            $("#rut_span").css("display","")
        }else{
            $("#rut_span").css("display","none")
            validar_rut_cliente($("#rut").val());
        }
    });

    //agregar digito al rut
    $('#rut').on('input', function() {
         $("#rut").val(add_guion_rut($("#rut").val()));
     });
     $('#rut_empresa').on('input', function() {
         $("#rut_empresa").val(add_guion_rut($("#rut_empresa").val()));
     });

  });
// Funciones normales

    //buscar comuna
    function buscar_comuna(id_region, id_comunas, direccion = "") {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            url: "{{ route('buscar_comunas') }}",
            data: { 'id_region': id_region },
            success: function(data) {
              
                $(id_comunas).empty();
                $.each(data, function(id, comuna_nombre_array) {
                $(id_comunas).append('<option value=' + comuna_nombre_array.id + '>' + comuna_nombre_array.des_comuna + '</option>');
                });
            },
            error: function(xhr, status) {
                alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
            }
        });

    }

       //validar rut
       function validar_rut_cliente(rut) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            url: "{{ route('validarrut.clientes') }}",
            data: { 'rut': rut },
            success: function(data) {
               //1 rut existe
               console.log(data);
               if(data == 1){
                     $("#rut").val('');
                     $("#rut_span").css("display","")
                }else{
                    $("#rut_span").css("display","none")
                }
            },
            error: function(xhr, status) {
                alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
            }
        });
    }

</script>

@endsection
