{{-- @extends('layouts.app') --}}
@extends('layouts.sidebar')

@section('content')
<style>
  /* Estilo para el campo readonly */
  input[readonly] {
    background-color: #f0f0f0;
    color: #808080;
    cursor: not-allowed;
  }
</style>
 <!-- content -->
<div class="titulos"> 

  @if(isset($id)) 
  <h2>Editar Servicio</h2>

  @else
  <h2>Nuevo Servicio</h2>

  @endif
    <hr />

</div>

<div class="container">
  @if (session('mensaje'))
  <div class="alert alert-danger">
      {{ session('mensaje') }}
  </div>
@endif
  <form action="{{route('servicios.store')}}" method="POST">  
    @csrf
    
     <div class="row card">
            <div class="card-header">
              Datos Servicio
            </div>
            {{-- datos personales --}}
        <div class="row">
            <div class="mb-3 col-4" >
              <label for="nombre" class="form-label">Nombre</label>
              {{-- <input type="text" required class="form-control" id="nombre" placeholder="" name="nombre" value="{{$getDataServicio[0]->nombre_servicio ?? ''}}"> --}}
              <input type="text" class="form-control" id="nombre" name="nombre" value="{{ old('nombre', isset($getDataServicio[0]->nombre_servicio) ? $getDataServicio[0]->nombre_servicio : '') }}" required>

              @error('nombre')
              <div class="alert alert-danger">{{ $message }}</div>
              @enderror
            </div>
            <div class="mb-3 col-4" >
              <label for="categoria" class="form-label">Categoria</label>
              <select required class="form-control mayuscula" name="categorias" id="categorias">
                <option value="">Seleccionar</option>

                
              @if(!empty($categorias))

              @foreach($categorias as $data)


                    @if(!empty($getDataServicio[0]->categorias_id)) 

                    @if($data->id == $getDataServicio[0]->categorias_id)
                    <option selected value="{{$data->id}}" {{(old('categorias')==$data->id)? 'selected':''}}>{{$data->nombre}}</option>

                    @else
                    <option  value="{{$data->id}}" {{(old('categorias')==$data->id)? 'selected':''}}>{{$data->nombre}}</option>

                    @endif

                    @else
                    <option  value="{{$data->id}}" {{(old('categorias')==$data->id)? 'selected':''}}>{{$data->nombre}}</option>

                    @endif

                   
                 
                  
              @endforeach
          @endif             
        </select>      
         @error('categoria')
              <div class="alert alert-danger">{{ $message }}</div>
              @enderror
            </div>

            <div class="mb-3 col-4" >
              <label for="sku" class="form-label">Sku</label>
              {{-- <input type="text" required class="form-control" id="sku" placeholder="" name="sku" value="{{$getDataServicio[0]->sku ?? ''}}"> --}}
              <input type="text" class="form-control" id="sku" name="sku" value="{{ old('sku', isset($getDataServicio[0]->sku) ? $getDataServicio[0]->sku : '') }}" required>

              @error('sku')
              <div class="alert alert-danger">{{ $message }}</div>
              @enderror
            </div>
          
          
            @if(\App\Models\User::tipoUsuario() == "superadmin" || \App\Models\User::tipoUsuario() == "admin")

                <div class="col-3" >
              
                  <label for="precio_editable" class="form-label">Precio Editable</label><br>
                  {{-- <input type="text" required class="form-control" id="precioneto" placeholder="" name="precioneto" value="{{$getDataServicio[0]->precio_neto ?? ''}}"> --}}
                  {{-- <input type="checkbox" id="precio_editable" name="precio_editable"> --}}


                  @if(!empty($getDataServicio[0]->precio_editable))
                    <input checked type="checkbox" id="precio_editable" name="precio_editable">
                  @else
                  <input type="checkbox" id="precio_editable" name="precio_editable">
                  
                  @endif
                  

                  @error('precio_editable')
                  <div class="alert alert-danger">{{ $message }}</div>
                  @enderror
                </div>
            @endif


            <div class="mb-3 col-3" >
              
              <label for="precio" class="form-label">Precio Neto</label>
              {{-- <input type="text" required class="form-control" id="precioneto" placeholder="" name="precioneto" value="{{$getDataServicio[0]->precio_neto ?? ''}}"> --}}
              <input type="text" class="form-control" id="precioneto" name="precioneto" value="{{ old('precioneto', isset($getDataServicio[0]->precio_neto) ? $getDataServicio[0]->precio_neto : '') }}" required>

              @error('precio')
              <div class="alert alert-danger">{{ $message }}</div>
              @enderror
            </div>
            <div class="mb-3 col-3" >
              
              <label for="precio" class="form-label">Impuesto</label>
              {{-- <input type="text" readonly required class="form-control" id="impuestos" placeholder="" name="impuestos" value="{{$getDataServicio[0]->impuesto ?? ''}}"> --}}
              <input type="text" readonly required class="form-control" id="impuestos" name="impuestos" value="{{ old('impuestos', isset($getDataServicio[0]->impuesto) ? $getDataServicio[0]->impuesto : '') }}">

              @error('precio')
              <div class="alert alert-danger">{{ $message }}</div>
              @enderror
            </div> <div class="mb-3 col-3" >
              
              <label for="precio" class="form-label">Precio Bruto</label>
              {{-- <input type="text" readonly required class="form-control" id="preciobruto" placeholder="" name="preciobruto" value="{{$getDataServicio[0]->precio_bruto ?? ''}}"> --}}
              <input type="text" readonly required class="form-control" id="preciobruto" name="preciobruto" value="{{ old('preciobruto', isset($getDataServicio[0]->precio_bruto) ? $getDataServicio[0]->precio_bruto : '') }}">

              @error('precio')
              <div class="alert alert-danger">{{ $message }}</div>
              @enderror
            </div>
          
            <input type="text" style="display: none" value="{{$id ?? ''}}" name="idservicio">



          
          <!-- <div class="mb-3 col-12" >
            <label for="descripcion" class="form-label">Descripcion</label>
            <textarea name="descripcion" id="" required cols="7" class="form-control" rows="7"></textarea>
            @error('descripcion')
            <div class="alert alert-danger">{{ $message }}</div>
            @enderror            
          </div> -->
         
       
        </div>          {{-- fin del row --}}

      </div>            {{-- fin del card --}}



        

        
        <br>
        
          <div style="text-align: right">
            {{-- <button type="submit"  class="btn btn-danger">Volver</button> --}}

            <button type="submit"  class="btn btn-success">Guardar</button>
          </div>
    
        </form>{{--INICIO FORMULARIO --}}
 
    
    
   

   

</div> {{-- FIN container --}}


<script>
  $(document).ready(function(){
    
    $(document).ready(function() {
      permitirSoloNumeros("#precioneto");
        });
      //traemos las comunas de la region seleccionada
   $("#correo").change(function(){
        validarCorreo();
    });



   //traemos las comunas de la region seleccionada
   $("#region").change(function(){
        buscar_comuna($("#region option:selected").val(),"#comuna");
    });



    // Función para calcular el precio neto
    $("#precioneto").change(function(){

  // Definir el porcentaje de impuestos
  var porcentajeImpuestos = 0.19;
 var valorBruto  = $("#precioneto").val();
  

  // Calcular el precio neto
  var impuestos =  (valorBruto * porcentajeImpuestos);

  $("#impuestos").val(impuestos);
  $("#preciobruto").val(parseInt(impuestos) + parseInt(valorBruto));
  
  
  // Devolver el resultado
  // return precioNeto;
});


//Validar rut
$("#rut").change(function(){
    //esta funcion (checkRut) se encuentra en funciones.js
      var resultado = checkRut( $("#rut").val());
        if(resultado == "Rut incorrecto"){
            $("#rut").val('');
            $("#rut_span").css("display","")
        }else{
            $("#rut_span").css("display","none")
            validar_rut_usuarios($("#rut").val());
        }
    });

    //agregar digito al rut
    $('#rut').on('input', function() {
         $("#rut").val(add_guion_rut($("#rut").val()));
     });
     $('#rut_empresa').on('input', function() {
         $("#rut_empresa").val(add_guion_rut($("#rut_empresa").val()));
     });

  });
// Funciones normales
//validaCorreofunction 
function validarCorreo(){

  var correo = $("#correo").val();
  $.ajax({
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            url: "{{ route('validarcorreo.usuarios') }}",
            data: { 'correo': correo },
            success: function(data) {
               //1 rut existe
               console.log("existecorreouser");
               console.log(data);
               if(data == 1){
                  //   $("#rut").val('');
                    // $("#rut_span").css("display","")
                }else{
                    //$("#rut_span").css("display","none")
                }
            },
            error: function(xhr, status) {
                alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
            }
        });

}
    //buscar comuna
    function buscar_comuna(id_region, id_comunas, direccion = "") {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            url: "{{ route('buscar_comunas') }}",
            data: { 'id_region': id_region },
            success: function(data) {
              
                $(id_comunas).empty();
                $.each(data, function(id, comuna_nombre_array) {
                $(id_comunas).append('<option value=' + comuna_nombre_array.id + '>' + comuna_nombre_array.des_comuna + '</option>');
                });
            },
            error: function(xhr, status) {
                alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
            }
        });

    }

       //validar rut
       function validar_rut_usuarios(rut) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            url: "{{ route('validarrut.usuarios') }}",
            data: { 'rut': rut },
            success: function(data) {
               //1 rut existe
               console.log("existerutuser");
               console.log(data);
               if(data == 1){
                     $("#rut").val('');
                     $("#rut_span").css("display","")
                }else{
                    $("#rut_span").css("display","none")
                }
            },
            error: function(xhr, status) {
                alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
            }
        });
    }

</script>

@endsection
