<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tabla con Filtros</title>
    <!-- Bootstrap CSS -->
    <link href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>

    <!-- Custom CSS -->
    <style>
        body {
            background-color: #f8f9fa;
        }
        
        .container {
            background-color: #fff;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
        }
        
        .table thead th {
            background-color: #343a40;
            color: #fff;
        }
        
        .table-striped tbody tr:nth-of-type(odd) {
            background-color: rgba(0, 0, 0, 0.05);
        }
    </style>
</head>

<body>

    <div class="container mt-4">
        <h2 class="text-center">Tabla con Filtros</h2>
        <div id="resultados"></div>

        <!-- Filtros -->
        <div class="row">
            <div class="col-md-3 col-lg-2 mb-3 mb-lg-0">
                <select class="form-control" id="selectSucursales">
                </select>
            </div>
            <div class="col-md-3 col-lg-2 mb-3 mb-lg-0">
                <input type="date" class="form-control" placeholder="Fecha">
            </div>
            <div class="col-md-3 col-lg-2 mb-3 mb-lg-0">
            <select class="form-control" id="selectMediosPago">
                </select>
            </div>
            <div class="col-md-3 col-lg-2 mb-3 mb-lg-0">
                <select class="form-control">
                    <option value="">Selecciona Tipo de Documento</option>
                    <option value="factura">Factura</option>
                    <option value="boleta">Boleta</option>
                    <!-- Agrega más opciones según sea necesario -->
                </select>
            </div>
            <div class="col-md-3 col-lg-2 mb-3 mb-lg-0">
                <input type="text" class="form-control" placeholder="Cliente">
            </div>
            <div class="col-md-3 col-lg-2">
                <input type="text" class="form-control" placeholder="Rut">
            </div>
        </div>

        <!-- Tabla -->
        <div class="row mt-4">
            <div class="col-md-12">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Sucursal</th>
                                <th>Fecha</th>
                                <th>Medio de Pago</th>
                                <th>Tipo de Documento</th>
                                <th>Cliente</th>
                                <th>Rut</th>
                            </tr>
                        </thead>
                        <tbody>
                            <!-- Aquí puedes agregar filas dinámicamente con JavaScript o PHP -->
                            <tr>
                                <td>Sucursal 1</td>
                                <td>2024-05-16</td>
                                <td>Efectivo</td>
                                <td>Factura</td>
                                <td>Juan Pérez</td>
                                <td>12345678-9</td>
                            </tr>
                            <tr>
                                <td>Sucursal 2</td>
                                <td>2024-05-15</td>
                                <td>Tarjeta de Crédito</td>
                                <td>Boleta</td>
                                <td>María Gómez</td>
                                <td>98765432-1</td>
                            </tr>
                            <!-- Agrega más filas según sea necesario -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>


    <script>
        // Realiza una solicitud GET a tu servicio Node.js
        axios.get('http://localhost:5700')
            .then(function (response) {
                // Si la solicitud es exitosa, muestra los resultados en la página
                // document.getElementById('resultados').innerText = JSON.stringify(response.data);
                console.log(response.data.sucursales);
              const  sucursales = response.data.sucursales;
              const selectSucursales = $('#selectSucursales');

            //   SUUCURSALES
                $.each(sucursales, function(index, sucursal) {
                selectSucursales.append($('<option>', {
                    value: sucursal.id,
                    text: sucursal.descripcion
                }));
               })


            //   MEDIOS DE PAGO
            const  medios_pago = response.data.medios_pago;
            const selectMediosPago = $('#selectMediosPago');

            $.each(medios_pago, function(index, medios_pago) {
                selectMediosPago.append($('<option>', {
                    value: medios_pago.id,
                    text: medios_pago.descripcion
                }));
               })

            })
            .catch(function (error) {
                // Si hay un error, muestra un mensaje de error en la página
                // document.getElementById('resultados').innerText = 'Error al obtener los datos: ' + error.message;
                console.log("ERROR CONSULTA DE DATOS FILTRO");
            });
    </script>

</body>

</html>