const express = require('express');
const mysql = require('mysql2');
// const cors = require('cors'); // Importa el middleware cors

const app = express();

// Habilita CORS para todas las solicitudes
// app.use(cors());

// Crear una conexión a MySQL
function createConnection() {
    return mysql.createConnection({
        host: 'localhost', // Cambia esto según tu configuración
        user: 'systemnebiolo', // Cambia esto según tu configuración
        password: 'Tn9YeBuQFQJdsps', // Cambia esto según tu configuración
        database: "system_nebiolo"
    });
}

// Ruta para cargar ventas agrupadas según el parámetro de sucursal
app.get('/estadosordenesot/:sucursal/:fechas', (req, res) => {
    const sucursal = atob(req.params.sucursal);
    var fechas = atob(req.params.fechas);


    // Crea una conexión a la base de datos
    const connection = createConnection();

    // Consulta SQL base

    let sqlTemplate = `
    SELECT
    estado.descripcion AS estado_orden_trabajo,
    ROUND(SUM(ordenes_trabajos.total_con_descuentos), 0) AS total_con_descuentos_total,

    COUNT(*) AS cantidad_ordenes
            FROM ordenes_trabajos
            INNER JOIN estado_orden_trabajo estado ON ordenes_trabajos.estado_orden_trabajo_id = estado.id
          where
          ordenes_trabajos.historial_ot  = 'activo'
    `;

    const conditions = [];
    const params = [];



    if (fechas !== 'sinvalor') {
        let [fechaInicio, fechaFin] = fechas.split(' - ').map(date => {
            const [day, month, year] = date.split('-');
            return `${year}-${month}-${day}`;
        });

        // Ajustar el formato de las fechas para que coincida con el de la base de datos
        fechaInicio += " 00:00:00";
        fechaFin += " 23:59:59";

        // Agregar la condición para el rango de fechas
        conditions.push("ordenes_trabajos.fecha_ingreso BETWEEN ? AND ?");
        params.push(fechaInicio);
        params.push(fechaFin);
    }


    if (sucursal !== 'sinvalor') {
        conditions.push("ordenes_trabajos.sucursales_id = ?");
        params.push(sucursal);
    }





    // Agregar las condiciones a la consulta base
    if (conditions.length > 0) {
        sqlTemplate += " AND " + conditions.join(" AND ");
    }

    sqlTemplate += " GROUP BY estado.descripcion";

    sqlTemplate += " ORDER BY ";
    sqlTemplate += "    CASE estado.descripcion";
    sqlTemplate += "        WHEN 'RECEPCIONADA' THEN 1";
    sqlTemplate += "        WHEN 'INICIADA' THEN 2";
    sqlTemplate += "        WHEN 'CANCELADA' THEN 3";
    sqlTemplate += "        WHEN 'FINALIZADA' THEN 4";
    sqlTemplate += "        WHEN 'FACTURADA' THEN 5";
    sqlTemplate += "        ELSE 6"; // Para cualquier otro caso no especificado
    sqlTemplate += "    END"
        // Imprime la consulta en la consola
        // console.log('Consulta SQL:', mysql.format(sqlTemplate, params));

    // Ejecuta la consulta SQL
    connection.query(sqlTemplate, params, (error, results, fields) => {
        // Cierra la conexión a la base de datos
        connection.end();

        // Si hay un error, envía un mensaje de error al cliente
        if (error) {
            return res.status(500).json({ error: 'Error al recuperar las sucursales.', details: error });
        }

        // Si no hay resultados, envía un mensaje al cliente indicando que no se encontraron sucursales
        if (!results.length) {
            return res.status(404).json({ message: 'No se encontraron sucursales.', query: sqlTemplate });
        }

        // Si hay resultados, envía los datos de las sucursales al cliente
        // res.status(200).json({ dataOt: results, query: sqlTemplate });
        res.status(200).json({ dataOt: results });

    });
});


// Escucha en el puerto 5800
const PORT = process.env.PORT || 5905;
app.listen(PORT, () => {
    console.log(`Servidor escuchando en el puerto ${PORT}`);
});