<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class clientes extends Model
{
    use HasFactory;


    public static function todosLosClientes()
    {
       
        
        $data = clientes::select("comunas.des_comuna","regions.des_region","clientes.id as id_cliente","clientes.razon_social","clientes.rut","clientes.telefono","clientes.correo","direcciones.nombre as nombre_direccion")
        ->join("direcciones","direcciones.id","=","clientes.direcciones_id")
        ->join("comunas","comunas.id","=","direcciones.comunas_id")
       ->join("regions","regions.id","=","comunas.id_region")->limit(150)->get();
        return $data;
    } 
    public static function datosDelCliente($idCliente = "")
    {
        
        
        $data = clientes::select("comunas.des_comuna","regions.des_region","clientes.id as id_cliente","clientes.razon_social","clientes.rut","clientes.telefono","clientes.correo","direcciones.nombre as nombre_direccion")
        ->join("direcciones","direcciones.id","=","clientes.direcciones_id")
        ->join("comunas","comunas.id","=","direcciones.comunas_id")
       ->join("regions","regions.id","=","comunas.id_region")
       ->where("clientes.id","=",$idCliente)->get();
        return $data;
    } 

    public static function validarRutCliente($rut)
    {
       
        
        $rutexiste = clientes::where("rut","=",$rut)->exists();
        return $rutexiste;
    }

    public static function validarCorreoCliente($correo)
    {
        $correoexiste = clientes::where("correo","=",$correo)->exists();
        return $correoexiste;
    }
}
