<?php

namespace App\Http\Controllers\Ordendetrabajo;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Crypt;
use App\Models\clientes;
use App\Models\servicios;
use App\Models\ordenes_trabajos;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\repuestos;
use App\Models\medios_pagos;
use App\Models\pagos;
use App\Models\repuestos_solicitados;
use App\Models\servicios_ordenes;
use DB;
use App\Models\ejecutar_servicios;
use App\Models\historial_ot_servicios;
use App\Models\equipos;
use App\Models\combustibles;
use Redirect;
use App\Models\regions;
use App\Models\comunas;
use App\Models\direcciones;
use App\Models\chofer_equipos;
use App\Models\cliente_equipos;



use App\Models\tecnicos;






class ordendetrabajoController extends Controller
{
    /** 
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    { 
        $ordenesdetrabajo = ordenes_trabajos::OrdenesAll();

        return view('ordenesdetrabajo/ordenesdetrabajo',compact("ordenesdetrabajo"));
    }

    public function iniciar(Request $request){ 

        $ordenes_trabajos =  ordenes_trabajos::where('id', $request->idot)->firstOrFail();
        $ordenes_trabajos->estado_orden_trabajo_id = 2; //procesando
        $ordenes_trabajos->timestamps = false;
        $ordenes_trabajos->save();
        return redirect::back()->with('mensaje', 'Ot Iniciada!');

}



public function crearsincliente(){ 

    $servicios =   servicios::todosLosServicios();

    $clientes =   clientes::select("clientes.*","clientes.id as id_cliente","direcciones.nombre as nombre_direccion","comunas_id","regions.id as idregion")
    ->join("direcciones","direcciones.id","=","clientes.direcciones_id")
    ->join("regions","regions.id","=","direcciones.comunas_id")
    ->get();
    ;
    $operarios =   User::datosOperarios();
    $datosChofer =   User::datosChofer();

    $regiones =          regions::orderBy('des_region', 'asc')->get();
 
    $comunasporregion  =  comunas::orderBy('des_comuna', 'asc')->get();
    $repuestos =   repuestos::all();
    $medios_pagos =   medios_pagos::all();
    $equipos= equipos::all();

    $combustibles = combustibles::all();


    return view('ordenesdetrabajo/nuevaOt',compact("comunasporregion","regiones","datosChofer","combustibles","equipos","medios_pagos","clientes",'servicios','operarios','repuestos'));

    
}
public function finalizar(Request $request){ 

    $ordenes_trabajos =  ordenes_trabajos::where('id', $request->idot)->firstOrFail();
    $ordenes_trabajos->estado_orden_trabajo_id = 3; //finalizado
    $ordenes_trabajos->timestamps = false;
    $ordenes_trabajos->save();
    return redirect::back()->with('mensaje', 'Ot Iniciada!');

}
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($idCliente)
    {

        

        try {
            $idCliente = Crypt::decryptString($idCliente);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }
  
        $servicios =   servicios::todosLosServicios();

        $cliente =   clientes::datosDelCliente($idCliente);
        $operarios =   User::datosOperarios();
        $repuestos =   repuestos::all();
        $medios_pagos =   medios_pagos::all();
        $equipos = equipos::select("equipos.*")
        ->join("cliente_equipos","cliente_equipos.equipos_id","=","equipos.id")
        ->where("cliente_equipos.clientes_id","=",$idCliente)->get();
        $combustibles = combustibles::all();

        return view('ordenesdetrabajo/createandedit',compact("combustibles","equipos","medios_pagos","idCliente","cliente",'servicios','operarios','repuestos'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */


     public function manualstore(Request $req){

    //  return $req;

        // {"_token":"YD1lqenG7MB6SkqCAoXIsBodOyS3TONcayAsAyq1"
        //     ,"equipo_modelo":"dasd"
        //     ,"equipo_patente":"fddaa"
        //     ,"equipo_marca":"dasd"
        //     ,"equipo_motor":"asd"
        //     ,"equipo_ano":"asd"
        //     ,"equipo_serie":"asd"
        //     ,"combustible":"2"
        //     ,"choferselect":null
        //     ,"operario":"7"
        //     ,"fecha_entrega":"2023-10-14"
        //     ,"comentario":null
        //     ,"arrayDatosTabla":"[{\"id\":3,\"nombre_servicio\":\"a\",\"descripcion\":\"dsfsdfsdf\",\"sku\":\"34534534\",\"precio_neto\":500,\"impuesto\":19,\"eliminado\":0,\"estado\":\"0\",\"categorias_id\":2,\"cantidad\":2,\"total\":1000}]"
        //     ,"arrayDatosTablaRepuestos":"[{\"id\":2,\"nombre\":\"metal biela\",\"categoria\":\"Ciguenal\",\"eliminado\":\"0\",\"cantidad\":1},{\"id\":5,\"nombre\":\"metales de leva\",\"categoria\":\"Block\",\"eliminado\":\"0\",\"cantidad\":1}]"
        //     "input_abono":"0"
        //     "input_descuento":"0"
        //     ,"input_metodopago":null
        //     ,"cliente_razon_social":"ariel"
        //     ,"cliente_rut":"18795022-8"
        //     ,"cliente_giro":"alj"
        //     ,"cliente_telefono":"454344"
        //     ,"cliente_correo":"valn.slim@gmail.com"
        //     ,"cliente_direccion":"talca"
        //     ,"region":"5"
        //     ,"comuna":"5"}

        $idClientes = "";

        if ($req->has('id_cliente') && $req->id_cliente !== null) {
           $idClientes =$req->id_cliente;
        } else {
            $dataDirecciones=[
                // 'name' => $data['name'],
                'nombre' => $req->cliente_direccion,
                'estado' => 0,
                'regions_id' => $req->region,
                'tipo' => "cliente",
                'comuna'=>$req->comuna
                
            ];

            $insertDirecciones=  direcciones::crearDireccion($dataDirecciones);
            

            $clientes = new clientes;
            $clientes->razon_social	 = $req->cliente_razon_social;
            $clientes->rut	  = $req->cliente_rut;
            $clientes->giro	  = $req->cliente_giro;
            $clientes->telefono	  = $req->cliente_telefono;
            $clientes->correo	  = $req->cliente_correo;
            $clientes->sucursales_id	  = 1;
            $clientes->eliminado	  = 0;
            $clientes->direcciones_id	  = $insertDirecciones;
            $clientes->timestamps = false;
            $clientes->save();


            $idClientes =$clientes->id;

        }


        // return  "idClientes:".$idClientes; 
        //fin del else

        // equipos_id
        $dataEquipo  = "";
        $dataEquipo = equipos::where('patente', $req->equipo_patente)
        ->orWhere('serie', $req->equipo_serie)
        ->first();

        if ($dataEquipo) {
            $dataEquipo->modelo = $req->equipo_modelo;
            $dataEquipo->marca = $req->equipo_marca;
            $dataEquipo->motor = $req->equipo_motor;
            $dataEquipo->ano = $req->equipo_ano;
            $dataEquipo->serie = $req->equipo_serie;
            $dataEquipo->combustible_id = $req->combustible;
            $dataEquipo->patente	  =$req->equipo_patente;
            $dataEquipo->timestamps = false;
            // $dataEquipo->clientes_id = $idClientes;        
            $dataEquipo->save();
            $idEquipo = $dataEquipo->id;
            // La patente o serie existe en la tabla 'equipos'.
            //CREAR SI NO EXISTE
            

            $registroExistente = cliente_equipos::where('equipos_id', $dataEquipo->id)
                ->where('clientes_id', $idClientes)
                ->first();

            if ($registroExistente) {
             
            } else {
                // No se encontró un registro existente con las mismas referencias, puedes proceder a insertar un nuevo registro.
                $cliente_equipos = new cliente_equipos;
                $cliente_equipos->equipos_id = $dataEquipo->id;
                $cliente_equipos->clientes_id = $idClientes;
                $cliente_equipos->timestamps = false;
                $cliente_equipos->save();

                // Realiza las acciones adicionales que necesites.
            }
        } else {
            // La patente o serie no se encuentra en la tabla 'equipos'.
            $equipos_ = new equipos;
            $equipos_->descripcion	  ="";
            $equipos_->modelo	  =$req->equipo_modelo;
            $equipos_->marca	   =$req->equipo_marca;
            $equipos_->motor	  =$req->equipo_motor;
            $equipos_->ano	   =$req->equipo_ano;
            $equipos_->serie	   =$req->equipo_serie;;;
            $equipos_->combustible_id	  =$req->combustible;
            $equipos_->patente	  =$req->equipo_patente;

            // $equipos_->clientes_id	  =$idClientes;
            $equipos_->timestamps = false;
            $equipos_->save();

            $idEquipo = $equipos_->id;

            $cliente_equipos = new cliente_equipos;
            $cliente_equipos->equipos_id	  =$equipos_->id;
            $cliente_equipos->clientes_id	  =$idClientes;
            $cliente_equipos->timestamps = false;
            $cliente_equipos->save();
            
        }

            //datos de la ot
              
             $user = Auth::user();
             $dataPrecios= $this->cacularPrecios($req->arrayDatosTabla);
             $fechaActualSinFormato = Carbon::now();
             $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');
             $descuento = ($dataPrecios["neto"] * $req->input_descuento) / 100;

             $ordenes_trabajos = new ordenes_trabajos;            
             $ordenes_trabajos->responsable	  =$req->responsable;
             $ordenes_trabajos->fecha_ingreso	  =$fechaActual;
             $ordenes_trabajos->fecha_entrega	  =$req->fecha_entrega;
             $ordenes_trabajos->eliminado	  =0;
             $ordenes_trabajos->abono	  =$req->input_abono; //falta
             $ordenes_trabajos->neto	  =$dataPrecios["neto"];;
             $ordenes_trabajos->iva	  =$dataPrecios["iva"];;
             $ordenes_trabajos->total	  =$dataPrecios["total"];;
             $ordenes_trabajos->descuento_pesos	  =$descuento;
             $ordenes_trabajos->descuento_porcentaje	  =$req->input_descuento;
             $ordenes_trabajos->observacion	  =$req->comentario;
             $ordenes_trabajos->fecha_creacion_registro	  =$fechaActual;
             $ordenes_trabajos->clientes_id	  =$idClientes; //falta
             $ordenes_trabajos->estado_orden_trabajo_id	  =1; //Ingresada
             $ordenes_trabajos->sucursales_id	  =$user->sucursales_id;
             $ordenes_trabajos->users_registra_id	  =$user->id;
             $ordenes_trabajos->operario_id	  =$req->operario;
             $ordenes_trabajos->equipos_id	  =$idEquipo; //falta       
              $ordenes_trabajos->timestamps = false;
             $ordenes_trabajos->save();

         
             if($req->choferselect != null){
                
                $chofer_equipos = new chofer_equipos;
                $chofer_equipos->ordenes_trabajos_id  =$ordenes_trabajos->id;
                $chofer_equipos->users_id   = $req->choferselect;
                $chofer_equipos->fecha  =$fechaActual;
                $chofer_equipos->timestamps = false;
                $chofer_equipos->save();
             }
             $pagos = new pagos;
             $pagos->fecha		  =$fechaActual;
             $pagos->motivo		  ="abono";
             $pagos->total		  =$req->input_abono;
             $pagos->ordenes_trabajos_id	  =$ordenes_trabajos->id;
             if($req->input_abono == 0){
                 $pagos->medios_pagos_id  =1; //como es cero, lo dejamos como que pagaron con efectivo
     
             }else{
                 $pagos->medios_pagos_id  =$req->input_metodopago;
     
             }
             $pagos->timestamps = false;
             $pagos->save();
      



       $repuestos = json_decode($req->arrayDatosTablaRepuestos, true);

       // Verificar si el arreglo está vacío o contiene datos
       if (empty($repuestos)) {
       } else {
           // echo "ID: " . $repuesto['id'] . "<br>";
          
           // Recorrer el arreglo de repuestos
           foreach ($repuestos as $repuesto) {

               $repuestos_solicitados = new repuestos_solicitados;
               $repuestos_solicitados->recibido		  ="no";
               $repuestos_solicitados->repuestos_id		  =$repuesto['id'];
               $repuestos_solicitados->cantidad		  =$repuesto['cantidad'];
               // $repuestos_solicitados->fecha_recibida	  =$ordenes_trabajos->id;
               $repuestos_solicitados->fecha_solicitada	  =$fechaActual;
               $repuestos_solicitados->comentario = "";
               $repuestos_solicitados->ordenes_trabajos_id =$ordenes_trabajos->id;
               $repuestos_solicitados->timestamps = false;
               $repuestos_solicitados->save();
              
           }
       }
       



       $servicios = json_decode($req->arrayDatosTabla, true);

       // Verificar si el arreglo está vacío o contiene datos
       if (empty($servicios)) {
       } else {
           // echo "ID: " . $repuesto['id'] . "<br>";
          
           // Recorrer el arreglo de servicios
           foreach ($servicios as $servicio) {

               $servicios_ordenes = new servicios_ordenes;
               $servicios_ordenes->servicios_id		  =$servicio['id'];
               $servicios_ordenes->cantidad		  =$servicio['cantidad'];
               $servicios_ordenes->fecha_solicitado	  =$fechaActual;
               $servicios_ordenes->ordentes_trabajos_id =$ordenes_trabajos->id;
               $servicios_ordenes->finalizado ="no";
               $servicios_ordenes->timestamps = false;
               $servicios_ordenes->save();


               
               $ejecutar_servicios = new ejecutar_servicios;
               $ejecutar_servicios->descripcion		  ="solicitud ingresada";
               $ejecutar_servicios->estado		  =0;
               $ejecutar_servicios->servicios_ordenes_id	  =$servicios_ordenes->id;
               $ejecutar_servicios->tecnicos_id =1; //lo agregamos a un tecnico invisble
               $ejecutar_servicios->fecha_ingreso	  =$fechaActual;
               
               // $ejecutar_servicios->fecha_ejecucion ="no";
               // $ejecutar_servicios->fecha_finalzado ="no";
               $ejecutar_servicios->estado_ejecucion_id =1; // ingresada

               
               $ejecutar_servicios->timestamps = false;
               $ejecutar_servicios->save();


               $historial_ot_servicios = new historial_ot_servicios;
               $historial_ot_servicios->fecha_ingresado =  $fechaActual;
               $historial_ot_servicios->descripcion ="solicitud ingresada";
               $historial_ot_servicios->servicios_ordenes_id  =$servicios_ordenes->id;
           
               $historial_ot_servicios->timestamps = false;
               $historial_ot_servicios->save();
           }
       }

       return redirect()->route('ordendetrabajo')->with('mensaje', 'Operación exitosa!');

     }

    public function store(Request $request)
    {
        // return  $request;
        return DB::transaction(function () use ($request) {

        
        $user = Auth::user();

//    return $request->arrayDatosTabla;
    
        $dataPrecios= $this->cacularPrecios($request->arrayDatosTabla);


    
        $fechaActualSinFormato = Carbon::now();
        
        $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');
        $descuento = ($dataPrecios["neto"] * $request->input_descuento) / 100;


        $ordenes_trabajos = new ordenes_trabajos;
        $ordenes_trabajos->fecha_ingreso	  =$fechaActual;
        $ordenes_trabajos->fecha_entrega	  =$request->fecha_entrega;
        $ordenes_trabajos->eliminado	  =0;
        $ordenes_trabajos->abono	  =$request->input_abono;
        $ordenes_trabajos->neto	  =$dataPrecios["neto"];;
        $ordenes_trabajos->iva	  =$dataPrecios["iva"];;
        $ordenes_trabajos->total	  =$dataPrecios["total"];;
        $ordenes_trabajos->descuento_pesos	  =$descuento;
        $ordenes_trabajos->descuento_porcentaje	  =$request->input_descuento;
        $ordenes_trabajos->observacion	  =$request->comentario;
        $ordenes_trabajos->fecha_creacion_registro	  ==$fechaActual;
        $ordenes_trabajos->clientes_id	  =$request->id_cliente;
        $ordenes_trabajos->estado_orden_trabajo_id	  =1; //Ingresada
        $ordenes_trabajos->sucursales_id	  =$user->sucursales_id;
        $ordenes_trabajos->users_registra_id	  =$user->id;
        $ordenes_trabajos->operario_id	  =$request->operario;
        $ordenes_trabajos->equipos_id	  =$request->seleccionaequipo;       
         $ordenes_trabajos->timestamps = false;
        $ordenes_trabajos->save();


        $pagos = new pagos;
        $pagos->fecha		  =$fechaActual;
        $pagos->motivo		  ="abono";
        $pagos->total		  =$request->input_abono;
        $pagos->ordenes_trabajos_id	  =$ordenes_trabajos->id;
        if($request->input_abono == 0){
            $pagos->medios_pagos_id  =1; //como es cero, lo dejamos como que pagaron con efectivo

        }else{
            $pagos->medios_pagos_id  =$request->input_metodopago;

        }
        // $pagos->medios_pagos_id  =$request->input_metodopago;
        $pagos->timestamps = false;
       $pagos->save();



       $repuestos = json_decode($request->arrayDatosTablaRepuestos, true);

            // Verificar si el arreglo está vacío o contiene datos
            if (empty($repuestos)) {
            } else {
                // echo "ID: " . $repuesto['id'] . "<br>";
               
                // Recorrer el arreglo de repuestos
                foreach ($repuestos as $repuesto) {

                    $repuestos_solicitados = new repuestos_solicitados;
                    $repuestos_solicitados->recibido		  ="no";
                    $repuestos_solicitados->repuestos_id		  =$repuesto['id'];
                    $repuestos_solicitados->cantidad		  =$repuesto['cantidad'];
                    // $repuestos_solicitados->fecha_recibida	  =$ordenes_trabajos->id;
                    $repuestos_solicitados->fecha_solicitada	  =$fechaActual;
                    $repuestos_solicitados->comentario = "";
                    $repuestos_solicitados->ordenes_trabajos_id =$ordenes_trabajos->id;
                    $repuestos_solicitados->timestamps = false;
                    $repuestos_solicitados->save();
                   
                }
            }
            



            $servicios = json_decode($request->arrayDatosTabla, true);

            // Verificar si el arreglo está vacío o contiene datos
            if (empty($servicios)) {
            } else {
                // echo "ID: " . $repuesto['id'] . "<br>";
               
                // Recorrer el arreglo de servicios
                foreach ($servicios as $servicio) {

                    $servicios_ordenes = new servicios_ordenes;
                    $servicios_ordenes->servicios_id		  =$servicio['id'];
                    $servicios_ordenes->cantidad		  =$servicio['cantidad'];
                    $servicios_ordenes->fecha_solicitado	  =$fechaActual;
                    $servicios_ordenes->ordentes_trabajos_id =$ordenes_trabajos->id;
                    $servicios_ordenes->finalizado ="no";

                    $servicios_ordenes->timestamps = false;
                    $servicios_ordenes->save();


                    
                    $ejecutar_servicios = new ejecutar_servicios;
                    $ejecutar_servicios->descripcion		  ="solicitud ingresada";
                    $ejecutar_servicios->estado		  =0;
                    $ejecutar_servicios->servicios_ordenes_id	  =$servicios_ordenes->id;
                    $ejecutar_servicios->tecnicos_id =1; //lo agregamos a un tecnico invisble
                    $ejecutar_servicios->fecha_ingreso	  =$fechaActual;
                    
                    // $ejecutar_servicios->fecha_ejecucion ="no";
                    // $ejecutar_servicios->fecha_finalzado ="no";
                    $ejecutar_servicios->estado_ejecucion_id =1; // ingresada

                    
                    $ejecutar_servicios->timestamps = false;
                    $ejecutar_servicios->save();


                    $historial_ot_servicios = new historial_ot_servicios;
                    $historial_ot_servicios->fecha_ingresado =  $fechaActual;
                    $historial_ot_servicios->descripcion ="solicitud ingresada";
                    $historial_ot_servicios->servicios_ordenes_id  =$servicios_ordenes->id;
                
                    $historial_ot_servicios->timestamps = false;
                    $historial_ot_servicios->save();
                }
            }

            
            return redirect()->route('ordendetrabajo')->with('mensaje', 'Operación exitosa!');

       
        }, 5);
// return $ordenes_trabajos;




        // $ordenes_trabajos->comunas_id	 =$request->comuna;
        // $ordenes_trabajos->tipo	  = "usuario";
        // $ordenes_trabajos->timestamps = false;
        // $ordenes_trabajos->save();
        // return $request->arrayDatosTabla;
       



        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */


     public function cacularPrecios($servicios){


        $data = json_decode($servicios, true);
         $total =   0; 
         $neto =   0; 


// Verificar si la decodificación fue exitosa
if ($data !== null) {
    // Recorrer el arreglo
    foreach ($data as $item) {
    
       // echo "Precio neto: " . $item['precio_neto'] . "<br>";
       // echo "Cantidad: " . $item['cantidad'] . "<br>";
        //echo "Total: " . $item['total'] . "<br>";
        $total = $total + $item['total'];
        $neto = $neto + ( $item['precio_neto'] * $item['cantidad']);

    }
} else {
    echo "Error al decodificar JSON.";
}

        return [
            'total'=> $total,
            'neto'=> $neto,
            'iva'=> 0,
        ];
     }

    public function show($id)
    {

        $servicios =   servicios::todosLosServicios();
        $numeroOt = $id; 
        $ordenes_trabajos = ordenes_trabajos::OrdenesShow($id);
        $datosdelequipo = ordenes_trabajos::datosdelequipo($id);

        // $cliente =   clientes::datosDelCliente($idCliente);
        $operarios =   User::datosOperarios();
        $repuestos =   repuestos::all();
        $medios_pagos =   medios_pagos::all();

        $servicios_ordenes = servicios_ordenes::showOrdenesServicios($id);
        $tecnicos = User::datosTecnicoUserAll();

         $repuestos_solicitados = repuestos_solicitados::showOrdenesRepuestos($id);



        return view('ordenesdetrabajo/showot',compact("datosdelequipo","repuestos_solicitados","tecnicos","servicios_ordenes","numeroOt","ordenes_trabajos","medios_pagos",'servicios','operarios','repuestos'));

        
        return  $id;
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
