<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
  use App\Models\estado_orden_trabajo;
use Carbon\Carbon;

use DB;
class ordenes_trabajos extends Model
{
    use HasFactory;

    public static function getStadosOt()
    {
        return estado_orden_trabajo::where("acortado","!=","solrep")
        // ->orderByDesc('descripcion')
        ->orderBy('descripcion', 'asc')

        
        ->get();
    }


    public static function datosdelequipo($data)
    {
        return   $data = ordenes_trabajos::select(
         "equipos.*",
         "ordenes_trabajos.responsable",
         "combustibles.nombre as nombrecombustible",
         "ordenes_trabajos.pendiente",
         "ordenes_trabajos.abono",
         "ordenes_trabajos.total"
        
        )
        ->join("equipos","equipos.id","=","ordenes_trabajos.equipos_id")
        ->join("combustibles","combustibles.id","=","equipos.combustible_id")

        ->where("ordenes_trabajos.id","=",$data)
      
           
            ->get();

    }

    public static function ObtenerNumeroOt($idOt)
    {
           $data = ordenes_trabajos::select(
            "ordenes_trabajos.numero_ot")   
           ->where("ordenes_trabajos.id","=",$idOt)             
            ->get();

            return $data[0]->numero_ot;

     }
   
    public static function OrdenesAllPorNOt($numeroOt)
    {


         $data = ordenes_trabajos::select(
            "estado_orden_trabajo.descripcion as descripcionestado",
         DB::raw("CONCAT(personas.nombre, ' ', personas.apellido) as nombre_completo"),
         "clientes.rut",
         "clientes.razon_social",
         "ordenes_trabajos.id"
         ,"ordenes_trabajos.fecha_ingreso"
         ,"ordenes_trabajos.numero_ot"

         ,"ordenes_trabajos.fecha_entrega")
        ->join("clientes","clientes.id","=","ordenes_trabajos.clientes_id")
        ->join("users","users.id","=","ordenes_trabajos.operario_id")
        ->join("personas","personas.id","=","users.personas_id")
        ->join("estado_orden_trabajo","estado_orden_trabajo.id","=","ordenes_trabajos.estado_orden_trabajo_id")
        ->orderByDesc('ordenes_trabajos.id')
        ->where("ordenes_trabajos.numero_ot","=",$numeroOt)
        ->where("ordenes_trabajos.eliminado","=",0)

            ->get();
  
        return $data;

    }

    public static function ordenexportar($fecha_inicio,$fecha_fin,$sucursal,$estados)
    {

        $tipoUsuario = User::tipoUsuario();



        $getData = ordenes_trabajos::select(
           "estado_orden_trabajo.descripcion as descripcionestado",
        DB::raw("CONCAT(personas.nombre, ' ', personas.apellido) as nombre_completo"),
        
        "equipos.modelo",
        "equipos.marca",
        "equipos.motor",
        "equipos.modelo",
        "equipos.ano",
        "equipos.serie",
        "combustibles.nombre as nombre_combustible",
        "ordenes_trabajos.total",
        "ordenes_trabajos.descuento_pesos",
        "ordenes_trabajos.total_con_descuentos",
        "ordenes_trabajos.iva",
        "ordenes_trabajos.sub_total",
        
        

        

        "clientes.rut",
        "clientes.razon_social",
        "ordenes_trabajos.id"
        ,"ordenes_trabajos.fecha_ingreso"
        ,"ordenes_trabajos.numero_ot",
        DB::raw("(SELECT descripcion FROM sucursales WHERE id = ordenes_trabajos.sucursales_id) as nombre_sucursal")

        ,"ordenes_trabajos.fecha_entrega")
       ->join("clientes","clientes.id","=","ordenes_trabajos.clientes_id")
       ->join("users","users.id","=","ordenes_trabajos.operario_id")
       ->join("personas","personas.id","=","users.personas_id")
       ->join("equipos","equipos.id","=","ordenes_trabajos.equipos_id")
       ->join("combustibles","combustibles.id","=","equipos.combustible_id")


       ->join("estado_orden_trabajo","estado_orden_trabajo.id","=","ordenes_trabajos.estado_orden_trabajo_id")
       
       ->orderByDesc('ordenes_trabajos.numero_ot')
       ->where("ordenes_trabajos.eliminado","=",0)

       ->where("ordenes_trabajos.historial_ot","=",'activo');

       if (isset($estados) && $estados !="undefined") {

        
       if($estados != null){
        $getData->where("ordenes_trabajos.estado_orden_trabajo_id","=",$estados );
            }
       }



       if (isset($sucursal) && $sucursal !="undefined") {

        
        if($sucursal != null){
         $getData->where("ordenes_trabajos.sucursales_id","=",$sucursal );
             }
        }
 


            if($fecha_inicio == null || $fecha_fin == null){

            // Obtener la fecha actual
            $fechaActual = Carbon::now();

            // Retroceder un año desde la fecha actual
            $fechaInicio = $fechaActual->copy()->subYear()->startOfYear(); // Inicio del año pasado
            $fechaFin = $fechaActual->copy()->endOfYear(); // Fin del año pasado

        }else{

            $fechaInicio = Carbon::createFromFormat('Y-m-d H:i:s', $fecha_inicio . " 00:00:00");
            $fechaFin = Carbon::createFromFormat('Y-m-d H:i:s', $fecha_fin . " 23:59:59");
            
        }
            

            // Aplicar los filtros
            $getData->where("fecha_ingreso", ">=", $fechaInicio->toDateTimeString());
            $getData->where("fecha_ingreso", "<=", $fechaFin->toDateTimeString());

       return $getData->get();;

    }

    public static function OrdenesAll($status = null, $buscar = null,$idcliente= null,$datafiltro="")
    {

        
           $tipoUsuario = User::tipoUsuario();



         $getData = ordenes_trabajos::select(
            "estado_orden_trabajo.descripcion as descripcionestado",
         DB::raw("CONCAT(personas.nombre, ' ', personas.apellido) as nombre_completo"),
         
         "equipos.modelo",
         "equipos.marca",
         "equipos.motor",
         "equipos.ano",
         "equipos.serie",
         "combustibles.nombre as nombre_combustible",


         

         "clientes.rut",
         "clientes.razon_social",
         "ordenes_trabajos.id"
         ,"ordenes_trabajos.fecha_ingreso"
         ,"ordenes_trabajos.numero_ot"
         ,"ordenes_trabajos.total_con_descuentos",

         DB::raw("(SELECT descripcion FROM sucursales WHERE id = ordenes_trabajos.sucursales_id) as nombre_sucursal")

         ,"ordenes_trabajos.fecha_entrega")
        ->join("clientes","clientes.id","=","ordenes_trabajos.clientes_id")
        ->join("users","users.id","=","ordenes_trabajos.operario_id")
        ->join("personas","personas.id","=","users.personas_id")
        ->join("equipos","equipos.id","=","ordenes_trabajos.equipos_id")
        ->join("combustibles","combustibles.id","=","equipos.combustible_id")


        ->join("estado_orden_trabajo","estado_orden_trabajo.id","=","ordenes_trabajos.estado_orden_trabajo_id")
        
        ->orderByDesc('ordenes_trabajos.numero_ot')
        ->where("ordenes_trabajos.eliminado","=",0)

        ->where("ordenes_trabajos.historial_ot","=",'activo');


        // return $datafiltro;
        if($datafiltro != ""){

            if($datafiltro->sucursales != null){
                $getData->where("ordenes_trabajos.sucursales_id","=",$datafiltro->sucursales );

            }

            if($datafiltro->estados != null){
                $getData->where("ordenes_trabajos.estado_orden_trabajo_id","=",$datafiltro->estados );

            }

            if ($datafiltro->fecha_inicio != null && $datafiltro->fecha_fin != null) {
                // $getData->whereBetween("ordenes_trabajos.fecha_ingreso", [$datafiltro->fecha_inicio, $datafiltro->fecha_fin]);
                 $getData->where("fecha_ingreso",">=",$datafiltro->fecha_inicio." 00:00:00");
                 $getData->where("fecha_ingreso","<=",$datafiltro->fecha_fin." 23:59:59");


            }

        }

        
        if($status == "CLIENTES"){

            $getData->where("clientes.id","=",$idcliente);

        }

        if($status == "REPUESTOS"){

            $getData->join("ordenesmasrepuestos","ordenesmasrepuestos.ordenes_trabajos_id","=","ordenes_trabajos.id")
            ->join("repuestos_solicitados","repuestos_solicitados.id","=","ordenesmasrepuestos.repuestos_solicitados_id")
           ->where("repuestos_solicitados.recibido","=","no")
         ->where("ordenes_trabajos.estado_orden_trabajo_id","!=",3) //no muestra las finalizadadas
        //  ->groupBy('ordenes_trabajos.numero_ot');
          ->distinct();
        }

        


        if($status != null &&  $status != "REPUESTOS" &&  $status != "CLIENTES" ){

            if($status == "DISTINCT"){
                $getData->where("estado_orden_trabajo.descripcion","!=","FINALIZADA");

            }else{
                $getData->where("estado_orden_trabajo.descripcion","=",$status);

            }
           

        }

       

        if ($buscar != null) {
            $getData->where(function ($query) use ($buscar) {
                $query->where("clientes.razon_social", "LIKE", "%{$buscar}%")
                    //   ->orWhere("clientes.rut", "LIKE", "%{$buscar}%")
                      ->orWhere("ordenes_trabajos.numero_ot", "LIKE", "%{$buscar}%")
                      ->orWhere("equipos.motor", "LIKE", "%{$buscar}%")
                      ->orWhere("equipos.serie", "LIKE", "%{$buscar}%")
                      ->orWhere("equipos.marca", "LIKE", "%{$buscar}%")
                      ->orWhere("equipos.modelo", "LIKE", "%{$buscar}%");

                    //   ->orWhere("clientes.rut", "LIKE", "%{$buscar}%");


         


            });
        }
        
       
                //filtrar por usuarios
                if(strtolower($tipoUsuario) != "admin" && strtolower($tipoUsuario) != "superadmin" && strtolower($tipoUsuario) != "operario"){

                    $getData->where("ordenes_trabajos.sucursales_id","=", Auth::user()->sucursales_id);
        
                }
 
                //filtrar por usuarios
                if(strtolower($tipoUsuario) == "operario" ){

                    $getData->where("ordenes_trabajos.operario_id","=", Auth::user()->id);
        
                }

                
                if($status == "CLIENTES"){
        return $data =     $getData->paginate(200);
                        
                }
                else{
                    return $data =     $getData->paginate(15);

                }

  
        return $getData->get();;

    }

    public static function OrdenesShow($numeroOt = "")
    {


         $data = ordenes_trabajos::select(
            "estado_orden_trabajo.descripcion as descripcionestado",
         DB::raw("CONCAT(personas.nombre, ' ', personas.apellido) as nombre_completo"),
         "clientes.rut",
         "clientes.correo",
         "clientes.telefono",
         "ordenes_trabajos.numero_ot",

         "clientes.razon_social",
         "ordenes_trabajos.id",
         "ordenes_trabajos.observacion",
         "ordenes_trabajos.fecha_ingreso",
            "users.id as id_user",
         "ordenes_trabajos.fecha_entrega")
        ->join("clientes","clientes.id","=","ordenes_trabajos.clientes_id")
        ->join("users","users.id","=","ordenes_trabajos.operario_id")
        ->join("personas","personas.id","=","users.personas_id")
        ->join("estado_orden_trabajo","estado_orden_trabajo.id","=","ordenes_trabajos.estado_orden_trabajo_id")
        ->where("ordenes_trabajos.id","=",$numeroOt)
            ->get();
  
        return $data;

    }
    public static function OrdenesShowContacto($numeroOt = "")
    {


         $data = ordenes_trabajos::select(
            "estado_orden_trabajo.descripcion as descripcionestado",
         DB::raw("CONCAT(personas.nombre, ' ', personas.apellido) as nombre_completo"),
         "clientes.rut",
         "clientes.correo",
         "clientes.telefono",
         "users.id as id_user",
         "ordenes_trabajos.numero_ot",
         
         "clientes.razon_social",
         "ordenes_trabajos.id",
         "ordenes_trabajos.sucursales_id",

         "ordenes_trabajos.observacion",
         "ordenes_trabajos.fecha_ingreso",
         "ordenes_trabajos.fecha_modificacion",

         "ordenes_trabajos.sub_total",
         "ordenes_trabajos.pendiente",

         "ordenes_trabajos.abono",
         "ordenes_trabajos.total",
         "ordenes_trabajos.iva",
         
         "ordenes_trabajos.impuesto_al_descuento",
         "ordenes_trabajos.neto_descuentos",
         "ordenes_trabajos.total_con_descuentos",

         
        //  "ordenes_trabajos.total",
         "ordenes_trabajos.descuento_pesos",
         "ordenes_trabajos.descuento_porcentaje",
         "ordenes_trabajos.descuento_porcentaje",
         "direcciones.comunas_id",
         "direcciones.nombre as nombre_direccion",
         "comunas.id_region",



         
         	
         
         
         
         

         "ordenes_trabajos.fecha_entrega")
        ->join("clientes","clientes.id","=","ordenes_trabajos.clientes_id")
        ->join("direcciones","direcciones.id","=","clientes.direcciones_id")
        ->join("comunas","comunas.id","=","direcciones.comunas_id")
        ->join("regions","regions.id","=","comunas.id_region")
        ->join("users","users.id","=","ordenes_trabajos.operario_id")
        ->join("personas","personas.id","=","users.personas_id")
        ->join("estado_orden_trabajo","estado_orden_trabajo.id","=","ordenes_trabajos.estado_orden_trabajo_id")
        ->where("ordenes_trabajos.id","=",$numeroOt)
        ->where("ordenes_trabajos.eliminado","=",0)

            ->get();
  
        return $data;

    }


    //HOME CONTROLER

    public static function getCountOt($status)
    {
        $tipoUsuario = User::tipoUsuario();

           $data = ordenes_trabajos::select(
         "estado_orden_trabajo.descripcion",
        
        
        )


        
        ->join("estado_orden_trabajo","estado_orden_trabajo.id","=","ordenes_trabajos.estado_orden_trabajo_id")
        ->where("ordenes_trabajos.eliminado","=",0);

        if($status == "DISTINCT"){
            $data->where("estado_orden_trabajo.descripcion","!=","FINALIZADA");

        }else{
            $data->where("estado_orden_trabajo.descripcion","=",$status);

        }


        $data->where("ordenes_trabajos.historial_ot","=",'activo');

               //filtrar por usuarios
               if(strtolower($tipoUsuario) != "admin" && strtolower($tipoUsuario) != "superadmin" && strtolower($tipoUsuario) != "operario" ){
                $data->where("ordenes_trabajos.sucursales_id","=", Auth::user()->sucursales_id);
    
              }

                   //filtrar por usuarios
                   if(strtolower($tipoUsuario) == "operario" ){

                    $data->where("ordenes_trabajos.operario_id","=", Auth::user()->id);
        
                }

                

            return      $data->count();

    }




    public static function getCountOtRepuestos()
    { 
        $tipoUsuario = User::tipoUsuario();


       
         $data = ordenes_trabajos::select("ordenes_trabajos.id")
         ->join("ordenesmasrepuestos","ordenesmasrepuestos.ordenes_trabajos_id","=","ordenes_trabajos.id")
         ->join("repuestos_solicitados","repuestos_solicitados.id","=","ordenesmasrepuestos.repuestos_solicitados_id")
         ->where("ordenes_trabajos.historial_ot","=","activo")
         ->where("ordenes_trabajos.estado_orden_trabajo_id","!=",3) //no muestra las finalizadadas
        ->where("ordenes_trabajos.eliminado","=",0)
         
        ->where("repuestos_solicitados.recibido","=","no")->groupBy("ordenes_trabajos.id"); // Agrupa por orden de trabajo para contar cada una una vez
     
     
     
            //filtrar por usuarios
            if(strtolower($tipoUsuario) != "admin" && strtolower($tipoUsuario) != "superadmin" && strtolower($tipoUsuario) != "operario" ){
                $data->where("ordenes_trabajos.sucursales_id","=", Auth::user()->sucursales_id);

        }

            //filtrar por usuarios
            if(strtolower($tipoUsuario) == "operario" ){

                $data->where("ordenes_trabajos.operario_id","=", Auth::user()->id);
    
            }

    return      $data->get();

       

    
    }
}
