<?php

namespace App\Http\Controllers\Servicios;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\servicios;
use App\Models\categorias;
use App\Models\ejecutar_servicios;
use App\Models\historial_ot_servicios;
use Carbon\Carbon;


use Illuminate\Support\Facades\Validator;
use DB;

class serviciosController extends Controller
{ 
    /**
     * Display a listing of the resource.
     * 
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        // $servicios =   servicios::paginate(20);
        $servicios =   servicios::todosLosServiciosPaginate();
        $serviciosAll =   servicios::todosLosServicios();


        return view('servicios/servicios',compact('servicios','serviciosAll'));
    }

    public function delet(request $req)
    {
     
        //
       $servicios =  servicios::where('id', "=",$req->idservicio)->firstOrFail();

       $servicios->eliminado	 =1;
       $servicios->timestamps = false;
       $servicios->save();
        
       return redirect()->route('servicios')->with('mensaje', 'Operación exitosa!');


    }


    public function editar($id)
    {
        //

        $getDataServicio =   servicios::getDataServicio($id);


        $categorias =   categorias::todosLosCategorias();

        return view('servicios/createandedit',compact('categorias',"getDataServicio","id"));





    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {        $categorias =   categorias::todosLosCategorias();

        return view('servicios/createandedit',compact('categorias'));

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        

        $idservicio = $request->idservicio;

        // Verifica si "precio_editable" está presente en la solicitud
        if ($request->has('precio_editable')) {
            // Si está presente, verifica si tiene el valor "on"
            if ($request->input('precio_editable') === 'on') {
                $precioEditable = 1;
            } else {
                $precioEditable = 0;
            }
        } else {
            // Si no está presente, establece la variable en 0
            $precioEditable = 0;
        }


        if($idservicio == ""){

            $servicios =  servicios::where('nombre_servicio', "=",$request->nombre)->where("eliminado","=","0")->count();

            if($servicios > 0){
                return redirect()->route('servicios.crear')->with('mensaje', 'Nombre Duplicado')->withInput();
            }

            $sku =  servicios::where('sku', "=",$request->sku)->where("eliminado","=","0")->count();

            if($sku > 0){
                return redirect()->route('servicios.crear')->with('mensaje', 'Sku Duplicado')->withInput();
            }


                return DB::transaction(function () use ($request,$precioEditable) {

                    

                    

                $servicios = new servicios;
                $servicios->nombre_servicio	 = $request->nombre;
                $servicios->descripcion	  = $request->descripcion;
                $servicios->sku	  = $request->sku;
                $servicios->precio_neto	  = $request->precioneto;
                $servicios->impuesto	  = $request->impuestos;
                $servicios->precio_bruto = $request->preciobruto;
                $servicios->precio_editable = $precioEditable;
                

                
                $servicios->eliminado	  = 0;

                $servicios->estado	  = 0;
                $servicios->categorias_id	  = $request->categorias;

                $servicios->timestamps = false;
                $servicios->save();


                    return redirect()->route('servicios')->with('mensaje', 'Operación exitosa!');


            }, 5);

        }else{
            return DB::transaction(function () use ($request,$idservicio,$precioEditable) {








                $servicios =  servicios::where('id', "=",$idservicio)->firstOrFail();


                if($servicios->nombre_servicio	 == $request->nombre && $servicios->sku	 == $request->sku  ){

                    $servicios->nombre_servicio	 = $request->nombre;
                    $servicios->descripcion	  = $request->descripcion;
                    $servicios->sku	  = $request->sku;
                    $servicios->precio_neto	  = $request->precioneto;
                    $servicios->impuesto	  = $request->impuestos;
                    $servicios->precio_bruto = $request->preciobruto;
                $servicios->precio_editable = $precioEditable;

                    $servicios->eliminado	  = 0;
                    $servicios->estado	  = 0;
                    $servicios->categorias_id	  = $request->categorias;
                    $servicios->timestamps = false;
                    $servicios->save();


                }else{

                    $serviciosGet =  servicios::where('nombre_servicio', "=",$request->nombre)->where("eliminado","=","0")->count();

                    if($servicios->nombre_servicio	 != $request->nombre ){
                        if($serviciosGet > 0){
                            return redirect()->route('servicios.crear')->with('mensaje', 'Nombre Duplicado')->withInput()
                            ;
                        }
                    }
                    
        
                    $skuGet =  servicios::where('sku', "=",$request->sku)->where("eliminado","=","0")->count();

                    if($servicios->sku	 != $request->sku  ){
                        if($skuGet > 0){
                            return redirect()->route('servicios.crear')->with('mensaje', 'Sku Duplicado')->withInput();
                        }
                    }
        
                    

                    $servicios->nombre_servicio	 = $request->nombre;
                    $servicios->descripcion	  = $request->descripcion;
                    $servicios->sku	  = $request->sku;
                    $servicios->precio_neto	  = $request->precioneto;
                    $servicios->impuesto	  = $request->impuestos;
                    $servicios->precio_bruto = $request->preciobruto;
                $servicios->precio_editable = $precioEditable;

                    $servicios->eliminado	  = 0;
                    $servicios->estado	  = 0;
                    $servicios->categorias_id	  = $request->categorias;
                    $servicios->timestamps = false;
                    $servicios->save();



                }

                


                    return redirect()->route('servicios')->with('mensaje', 'Operación exitosa!');


            }, 5);
        
        }
        return $request;
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function hisotiralservicios(Request $request)
    {
        //
        $data = historial_ot_servicios::where("servicios_ordenes_id","=",$request->idServicio)->get();
        return  $data;
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
        return $request;
    }



    
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    //servicios de las ordenes

    public function updateservicioorden(Request $request){
        //


        // return $request;
        
        $ejecutar_servicios =  ejecutar_servicios::where('id', $request->identificador_servicio_eje)->firstOrFail();
        $ejecutar_servicios->tecnicos_id =  $request->tecnicoselecionado;
        $ejecutar_servicios->timestamps = false;
        $ejecutar_servicios->save();


        $this->registrarHistoriaServiciosOt($request->id_servicio_orden,"Asignación de tecnico");
        return back()->with('success_servicios', 'Operación Exitosa!');

    }



    public function iniciarservicio(Request $request){

        $fechaActualSinFormato = Carbon::now();
        
        $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');

     
        $ejecutar_servicios =  ejecutar_servicios::where('id', $request->id_ejecucion_servicio)->firstOrFail();

      
        $ejecutar_servicios->fecha_ejecucion =  $fechaActual;

        if($request->accion == "iniciar"){
            $ejecutar_servicios->estado_ejecucion_id =  2;  //procesando
            $descripcion = "Servicio Iniciado";

        }else if($request->accion == "finalizar"){
            $ejecutar_servicios->estado_ejecucion_id =  3;  //finalizado
            $descripcion = "servicio finalizado";



        }else{
            return "error";
        }
     
       
        $ejecutar_servicios->timestamps = false;
      
        $ejecutar_servicios->save();
       
        $this->registrarHistoriaServiciosOt($request->id_servicio_orden,$descripcion);
return "ok";
    }

    public function registrarHistoriaServiciosOt($idServicioOrden,$descripcion){
        //

        $fechaActualSinFormato = Carbon::now();
        
        $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');

        $historial_ot_servicios = new historial_ot_servicios;
        $historial_ot_servicios->fecha_ingresado =  $fechaActual;
        $historial_ot_servicios->descripcion =  $descripcion;
        $historial_ot_servicios->servicios_ordenes_id =  $idServicioOrden;
       
        $historial_ot_servicios->timestamps = false;
        $historial_ot_servicios->save();
        return "ok";
    }
}
