<?php

namespace App\Http\Controllers\Ordendetrabajo;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Crypt;
use App\Models\clientes;
use App\Models\contactos;
use App\Http\Controllers\Configuraciones\ConfigController;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\File;
use App\Http\Controllers\Servicios\serviciosController;

use PDF;
use Illuminate\Pagination\Paginator;

use App\Models\servicios;
use App\Models\ordenes_trabajos;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Models\repuestos;
use App\Models\medios_pagos;
use App\Models\pagos;
use App\Models\repuestos_solicitados;
use App\Models\servicios_ordenes;
use DB;
use App\Models\ejecutar_servicios;
use App\Models\historial_ot_servicios;
use App\Models\equipos;
use App\Models\combustibles;
use Redirect;
use App\Models\regions;
use App\Models\comunas;
use App\Models\direcciones;
use App\Models\chofer_equipos;
use App\Models\cliente_equipos;
use App\Models\historial_total_ots;
use App\Models\ordenesmasservicios;
use App\Models\ordenesmasrepuestos;
use App\Models\abonos;
use App\Models\retiros_ots;
use App\Models\sucursales;
use App\Models\repuestos_medidas;
use App\Models\datos_dte;



use App\Models\ot_canceladas;
use App\Models\ot_facturadas;







use App\Models\tecnicos;






class ordendetrabajoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    protected $idotService;
    public function __construct(ConfigController $idotService)
    {
        $this->idotService = $idotService;
    }




    public function imprimirordendetrabajo() {

        $fecha_inicio = $_GET["fecha_inicio"];
        $fecha_fin = $_GET["fecha_fin"];
        $sucursal = $_GET["sucursal"];
        $estados = $_GET["estados"];


$ordenesdetrabajo = ordenes_trabajos::ordenexportar($fecha_inicio,$fecha_fin,$sucursal,$estados);


      // $html = view('imprimir.imprimirservicios')->render(); // Renderiza la vista a HTML
      $html = view('imprimir.imprimirordenesdetrabajo', compact('ordenesdetrabajo'))->render(); // Pasa el parámetro a la vista

      // Genera una respuesta en formato PDF (requiere la instalación de una biblioteca como Dompdf)
      // O puedes generar una respuesta en formato HTML si no necesitas PDF
      $pdf = PDF::loadHTML($html); // Debes instalar una biblioteca PDF, como Dompdf

      // Descargar el PDF directamente
      // return $pdf->download('servicios.pdf');

      // O mostrar el PDF en el navegador
      return $pdf->stream();
          return $req->numeroOt;
      }


    public function exportarot(request $req) {
// Obtener los datos de ejemplo


$fecha_inicio = $_GET["fecha_inicio"];
$fecha_fin = $_GET["fecha_fin"];
$sucursal = $_GET["sucursal"];
$estados = $_GET["estados"];

 $ordenesdetrabajo = ordenes_trabajos::ordenexportar($fecha_inicio,$fecha_fin,$sucursal,$estados);

// Nombre del archivo
$archivo = 'exportacion.xls';

// Encabezados HTTP para descargar el archivo
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="' . $archivo . '"');
header('Cache-Control: max-age=0');

// Abrir el archivo en modo escritura
$gestor_archivo = fopen('php://output', 'w');
// $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');

// Escribir título para las columnas
fwrite($gestor_archivo, "Fecha\tNumero Orden\tCliente\tMotor\tTotal\tDescuento\tNeto subtotal\tImpuesto\tTotal con descuento\tEstado\n");
// Total: $609.104
// Descuento($): $4
// Neto subtotal: $511.848
// Impuesto: $97.251
// Total con descuento: $609.100
// Escribir datos en el archivo XLS
foreach ($ordenesdetrabajo as $orden) {
    // fwrite($gestor_archivo, $orden->fecha_ingreso . "\t");
    // fwrite($gestor_archivo, $orden->fecha_ingreso->format('Y-m-d') . "\t");
    $fechaIngreso = Carbon::parse($orden->fecha_ingreso);
fwrite($gestor_archivo, $fechaIngreso->format('Y-m-d') . "\t");

    fwrite($gestor_archivo, $orden->numero_ot . "\t");
    fwrite($gestor_archivo, $orden->razon_social . "\t");
    fwrite($gestor_archivo, $orden->marca ." / ".$orden->modelo ." / ". $orden->motor ." / ". $orden->nombre_combustible  . "\t");
    fwrite($gestor_archivo,\App\Models\config::formatNumberWithCommas( $orden->total) . "\t");

    fwrite($gestor_archivo,\App\Models\config::formatNumberWithCommas( $orden->descuento_pesos) . "\t");
    fwrite($gestor_archivo,\App\Models\config::formatNumberWithCommas( $orden->sub_total) . "\t");
    fwrite($gestor_archivo,\App\Models\config::formatNumberWithCommas( $orden->iva) . "\t");
    fwrite($gestor_archivo,\App\Models\config::formatNumberWithCommas( $orden->total_con_descuentos) . "\t");
    fwrite($gestor_archivo,$orden->descripcionestado . "\t");

    
    // Agregar más columnas si es necesario
    fwrite($gestor_archivo, "\n");
}

// Cerrar el archivo
fclose($gestor_archivo);

exit;

    }
public function imprimirot(request $req) {






    $datos_ot = "";
         $ordenes_trabajos = ordenes_trabajos::OrdenesShowContacto($req->idOT);
           $sucursales_id = $ordenes_trabajos[0]->sucursales_id;
         $servicios_ordenes = servicios_ordenes::showOrdenesServicios($req->idOT);
         $repuestos_solicitados = repuestos_solicitados::showOrdenesRepuestos($req->idOT);
         $datosdelequipo = ordenes_trabajos::datosdelequipo($req->idOT);
         $getComuna = comunas::getNombreComuna($ordenes_trabajos[0]->comunas_id);

    $jsonString = sucursales::dataSucursal($sucursales_id);
    $logoSucursal = sucursales::getLogo($sucursales_id);


  $data = json_decode($jsonString, true);

  // Verificar si la decodificación fue exitosa
  if ($data !== null) {
      // Recorrer el array resultante
      foreach ($data as $item) {
          // Decodificar el JSON dentro de "datassucursal"
          $sucursalData = json_decode($item['datassucursal'], true);

          // Verificar si la decodificación fue exitosa
          if ($sucursalData !== null) {
              // Acceder a los valores
              $nombre = $sucursalData['nombre'];
              $giro = $sucursalData['giro'];
              $telefono = $sucursalData['telefono'];
              $celular = $sucursalData['celular'];
              $corrreo = $sucursalData['corrreo'];
              $direccion = $sucursalData['direccion'];


             $dataArraySucursal = [
                "nombre"=> $nombre,
                "giro"=> $giro,
                "telefono"=> $telefono,
                "celular"=> $celular,
                "direccion"=> $direccion,
                "corrreo"=> $corrreo,

             ];
          } else {
              echo "Error al decodificar 'datassucursal'";
          }

           $dataArraySucursal;
      }
  } else {
      echo "Error al decodificar el JSON principal";
  }


    // $miArrayAsociativo = array(
    //     "nombre" => "Juan",
    //     "edad" => 25,
    //     "ciudad" => "EjemploCity"
    // );

    // Convertir el array a formato JSON
//   return  $datosJSON = json_encode($miArrayAsociativo);


$getOt = ordenes_trabajos::select("id")->where("numero_ot","=",$ordenes_trabajos[0]->numero_ot)->orderby("id","ASC")->get();
// Decodificar el JSON a una colección de Laravel
// Variable a buscar

 $valorBuscado = $req->idOT; // Esto podría ser cualquier valor que desees buscar

// Decodificar el JSON a una colección de Laravel
$coleccion = collect(json_decode($getOt, true));

// Buscar la posición del valor buscado
$posicion = $coleccion->search(function ($item) use ($valorBuscado) {
    return $item['id'] == $valorBuscado;
});


$LetraAsignada= $this->obtenerLetra($posicion);

// // Mostrar la posición de la ID 13
// if ($posicion !== false) {
//     echo "La ID 13 se encuentra en la posición: $posicion";
// } else {
//     echo "La ID 13 no se encontró en la colección.";
// }



   $html = view('imprimir.pdfOT', compact('getComuna',"logoSucursal","datosdelequipo","repuestos_solicitados","ordenes_trabajos",'dataArraySucursal','servicios_ordenes'))->render(); // Pasa el parámetro a la vista

// Genera una respuesta en formato PDF (requiere la instalación de una biblioteca como Dompdf)
// O puedes generar una respuesta en formato HTML si no necesitas PDF
$pdf = PDF::loadHTML($html); // Debes instalar una biblioteca PDF, como Dompdf

// Descargar el PDF directamente
// return $pdf->download('servicios.pdf');

// O mostrar el PDF en el navegador
// return $pdf->stream();

// Nombre del archivo para descargar
$filename = 'orden_numero_'.$ordenes_trabajos[0]->numero_ot."_".$LetraAsignada.'.pdf';

// Descargar el archivo con el nombre especificado
return $pdf->stream($filename);

return $pdf->download($filename);
}



public function  obtenerLetra($posicion) {
    // Arreglo con las letras del alfabeto
    $alfabeto = range('A', 'Z');

    // Verificar si la posición está dentro del rango de 0 a 25 (correspondiente a las letras del alfabeto)
    if ($posicion >= 0 && $posicion <= 25) {
        // Obtener la letra correspondiente al índice de la posición en el arreglo
        return $alfabeto[$posicion];
    } else {
        return "Posición inválida";
    }
}

    public function cargaOt()
     {

//         $servicios_ordenes = servicios_ordenes::showOrdenesServiciosAll();
// $colecionResultados = collect($servicios_ordenes);

// // Get the current page from the request or set a default value
// $page = request()->get('page', 1);

// // Number of items per page
// $perPage = 15;

// // Manually slice the collection based on the current page and number of items per page
// $paginatedResults = $colecionResultados->forPage($page, $perPage);

// return view('ordenesdetrabajo/cargasOt', [
//     'servicios_ordenes' => $paginatedResults,
// ]);

$servicios_ordenes = servicios_ordenes::showOrdenesServiciosAll();
$colecionResultados = collect($servicios_ordenes);

// Get the current page from the request or set a default value
$page = request()->get('page', 1);

// Number of items per page
$perPage = 15;

// Manually slice the collection based on the current page and number of items per page
$paginatedResults = $colecionResultados->forPage($page, $perPage);

// Create a LengthAwarePaginator instance
$paginator = new LengthAwarePaginator(
    $paginatedResults,
    $colecionResultados->count(),
    $perPage,
    $page,
    [
        'path' => url('/carga/ordendetrabajo'), // Set the path to the full URL
    ]
);

// // Create a LengthAwarePaginator instance
// $paginator = new LengthAwarePaginator(
//     $paginatedResults,
//     $colecionResultados->count(),
//     $perPage,
//     $page
// );

return view('ordenesdetrabajo/cargasOt', [
    'servicios_ordenes' => $paginator,
]);


    //    $servicios_ordenes = servicios_ordenes::showOrdenesServiciosAll();

    //    $colecionResultados = collect($servicios_ordenes);


    //   return view('ordenesdetrabajo/cargasOt', [
    //     'servicios_ordenes' => collect($colecionResultados)->paginate(15),
    // ]);


        return view('ordenesdetrabajo/cargasOt',compact('servicios_ordenes'));



     }



     public function filtrarOt(request $req )
     {
        $sucursales = sucursales::all();

        $status = null;
        $medios_pagos =   medios_pagos::all();
        $ordenesdetrabajo = ordenes_trabajos::OrdenesAll(null,null,null,$req);
        $datosDelCliente = null;
        $estados_ot =   ordenes_trabajos::getStadosOt();
            return view('ordenesdetrabajo/ordenesdetrabajo',compact("estados_ot","sucursales","ordenesdetrabajo","medios_pagos","datosDelCliente","req"));

    }

    public function index($status = null)
    {
        $sucursales = sucursales::all();


        if(isset($_GET["opciones"])) {
            //$status vendria la id del cliente

            $datosDelCliente = clientes::datosDelCliente($status);
            $ordenesdetrabajo = ordenes_trabajos::OrdenesAll("CLIENTES",null,$status);

        } else {
            // If it doesn't exist, you can set a default value or handle it accordingly
            $ordenesdetrabajo = ordenes_trabajos::OrdenesAll($status);
            $datosDelCliente = null;
        }

           $medios_pagos =   medios_pagos::all();
           $estados_ot =   ordenes_trabajos::getStadosOt();

           

        return view('ordenesdetrabajo/ordenesdetrabajo',compact("estados_ot","sucursales","ordenesdetrabajo","medios_pagos","datosDelCliente"));
    }

    public function searchOt(request $req)
    {
        $ordenesdetrabajo = ordenes_trabajos::OrdenesAll(null, $req->data);

        return $ordenesdetrabajo;

    }
    public function historial(Request $request)
    {
        $ordenesdetrabajo = ordenes_trabajos::OrdenesAllPorNOt($request->numerodelaot);
        return $ordenesdetrabajo;
        $ordenesdetrabajo = ordenes_trabajos::OrdenesAll();
        $estados_ot =   ordenes_trabajos::getStadosOt();

        return view('ordenesdetrabajo/ordenesdetrabajo',compact("estados_ot","ordenesdetrabajo"));
    }
    public function recepcionarpresupuesto(Request $request){

     // return "dss";
     $ordenes_trabajos =  ordenes_trabajos::where('id', $request->idOrdenTrabajo)->firstOrFail();
     $ordenes_trabajos->estado_orden_trabajo_id = 1; //recepcionada
     $ordenes_trabajos->ispresupuesto = 0; //
     $ordenes_trabajos->ischangepresupuesto = 1; //
    $ordenes_trabajos->timestamps = false;
    $ordenes_trabajos->save();

    return redirect::back()->with('mensaje', 'Operación exitosa!')->with('idOT', $ordenes_trabajos->id);

    // return redirect::back()->with('mensaje', 'Ot Recepcionada!');

    }
    public function finalizarget($idot =""){
 
        $request = new Request(['idot' => $idot]);
        return $this->finalizar($request);
 
    }
    public function iniciarget($idot =""){
 
        // return $idot;
         // Crear un objeto Request con el parámetro $idot
    $request = new Request(['idot' => $idot]);

    // Llamada a la función iniciar con el objeto Request
    return $this->iniciar($request);
 
    }

    public function iniciar(Request $request){

        // return "dss";
         $ordenes_trabajos =  ordenes_trabajos::where('id', $request->idot)->firstOrFail();
         $ordenes_trabajos->estado_orden_trabajo_id = 2; //procesando
        $ordenes_trabajos->timestamps = false;
        $ordenes_trabajos->save();

        $ordenes_trabajos =  ordenesmasservicios::select("ejecutar_servicios.*","servicios_ordenes.id as id_servicios")
    ->join("servicios_ordenes","servicios_ordenes.id","=","ordenesmasservicios.servicios_ordenes_id")
    ->join("ejecutar_servicios","ejecutar_servicios.servicios_ordenes_id","=","servicios_ordenes.id")

    ->where('ordenesmasservicios.ordenes_trabajos_id', $request->idot)->get();
    $fechaActualSinFormato = Carbon::now();

    $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');
    foreach ($ordenes_trabajos as $item) {

        $ejecutar_servicios =  ejecutar_servicios::where('id', $item->id)->firstOrFail();
        $ejecutar_servicios->fecha_ejecucion =  $fechaActual;
        $ejecutar_servicios->estado_ejecucion_id =  2;  //procesando
        $descripcion = "Servicio Iniciado";
        // echo $item->id;
        $ejecutar_servicios->timestamps = false;
        $ejecutar_servicios->save();

        $serviciosController = new serviciosController();
        $serviciosController->registrarHistoriaServiciosOt($item->id_servicios,$descripcion);
    }

        return redirect::back()->with('mensaje', 'Ot Iniciada!');

}

public function addabono(request $req){

    $fechaActualSinFormato = Carbon::now();
     $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');


         $pagos_save = new pagos;
         $pagos_save->fecha		  =$fechaActual;
         $pagos_save->motivo		  ="abono";
         $pagos_save->numero_ot		  =$req->numeroDelaOtGlobal;

         $pagos_save->total =$req->montoparaabonar;
         $pagos_save->ordenes_trabajos_id	  =$req->idOtGlobal;
         $pagos_save->medios_pagos_id  =$req->mediosPagosSelect;
         $pagos_save->timestamps = false;
         $pagos_save->save();

       $totalPagos = pagos::where("numero_ot", "=", $req->numeroDelaOtGlobal)->sum('total');


             //actualizar abono de la ot
         $update_ordenes_trabajos =  ordenes_trabajos::where('id', $req->idOtGlobal)->firstOrFail();
         $update_ordenes_trabajos->abono		  =   $totalPagos;
         $update_ordenes_trabajos->pendiente		  =   $update_ordenes_trabajos->pendiente - $req->montoparaabonar;

         $update_ordenes_trabajos->timestamps = false;
         $update_ordenes_trabajos->save();



             $dataOT =  ordenes_trabajos::where('id', $req->idOtGlobal)->get();
             $adeudado = $dataOT[0]->total_con_descuentos - $dataOT[0]->abono;

             $pagos =  pagos::select("pagos.*","medios_pagos.descripcion")
             ->join("medios_pagos","medios_pagos.id","=","pagos.medios_pagos_id")
    ->where('pagos.total',"<>",0)

             ->where('numero_ot', $req->numeroDelaOtGlobal)->get();



 return [
     "pagos" => $pagos,
     "adeudado" => $adeudado,
 ];
}

public function addabono_old(request $req){

       $fechaActualSinFormato = Carbon::now();
        $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');


            $pagos_save = new pagos;
            $pagos_save->fecha		  =$fechaActual;
            $pagos_save->motivo		  ="abono";
            $pagos_save->numero_ot		  =$req->numeroDelaOtGlobal;

            $pagos_save->total =$req->montoparaabonar;
            $pagos_save->ordenes_trabajos_id	  =$req->idOtGlobal;
            $pagos_save->medios_pagos_id  =$req->mediosPagosSelect;
            $pagos_save->timestamps = false;
            $pagos_save->save();


                //actualizar abono de la ot
            $update_ordenes_trabajos =  ordenes_trabajos::where('id', $req->idOtGlobal)->firstOrFail();
            $update_ordenes_trabajos->abono		  =   $update_ordenes_trabajos->abono	+ $req->montoparaabonar;
            $update_ordenes_trabajos->pendiente		  =   $update_ordenes_trabajos->pendiente - $req->montoparaabonar;

            $update_ordenes_trabajos->timestamps = false;
            $update_ordenes_trabajos->save();



                $dataOT =  ordenes_trabajos::where('id', $req->idOtGlobal)->get();
                $adeudado = $dataOT[0]->total - $dataOT[0]->abono;

                $pagos =  pagos::select("pagos.*","medios_pagos.descripcion")->join("medios_pagos","medios_pagos.id","=","pagos.medios_pagos_id")->where('numero_ot', $req->numeroDelaOtGlobal)->get();



    return [
        "pagos" => $pagos,
        "adeudado" => $adeudado,
    ];
}
public function abonos(request $req){


    $pagos =  pagos::select("pagos.*","medios_pagos.descripcion")
    ->join("medios_pagos","medios_pagos.id","=","pagos.medios_pagos_id")
    ->where('pagos.total',"<>",0)
    ->where('numero_ot', $req->numerodelaot)->get();


    $dataOT =  ordenes_trabajos::where('id', $req->idOt)->get();

    $adeudado = $dataOT[0]->total_con_descuentos - $dataOT[0]->abono;


    return [
        "pagos" => $pagos,
        "adeudado" => $adeudado,
    ];
}






public function crearsincliente(){

    // $servicios =   servicios::todosLosServiciosCategoriar();
    $servicios =   servicios::todosLosServicios();


//     $contactos =   contactos::select("contactos.*","contactos.id as id_cliente","direcciones.nombre as nombre_direccion","comunas_id","regions.id as idregion")
//     ->join("direcciones","direcciones.id","=","contactos.direcciones_id")
//     ->join("regions","regions.id","=","direcciones.comunas_id")
//     ->get();
//     ;


//    return  $contactos =   clientes::select("clientes.*","clientes.id as id_cliente","direcciones.nombre as nombre_direccion","comunas_id","regions.id as idregion")
//     ->join("direcciones","direcciones.id","=","clientes.direcciones_id")
//     ->join("regions","regions.id","=","direcciones.comunas_id")
//     ->get();
//     ;

//   $contactoss = contactos::select("contactos.*", "contactos.id as id_contacto", "direcciones.nombre as nombre_direccion", "comunas_id", "comunas.id_region as idregion")
//     ->join("direcciones", "direcciones.id", "=", "contactos.direcciones_id")
//     ->join("comunas", "comunas.id", "=", "direcciones.comunas_id");

    $contactos = clientes::selectRaw("clientes.*, " . DB::raw('NULL') . " as id_contacto, direcciones.nombre as nombre_direccion, comunas_id, comunas.id_region as idregion")
    ->join("direcciones", "direcciones.id", "=", "clientes.direcciones_id")
    ->join("comunas", "comunas.id", "=", "direcciones.comunas_id")->get();

    // $contactos = $contactoss->union($clientes)->get();



    $operarios =   User::datosOperarios();
    $datosChofer =   User::datosChofer();

    $regiones =          regions::orderBy('des_region', 'asc')->get();

    $comunasporregion  =  comunas::orderBy('des_comuna', 'asc')->get();
    $repuestos =   repuestos::select("repuestos.*","categorias.nombre as categoria")->join("categorias","categorias.id","=","repuestos.id_categoria")->get();
    $medios_pagos =   medios_pagos::all();
    $equipos= equipos::all();

    $combustibles = combustibles::all();
    $sucursales = sucursales::all();
    $repuestos_medidas = repuestos_medidas::all();



    return view('ordenesdetrabajo/nuevaOt',compact('repuestos_medidas','sucursales',"comunasporregion","regiones","datosChofer","combustibles","equipos","medios_pagos","contactos",'servicios','operarios','repuestos'));


}

public function getoperarios(Request $request){

  $operarios = User::datosOperarioSucursal($request->idsucursal);
  $datosChofer = User::datosChofer($request->idsucursal);


  return [
    'operarios'=> $operarios,
    'choferes'=> $datosChofer
  ];
}

public function finalizar(Request $request){


    $ordenes_trabajos =  ordenes_trabajos::where('id', $request->idot)->firstOrFail();
    $ordenes_trabajos->estado_orden_trabajo_id = 3; //finalizado
    $ordenes_trabajos->timestamps = false;
    $ordenes_trabajos->save();
    return redirect::back()->with('mensaje', 'Ot Iniciada!');

}




public function crearDTE($rutCliente, $razonSocial, $giro, $domicilio, $comuna, $data, $descuentoTotal,$opcion)
{

    $descuentoTotal = round($descuentoTotal);
    // Calcular el total de la venta sumando los precios de todos los productos
    $subtotal = 0;
    foreach ($data as $producto) {
        $subtotal += $producto['cantidad'] * $producto['precio_unidad'];
    }
    $subtotal = round($subtotal);

    // Calcular el impuesto sobre el subtotal (19%)
    $impuesto = $subtotal * 0.19;
    $impuesto = round($impuesto);

    // Calcular el total de la venta incluyendo el impuesto
    $totalVenta = $subtotal + $impuesto;

    // Aplicar el descuento al total más el impuesto
    $totalConDescuento = $totalVenta - $descuentoTotal;


    // Calcular el nuevo subtotal sin impuestos después del descuento
    $subtotalConDescuento = $totalConDescuento / 1.19;

    $totalConDescuento = round($totalConDescuento);


    // Ajustar los precios de los productos con el descuento proporcional
    foreach ($data as &$producto) {
        $producto['precio_unidad'] = ($producto['precio_unidad'] / $subtotal) * $subtotalConDescuento;
        $producto['precio_unidad'] = round($producto['precio_unidad']);



        if($opcion == "boleta"){

                // Calcular el precio unitario con impuesto incluido
                $precio_con_impuesto = $producto['precio_unidad'] * 1.19;

                // Redondear el precio con impuesto a dos decimales
                $precio_con_impuesto = round($precio_con_impuesto);

                // Actualizar el precio unitario del producto con impuesto
                $producto['precio_unidad'] = $precio_con_impuesto;
                $producto['precio_unidad'] = round($producto['precio_unidad']);
         }

    }


    // Contenido del archivo de texto
    $content = "'Receptor' => [" . PHP_EOL;
    $content .= "    'RUTRecep' => '" . $rutCliente . "'," . PHP_EOL;
    $content .= "    'RznSocRecep' => '" . $this->eliminar_tildes($razonSocial) . "'," . PHP_EOL;
    $content .= "    'GiroRecep' => '" . $this->eliminar_tildes($giro) . "'," . PHP_EOL;
    $content .= "    'DirRecep' => '" . $this->eliminar_tildes($domicilio) . "'," . PHP_EOL;
    $content .= "    'CmnaRecep' => '" . $this->eliminar_tildes($comuna) . "'," . PHP_EOL;
    $content .= "]," . PHP_EOL;
    $content .= "]," . PHP_EOL;

    $content .= "'Detalle' => [" . PHP_EOL;

    foreach ($data as $getdata) {
        $content .= " [" . PHP_EOL;
        $content .= "    'NmbItem' => '" . $getdata['nombre_servicio'] . "'," . PHP_EOL;
        $content .= "    'QtyItem' => " . $this->eliminar_tildes($getdata['cantidad']) . "," . PHP_EOL;
        $content .= "    'PrcItem' => " . $this->eliminar_tildes($getdata['precio_unidad']) . "," . PHP_EOL;
        $content .= " ]," . PHP_EOL;
    }

    $content .= "]," . PHP_EOL;

    // Nombre del archivo
    $nombre_aleatorio = $this->mombre_aleatorio();
    $fileName = 'dte/orginales' . $nombre_aleatorio . '.txt';

    // Ruta de destino en la carpeta public
    $filePath = public_path($fileName);

    // Crear la carpeta si no existe
    File::makeDirectory(dirname($filePath), 0777, true, true);

    // Guardar el contenido en el archivo
    File::put($filePath, $content);

    return $nombre_aleatorio;
}

public function crearDTEFactura($rutCliente, $razonSocial, $giro, $domicilio, $comuna, $data, $descuentoTotal,$opcion)
{

    $descuentoTotal = round($descuentoTotal,4);
    // Calcular el total de la venta sumando los precios de todos los productos
    $subtotal = 0;
    foreach ($data as $producto) {
        $subtotal += $producto['cantidad'] * $producto['precio_unidad'];
    }
    $subtotal = round($subtotal,4);

    // Calcular el impuesto sobre el subtotal (19%)
    $impuesto = $subtotal * 0.19;
    $impuesto = round($impuesto,4);

    // Calcular el total de la venta incluyendo el impuesto
    $totalVenta = $subtotal + $impuesto;

    // Aplicar el descuento al total más el impuesto
    $totalConDescuento = $totalVenta - $descuentoTotal;


    // Calcular el nuevo subtotal sin impuestos después del descuento
    $subtotalConDescuento = $totalConDescuento / 1.19;

    $totalConDescuento = round($totalConDescuento,4);


    // Ajustar los precios de los productos con el descuento proporcional
    foreach ($data as &$producto) {
        $producto['precio_unidad'] = ($producto['precio_unidad'] / $subtotal) * $subtotalConDescuento;
        $producto['precio_unidad'] = round($producto['precio_unidad'],4);



        if($opcion == "boleta"){

                // Calcular el precio unitario con impuesto incluido
                $precio_con_impuesto = $producto['precio_unidad'] * 1.19;

                // Redondear el precio con impuesto a dos decimales
                $precio_con_impuesto = round($precio_con_impuesto,4);

                // Actualizar el precio unitario del producto con impuesto
                $producto['precio_unidad'] = $precio_con_impuesto;
                $producto['precio_unidad'] = round($producto['precio_unidad'],4);
         }

    }


    // Contenido del archivo de texto
    $content = "'Receptor' => [" . PHP_EOL;
    $content .= "    'RUTRecep' => '" . $rutCliente . "'," . PHP_EOL;
    $content .= "    'RznSocRecep' => '" . $this->eliminar_tildes($razonSocial) . "'," . PHP_EOL;
    $content .= "    'GiroRecep' => '" . $this->eliminar_tildes($giro) . "'," . PHP_EOL;
    $content .= "    'DirRecep' => '" . $this->eliminar_tildes($domicilio) . "'," . PHP_EOL;
    $content .= "    'CmnaRecep' => '" . $this->eliminar_tildes($comuna) . "'," . PHP_EOL;
    $content .= "]," . PHP_EOL;
    $content .= "]," . PHP_EOL;

    $content .= "'Detalle' => [" . PHP_EOL;

    foreach ($data as $getdata) {
        $content .= " [" . PHP_EOL;
        $content .= "    'NmbItem' => '" . $getdata['nombre_servicio'] . "'," . PHP_EOL;
        $content .= "    'QtyItem' => " . $this->eliminar_tildes($getdata['cantidad']) . "," . PHP_EOL;
        $content .= "    'PrcItem' => " . $this->eliminar_tildes($getdata['precio_unidad']) . "," . PHP_EOL;
        $content .= " ]," . PHP_EOL;
    }

    $content .= "]," . PHP_EOL;

    // Nombre del archivo
    $nombre_aleatorio = $this->mombre_aleatorio();
    $fileName = 'dte/orginales' . $nombre_aleatorio . '.txt';

    // Ruta de destino en la carpeta public
    $filePath = public_path($fileName);

    // Crear la carpeta si no existe
    File::makeDirectory(dirname($filePath), 0777, true, true);

    // Guardar el contenido en el archivo
    File::put($filePath, $content);

    return $nombre_aleatorio;
}



public function crearDTE_old_2($rutCliente, $razonSocial, $giro, $domicilio, $comuna, $data, $descuentoTotal)
{
    // Calcular el total de la venta sumando los precios de todos los productos
    $totalVenta = 0;
    foreach ($data as $producto) {
        $totalVenta += $producto['cantidad'] * $producto['precio_unidad'];
    }

    // Calcular el descuento proporcional para cada producto
    foreach ($data as &$producto) {
        // Calcular el porcentaje del precio total que representa este producto
        $porcentajeProducto = ($producto['cantidad'] * $producto['precio_unidad']) / $totalVenta;

        // Aplicar el descuento proporcional a este producto
        $descuentoProducto = $descuentoTotal * $porcentajeProducto;

        // Restar el descuento del precio del producto
        $producto['precio_unidad'] -= $descuentoProducto;

        // Asegurarse de que el precio no sea negativo
        if ($producto['precio_unidad'] < 0) {
            $producto['precio_unidad'] = 0;
        }
    }

    // Contenido del archivo de texto
    $content = "'Receptor' => [" . PHP_EOL;
    $content .= "    'RUTRecep' => '" . $rutCliente . "'," . PHP_EOL;
    $content .= "    'RznSocRecep' => '" . $this->eliminar_tildes($razonSocial) . "'," . PHP_EOL;
    $content .= "    'GiroRecep' => '" . $this->eliminar_tildes($giro) . "'," . PHP_EOL;
    $content .= "    'DirRecep' => '" . $this->eliminar_tildes($domicilio) . "'," . PHP_EOL;
    $content .= "    'CmnaRecep' => '" . $this->eliminar_tildes($comuna) . "'," . PHP_EOL;
    $content .= "]," . PHP_EOL;
    $content .= "]," . PHP_EOL;

    $content .= "'Detalle' => [" . PHP_EOL;

    foreach ($data as $getdata) {
        $content .= " [" . PHP_EOL;
        $content .= "    'NmbItem' => '" . $getdata['nombre_servicio'] . "'," . PHP_EOL;
        $content .= "    'QtyItem' => " . $this->eliminar_tildes($getdata['cantidad']) . "," . PHP_EOL;
        $content .= "    'PrcItem' => " . $this->eliminar_tildes($getdata['precio_unidad']) . "," . PHP_EOL;
        $content .= " ]," . PHP_EOL;
    }

    $content .= "]," . PHP_EOL;

    // Nombre del archivo
    $nombre_aleatorio = $this->mombre_aleatorio();
    $fileName = 'dte/orginales' . $nombre_aleatorio . '.txt';

    // Ruta de destino en la carpeta public
    $filePath = public_path($fileName);

    // Crear la carpeta si no existe
    File::makeDirectory(dirname($filePath), 0777, true, true);

    // Guardar el contenido en el archivo
    File::put($filePath, $content);

    return $nombre_aleatorio;
}


 public function crearDTE_old($rutCliente,$razonSocial,$giro,$domicilio,$comuna,$data,$descuentoTotal){

      // Contenido del archivo de texto
      $content="";
      $content.="'Receptor' => [".PHP_EOL;
      $content.= "    'RUTRecep' => '".$rutCliente."',".PHP_EOL;
      $content.= "    'RznSocRecep' => '".$this->eliminar_tildes($razonSocial)."',".PHP_EOL;
      $content.= "    'GiroRecep' => '".$this->eliminar_tildes($giro)."',".PHP_EOL;
      $content.= "    'DirRecep' => '".$this->eliminar_tildes($domicilio )."',".PHP_EOL;
      $content.= "    'CmnaRecep' => '".$this->eliminar_tildes($comuna)."',".PHP_EOL;
      $content.= "],".PHP_EOL;
      $content.= "],";

      $content.="'Detalle' => [".PHP_EOL;


      foreach ($data as $getdata) {

       $content.=" [".PHP_EOL;
       $content.="    'NmbItem' => '".$getdata['nombre_servicio']."',".PHP_EOL;


       $content.="    'QtyItem' => ".$this->eliminar_tildes($getdata['cantidad'] ).",".PHP_EOL;
      //  $content.="    'PrcItem' => ".$this->eliminar_tildes($getOtEje[0]->total_venta_eje).",".PHP_EOL;
       $content.="    'PrcItem' => ".$this->eliminar_tildes($getdata['precio_unidad']).",".PHP_EOL;
       $content.=" ],".PHP_EOL;
    }




      $content.="],".PHP_EOL;

      // Nombre del archivo
      $nombre_aleatorio = $this->mombre_aleatorio();
      // $fileName = 'dte/'.$this->mombre_aleatorio().'.txt';
      $fileName = 'dte/orginales'.$nombre_aleatorio.'.txt';

      // Ruta de destino en la carpeta public
      $filePath = public_path($fileName);

      // Crear la carpeta si no existe
      File::makeDirectory(dirname($filePath), 0777, true, true);

      // Guardar el contenido en el archivo
      File::put($filePath, $content);

      return $nombre_aleatorio;
 }


 public function agregarAbonoDTE($numeroOt,$idOt,$totalAbono,$tipoAbono,$infobanco,$infofecha){



    $fechaActualSinFormato = Carbon::now();
     $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');

    //   $infodate= $infofecha->format('Y-m-d H:i:s');

         $pagos_save = new pagos;
         $pagos_save->fecha		  =$fechaActual;
         $pagos_save->motivo		  ="abono";
         $pagos_save->numero_ot		  =$numeroOt;
         $pagos_save->infobanco			  =$infobanco;
         $pagos_save->infodate		  =$infofecha;


         $pagos_save->total =$totalAbono;
         $pagos_save->ordenes_trabajos_id	  =$idOt;
         $pagos_save->medios_pagos_id  =$tipoAbono;
         $pagos_save->timestamps = false;
         $pagos_save->save();

       $totalPagos = pagos::where("numero_ot", "=", $numeroOt)->sum('total');


             //actualizar abono de la ot
         $update_ordenes_trabajos =  ordenes_trabajos::where('id', $idOt)->firstOrFail();
         $update_ordenes_trabajos->abono		  =   $totalPagos;
         $update_ordenes_trabajos->pendiente		  =   $update_ordenes_trabajos->pendiente - $totalAbono;

         $update_ordenes_trabajos->timestamps = false;
         $update_ordenes_trabajos->save();



       return "ok";
}
public function facturar_prueba_pablo(Request $request){
$idOT = $request->input('idot');


$rutCliente= "18795022-8";
$giroActual = "prueba";
$opcion = "factura";
// return $request;
$fechaActualSinFormato = Carbon::now();
$fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');

        $clientes =  clientes::where('rut', $rutCliente)->firstOrFail();


    $direcciones =  direcciones::where('id', 3)->firstOrFail();
    $comunas = comunas::where('id', 3)->firstOrFail();
    $servicios_ordenes = servicios_ordenes::showOrdenesServicios($idOT);
    $ordenes_trabajos =  ordenes_trabajos::where('id', $idOT)->firstOrFail();

    $gtRut = explode('-', $rutCliente);
    $rutSinGuion =  $gtRut[0];

    $nombreDteGenerado =   $this->crearDTEFactura($rutCliente, "razonprueba",  $giroActual,$direcciones->nombre,$comunas->des_comuna,$servicios_ordenes,$ordenes_trabajos->descuento_pesos,$opcion);


    $ot_facturadas = new ot_facturadas;

        $ot_facturadas->fecha_facturada =$fechaActual;
        $ot_facturadas->id_ot_facturada =$idOT;
        $ot_facturadas->numero_ot =$ordenes_trabajos->numero_ot;
        $ot_facturadas->id_cliente =$clientes->id;



            $ot_facturadas->factura =1;
            $ot_facturadas->url_dte_factura ="orginales".$nombreDteGenerado.".txt";



    $ot_facturadas->timestamps = false;
    // $ot_facturadas->save();

    $cl =base64_encode("nebio1");


    $total =base64_encode( $ordenes_trabajos->total_con_descuentos."");
    $roundTotalFactura = round($ordenes_trabajos->total_con_descuentos);
    $totalFactura =base64_encode( $roundTotalFactura."");


    $ids=base64_encode($request->idot."");
    $rr=base64_encode( $rutSinGuion."");
    $name_txt =base64_encode( "https://sistema.nebiolo.cl/dte/orginales".$nombreDteGenerado.".txt");
    $ot=base64_encode($ordenes_trabajos->numero_ot."");





        $url = 'https://iretail.cl/emision_dte/facturaexterna.php?cl='.$cl.'&total='.$totalFactura.'&ids='.$ids.'&rr='.$rr.'&txt='.$name_txt.'&ot='.$ot;




    return redirect('/ordendetrabajo')->with([
        'mensaje' => 'Orden Realizada',
        'url' => $url
    ]);



}

public function facturar(Request $request){



    if($request->giro_m == "OTRO"){
        $giroActual	  = $request->text_giro_otro;

     }else{
        $giroActual	  = $request->giro_m;

     }


     if($request->comuna_m == "Seleccionar"){

        $request->comuna_m = 999; //sin comuna
     }


    // if($request->direccion_m == "OTRO"){
    //     $dataDireccion = $request->text_direccion_otro;
    // }else{
    //     $dataDireccion = $request->direccion_m;

    // }

    if ($request->direccion_m == "OTRO") {
        $dataDireccion = $request->text_direccion_otro;
    } else {
        $direccion = $request->direccion_m;

        // Patron de expresión regular para buscar "DOMICILIO:" seguido de cualquier texto hasta el siguiente punto.
        $patron = '/DOMICILIO:(.*?)\./';

        // Encuentra todas las coincidencias del patrón en la cadena de dirección
        preg_match($patron, $direccion, $matches);

        // Si se encontraron coincidencias
        if (isset($matches[1])) {
            // Obtén el valor encontrado, que estará en el segundo elemento del array $matches
            $dataDireccion = trim($matches[1]); // Elimina espacios en blanco al principio y al final
        } else {
            // Si no se encontró el patrón, usa la dirección completa
            $dataDireccion = $direccion;
        }
    }

// return $request;
    $fechaActualSinFormato = Carbon::now();
    $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');

$existeCliente = clientes::validarRutCliente($request->rut_m);

if($existeCliente == 1){



    $clientes =  clientes::where('rut', $request->rut_m)->firstOrFail();
    $clientes->razon_social	 = $request->razon_social_m;
    $clientes->rut	  = $request->rut_m;
    $clientes->giro	  = $giroActual;
    $clientes->telefono	  = $request->telefono_m;
    $clientes->correo	  = $request->correo_m;
    $clientes->timestamps = false;
    $clientes->save();


    $direcciones =  direcciones::where('id', $clientes->direcciones_id)->firstOrFail();
    $direcciones->nombre	  = $dataDireccion;
    $direcciones->comunas_id	  = $request->comuna_m;
    $direcciones->timestamps = false;
    $direcciones->save();



}else{



    $dataDirecciones=[
        // 'name' => $data['name'],
        'nombre' => $dataDireccion,
        'estado' => 0,
        'regions_id' => 1,
        'tipo' => "cliente",
        'comuna'=>$request->comuna_m

    ];

    $insertDirecciones=  direcciones::crearDireccion($dataDirecciones);








     $clientes = new clientes;
     $clientes->razon_social	 = $request->razon_social_m;
     $clientes->rut	  = $request->rut_m;

        $clientes->giro	  = $giroActual;



     $clientes->telefono	  = $request->telefono_m;
     $clientes->correo	  = $request->correo_m;
     $clientes->sucursales_id	  = 1;
     $clientes->eliminado	  = 0;
     $clientes->direcciones_id	  = $insertDirecciones;
     $clientes->timestamps = false;
     $clientes->save();


}


/*
esta funcion nos permite agregar en abonos todo los pagos
*/

// Iteramos desde 0 hasta 99
for ($i = 0; $i < 100; $i++) {
    // Construimos el nombre de la clave basado en el valor de $i
    $clave = "seleccionopcion".$i;
    $valoropcion = "valoropcion".$i;
    $banco = "banco".$i;
    $fecha = "fecha".$i;


    // Verificamos si la clave existe en $request
    if (isset($request->$clave)) {
        // Si la clave existe, almacenamos su valor en el array
        // $valoresEncontrados[] = $request->$clave;
        // echo $request->$clave;
        $this->agregarAbonoDTE($request->numeroot,$request->idot,$request->$valoropcion,$request->$clave,$request->$banco,$request->$fecha);


    }else{
        $i=101;
    }

}

    $ordenes_trabajos =  ordenes_trabajos::where('id', $request->idot)->firstOrFail();
    $ordenes_trabajos->estado_orden_trabajo_id = 3; //finalizadas
    // $ordenes_trabajos->fecha_facturada = $fechaActual;
    $ordenes_trabajos->timestamps = false;
    $ordenes_trabajos->save();
	// id	fecha_facturada	id_ot_facturada	numero_ot	id_cliente

    // $ot_canceladas =  ot_canceladas::where('id', $request->idot)->firstOrFail();
    // $ot_facturadas = new ot_facturadas;

    // $ot_facturadas->fecha_facturada =$fechaActual;
    // $ot_facturadas->id_ot_facturada =$request->idot;
    // $ot_facturadas->numero_ot =$request->numeroot;
    // $ot_facturadas->id_cliente =$clientes->id;


    // $ot_facturadas->timestamps = false;
    // $ot_facturadas->save();

//DATOS DE FACTURACION


    $direcciones =  direcciones::where('id', $clientes->direcciones_id)->firstOrFail();
    $comunas = comunas::where('id', $direcciones->comunas_id)->firstOrFail();
    $servicios_ordenes = servicios_ordenes::showOrdenesServicios($request->idot);


    $gtRut = explode('-', $clientes->rut);
    $rutSinGuion =  $gtRut[0];

    // $opcion= "factura";
    $opcion = $request->opcion_dte;


    if($opcion == "boleta"){

     $nombreDteGenerado =   $this->crearDTE($clientes->rut, $clientes->razon_social	,  $giroActual,$direcciones->nombre,$comunas->des_comuna,$servicios_ordenes,$ordenes_trabajos->descuento_pesos,$opcion);
    }else if($opcion == "factura"){

        $nombreDteGenerado =   $this->crearDTEFactura($clientes->rut, $clientes->razon_social	,  $giroActual,$direcciones->nombre,$comunas->des_comuna,$servicios_ordenes,$ordenes_trabajos->descuento_pesos,$opcion);

    }


//PARAGUARDAR LOS DATOS DE LA ORFACUTARADA

$ot_facturadas = new ot_facturadas;

$ot_facturadas->fecha_facturada =$fechaActual;
$ot_facturadas->id_ot_facturada =$request->idot;
$ot_facturadas->numero_ot =$request->numeroot;
$ot_facturadas->id_cliente =$clientes->id;
$ot_facturadas->estado =1;
$ot_facturadas->comentario	  = "en proceso de creacion dte";

        if($opcion == "boleta"){
            $ot_facturadas->boleta =1;
            $ot_facturadas->url_dte_boleta="orginales".$nombreDteGenerado.".txt";


        }else if($opcion == "factura"){
            $ot_facturadas->factura =1;
            $ot_facturadas->url_dte_factura ="orginales".$nombreDteGenerado.".txt";

        }

    $ot_facturadas->timestamps = false;
    $ot_facturadas->save();



    $cl =base64_encode("nebio1");


    $total =base64_encode( $ordenes_trabajos->total_con_descuentos."");
    $roundTotalFactura = round($ordenes_trabajos->total_con_descuentos);
    $totalFactura =base64_encode( $roundTotalFactura."");


    $ids=base64_encode($request->idot."");
    $rr=base64_encode( $rutSinGuion."");
    $name_txt =base64_encode( "https://sistema.nebiolo.cl/dte/orginales".$nombreDteGenerado.".txt");
    $ot=base64_encode($ordenes_trabajos->numero_ot."");



    if($opcion == "boleta"){

        $url='https://iretail.cl/emision_dte/boletaexterna.php?cl='.$cl.'&ids='.$ids.'&txt='.$name_txt.'&mnt='.$total.'&ot='.$ot;

    }else if($opcion == "factura"){

        $url = 'https://iretail.cl/emision_dte/facturaexterna.php?cl='.$cl.'&total='.$totalFactura.'&ids='.$ids.'&rr='.$rr.'&txt='.$name_txt.'&ot='.$ot;

    }else if($opcion == "guia"){

        $url = 'https://iretail.cl/emision_dte/guiaexterna.php?cl='.$cl.'&total='.$total.'&ids='.$ids.'&rr='.$rr.'&txt='.$name_txt;

    }


    return redirect('/ordendetrabajo')->with([
        'mensaje' => 'Orden Realizada',
        'url' => $url
    ]);

    // ot_canceladas

    // {"_token":"chKsHewqSVQ1emRV9JjjRXZ17gOTWMwDaqd0PmZQ","motivocancelacion":"asdafff","numeroot":"36"}


    return redirect::back()->with('mensaje', 'Ot Cancelada!');

}

public function retirarot(Request $request){


     $numeroOt = ordenes_trabajos::ObtenerNumeroOt($request->idOtRetirar);



    $fechaActualSinFormato = Carbon::now();
    $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');

    // $retiros_ots =  retiros_ots::where('id', $request->idot)->firstOrFail();
    $retiros_ots = new retiros_ots;
    $retiros_ots->nombre = $request->nombre_retira;
    $retiros_ots->rut = $request->rut_retira;
    $retiros_ots->telefono = $request->telefono_retira;
    $retiros_ots->numero_ot = $numeroOt;
    $retiros_ots->fecha_retiro = $fechaActual;
    $retiros_ots->comentario = $request->comentario_retira;

    $retiros_ots->timestamps = false;
    $retiros_ots->save();

    return redirect::back()->with('mensaje', 'Ot Retirada');


}

public function cancelarot(Request $request){



    $fechaActualSinFormato = Carbon::now();
    $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');


    $ordenes_trabajos =  ordenes_trabajos::where('id', $request->idot)->firstOrFail();
    $ordenes_trabajos->estado_orden_trabajo_id = 4; //cancelada
    $ordenes_trabajos->timestamps = false;
    $ordenes_trabajos->save();


    // $ot_canceladas =  ot_canceladas::where('id', $request->idot)->firstOrFail();
    $ot_canceladas = new ot_canceladas;

    $ot_canceladas->fecha_cancelada =$fechaActual;
    $ot_canceladas->numero_ot =$request->numeroot;
    $ot_canceladas->motivo_cancelacion =$request->motivocancelacion ?? "No registra comentario";

    $ot_canceladas->timestamps = false;
    $ot_canceladas->save();

    // ot_canceladas

    // {"_token":"chKsHewqSVQ1emRV9JjjRXZ17gOTWMwDaqd0PmZQ","motivocancelacion":"asdafff","numeroot":"36"}


    return redirect::back()->with('mensaje', 'Ot Cancelada!');

}
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($idCliente)
    {



        try {
            $idCliente = Crypt::decryptString($idCliente);
        } catch (DecryptException $e) {
            //
            return "No Puede Realizar Esta Accion";
        }

        $servicios =   servicios::todosLosServicios();

        $cliente =   clientes::datosDelCliente($idCliente);
        $operarios =   User::datosOperarios();
        $repuestos =   repuestos::select("repuestos.*","categorias.nombre as categoria")->join("categorias","categorias.id","=","repuestos.id_categoria")->get();
        $medios_pagos =   medios_pagos::all();
        $equipos = equipos::select("equipos.*")
        ->join("cliente_equipos","cliente_equipos.equipos_id","=","equipos.id")
        ->where("cliente_equipos.clientes_id","=",$idCliente)->get();
        $combustibles = combustibles::all();

        return view('ordenesdetrabajo/createandedit',compact("combustibles","equipos","medios_pagos","idCliente","cliente",'servicios','operarios','repuestos'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */



     public function editandostore(Request $req){

        return DB::transaction(function () use ($req) {

                        $idTableOt  = $req->idOrdenTrabajo;
                        $numeroDelaOt =  $req->numeroOt;
                        $fechaActualSinFormato = Carbon::now();
                        $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');

                        $update_ordenes_trabajos =  ordenes_trabajos::where('id', $idTableOt)->firstOrFail();
                        $update_ordenes_trabajos->fecha_modificacion	  =$fechaActual;
                        $update_ordenes_trabajos->historial_ot	  ="modificada";
                        $update_ordenes_trabajos->timestamps = false;
                       $update_ordenes_trabajos->save();


                //creamos una nueva orden de trabajo
                //datos de la ot
                            //   return $req->arrayDatosTabla;
                $user = Auth::user();
                $dataPrecios= $this->cacularPrecios($req->arrayDatosTabla,$req->input_descuento,$req->input_abono);

                $descuento = $dataPrecios["descuentoT"] ;
                                $nuevo_registro = $update_ordenes_trabajos->replicate();

             $nuevo_registro->fecha_ingreso	  =$fechaActual;
             $nuevo_registro->fecha_entrega	  =$req->fecha_entrega;
             $nuevo_registro->eliminado	  =0;
             $nuevo_registro->observacion	  =$req->comentario;
             $nuevo_registro->fecha_modificacion	  =null;



             $nuevo_registro->abono	  =$req->input_abono; //falta
             $nuevo_registro->sub_total	  =$dataPrecios["sub_total"];;
             $nuevo_registro->iva	  =$dataPrecios["impuesto"];;
             $nuevo_registro->total	  =$dataPrecios["total"];;
             $nuevo_registro->descuento_pesos	   =$dataPrecios["descuentoT"];;
             $nuevo_registro->total_con_descuentos	   =$dataPrecios["totalcondescuento"];;
             $nuevo_registro->impuesto_al_descuento		   =$dataPrecios["impuestototal"];;
             $nuevo_registro->neto_descuentos		   =$dataPrecios["neto_descuentos"];;
             $nuevo_registro->pendiente	  =$dataPrecios["pendiente"];;
             $nuevo_registro->descuento_porcentaje	  =$req->input_descuento;
            //  $nuevo_registro->neto	  =$dataPrecios["neto"];;
            //  $nuevo_registro->sub_total	  =$dataPrecios["sub_total"];;


            //  $nuevo_registro->iva	  =$dataPrecios["iva"];;
            //  $nuevo_registro->total	  =$dataPrecios["total"];;
            //  $nuevo_registro->pendiente	  =$dataPrecios["pendiente"];;


            //  $nuevo_registro->abono	  =$req->input_abono; //falta
            //  $nuevo_registro->neto	  =$dataPrecios["neto"];;
            //  $nuevo_registro->iva	  =$dataPrecios["iva"];;
            //  $nuevo_registro->total	  =$dataPrecios["totalConAbono"];;
            //  $nuevo_registro->descuento_pesos	  =$descuento;
            //  $nuevo_registro->descuento_porcentaje	  =$req->input_descuento;
             $nuevo_registro->fecha_creacion_registro	  =$fechaActual;
            //  $nuevo_registro->estado_orden_trabajo_id	  =1; //Ingresada
             $nuevo_registro->sucursales_id	  =$user->sucursales_id;
             $nuevo_registro->users_registra_id	  =$user->id;
             $nuevo_registro->numero_ot	  = $numeroDelaOt; //es el primero que se inserta
             $nuevo_registro->historial_ot		  ="activo"; //es el primero que se inserta
             $nuevo_registro->timestamps = false;
              $nuevo_registro->save();

             //actualizamos los servicios

            $servicios = json_decode($req->arrayDatosTabla, true);

            if (empty($servicios)) {
            } else {

                foreach ($servicios as $servicio) {

                        $resultado = DB::table('ordenesmasservicios')
                        ->join('servicios_ordenes', 'ordenesmasservicios.servicios_ordenes_id', '=', 'servicios_ordenes.id')
                        ->where('servicios_ordenes.servicios_id', $servicio['id'])
                        ->where('ordenesmasservicios.ordenes_trabajos_id', $idTableOt)
                        ->select('servicios_ordenes.id','servicios_ordenes.cantidad')
                        ->first();

                    if ($resultado) {

                        $serviciosOrdenesId = $resultado->id;

                        $ordenesmasservicios = new ordenesmasservicios;
                        $ordenesmasservicios->ordenes_trabajos_id = $nuevo_registro->id;
                        $ordenesmasservicios->servicios_ordenes_id = $serviciosOrdenesId;
                        $ordenesmasservicios->cantidad_servicios =$servicio['cantidad'];
                        $ordenesmasservicios->precio_unidad =$servicio['precio_neto'];
                        $ordenesmasservicios->descripcion =$servicio['descripcionservicio'];

                        $ordenesmasservicios->precio_neto_total =$servicio['total'];
                        $ordenesmasservicios->impuesto =$servicio['total'] * 0.19;
                        $ordenesmasservicios->precio_total	 =$ordenesmasservicios->precio_neto_total +  $ordenesmasservicios->impuesto;


                        $ordenesmasservicios->timestamps = false;
                       $ordenesmasservicios->save();



                    //    if($resultado->cantidad <> $servicio['cantidad']){

                    //         $servicios_ordenes =  servicios_ordenes::where('id', $resultado->id)->firstOrFail();
                    //         $servicios_ordenes->cantidad  =$servicio['cantidad'];
                    //         $servicios_ordenes->timestamps = false;
                    //         $servicios_ordenes->save();

                    //    }

                        // Aquí tienes la ID de la tabla servicios_ordenes
                    } else {
                        // No se encontraron registros que cumplan ambas condiciones
                        $servicios_ordenes = new servicios_ordenes;
                        $servicios_ordenes->servicios_id		  =$servicio['id'];
                        $servicios_ordenes->cantidad		  =$servicio['cantidad'];
                        $servicios_ordenes->fecha_solicitado	  =$fechaActual;
                     //    $servicios_ordenes->ordentes_trabajos_id =$ordenes_trabajos->id;
                        $servicios_ordenes->finalizado ="no";
                        $servicios_ordenes->timestamps = false;
                        $servicios_ordenes->principal ="si";
                        $servicios_ordenes->estado_servicio_historial ="activo";
                        // $servicios_ordenes->precio_unidad =$servicio['precio_neto'];
                        // $servicios_ordenes->precio_neto_total =$servicio['total'];
                        // $servicios_ordenes->impuesto =$servicio['total'] * 0.19;
                        // $servicios_ordenes->precio_total	 =$servicios_ordenes->precio_neto_total +  $servicios_ordenes->impuesto;
                        $servicios_ordenes->save();


                        $ordenesmasservicios = new ordenesmasservicios;
                        $ordenesmasservicios->ordenes_trabajos_id = $nuevo_registro->id;
                        $ordenesmasservicios->servicios_ordenes_id = $servicios_ordenes->id;
                        $ordenesmasservicios->timestamps = false;
                        $ordenesmasservicios->precio_unidad =$servicio['precio_neto'];
                        $ordenesmasservicios->descripcion =$servicio['descripcionservicio'];

                        $ordenesmasservicios->cantidad_servicios =$servicio['cantidad'];
                        $ordenesmasservicios->precio_neto_total =$servicio['total'];
                        $ordenesmasservicios->impuesto =$servicio['total'] * 0.19;
                        $ordenesmasservicios->precio_total	 =$servicios_ordenes->precio_neto_total +  $servicios_ordenes->impuesto;


                        $ordenesmasservicios->timestamps = false;

                        $ordenesmasservicios->save();

                        $ejecutar_servicios = new ejecutar_servicios;
                        $ejecutar_servicios->descripcion		  ="solicitud ingresada";
                        $ejecutar_servicios->estado		  =0;
                        $ejecutar_servicios->servicios_ordenes_id	  =$servicios_ordenes->id;
                        $ejecutar_servicios->tecnicos_id =1; //lo agregamos a un tecnico invisble
                        $ejecutar_servicios->fecha_ingreso	  =$fechaActual;

                        // $ejecutar_servicios->fecha_ejecucion ="no";
                        // $ejecutar_servicios->fecha_finalzado ="no";
                        $ejecutar_servicios->estado_ejecucion_id =1; // ingresada


                        $ejecutar_servicios->timestamps = false;
                        $ejecutar_servicios->save();


                        $historial_ot_servicios = new historial_ot_servicios;
                        $historial_ot_servicios->fecha_ingresado =  $fechaActual;
                        $historial_ot_servicios->descripcion ="solicitud ingresada";
                        $historial_ot_servicios->servicios_ordenes_id  =$servicios_ordenes->id;

                        $historial_ot_servicios->timestamps = false;
                        $historial_ot_servicios->save();
                    }


                }



             }


            //  REPUESTOS
                    $repuestos = json_decode($req->arrayDatosTablaRepuestos, true);
                    if (empty($repuestos)) {
                    } else {

                            // Recorrer el arreglo de repuestos
                            foreach ($repuestos as $repuesto) {



                        $resultado = DB::table('ordenesmasrepuestos')
                        ->join('repuestos_solicitados', 'ordenesmasrepuestos.repuestos_solicitados_id', '=', 'repuestos_solicitados.id')
                        ->where('repuestos_solicitados.repuestos_id', $repuesto['id'])
                        ->where('ordenesmasrepuestos.ordenes_trabajos_id', $idTableOt)
                        ->select('repuestos_solicitados.id')
                        ->first();

                                if ($resultado) {

                                      $repuestosIdSolicitados = $resultado->id;

                                        $ordenesmasrepuestos = new ordenesmasrepuestos;
                                        $ordenesmasrepuestos->ordenes_trabajos_id = $nuevo_registro->id;
                                        $ordenesmasrepuestos->repuestos_solicitados_id = $repuestosIdSolicitados;
                                        $ordenesmasrepuestos->cantidad		  =$repuesto['cantidad'];
                                        // $ordenesmasrepuestos->id_medida		  =$repuesto['valor'];
                                        if($repuesto['nombre'] == "OTRO"){
                                            $getDataMedida =  repuestos_medidas::select("id")->where('medida', "MEDIDAOTRO")->get();
                                            $idMedida = $getDataMedida[0]->id;
                                            $ordenesmasrepuestos->descripcion_medida_otro =$repuesto["descripcion_medida_otro"];
                                            $ordenesmasrepuestos->id_medida		  =$idMedida;
                                                // MEDIDAOTRO
                                            }else{
                                                $ordenesmasrepuestos->id_medida		  =$repuesto['valor'];


                                            }

                                        $ordenesmasrepuestos->timestamps = false;
                                         $ordenesmasrepuestos->save();
                                    // echo "si";
                                }else{
                                    $repuestos_solicitados = new repuestos_solicitados;
                                    $repuestos_solicitados->recibido		  ="no";

                                    if($repuesto['nombre'] == "OTRO"){
                                        $getDatosRepuestos =  repuestos::select("id")->where('nombre', $repuesto['nombre'])->get();
                                        $idRespuestoOtros = $getDatosRepuestos[0]->id;

                                        $repuestos_solicitados->repuestos_id		  =$idRespuestoOtros;
                                        $repuestos_solicitados->descripcion_repuestos_otro = $repuesto['descripcion_repuestos_otro'];
                                    }else{
                                         $repuestos_solicitados->repuestos_id		  =$repuesto['id'];

                                    }


                                    // $repuestos_solicitados->repuestos_id		  =$repuesto['id'];
                                    $repuestos_solicitados->fecha_solicitada	  =$fechaActual;
                                    $repuestos_solicitados->comentario = "";
                                 //    $repuestos_solicitados->ordenes_trabajos_id =$ordenes_trabajos->id;
                                    $repuestos_solicitados->estado_repuesto_historial ="activo";
                                    $repuestos_solicitados->principal ="si";
                                    $repuestos_solicitados->timestamps = false;
                                    $repuestos_solicitados->save();

                                    $ordenesmasrepuestos = new ordenesmasrepuestos;

                                    if($repuesto['nombre'] == "OTRO"){
                                        $getDataMedida =  repuestos_medidas::select("id")->where('medida', "MEDIDAOTRO")->get();
                                        $idMedida = $getDataMedida[0]->id;
                                        $ordenesmasrepuestos->descripcion_medida_otro =$repuesto["descripcion_medida_otro"];
                                        $ordenesmasrepuestos->id_medida		  =$idMedida;
                                            // MEDIDAOTRO
                                        }else{
                                            $ordenesmasrepuestos->id_medida		  =$repuesto['valor'];


                                        }

                                    $ordenesmasrepuestos->ordenes_trabajos_id =$nuevo_registro->id;
                                    $ordenesmasrepuestos->cantidad		  =$repuesto['cantidad'];
                                    // $ordenesmasrepuestos->id_medida		  =$repuesto['valor'];

                                    $ordenesmasrepuestos->repuestos_solicitados_id =$repuestos_solicitados->id;
                                    $ordenesmasrepuestos->timestamps = false;
                                    $ordenesmasrepuestos->save();
                                }


                            }

                    }

                    return redirect()->route('ordendetrabajo')->with('mensaje', 'Operación exitosa!')->with('idOT', $nuevo_registro->id);

        return redirect()->route('ordendetrabajo')->with('mensaje', 'Operación exitosa!');
        }, 5);

        $fechaActualSinFormato = Carbon::now();
        $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');

        $repuestos = json_decode($req->arrayDatosTablaRepuestos, true);
        $dataPrecios= $this->cacularPrecios($req->arrayDatosTabla);
        $descuento = ($dataPrecios["neto"] * $req->input_descuento) / 100;

        if (empty($repuestos)) {
        } else {
            // echo "ID: " . $repuesto['id'] . "<br>";

            // Recorrer el arreglo de repuestos
            foreach ($repuestos as $repuesto) {


                // $repuesto['id'] es la id del repuesto solicitado
                $getDataRespuestos = repuestos_solicitados::where('ordenes_trabajos_id', $ordenOt)
                        ->where('repuestos_id', $repuesto['id'])->where('estado_repuesto_historial', 'activo')->first();




                 if ($getDataRespuestos) {

                    $getDataRespuestos->estado_repuesto_historial ="desactivado";
                    $getDataRespuestos->fecha_modificado =$fechaActual;

                        $getDataRespuestos->timestamps = false;
                         $getDataRespuestos->save();
                 }


                     $repuestos_solicitados = new repuestos_solicitados;
                     $repuestos_solicitados->recibido		  ="no";
                     $repuestos_solicitados->repuestos_id		  =$repuesto['id'];
                     $repuestos_solicitados->cantidad		  =$repuesto['cantidad'];
                     $repuestos_solicitados->fecha_solicitada	  =$fechaActual;
                     $repuestos_solicitados->estado_repuesto_historial ="activo";
                     $repuestos_solicitados->fecha_modificado =$fechaActual;
                     $repuestos_solicitados->principal ="no";

                     $repuestos_solicitados->comentario = "";
                     $repuestos_solicitados->ordenes_trabajos_id =$ordenOt;
                     $repuestos_solicitados->timestamps = false;
                     $repuestos_solicitados->save();




            }
        }

        //servicios
        $servicios = json_decode($req->arrayDatosTabla, true);

        if (empty($servicios)) {
        } else
        {




//no
            foreach ($servicios as $servicio)
            {


                $getDataServicios = servicios_ordenes::where('ordentes_trabajos_id', $ordenOt)
                ->where('servicios_id', $servicio['id'])->where('estado_servicio_historial', 'activo')->first();

                        if ($getDataServicios) {


                            $getDataServicios->estado_servicio_historial ="desactivado";
                            $getDataServicios->fecha_modificado =$fechaActual;
                            $getDataServicios->timestamps = false;
                            $getDataServicios->save();

                        }


                                $servicios_ordenes = new servicios_ordenes;
                                $servicios_ordenes->servicios_id		  =$servicio['id'];
                                $servicios_ordenes->cantidad		  =$servicio['cantidad'];
                                $servicios_ordenes->fecha_solicitado	  =$fechaActual;
                                $servicios_ordenes->ordentes_trabajos_id =$ordenOt;
                                $servicios_ordenes->principal ="no";  //es una edicion, por lo que ya no corresponde a la original
                                $servicios_ordenes->estado_servicio_historial ="activo";
                                $servicios_ordenes->precio_unidad =$servicio['precio_neto'];
                                $servicios_ordenes->precio_neto_total =$servicio['total'];
                                $servicios_ordenes->impuesto =$servicio['total'] * 0.19;
                                $servicios_ordenes->precio_total	 =$servicios_ordenes->precio_neto_total +  $servicios_ordenes->impuesto;
                                $servicios_ordenes->finalizado ="no";
                                $servicios_ordenes->timestamps = false;
                                $servicios_ordenes->save();



                                $ejecutar_servicios = new ejecutar_servicios;
                                $ejecutar_servicios->descripcion		  ="solicitud ingresada";
                                $ejecutar_servicios->estado		  =0;
                                $ejecutar_servicios->servicios_ordenes_id	  =$servicios_ordenes->id;
                                $ejecutar_servicios->tecnicos_id =1; //lo agregamos a un tecnico invisble
                                $ejecutar_servicios->fecha_ingreso	  =$fechaActual;

                                // $ejecutar_servicios->fecha_ejecucion ="no";
                                // $ejecutar_servicios->fecha_finalzado ="no";
                                $ejecutar_servicios->estado_ejecucion_id =1; // ingresada


                                $ejecutar_servicios->timestamps = false;
                                $ejecutar_servicios->save();


                                $historial_ot_servicios = new historial_ot_servicios;
                                $historial_ot_servicios->fecha_ingresado =  $fechaActual;
                                $historial_ot_servicios->descripcion ="solicitud ingresada";
                                $historial_ot_servicios->servicios_ordenes_id  =$servicios_ordenes->id;

                                $historial_ot_servicios->timestamps = false;
                                $historial_ot_servicios->save();

            }

        }


         $ordenes_trabajos =  ordenes_trabajos::where('id', $req->numeroOt)->firstOrFail();
         $ordenes_trabajos->fecha_entrega	  =$req->fecha_entrega;
         $ordenes_trabajos->abono	  =$req->input_abono; //falta
         $ordenes_trabajos->neto	  =$dataPrecios["neto"];;
         $ordenes_trabajos->iva	  =$dataPrecios["iva"];;
         $ordenes_trabajos->total	  =$dataPrecios["total"];;
         $ordenes_trabajos->descuento_pesos	  =$descuento;
         $ordenes_trabajos->descuento_porcentaje	  =$req->input_descuento;
          $ordenes_trabajos->timestamps = false;
         $ordenes_trabajos->save();

         $ordenes_trabajos_id = $ordenes_trabajos->id;

            // Buscar el último registro con el mismo ordenes_trabajos_id
            $ultimo_registro = historial_total_ots::where('ordenes_trabajos_id', $ordenes_trabajos_id)
                ->orderBy('id', 'desc') // Ordenar por id en orden descendente para obtener el último registro
                ->first();

            if ($ultimo_registro && $ultimo_registro->posicion == 2) {
                // Si existe un registro y la posición es 2, actualiza los campos en lugar de crear uno nuevo
                $ultimo_registro->abono = $req->input_abono;
                $ultimo_registro->neto = $dataPrecios["neto"];
                $ultimo_registro->iva = $dataPrecios["iva"];
                $ultimo_registro->total = $dataPrecios["total"];
                $ultimo_registro->descuento_pesos = $descuento;
                $ultimo_registro->descuento_porcentaje = $req->input_descuento;
                $ultimo_registro->timestamps = false;

                $ultimo_registro->save();
            } else {
                // Si no existe un registro o la posición no es 2, crea un nuevo registro
                $historial_total_ots = new historial_total_ots;
                $historial_total_ots->abono = $req->input_abono;
                $historial_total_ots->ordenes_trabajos_id = $ordenes_trabajos_id;
                $historial_total_ots->fecha_registrado = $fechaActual;
                $historial_total_ots->neto = $dataPrecios["neto"];
                $historial_total_ots->iva = $dataPrecios["iva"];
                $historial_total_ots->total = $dataPrecios["total"];
                $historial_total_ots->descuento_pesos = $descuento;
                $historial_total_ots->posicion = 2; // Nueva posición
                $historial_total_ots->descuento_porcentaje = $req->input_descuento;
                $historial_total_ots->timestamps = false;
                $historial_total_ots->save();
            }

        //  $historial_total_ots = new historial_total_ots;
        //  $historial_total_ots->abono	  =$req->input_abono; //falta
        //  $historial_total_ots->ordenes_trabajos_id	  =$ordenes_trabajos->id; //falta
        //  $historial_total_ots->fecha_registrado	  =$fechaActual;
        //  $historial_total_ots->neto	  =$dataPrecios["neto"];;
        //  $historial_total_ots->iva	  =$dataPrecios["iva"];;
        //  $historial_total_ots->total	  =$dataPrecios["total"];;
        //  $historial_total_ots->descuento_pesos	  =$descuento;
        //  $historial_total_ots->posicion	  =2; //es el primero que se inserta

        //  $historial_total_ots->descuento_porcentaje	  =$req->input_descuento;
        //  $historial_total_ots->timestamps = false;
        //  $historial_total_ots->save();



        return redirect::back()->with('mensaje', 'Ot Actualizada!');

}
     public function manualstore(Request $req){


        return DB::transaction(function () use ($req) {


       $idOT = $this->idotService->obtenerProximoIDDisponible();
       $user = Auth::user();;

    $isPresupuesto = "no";

       if (isset($req->sucursal)) {

        // La propiedad 'sucursal' está presente en el objeto $req
        // Puedes realizar acciones adicionales aquí
        $sucursales_id = $req->sucursal;
        // ...
    } else {
        $sucursales_id = $user->sucursales_id;
    }


//VERIFICAR SI ES PRESUPUESTO
    if ($req->has("crear_presupuesto") && $req->input("crear_presupuesto") === "on") {
        $isPresupuesto = "si";

    } else {
        $isPresupuesto = "no";

    }



        $idContactos = "";
        $idClientes = 1 ;//"cliente del sistema que se va a registrar"
        if ($req->has('id_contacto') && $req->id_contacto !== null) {

            $idContactos =$req->id_contacto;

            $idClientes = $idContactos;

            $clientes =  clientes::where('id', $idClientes)->firstOrFail();
            $clientes->razon_social	 = $req->contacto_razon_social;
            $clientes->rut	  = $req->contacto_rut;
            $clientes->giro	  = $req->contacto_giro;
            $clientes->telefono	  = $req->contacto_telefono;
            $clientes->correo	  = $req->contacto_correo;
            $clientes->timestamps = false;
             $clientes->save();


                $direcciones =  direcciones::where('id', $clientes->direcciones_id)->firstOrFail();
                $direcciones->nombre	  = $req->contacto_direccion;
                $direcciones->comunas_id	  = $req->comuna;
                $direcciones->timestamps = false;
                $direcciones->save();






        } else {
            $dataDirecciones=[
                // 'name' => $data['name'],
                'nombre' => $req->contacto_direccion,
                'estado' => 0,
                'regions_id' => $req->region,
                'tipo' => "contacto",
                'comuna'=>$req->comuna

            ];

            $insertDirecciones=  direcciones::crearDireccion($dataDirecciones);


            $contactos = new clientes;
            $contactos->razon_social	 = $req->contacto_razon_social;
            $contactos->rut	  = $req->contacto_rut;
            $contactos->giro	  = $req->contacto_giro;
            $contactos->telefono	  = $req->contacto_telefono;
            $contactos->correo	  = $req->contacto_correo;
            $contactos->sucursales_id	  = $sucursales_id;
            $contactos->eliminado	  = 0;
            $contactos->direcciones_id	  = $insertDirecciones;
            $contactos->timestamps = false;
            $contactos->save();


            $idContactos =$contactos->id;
            $idClientes = $idContactos;

        }



            // La patente o serie no se encuentra en la tabla 'equipos'.
            $equipos_ = new equipos;
            $equipos_->descripcion	  ="";
            $equipos_->modelo	  =$req->equipo_modelo;
            $equipos_->marca	   =$req->equipo_marca;
            $equipos_->motor	  =$req->equipo_motor;
            $equipos_->ano	   =$req->equipo_ano;
            $equipos_->serie	   =$req->equipo_serie;;;
            $equipos_->combustible_id	  =$req->combustible;
            $equipos_->patente	  =$req->equipo_patente;

            // $equipos_->clientes_id	  =$idClientes;
            $equipos_->timestamps = false;
            $equipos_->save();

            $idEquipo = $equipos_->id;

            $cliente_equipos = new cliente_equipos;
            $cliente_equipos->equipos_id	  =$equipos_->id;
            $cliente_equipos->clientes_id	  =$idClientes;
            $cliente_equipos->timestamps = false;
            $cliente_equipos->save();

        // }

            //datos de la ot

             $user = Auth::user();
             $dataPrecios= $this->cacularPrecios($req->arrayDatosTabla,$req->input_descuento,$req->input_abono);
             $fechaActualSinFormato = Carbon::now();
             $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');
             $descuento = $dataPrecios["descuentoT"];

             $ordenes_trabajos = new ordenes_trabajos;
             $ordenes_trabajos->responsable	  =$req->responsable;
             $ordenes_trabajos->fecha_ingreso	  =$fechaActual;
             $ordenes_trabajos->fecha_entrega	  =$req->fecha_entrega;
             $ordenes_trabajos->eliminado	  =0;
             $ordenes_trabajos->abono	  =$req->input_abono; //falta


             if($isPresupuesto == "si"){
                     $ordenes_trabajos->ispresupuesto =1;
                     $ordenes_trabajos->estado_orden_trabajo_id	  =7; //presupuesto

             }else{
             $ordenes_trabajos->estado_orden_trabajo_id	  =1; //Ingresada

             }

             $ordenes_trabajos->sub_total	  =$dataPrecios["sub_total"];;
             $ordenes_trabajos->iva	  =$dataPrecios["impuesto"];;
             $ordenes_trabajos->total	  =$dataPrecios["total"];;
             $ordenes_trabajos->descuento_pesos	   =$dataPrecios["descuentoT"];;
             $ordenes_trabajos->total_con_descuentos	   =$dataPrecios["totalcondescuento"];;
             $ordenes_trabajos->impuesto_al_descuento		   =$dataPrecios["impuestototal"];;
             $ordenes_trabajos->neto_descuentos		   =$dataPrecios["neto_descuentos"];;


            //  $ordenes_trabajos->neto	  =$dataPrecios["sub_total"];;


            //  $ordenes_trabajos->iva	  =$dataPrecios["iva"];;
            //  $ordenes_trabajos->total	  =$dataPrecios["total"];;
             $ordenes_trabajos->pendiente	  =$dataPrecios["pendiente"];;


             $ordenes_trabajos->descuento_porcentaje	  =$req->input_descuento;
             $ordenes_trabajos->observacion	  =$req->comentario;
             $ordenes_trabajos->fecha_creacion_registro	  =$fechaActual;
             $ordenes_trabajos->clientes_id	  =$idClientes; //falta
            //  $ordenes_trabajos->contactos_id	  =$idContactos; //falta
             $ordenes_trabajos->sucursales_id	  =$sucursales_id;
             $ordenes_trabajos->users_registra_id	  =$user->id;
             $ordenes_trabajos->operario_id	  =$req->operario;
             $ordenes_trabajos->equipos_id	  =$idEquipo; //falta
             $ordenes_trabajos->numero_ot	  = $idOT; //es el primero que se inserta
             $ordenes_trabajos->historial_ot		  ="activo"; //es el primero que se inserta

              $ordenes_trabajos->timestamps = false;
             $ordenes_trabajos->save();







             if($req->choferselect != null){

                $chofer_equipos = new chofer_equipos;
                $chofer_equipos->ordenes_trabajos_id  =$ordenes_trabajos->id;
                $chofer_equipos->numero_ot  =$idOT;

                $chofer_equipos->users_id   = $req->choferselect;
                $chofer_equipos->fecha  =$fechaActual;
                $chofer_equipos->timestamps = false;
                $chofer_equipos->save();
             }


             $pagos = new pagos;
             $pagos->fecha		  =$fechaActual;
             $pagos->motivo		  ="abono";
             $pagos->numero_ot		 = $idOT;


             $pagos->total		  =$req->input_abono;
             $pagos->ordenes_trabajos_id	  =$ordenes_trabajos->id;
             if($req->input_abono == 0){
                 $pagos->medios_pagos_id  =1; //como es cero, lo dejamos como que pagaron con efectivo

             }else{
                 $pagos->medios_pagos_id  =$req->input_metodopago;

             }
             $pagos->timestamps = false;
             $pagos->save();




       $repuestos = json_decode($req->arrayDatosTablaRepuestos, true);

       // Verificar si el arreglo está vacío o contiene datos
       if (empty($repuestos)) {
       } else {
           // echo "ID: " . $repuesto['id'] . "<br>";

           // Recorrer el arreglo de repuestos
           foreach ($repuestos as $repuesto) {


//  return $repuesto["medidaOtro"];
            $getDatosRepuestos =  repuestos::select("id")->where('nombre', $repuesto['nombre'])->get();
                 $idRespuestoOtros = $getDatosRepuestos[0]->id;

            // if($nameRepuestos == "OTRO"){
            //     descripcion_repuestos_otro
            // }


               $repuestos_solicitados = new repuestos_solicitados;
               $repuestos_solicitados->recibido		  ="no";

               if($repuesto['nombre'] == "OTRO"){
                  $repuestos_solicitados->repuestos_id		  =$idRespuestoOtros;
                  $repuestos_solicitados->descripcion_repuestos_otro = $repuesto['descripcionOtro'];
              }else{
                   $repuestos_solicitados->repuestos_id		  =$repuesto['id'];

              }

// return $repuestos_solicitados;
               // $repuestos_solicitados->fecha_recibida	  =$ordenes_trabajos->id;
               $repuestos_solicitados->fecha_solicitada	  =$fechaActual;
               $repuestos_solicitados->comentario = "";
            //    $repuestos_solicitados->ordenes_trabajos_id =$ordenes_trabajos->id;
               $repuestos_solicitados->estado_repuesto_historial ="activo";
               $repuestos_solicitados->principal ="si";
               $repuestos_solicitados->timestamps = false;
               $repuestos_solicitados->save();



               // ORDENES MAS RESPUESTAS
               $ordenesmasrepuestos = new ordenesmasrepuestos;

               if($repuesto['nombre'] == "OTRO"){
                $getDataMedida =  repuestos_medidas::select("id")->where('medida', "MEDIDAOTRO")->get();
                $idMedida = $getDataMedida[0]->id;
                $ordenesmasrepuestos->descripcion_medida_otro =$repuesto["medidaOtro"];
                $ordenesmasrepuestos->id_medida		  =$idMedida;
                    // MEDIDAOTRO
                }else{
                    $ordenesmasrepuestos->id_medida		  =$repuesto['valor'];


                }



               $ordenesmasrepuestos->ordenes_trabajos_id =$ordenes_trabajos->id;
               $ordenesmasrepuestos->repuestos_solicitados_id =$repuestos_solicitados->id;
               $ordenesmasrepuestos->cantidad		  =$repuesto['cantidad'];

               $ordenesmasrepuestos->timestamps = false;
               $ordenesmasrepuestos->save();


           }
       }




       $servicios = json_decode($req->arrayDatosTabla, true);

       // Verificar si el arreglo está vacío o contiene datos
       if (empty($servicios)) {
       } else {
           // echo "ID: " . $repuesto['id'] . "<br>";

           // Recorrer el arreglo de servicios
           foreach ($servicios as $servicio) {

               $servicios_ordenes = new servicios_ordenes;
               $servicios_ordenes->servicios_id		  =$servicio['id'];
               $servicios_ordenes->cantidad		  =$servicio['cantidad'];
               $servicios_ordenes->fecha_solicitado	  =$fechaActual;
            //    $servicios_ordenes->ordentes_trabajos_id =$ordenes_trabajos->id;
               $servicios_ordenes->finalizado ="no";
               $servicios_ordenes->timestamps = false;
               $servicios_ordenes->principal ="si";
               $servicios_ordenes->estado_servicio_historial ="activo";
            //    $servicios_ordenes->precio_unidad =$servicio['precio_neto'];
            //    $servicios_ordenes->precio_neto_total =$servicio['total'];
            //    $servicios_ordenes->impuesto =$servicio['total'] * 0.19;
            //    $servicios_ordenes->precio_total	 =$servicios_ordenes->precio_neto_total +  $servicios_ordenes->impuesto;
               $servicios_ordenes->save();


               $ordenesmasservicios = new ordenesmasservicios;
               $ordenesmasservicios->ordenes_trabajos_id = $ordenes_trabajos->id;
               $ordenesmasservicios->servicios_ordenes_id = $servicios_ordenes->id;
               $ordenesmasservicios->precio_unidad =$servicio['precio_neto'];
               $ordenesmasservicios->descripcion =$servicio['descripcion'];


               $ordenesmasservicios->cantidad_servicios =$servicio['cantidad'];
               $ordenesmasservicios->precio_neto_total =$servicio['total'];
               $ordenesmasservicios->impuesto =$servicio['total'] * 0.19;
               $ordenesmasservicios->precio_total	 =$servicios_ordenes->precio_neto_total +  $servicios_ordenes->impuesto;




               $ordenesmasservicios->timestamps = false;

               $ordenesmasservicios->save();


               $ejecutar_servicios = new ejecutar_servicios;
               $ejecutar_servicios->descripcion		  ="solicitud ingresada";
               $ejecutar_servicios->estado		  =0;
               $ejecutar_servicios->servicios_ordenes_id	  =$servicios_ordenes->id;
               $ejecutar_servicios->tecnicos_id =1; //lo agregamos a un tecnico invisble
               $ejecutar_servicios->fecha_ingreso	  =$fechaActual;

               // $ejecutar_servicios->fecha_ejecucion ="no";
               // $ejecutar_servicios->fecha_finalzado ="no";
               $ejecutar_servicios->estado_ejecucion_id =1; // ingresada


               $ejecutar_servicios->timestamps = false;
               $ejecutar_servicios->save();


               $historial_ot_servicios = new historial_ot_servicios;
               $historial_ot_servicios->fecha_ingresado =  $fechaActual;
               $historial_ot_servicios->descripcion ="solicitud ingresada";
               $historial_ot_servicios->servicios_ordenes_id  =$servicios_ordenes->id;

               $historial_ot_servicios->timestamps = false;
               $historial_ot_servicios->save();
           }
       }
    //    route('imprimirot', ['idOT' => $los_datos->id])

       return redirect()->route('ordendetrabajo')->with('mensaje', 'Operación exitosa!')->with('idOT', $ordenes_trabajos->id);

    //    return redirect()->route('ordendetrabajo', ['iot' => $ordenes_trabajos->id])->with('mensaje', 'Operación exitosa!');

       return redirect()->route('ordendetrabajo')->with('mensaje', 'Operación exitosa!');

    }, 5);
     }

    public function store(Request $request)
    {
        // return  $request;
        return DB::transaction(function () use ($request) {
            $idOT = $this->idotService->obtenerProximoIDDisponible();


        $user = Auth::user();

//    return $request->arrayDatosTabla;

        $dataPrecios= $this->cacularPrecios($request->arrayDatosTabla);



        $fechaActualSinFormato = Carbon::now();

        $fechaActual= $fechaActualSinFormato->format('Y-m-d H:i:s');
        $descuento = ($dataPrecios["neto"] * $request->input_descuento) / 100;


        $ordenes_trabajos = new ordenes_trabajos;
        $ordenes_trabajos->fecha_ingreso	  =$fechaActual;
        $ordenes_trabajos->fecha_entrega	  =$request->fecha_entrega;
        $ordenes_trabajos->eliminado	  =0;
        $ordenes_trabajos->abono	  =$request->input_abono;
        $ordenes_trabajos->neto	  =$dataPrecios["neto"];;
        $ordenes_trabajos->iva	  =$dataPrecios["iva"];;
        $ordenes_trabajos->total	  =$dataPrecios["total"];;
        $ordenes_trabajos->descuento_pesos	  =$descuento;
        $ordenes_trabajos->descuento_porcentaje	  =$request->input_descuento;
        $ordenes_trabajos->observacion	  =$request->comentario;
        $ordenes_trabajos->fecha_creacion_registro	  ==$fechaActual;
        $ordenes_trabajos->clientes_id	  =$request->id_cliente;
        $ordenes_trabajos->estado_orden_trabajo_id	  =1; //Ingresada
        $ordenes_trabajos->sucursales_id	  =$user->sucursales_id;
        $ordenes_trabajos->users_registra_id	  =$user->id;
        $ordenes_trabajos->operario_id	  =$request->operario;
        $ordenes_trabajos->equipos_id	  =$request->seleccionaequipo;
        $ordenes_trabajos->modificada	  ="no";

         $ordenes_trabajos->timestamps = false;
        $ordenes_trabajos->save();


        $pagos = new pagos;
        $pagos->fecha		  =$fechaActual;
        $pagos->motivo		  ="abono";
        $pagos->total		  =$request->input_abono;
        $pagos->ordenes_trabajos_id	  =$ordenes_trabajos->id;
        $pagos->numero_ot		 = $idOT;
        if($request->input_abono == 0){
            $pagos->medios_pagos_id  =1; //como es cero, lo dejamos como que pagaron con efectivo

        }else{
            $pagos->medios_pagos_id  =$request->input_metodopago;

        }
        // $pagos->medios_pagos_id  =$request->input_metodopago;
        $pagos->timestamps = false;
       $pagos->save();



       $repuestos = json_decode($request->arrayDatosTablaRepuestos, true);

            // Verificar si el arreglo está vacío o contiene datos
            if (empty($repuestos)) {
            } else {
                // echo "ID: " . $repuesto['id'] . "<br>";

                // Recorrer el arreglo de repuestos
                foreach ($repuestos as $repuesto) {

                    $repuestos_solicitados = new repuestos_solicitados;
                    $repuestos_solicitados->recibido		  ="no";
                    $repuestos_solicitados->repuestos_id		  =$repuesto['id'];
                    $repuestos_solicitados->cantidad		  =$repuesto['cantidad'];
                    // $repuestos_solicitados->fecha_recibida	  =$ordenes_trabajos->id;
                    $repuestos_solicitados->fecha_solicitada	  =$fechaActual;
                    $repuestos_solicitados->comentario = "";
                    $repuestos_solicitados->ordenes_trabajos_id =$ordenes_trabajos->id;
                    $repuestos_solicitados->timestamps = false;
                    $repuestos_solicitados->save();

                }
            }




            $servicios = json_decode($request->arrayDatosTabla, true);

            // Verificar si el arreglo está vacío o contiene datos
            if (empty($servicios)) {
            } else {
                // echo "ID: " . $repuesto['id'] . "<br>";

                // Recorrer el arreglo de servicios
                foreach ($servicios as $servicio) {

                    $servicios_ordenes = new servicios_ordenes;
                    $servicios_ordenes->servicios_id		  =$servicio['id'];
                    $servicios_ordenes->cantidad		  =$servicio['cantidad'];
                    $servicios_ordenes->fecha_solicitado	  =$fechaActual;
                    $servicios_ordenes->ordentes_trabajos_id =$ordenes_trabajos->id;
                    $servicios_ordenes->finalizado ="no";
                    $servicios_ordenes->principal ="si";
                    $servicios_ordenes->estado_servicio_historial ="activo";
                    $servicios_ordenes->precio_unidad ="activo";
                    $servicios_ordenes->precio_neto_total ="activo";


                    // precio_neto_total
                    // impuesto
                    // precio_total
                    $servicios_ordenes->timestamps = false;
                    $servicios_ordenes->save();



                    $ejecutar_servicios = new ejecutar_servicios;
                    $ejecutar_servicios->descripcion		  ="solicitud ingresada";
                    $ejecutar_servicios->estado		  =0;
                    $ejecutar_servicios->servicios_ordenes_id	  =$servicios_ordenes->id;
                    $ejecutar_servicios->tecnicos_id =1; //lo agregamos a un tecnico invisble
                    $ejecutar_servicios->fecha_ingreso	  =$fechaActual;

                    // $ejecutar_servicios->fecha_ejecucion ="no";
                    // $ejecutar_servicios->fecha_finalzado ="no";
                    $ejecutar_servicios->estado_ejecucion_id =1; // ingresada


                    $ejecutar_servicios->timestamps = false;
                    $ejecutar_servicios->save();


                    $historial_ot_servicios = new historial_ot_servicios;
                    $historial_ot_servicios->fecha_ingresado =  $fechaActual;
                    $historial_ot_servicios->descripcion ="solicitud ingresada";
                    $historial_ot_servicios->servicios_ordenes_id  =$servicios_ordenes->id;

                    $historial_ot_servicios->timestamps = false;
                    $historial_ot_servicios->save();
                }
            }


            return redirect()->route('ordendetrabajo')->with('mensaje', 'Operación exitosa!');


        }, 5);
// return $ordenes_trabajos;




        // $ordenes_trabajos->comunas_id	 =$request->comuna;
        // $ordenes_trabajos->tipo	  = "usuario";
        // $ordenes_trabajos->timestamps = false;
        // $ordenes_trabajos->save();
        // return $request->arrayDatosTabla;





    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */

     public function verificarExistencia($array,$tipo){


        $data = json_decode($array, true);
        $total =   0;
        $neto =   0;


        // Verificar si la decodificación fue exitosa
        if ($data !== null) {
    // Recorrer el arreglo
        foreach ($data as $item) {


            // $total = $total + $item['total'];

                }
            } else {
                echo "Error al decodificar JSON.";
            }

            return [
                'total'=> 1,
                'neto'=> 1,
                'iva'=> 0,
            ];
 }
 public function cacularPrecios($servicios,$descuento = "", $abono =""){


    $data = json_decode($servicios, true);
    $total =   0;
    $neto =   0;
    $subtotal = 0;
    $pendiente = 0;

    // Verificar si la decodificación fue exitosa
    if ($data !== null) {
            // Recorrer el arreglo
            foreach ($data as $item) {

                    // echo "Precio neto: " . $item['precio_neto'] . "<br>";
                    // echo "Cantidad: " . $item['cantidad'] . "<br>";
                    //echo "Total: " . $item['total'] . "<br>";
                    $total = $total + $item['total'];
                    $subtotal = $subtotal + ( $item['precio_neto'] * $item['cantidad']);

             }
        } else {
            echo "Error al decodificar JSON.";
        }


        $impuesto = $subtotal * 0.19;
        $total = $subtotal+$impuesto;

        $descuentoT = ($total * $descuento) / 100;
        $totalConDescuento = $total - $descuentoT ;
        $impuestototal =  $totalConDescuento - ($totalConDescuento / 1.19);
        $pendiente = $totalConDescuento-$abono;


        // $totalConAbono =   $totalConDescuento - $abono;
        // $total = $impuesto+$totalConDescuento;

        return [
            'sub_total'=> $subtotal,
            'impuesto'=> $impuesto,
            'total'=> $total,

            'descuentoT'=> $descuentoT,
            'totalcondescuento' => $totalConDescuento,
            'impuestototal' =>$impuestototal,
            'neto_descuentos' =>$totalConDescuento- $impuestototal,

            'abono'=> $abono,
            'pendiente'=> $pendiente,


            // 'total'=> $total,
            // 'neto'=> $totalConDescuento,
            // 'iva'=> $impuesto,



            // 'totalConDescuento'=> $totalConDescuento,
            // 'totalConAbono'=> $totalConAbono,

        ];
}
 public function cacularPreciosDos($servicios,$descuento = "", $abono =""){


    $data = json_decode($servicios, true);
    $total =   0;
    $neto =   0;


    // Verificar si la decodificación fue exitosa
    if ($data !== null) {
// Recorrer el arreglo
    foreach ($data as $item) {

    // echo "Precio neto: " . $item['precio_neto'] . "<br>";
    // echo "Cantidad: " . $item['cantidad'] . "<br>";
        //echo "Total: " . $item['total'] . "<br>";
        $total = $total + $item['total'];
        $neto = $neto + ( $item['precio_neto'] * $item['cantidad']);

            }
        } else {
            echo "Error al decodificar JSON.";
        }


        $descuentoT = ($neto * $descuento) / 100;
        $totalConDescuento = $neto -    $descuentoT ;
        $totalConAbono =   $totalConDescuento - $abono;
        $impuesto = $totalConAbono * 0.19;
        return [
            'total'=> $totalConAbono,
            'neto'=> $neto,
            'iva'=> $impuesto,
            'descuentoT'=> $descuentoT,
            'totalConDescuento'=> $totalConDescuento,
            'totalConAbono'=> $totalConAbono,
            'sub_total'=> $neto,

        ];
}
     public function cacularPrecios_old($servicios,$descuento = "", $abono =""){


            $data = json_decode($servicios, true);
            $total =   0;
            $neto =   0;
            $sub_total =   0;



            // Verificar si la decodificación fue exitosa
            if ($data !== null) {
                // Recorrer el arreglo
                    foreach ($data as $item) {

                    //por productos

                        $total = $total + $item['total'];
                        $neto = $neto + ( $item['precio_neto'] * $item['cantidad']);



                    }


                } else {
                    echo "Error al decodificar JSON.";
                }

                //los servicios vienen con impuesto incluido
                $sub_total_Impuesto = $neto * 0.19;
                $sub_total = $neto - $sub_total_Impuesto ;
                $descuentoT = ($sub_total * $descuento) / 100;
                $totalConDescuento = $sub_total -    $descuentoT ;

                $totalConAbono =   $totalConDescuento - $abono;

                $totalVenta = $totalConDescuento + $sub_total_Impuesto;

                $impuesto = $totalConDescuento * 0.19;
                return [
                    'sub_total_Impuesto' => $sub_total_Impuesto,
                    'total'=> $totalVenta,
                    'neto'=> $totalConDescuento,
                    'sub_total'=> $sub_total,



                    'iva'=> $impuesto,
                    'descuentoT'=> $descuentoT,
                    'totalConDescuento'=> $totalConDescuento,
                    'totalConAbono'=> $totalConAbono,

                ];
     }

     public function editar($id)
     {
//  return $id;numero_ot
         $servicios =   servicios::todosLosServicios();
         $ordenes_trabajos = ordenes_trabajos::OrdenesShowContacto($id);
         $numeroOt =  $ordenes_trabajos[0]->numero_ot;
         $idOrdenTrabajo = $ordenes_trabajos[0]->id;


         $datosdelequipo = ordenes_trabajos::datosdelequipo($id);

         // $cliente =   clientes::datosDelCliente($idCliente);
         $operarios =   User::datosOperarios();
         $repuestos =   repuestos::select("repuestos.*","categorias.nombre as categoria")->join("categorias","categorias.id","=","repuestos.id_categoria")->get();
         $medios_pagos =   medios_pagos::all();
           $descuento_pesos = $ordenes_trabajos[0]->descuento_pesos;
         $servicios_ordenes = servicios_ordenes::EditOrdenesServicios($id);
         $tecnicos = User::datosTecnicoUserAll();

          $repuestos_solicitados = repuestos_solicitados::showOrdenesRepuestos($id);

          $repuestos_medidas = repuestos_medidas::all();



         return view('ordenesdetrabajo/editot',compact("descuento_pesos","repuestos_medidas","idOrdenTrabajo","datosdelequipo","repuestos_solicitados","tecnicos","servicios_ordenes","numeroOt","ordenes_trabajos","medios_pagos",'servicios','operarios','repuestos'));


         return  $id;
         //
     }


      public function showhistorial($id)
    {

        $servicios =   servicios::todosLosServicios();

      $ordenes_trabajos = ordenes_trabajos::OrdenesShowContacto($id);


    $numeroOt = $ordenes_trabajos[0]->numero_ot;
        $datosdelequipo = ordenes_trabajos::datosdelequipo($id);

        // $cliente =   clientes::datosDelCliente($idCliente);
        $operarios =   User::datosOperarios();
        $repuestos =   repuestos::select("repuestos.*","categorias.nombre as categoria")->join("categorias","categorias.id","=","repuestos.id_categoria")->get();
        $medios_pagos =   medios_pagos::all();

        $servicios_ordenes = servicios_ordenes::showOrdenesServicios($id);
        $tecnicos = User::datosTecnicoUserAll();

         $repuestos_solicitados = repuestos_solicitados::showOrdenesRepuestos($id);

        $historial = "si";
        //pagosAbono
         $ordenes_trabajos[0]->fecha_modificacion;
        $pagosAbonos = pagos::getBonoHistorial($ordenes_trabajos[0]->fecha_ingreso,$numeroOt,$ordenes_trabajos[0]->fecha_modificacion);
        $datos_facturacion = ot_facturadas::getOtfacturada($numeroOt);
        $datos_canceladas = ot_canceladas::getOtCanceladas($numeroOt);

        $urlFactura = "zxxx";
        $urlBoleta ="fff";

        return view('ordenesdetrabajo/showot',compact("urlFactura","urlBoleta","datos_canceladas","datos_facturacion","pagosAbonos","historial","datosdelequipo","repuestos_solicitados","tecnicos","servicios_ordenes","numeroOt","ordenes_trabajos","medios_pagos",'servicios','operarios','repuestos'));


        return  $id;
        //
    }

    public function show($id)
    {

        $servicios =   servicios::todosLosServicios();
        // $numeroOt = $id;
        $ordenes_trabajos = ordenes_trabajos::OrdenesShowContacto($id);
        $numeroOt =  $ordenes_trabajos[0]->numero_ot;
        $idOrdenTrabajo =  $id;

        $getclientes = clientes::todosLosClientesAll();
        $datosdelequipo = ordenes_trabajos::datosdelequipo($id);

        // $cliente =   clientes::datosDelCliente($idCliente);
        $operarios =   User::datosOperarios();
        $repuestos =   repuestos::select("repuestos.*","categorias.nombre as categoria")->join("categorias","categorias.id","=","repuestos.id_categoria")->get();
        $medios_pagos =   medios_pagos::all();

        $servicios_ordenes = servicios_ordenes::showOrdenesServicios($id);


        if(User::tipoUsuario() == "superadmin" || User::tipoUsuario() == "admin"){
            $tecnicos = User::datosTecnicoUserAll();

        }else{
           $tecnicos = User::datosTecnicoUserAllSucursal(Auth::user()->sucursales_id);

        }


         $repuestos_solicitados = repuestos_solicitados::showOrdenesRepuestos($id);
         $regiones =          regions::orderBy('des_region', 'asc')->get();
         $idREgion =          comunas::select("id_region")->where("id","=",$ordenes_trabajos[0]->comunas_id)->get();

         $comunasporregion  =  comunas::orderBy('des_comuna', 'asc')->where("id_region","=",$idREgion[0]->id_region)->get();
         $comunasporregionTodas  =  comunas::orderBy('des_comuna', 'asc')->get();


         $datos_facturacion = ot_facturadas::getOtfacturada($numeroOt);

        $chofer_equipos = User::GetChoferData($numeroOt);



          $otRetirada =  retiros_ots::where('numero_ot', $numeroOt)->get();

          $Getdatos_dte = datos_dte::all();
    $medios_pagos =   medios_pagos::all();


        return view('ordenesdetrabajo/completandoOt',compact('medios_pagos','comunasporregionTodas','Getdatos_dte',"otRetirada","chofer_equipos","datos_facturacion","comunasporregion","regiones","getclientes","idOrdenTrabajo","datosdelequipo","repuestos_solicitados","tecnicos","servicios_ordenes","numeroOt","ordenes_trabajos","medios_pagos",'servicios','operarios','repuestos'));


        return  $id;
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public  function eliminar_tildes($cadena){

        //Codificamos la cadena en formato utf8 en caso de que nos de errores
        $cadena = utf8_encode($cadena);

        //Ahora reemplazamos las letras
        $cadena = str_replace(
            array('á', 'à', 'ä', 'â', 'ª', 'Á', 'À', 'Â', 'Ä'),
            array('a', 'a', 'a', 'a', 'a', 'A', 'A', 'A', 'A'),
            $cadena
        );

        $cadena = str_replace(
            array('é', 'è', 'ë', 'ê', 'É', 'È', 'Ê', 'Ë'),
            array('e', 'e', 'e', 'e', 'E', 'E', 'E', 'E'),
            $cadena );

        $cadena = str_replace(
            array('í', 'ì', 'ï', 'î', 'Í', 'Ì', 'Ï', 'Î'),
            array('i', 'i', 'i', 'i', 'I', 'I', 'I', 'I'),
            $cadena );

        $cadena = str_replace(
            array('ó', 'ò', 'ö', 'ô', 'Ó', 'Ò', 'Ö', 'Ô'),
            array('o', 'o', 'o', 'o', 'O', 'O', 'O', 'O'),
            $cadena );

        $cadena = str_replace(
            array('ú', 'ù', 'ü', 'û', 'Ú', 'Ù', 'Û', 'Ü'),
            array('u', 'u', 'u', 'u', 'U', 'U', 'U', 'U'),
            $cadena );

        $cadena = str_replace(
            array('ñ', 'Ñ', 'ç', 'Ç'),
            array('n', 'N', 'c', 'C'),
            $cadena
        );
        $cadena = str_replace(
            array('º', '!', '$', '%','"',"'"),
            array('', '', '', '','',''),
            $cadena
        );
        return $cadena;
    }

    public function mombre_aleatorio(){
        $numeroAleatorio = mt_rand(1000, 9999);
        // Obtener la fecha actual con hora y segundos
        $fechaActual = date('Ymd_His');
        // Concatenar el número aleatorio y la fecha
        $nombreArchivo = $fechaActual . '_' . $numeroAleatorio;
        return $nombreArchivo;
    }

}
