<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ordenes_trabajos;
use Illuminate\Support\Facades\Http;
use Carbon\Carbon;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
       $countOtEnproceso = ordenes_trabajos::getCountOt("INICIADA");
       $countOtRecepcionada = ordenes_trabajos::getCountOt("RECEPCIONADA");
       $countOtPendientes = ordenes_trabajos::getCountOt("Activa");

       $countOtPendientesRepuestos = ordenes_trabajos::getCountOtRepuestos();

       $countOtDistinct = ordenes_trabajos::getCountOt("DISTINCT");
       /***********************************************************/
       // Obtener el primer día del mes actual
       $primerDiaDelMes = Carbon::now()->startOfMonth()->format('d-m-Y');

       // Obtener el último día del mes actual
       $ultimoDiaDelMes = Carbon::now()->endOfMonth()->format('d-m-Y');// Formato 'Y-m-d'

       $response = Http::get('http://nebiolo.cl:5905/estadosordenesot/'.base64_encode(1).'/'.base64_encode($primerDiaDelMes.' - '.$ultimoDiaDelMes));
       $dataOt = $response->json()['dataOt'];
       /***********************************************************/


       return view('home',compact("countOtDistinct","countOtEnproceso",'countOtRecepcionada','countOtPendientes','countOtPendientesRepuestos','dataOt'));

    }

    public function gohomeinformes(request $req )
     
    { 
       return view('informes/homeinformes');

       
   }
}
  