<?php

namespace App\Http\Controllers\Configuraciones;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request; 
use App\Models\comunas;
use App\Models\clientes;
use App\Models\contactos;
use App\Models\servicios_ordenes;
use App\Models\ordenes_trabajos;
use DB;

use PDF;

use App\Models\User;

class ConfigController extends Controller
{
    //
    public function buscarComuna(request $req)
    {
       return  comunas::buscarComuna($req->id_region) ;
    }
    public function validarRut_cli(request $req)
    {
        return clientes::validarRutCliente($req->rut);
    }


    public function getRutCliente(request $req)
    {
        return clientes::getRutCliente($req->rut);
    }
    
    public function validarRut_user(request $req)
    {
        return User::validarRutUser($req->rut,$req->idusuario);
    }
    public function validarCorreo_user(request $req)
    {
        return User::validarCorreoUser($req->correo,$req->idusuario);
    }

    public function validarRut_contacto(request $req)
    {
        // return contactos::validarRutContacto($req->rut);
        return clientes::validarRutCliente($req->rut,$req->id_cliente);

    }

    public function imprimirservicios(request $req)
    {



        
        $idOT =  $req->numeroOt;
        $getServicios_ordenes = servicios_ordenes::showOrdenesServiciosPrint($idOT);

         $servicios_ordenes = $getServicios_ordenes['data'];
         $datos_ot = $getServicios_ordenes['ordenes_trabajos'];
       $numerodelaOT=   ordenes_trabajos::ObtenerNumeroOt($idOT);

       // $html = view('imprimir.imprimirservicios')->render(); // Renderiza la vista a HTML
       $html = view('imprimir.imprimirservicios', compact('datos_ot','servicios_ordenes','idOT','numerodelaOT'))->render(); // Pasa el parámetro a la vista

    // Genera una respuesta en formato PDF (requiere la instalación de una biblioteca como Dompdf)
    // O puedes generar una respuesta en formato HTML si no necesitas PDF
    $pdf = PDF::loadHTML($html); // Debes instalar una biblioteca PDF, como Dompdf

    // Descargar el PDF directamente
    // return $pdf->download('servicios.pdf');

    // O mostrar el PDF en el navegador
    return $pdf->stream();
        return $req->numeroOt;
    }
    


    public function obtenerProximoIDDisponible()
    {
        return DB::transaction(function () {
            // Obtener el próximo ID_OT
            $nextID = DB::table('id_ot_tracker')->select('next_id')->lockForUpdate()->first()->next_id;

            // Actualizar el valor del próximo ID_OT
            DB::table('id_ot_tracker')->update(['next_id' => $nextID + 1]);

            return $nextID;
        });
    }
    
}
