const express = require('express');
const mysql = require('mysql2');
const cors = require('cors'); // Importa el middleware cors

const app = express();

// Habilita CORS para todas las solicitudes
app.use(cors());

// Define una ruta para la raíz de tu servicio
app.get('/', (req, res) => {
    const baseDeDatos = "system_nebiolo";
    if (!baseDeDatos) {
        res.status(400).send('Debe proporcionar el nombre de la base de datos.');
        return; // Termina la ejecución de la función si no se proporciona la base de datos
    }

    // Configura la conexión a tu base de datos MySQL
    const connection = mysql.createConnection({
        host: 'localhost',
        user: 'root',
        password: '',
        database: baseDeDatos,
    });

    // Intenta conectar a la base de datos
    connection.connect((err) => {
        if (err) {
            console.error('Error al conectar a la base de datos:', err);
            res.status(500).send('Error al conectar a la base de datos.');
            return;
        }
        console.log('Conexión exitosa a la base de datos MySQL');

        //consulta para la bd
        const consultaSucursales = 'SELECT * FROM `sucursales` WHERE 1';
        const consultaMediosPago = 'SELECT * FROM `medios_pagos` WHERE 1';
        const consultaClientes = 'SELECT * FROM `clientes` WHERE 1';

        // Ejecuta las consultas
        connection.query(consultaSucursales, (errSucursales, resultadosSucursales) => {
            if (errSucursales) {
                console.error('Error al ejecutar la consulta de sucursales:', errSucursales);
                res.status(500).send('Error al ejecutar la consulta de sucursales.');
                return;
            }

            connection.query(consultaMediosPago, (errMediosPago, resultadosMediosPago) => {
                if (errMediosPago) {
                    console.error('Error al ejecutar la consulta de medios de pago:', errMediosPago);
                    res.status(500).send('Error al ejecutar la consulta de medios de pago.');
                    return;
                }

                connection.query(consultaClientes, (errClientes, resultadosClientes) => {
                    if (errClientes) {
                        console.error('Error al ejecutar la consulta de clientes:', errClientes);
                        res.status(500).send('Error al ejecutar la consulta de clientes.');
                        return;
                    }

                    // Combina los resultados de las consultas en un solo objeto
                    const data = {
                        sucursales: resultadosSucursales,
                        medios_pago: resultadosMediosPago,
                        clientes: resultadosClientes
                    };

                    console.log('Resultados de las consultas:', data);
                    res.send(data); // Envía los resultados al cliente

                    // Cierra la conexión cuando hayas terminado
                    connection.end();
                });
            });
        });
    });
});

// Escucha en el puerto 5700
const PORT = process.env.PORT || 5700;
app.listen(PORT, () => {
    console.log(`Servidor escuchando en el puerto ${PORT}`);
});