<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('auth/login');
});

Auth::routes();
Route::group(['middleware' => ['auth']], function () {

            Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');

            //clientess

            Route::get('/clientes', [App\Http\Controllers\Clientes\clientesController::class, 'index'])->name('clientes');
            Route::get('/clientes/crear', [App\Http\Controllers\Clientes\clientesController::class, 'create'])->name('clientes.crear');
            Route::post('/clientes/store', [App\Http\Controllers\Clientes\clientesController::class, 'store'])->name('clientes.store');
            Route::get('/buscar/comunas/{id?}', [App\Http\Controllers\Configuraciones\ConfigController::class, 'buscarComuna'])->name('buscar_comunas');
            Route::get('/validar/rutcliente/{rut?}', [App\Http\Controllers\Configuraciones\ConfigController::class, 'validarRut_cli'])->name('validarrut.clientes');

            //clientes
            Route::post('/clientesaddot', [App\Http\Controllers\Clientes\clientesController::class, 'clientesaddot'])->name('clientesaddot');


            //usuarios
            Route::get('/usuarios', [App\Http\Controllers\Usuarios\usuariosController::class, 'index'])->name('usuarios');
            Route::get('/usuarios/crear', [App\Http\Controllers\Usuarios\usuariosController::class, 'create'])->name('usuarios.crear');
            Route::get('/validar/rutusuarios/{rut?}', [App\Http\Controllers\Configuraciones\ConfigController::class, 'validarRut_user'])->name('validarrut.usuarios');
            Route::get('/validar/correousuarios/{rut?}', [App\Http\Controllers\Configuraciones\ConfigController::class, 'validarCorreo_user'])->name('validarcorreo.usuarios');
            Route::post('/usuarios/store', [App\Http\Controllers\Usuarios\usuariosController::class, 'store'])->name('usuarios.store');



            //servicios
            Route::get('/servicios', [App\Http\Controllers\Servicios\serviciosController::class, 'index'])->name('servicios');
            Route::get('/servicios/crear', [App\Http\Controllers\Servicios\serviciosController::class, 'create'])->name('servicios.crear');
            Route::post('/servicios/store/{rut?}', [App\Http\Controllers\Servicios\serviciosController::class, 'store'])->name('servicios.store');


            //ordenes de trabajo

            Route::get('/ordendetrabajo', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'index'])->name('ordendetrabajo');
            Route::get('/ordendetrabajo/crear/{idcliente?}', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'create'])->name('ordendetrabajo.crear');
            Route::get('/ordendetrabajo/crearsincliente', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'crearsincliente'])->name('ot.crearsincliente');

            Route::post('/ordendetrabajo/store', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'store'])->name('ordendetrabajo.store');
            Route::post('/ordendetrabajo/manualstore', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'manualstore'])->name('ordendetrabajo.manualstore');


                        Route::post('/ordendetrabajo/iniciar', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'iniciar'])->name('ordendetrabajo.iniciar');
                        Route::post('/ordendetrabajo/finalizar', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'finalizar'])->name('ordendetrabajo.finalizar');


            Route::get('/ordendetrabajo/show/{id?}', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'show'])->name('ordendetrabajo.show');


            //actualizar lis servicios
            Route::post('/servicios/updateservicioorden', [App\Http\Controllers\Servicios\serviciosController::class, 'updateservicioorden'])->name('update.updateservicioorden');
            Route::post('/servicios/iniciarservicio', [App\Http\Controllers\Servicios\serviciosController::class, 'iniciarservicio'])->name('update.iniciarservicio');
            Route::get('/servicios/historial/{id?}', [App\Http\Controllers\Servicios\serviciosController::class, 'hisotiralservicios'])->name('historialservicios');

            //actualizar los repuestos
            Route::post('/repuestos/updaterepuestosorden', [App\Http\Controllers\Repuestos\repuestosController::class, 'updatesolicitados'])->name('update.updaterepuestosorden');
            Route::get('/repuestos/historial/{id?}', [App\Http\Controllers\Repuestos\repuestosController::class, 'historialrepuestos'])->name('historialrepuestos');


//crear equipo
// create.equipo
Route::post('/equipos/store', [App\Http\Controllers\Equipos\equipoController::class, 'store'])->name('equipos.store');
            
        });

        Route::get('limpiar', function () {
            // Artisan::call('optimize ')
            Artisan::call('config:clear ');
            Artisan::call('config:cache');
            Artisan::call('view:clear');
            Artisan::call('view:cache');
            Artisan::call('cache:clear');
            // Artisan::call('route:clear');
            // Artisan::call('route:cache');
            //  Artisan::call('storage:link');
        });