<?php

use Illuminate\Support\Facades\Route;

/*
|----------------------------------------- ---------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('auth/login');
});

Auth::routes();
Route::group(['middleware' => ['auth']], function () {

    Route::get('limpiar', function () {
        // Artisan::call('optimize ')
        // Artisan::call('config:clear ');
        // Artisan::call('config:cache');
        // Artisan::call('view:clear');
        // Artisan::call('view:cache');
        // Artisan::call('cache:clear');
         Artisan::call('route:clear');
        //  Artisan::call('route:cache');
        //  Artisan::call('storage:link');
    });

    Route::get('/facturarpruebapablo', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'facturar_prueba_pablo'])->name('facturarpruebapablo');

            Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
            Route::get('/exportar/ordenesdetrabajo', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'exportarot'])->name('exportarOt');
            Route::get('/imprimir/ordenesdetrabajo', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'imprimirordendetrabajo'])->name('imprimirordendetrabajo');
            Route::get('/gohomeinformes', [App\Http\Controllers\HomeController::class, 'gohomeinformes'])->name('gohomeinformes');

            Route::get('/gohomeiframe/{url}', [App\Http\Controllers\HomeController::class, 'gohomeiframe'])->name('gohomeiframe');
            
            //clientess

            Route::get('/clientes', [App\Http\Controllers\Clientes\clientesController::class, 'index'])->name('clientes');
            Route::get('/clientes/crear', [App\Http\Controllers\Clientes\clientesController::class, 'create'])->name('clientes.crear');
            Route::post('/clientes/store', [App\Http\Controllers\Clientes\clientesController::class, 'store'])->name('clientes.store');
            Route::get('/buscar/comunas/{id?}', [App\Http\Controllers\Configuraciones\ConfigController::class, 'buscarComuna'])->name('buscar_comunas');
            Route::get('/validar/rutcliente/{rut?}', [App\Http\Controllers\Configuraciones\ConfigController::class, 'validarRut_cli'])->name('validarrut.clientes');
            Route::get('/validar/getRutCliente/{rut?}', [App\Http\Controllers\Configuraciones\ConfigController::class, 'getRutCliente'])->name('validarrut.getRutCliente');
            
            Route::get('/clientes/editar/{id?}', [App\Http\Controllers\Clientes\clientesController::class, 'editar'])->name('clienteseditar');
            Route::post('/clientes/delet/', [App\Http\Controllers\Clientes\clientesController::class, 'delet'])->name('clientes.delet');
          
            // Route::get('/clientes/misservicios/{id?}', [App\Http\Controllers\Clientes\clientesController::class, 'misservicios'])->name('clientes.misservicios');
            Route::get('/clientes/misservicios/{id?}', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'index'])->name('clientes.misservicios');
            
            //contacto
            Route::get('/validar/rutcontacto/{rut?}', [App\Http\Controllers\Configuraciones\ConfigController::class, 'validarRut_contacto'])->name('validarrut.contacto');

            

            //clientes
            Route::post('/clientesaddot', [App\Http\Controllers\Clientes\clientesController::class, 'clientesaddot'])->name('clientesaddot');


            Route::get('/clientes/consultarrut/{id?}', [App\Http\Controllers\Clientes\clientesController::class, 'consultarrutcliente'])->name('consultarrutcliente');


            //usuarios
            Route::get('/usuarios', [App\Http\Controllers\Usuarios\usuariosController::class, 'index'])->name('usuarios');
            Route::get('/usuarios/crear', [App\Http\Controllers\Usuarios\usuariosController::class, 'create'])->name('usuarios.crear');
            Route::get('/validar/rutusuarios/{rut?}', [App\Http\Controllers\Configuraciones\ConfigController::class, 'validarRut_user'])->name('validarrut.usuarios');
            Route::get('/validar/correousuarios/{rut?}', [App\Http\Controllers\Configuraciones\ConfigController::class, 'validarCorreo_user'])->name('validarcorreo.usuarios');
            Route::post('/usuarios/stores/', [App\Http\Controllers\Usuarios\usuariosController::class, 'store'])->name('usuarios.stores');
            Route::post('/usuarios/delet/', [App\Http\Controllers\Usuarios\usuariosController::class, 'delet'])->name('usuarios.delet');


            Route::POST('/usuarios/getoperarios', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'getoperarios'])->name('getoperarios');

            Route::get('/usuarios/editar/{id?}', [App\Http\Controllers\Usuarios\usuariosController::class, 'editar'])->name('usuarios.editar');

            //servicios
            Route::get('/servicios', [App\Http\Controllers\Servicios\serviciosController::class, 'index'])->name('servicios');
            Route::get('/servicios/crear', [App\Http\Controllers\Servicios\serviciosController::class, 'create'])->name('servicios.crear');
            Route::post('/servicios/store/{rut?}', [App\Http\Controllers\Servicios\serviciosController::class, 'store'])->name('servicios.store');
            Route::post('/servicios/delet/', [App\Http\Controllers\Servicios\serviciosController::class, 'delet'])->name('servicios.delet');
            Route::get('/servicios/editar/{id?}', [App\Http\Controllers\Servicios\serviciosController::class, 'editar'])->name('servicios.editar');

            //REPUESTOS
            Route::get('/repuestos', [App\Http\Controllers\Repuestos\repuestosController::class, 'index'])->name('repuestos');
            Route::post('/repuestos/store', [App\Http\Controllers\Repuestos\repuestosController::class, 'store'])->name('repuestos.store');


            //ordenes de trabajo

            Route::get('/ordendetrabajo', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'index'])->name('ordendetrabajo');
            Route::get('search/ordendetrabajo/{status?}', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'index'])->name('search.ordendetrabajo');
            Route::get('carga/ordendetrabajo/', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'cargaOt'])->name('carga.ordendetrabajo');


            //RETIRA OT
            Route::post('/ordendetrabajo/retirarot', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'retirarot'])->name('ordendetrabajo.retirarot');


                //buscar
                Route::post('search/ot', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'searchOt'])->name('search.ot');
                Route::get('filtrar/ot', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'filtrarOt'])->name('filtrarOt.ot');


            Route::get('/ordendetrabajo/crear/{idcliente?}', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'create'])->name('ordendetrabajo.crear');
            Route::get('/ordendetrabajo/crearsincliente', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'crearsincliente'])->name('ot.crearsincliente');
            Route::get('/ordendetrabajo/pendientesdepago', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'pendientesdepago'])->name('ot.pendientesdepago');
            Route::post('/ordendetrabajo/cambiarmetododepago', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'cambiarmetododepago'])->name('ot.cambiarmetododepago');

            Route::post('/ordendetrabajo/store', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'store'])->name('ordendetrabajo.store');
            Route::post('/ordendetrabajo/imprimirservicios', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'manualstore'])->name('ordendetrabajo.manualstore');
            Route::post('/ordendetrabajo/editandostore', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'editandostore'])->name('ordendetrabajo.editandostore');

//estados


// GET
Route::get ('/ordendetrabajo/iniciarget/{id?}', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'iniciarget'])->name('ordendetrabajo.iniciarget');
Route::get ('/ordendetrabajo/finalizarget/{id?}', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'finalizarget'])->name('ordendetrabajo.finalizarget');

                        Route::post('/ordendetrabajo/iniciar', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'iniciar'])->name('ordendetrabajo.iniciar');
                        Route::post('/ordendetrabajo/finalizar', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'finalizar'])->name('ordendetrabajo.finalizar');
                        Route::post('/ordendetrabajo/cancelarot', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'cancelarot'])->name('ordendetrabajo.cancelarot');
                        Route::post('/ordendetrabajo/facturar', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'facturar'])->name('ordendetrabajo.facturar');

                        Route::get('/ordendetrabajo/recepcionarpresupuesto', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'recepcionarpresupuesto'])->name('ordendetrabajo.recepcionarpresupuesto');



            Route::get('/ordendetrabajo/completar/{id?}', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'show'])->name('ordendetrabajo.show');
            Route::get('/ordendetrabajo/editar/{id?}', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'editar'])->name('ordendetrabajo.editar');
            //Historial OT
            Route::POST('/ordendetrabajo/historial/{id?}', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'historial'])->name('ordendetrabajo.historial');
            Route::get('/ordendetrabajo/showhistorial/{id?}', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'showhistorial'])->name('ordendetrabajo.showhistorial');

            //HISTORIAL ABONOS
            Route::POST('/ordendetrabajo/abonos/{id?}', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'abonos'])->name('ordendetrabajo.abonos');
            Route::POST('/ordendetrabajo/addabono', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'addabono'])->name('ordendetrabajo.addabono');


            //actualizar lis servicios
            Route::post('/servicios/updateservicioorden', [App\Http\Controllers\Servicios\serviciosController::class, 'updateservicioorden'])->name('update.updateservicioorden');
            Route::post('/servicios/iniciarservicio', [App\Http\Controllers\Servicios\serviciosController::class, 'iniciarservicio'])->name('update.iniciarservicio');
            Route::get('/servicios/historial/{id?}', [App\Http\Controllers\Servicios\serviciosController::class, 'hisotiralservicios'])->name('historialservicios');

            //actualizar los repuestos
            Route::post('/repuestos/updaterepuestosorden', [App\Http\Controllers\Repuestos\repuestosController::class, 'updatesolicitados'])->name('update.updaterepuestosorden');
            Route::get('/repuestos/historial/{id?}', [App\Http\Controllers\Repuestos\repuestosController::class, 'historialrepuestos'])->name('historialrepuestos');


            //IMPRIMIR
            Route::get('/imprimir/imprimirservicios/{id?}', [App\Http\Controllers\Configuraciones\ConfigController::class, 'imprimirservicios'])->name('imprimirservicios');

            Route::get('/imprimir/ot/{id?}', [App\Http\Controllers\Ordendetrabajo\ordendetrabajoController::class, 'imprimirot'])->name('imprimirot');


            

//crear equipo
// create.equipo
Route::post('/equipos/store', [App\Http\Controllers\Equipos\equipoController::class, 'store'])->name('equipos.store');
            
        });
