{{-- @extends('layouts.app') --}}
@extends('layouts.sidebar')

@section('content')
    <!-- content -->
    <div class="titulos">
        <h2>Servicios</h2>
        <hr />

    </div>

    @if (session('mensaje'))
        <div class="alert alert-success">
            {{ session('mensaje') }}
        </div>
    @endif
    <div class="container-fluid botones-extremo ">

  @if(\App\Models\User::tipoUsuario() != "operario")

        <div class="d-flex justify-content-between">
            <a href="{{ route('servicios.crear') }}" class=" btn  btn-success" title="">Nuevo</a>


        </div>
        @endif
    </div>

    <div class="container-fluid table-responsive">
        <div class="row">
            <div class="col bttn-buscar">
                <input type="text" class="form-control" placeholder="Buscar" id="buscarservicios">
            </div>
        </div><br>

        {{-- INICIO TABLA --}}
        <div class="table-responsive mb-5">
            <table class="table table-striped table-hover" id="mitable">
                <thead class="color-head">
                    {{-- id	nombre_servicio	descripcion	sku	precio_neto	iva	eliminado	estado	categorias_id --}}
                    <tr>
                        <th class="th-subhead border-th">NOMBRE</th>
                        <th class="th-subhead border-th">CATEGORIA</th>

                        <th class="th-subhead border-th separador-v">SKU</th>
                        <th class="th-subhead border-th">NETO</th>
                        <th class="th-subhead border-th separador-v">IVA</th>
                        <th class="th-subhead border-th separador-v">TOTAL</th>


                        {{-- <th class="th-subhead border-th">Comuna</th> --}}
                        <th class="th-subhead border-th"></th>
                    </tr>
                </thead>
                <tbody id="tableservicios"></tbody>
                <tbody id="tableserviciosGeneral">
                    <tr>
                        {{-- <td class="td-val">a</td> --}}


                    </tr>
                    {{-- {{$usuarios}} --}}
                    {{-- [{"id_usuariio":2
              "id":1
              "nombre":"ariel"
              "apellido":"alejandro"
              "rut":"1-9"
              "fecha_nacimiento":"marzo"
              "direccion":"talca"
              "telefono":"53425865"
              "nacionalidades_id":1
              "direcciones_id":1
              "des_comuna":"Arica"
              "des_region":"Arica y Parinacota"}] --}}


                    @if (!empty($servicios))
                        @foreach ($servicios as $los_datos)
                            <tr>
                                <td class="td-val">{{ $los_datos->nombre_servicio }}</td>
                                <td class="td-val">{{ $los_datos->nombre_categoria }}</td>

                                <td class="td-val">{{ $los_datos->sku }}</td>
                                <td class="td-val">{{ \App\Models\config::formatNumberWithCommas($los_datos->precio_neto) }}</td>
                                <td class="td-val">{{ \App\Models\config::formatNumberWithCommas($los_datos->impuesto) }}</td>


                           
                                <td class="td-val">{{ \App\Models\config::formatNumberWithCommas($los_datos->precio_neto+  $los_datos->impuesto ) }}</td>

                                
                                {{-- <td class="td-val">{{$los_datos->des_comuna}}</td> --}}

                                <td class="td-val">
                                    <a href="{{ route('servicios.editar', ['id' => $los_datos->id]) }}" >
                                        <span class="material-symbols-outlined">
                                          edit
                                          </span>
                                    </a>
                                      <a>
                                        <span class="material-symbols-outlined" onclick="abrirModalEliminar({{$los_datos->id}})">
                                          delete
                                          </span>
                                        </a>
                                    

                                </td>


                            </tr>
                        @endforeach
                    @endif
                </tbody>

            </table>
            {{ $servicios->links('pagination::bootstrap-4') }}

        </div>


        {{-- FIN TABLA --}}
        {{-- {{ $serviciosAll }} --}}
    </div>
<!-- The Modal -->
<div class="modal" id="modalEliminar">
    <div class="modal-dialog">
      <div class="modal-content">
  
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Eliminar</h4>
          <button type="button" class="btn-close" data-bs-dismiss="modal" onclick="cerrarModal()"></button>
        </div>
  
        <!-- Modal body -->
        <div class="modal-body" style="text-align: center">
  
          <h3>
         ¿Esta seguro que desea eliminar el registro?
  
          </h3>
  
        </div>
  
        <!-- Modal footer -->
        <div class="modal-footer">
          <form action="{{ route('servicios.delet') }}" method="POST">
  
            @csrf
                <input type="text" hidden name="idservicio" value="" id="idservicio" >
               <button type="submit" class="btn btn-success" onclick="cerrarModal()">Eliminar</button>
  
              </form>
  
          <button type="button" class="btn btn-danger" onclick="cerrarModal()">Cerrar</button>
        </div>
  
      </div>
    </div>
  </div>
    <script>
          function abrirModalEliminar(idServicio){

            $("#idservicio").val(idServicio);
            $("#modalEliminar").show();

            }

            function cerrarModal(){

            $("#modalEliminar").hide();

            }


        $(document).ready(function() {

            $('#buscarservicios').on('keyup', function() {
                var valorIngresado = $(this).val();
                var data = @json($serviciosAll);

                resultadoServicios = $.grep(data, function(servicio) {
                    // Comparar el nombre y el SKU en minúsculas para que la búsqueda sea insensible a mayúsculas/minúsculas
                    var nombreLowerCase = servicio.nombre_servicio.toLowerCase();
                    var skuLowerCase = servicio.sku.toLowerCase();
                    var letraBusqueda = valorIngresado.toLowerCase();

                    return nombreLowerCase.includes(letraBusqueda) || skuLowerCase.includes(
                        letraBusqueda);
                });

                $('#tableservicios').empty();
                $('#tableserviciosGeneral').css("display","none");
                if (valorIngresado != "") {

                    $(resultadoServicios).each(function(i, v) {
                        $('#tableservicios').append(
                            '<tr><td>'  + v.nombre_servicio.toUpperCase() + '</td>'
                            +'<td>'+v.nombre_categoria+'</td>'  

                            +'<td>'+v.sku+'</td>'  
                            +'<td>'+formatNumberWithCommas(v.precio_neto)+'</td>'  
                            +'<td>'+formatNumberWithCommas(v.impuesto)+'</td>'  
                            +'<td>'+formatNumberWithCommas(v.precio_bruto)+'</td>'  

                            + '<td>' + '<a  style="cursor:pointer" onclick="editarBuscador('+"'"+v.id+"'"+')"><span class="material-symbols-outlined">edit</span></a>' 

                        +  '<a  style="cursor:pointer"  onclick="abrirModalEliminar('+"'"+v.id+"'"+')"><span class="material-symbols-outlined">delete</span></a>'  + '</td>'


                        +'</tr>');
                    })
                } else {
                $("#tableserviciosGeneral").css("display","");

                    $('#tableservicios').empty();

                }

            });

            // Nombre	sku	Precio neto	impuesto	Categoria

        });


        function editarBuscador(idServicio){


// Reemplaza esto con tu lógica para obtener el ID del usuario
   var urlEditarServicio = @json(route('servicios.editar')) + '/' + idServicio;

   // Redirige a la URL generada en la misma pantalla
   window.location.href = urlEditarServicio;
}
    </script>
@endsection
