{{-- @extends('layouts.app') --}}
@extends('layouts.sidebar')

@section('content')
    <!-- content -->
    <div class="titulos">
        <h2>Repuestos</h2>
        <hr />

    </div>

    @if (session('mensaje'))
        <div class="alert alert-success">
            {{ session('mensaje') }}
        </div>
    @endif
    <div class="container-fluid botones-extremo ">
        <div class="d-flex justify-content-between">
            <button type="button" class="btn btn-primary"  onclick="nuevoRepuesto()">
              NUEVO
              </button>

        </div>
    </div>

    <div class="container-fluid table-responsive">
        <div class="row">
            <div class="col bttn-buscar">
                <input type="text" class="form-control" placeholder="Buscar" id="buscarRepuestos">
            </div>
        </div>

        {{-- INICIO TABLA --}}
        <div class="table-responsive mb-5">
            <table class="table table-striped table-hover" id="mitable">
                <thead class="color-head">
                    {{-- id	nombre_servicio	descripcion	sku	precio_neto	iva	eliminado	estado	categorias_id --}}
                    <tr>
                        <th class="th-subhead border-th">Nombre</th>
                        <th class="th-subhead border-th separador-v">Categoria</th>
                       
                        {{-- <th class="th-subhead border-th">Comuna</th> --}}
                        <th class="th-subhead border-th"></th>
                    </tr>
                </thead>
                <tbody id="tableRepuestos"></tbody>
                <tbody id="tableRepuestosGeneral">
                    
                
                    @if (!empty($repuestos))
                        @foreach ($repuestos as $los_datos)
                            <tr>
                                <td class="td-val">{{$los_datos->nombre}}</td>
                                <td class="td-val">{{$los_datos->nombre_categoria}}</td>
                                <td class="td-val">

                                    <a onclick="Buscador({{$los_datos}})" >
                                        <span class="material-symbols-outlined">
                                          edit
                                          </span>
                                    </a>
          
                                    

                                </td>


                           




                            </tr>
                        @endforeach
                        {{ $repuestos->links('pagination::bootstrap-4') }}
                    @endif
                </tbody>

            </table>

        </div>


        {{-- FIN TABLA --}}
        {{-- {{ $RepuestosAll }} --}}
    </div>



    <!-- The Modal -->
<div class="modal" id="myModalcreate">
    <div class="modal-dialog">
      <div class="modal-content">
  
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Repuestos</h4>
          <button type="button" class="btn-close" data-bs-dismiss="modal" onclick="cerrarmodal()"></button>
        </div>
        <form action="{{route('repuestos.store')}}" method="POST">  
            @csrf

        <!-- Modal body -->
        <div class="modal-body">

           

                    <div>
                        <label for="">Nombre</label>
                        <input type="text" required  name="nombre_repuestos" id="nombre_repuestos" class="form-control">
                        <input type="text" required  style="display: none"  name="editarrepuesto" id="editarrepuesto" class="form-control">

                    </div>

                    <div>
                        <label for="">Categoria</label>
                        <select name="idcategoria" required class="form-control" id="idcategoria" >

                            <option value="" class="" >Seleccionar</option>
                            @foreach($categorias as $data)
                            <option  value="{{$data->id}}" >{{$data->nombre}}</option>

                        @endforeach


                        </select>
                    </div>
                
        </div>
  
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="submit" class="btn btn-success" data-bs-dismiss="modal">Guardar</button>
        </div>
    </form>
      </div>
    </div>
  </div>


    <script>

function editarBuscador(nombre,idRepuesto,idcategoria){

    $("#nombre_repuestos").val(nombre);
$("#idcategoria").val(idcategoria);
$("#editarrepuesto").val(idRepuesto);
$("#myModalcreate").show();

}

function nuevoRepuesto(data){
    $("#myModalcreate").show();
    $("#nombre_repuestos").val("");
$("#idcategoria").val("");
$("#editarrepuesto").val("no");

    
}
function Buscador(data){
console.log(data);

$("#nombre_repuestos").val(data.nombre);
$("#idcategoria").val(data.id_categoria);
$("#editarrepuesto").val(data.id);


$("#myModalcreate").show();



}
function cerrarmodal(data){
    $("#myModalcreate").hide();
    $("#nombre_repuestos").val();
$("#editarrepuesto").val();

$("#idcategoria").val();
}

function eliminar(data){
console.log(data);
    
}

        $(document).ready(function() {

            $('#buscarRepuestos').on('keyup', function() {
                var valorIngresado = $(this).val();
                var data = @json($repuestosAll);
                console.log("datasssssss");

                console.log(data);

                resultadoRepuestos = $.grep(data, function(servicio) {
                    // Comparar el nombre y el SKU en minúsculas para que la búsqueda sea insensible a mayúsculas/minúsculas
                    var nombreLowerCase = servicio.nombre.toLowerCase();
                    var skuLowerCase = servicio.nombre_categoria.toLowerCase();
                    var letraBusqueda = valorIngresado.toLowerCase();

                    return nombreLowerCase.includes(letraBusqueda) || skuLowerCase.includes(
                        letraBusqueda);
                });

                $('#tableRepuestos').empty();
                $('#tableRepuestosGeneral').css("display","none");
                if (valorIngresado != "") {

                    $(resultadoRepuestos).each(function(i, v) {
                        $('#tableRepuestos').append(
                            '<tr><td>'+v.nombre+'</td>'  
                            +'<td>'+v.nombre_categoria+'</td>'  

                             
                            + '<td>' + '<a onclick="editarBuscador(' +"'"+ v.nombre+"',"+v.id+","+ v.id_categoria+ ')"><span class="material-symbols-outlined">edit</span></a>' + '</td>'


                            
                            +'</tr>');
                    })
                } else {
                $("#tableRepuestosGeneral").css("display","");

                    $('#tableRepuestos').empty();

                }

            });

            // Nombre	sku	Precio neto	impuesto	Categoria

        });
    </script>
@endsection
