{{-- @extends('layouts.app') --}}
@extends('layouts.sidebar')

@section('content')
    <!-- content -->

    {{-- {{ $repuestos }} --}}
    <style>
        .narrow-input {
            width: 30px;
            /* Puedes ajustar este valor según tus necesidades */
            text-align: center;

        }

        .material-symbols-outlined {
            font-size: 15px;
            /* Puedes ajustar este valor según tus preferencias */
            cursor: pointer;
        }
         #modalDescuento {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            margin: 0;
  }
    </style>
    <div class="titulos">
        <h2>Nuevo OT
            <hr />

    </div>

    <div class="container">
        @if(session('mensaje'))
        <div class="alert alert-success">
            {{ session('mensaje') }}
        </div>
    @endif
        <form action="{{ route('ordendetrabajo.store') }}" method="POST">
            @csrf

            <input type="text" hidden name="id_cliente" value="{{ $idCliente ?? '' }}">
            <div class="row card">
                <div class="card-header">
                    Datos del cliente
                </div>
                {{-- datos personales --}}
                <div class="row">
                    <div class="mb-3 col-6">
                        <label for="razon_social" class="form-label">Razon Social</label>
                        <input type="text" required class="form-control" id="razon_social"
                            value="{{ $cliente[0]->razon_social ?? '' }}" disabled placeholder="" name="razon_social">

                    </div>
                    <div class="mb-3 col-6">
                        <label for="" class="form-label">Rut</label>
                        <input type="text" value="{{ $cliente[0]->rut ?? '' }}" disabled required class="form-control"
                            id="" placeholder="" name="">

                    </div>

                    <div class="mb-3 col-12">
                        <label for="" class="form-label">Seleccionar equipo</label>
                        <a onclick="addModelo({{$idCliente}})">
                            <span class="material-symbols-outlined">
                                add_circle
                            </span>
                        </a>
                        <select  class="form-control mayuscula" name="seleccionaequipo" id="seleccionaequipo">
                            <option value="">Seleccionar</option>
                            @if (!empty($equipos))
                                @foreach ($equipos as $data)
                                    <option value="{{ $data->id }}" >
                                        {{ $data->descripcion }}</option>
                                @endforeach
                            @endif
                        </select>

                    </div>
                    
                    <div class="mb-3 col-6">
                        <label for="" class="form-label">Correo</label>
                        <input type="text" value="{{ $cliente[0]->correo ?? '' }}" disabled required class="form-control"
                            id="" placeholder="" name="">

                    </div>
                    <div class="mb-3 col-6">
                        <label for="" class="form-label">Telefono</label>
                        <input type="text" value="{{ $cliente[0]->telefono ?? '' }}" disabled required
                            class="form-control" id="" placeholder="" name="">

                    </div>
                    <hr>
                    <strong><label for="">Ejecutar orden</label></strong>
                    <hr>
                    <div class="mb-3 col-6">
                        <label for="" class="form-label">Operario encargado</label>
                        <select required class="form-control mayuscula" name="operario" id="operario">
                            <option value="">Seleccionar</option>
                            @if (!empty($operarios))
                                @foreach ($operarios as $data)
                                    <option value="{{ $data->id_user }}"
                                        {{ old('operario') == $data->id_user ? 'selected' : '' }}>{{ $data->nombre }}
                                        {{ $data->apellido }}</option>
                                @endforeach
                            @endif
                        </select>

                    </div>


                    <div class="mb-3 col-6">
                        <label for="" class="form-label">Fecha entrega</label>
                        <input type="date" value="{{ $cliente[0]->fecha_entrega ?? '' }}" required class="form-control"
                            id="" placeholder="" name="fecha_entrega">
                    </div>

                    <div class="mb-3 col-13">
                        <label for="" class="form-label">Comentario</label>

                        <textarea name="comentario" class="form-control" id="" cols="3" rows="3"></textarea>

                    </div>



                </div> {{-- fin del row --}}

            </div> {{-- fin del card --}}



            {{-- DATOS DE SERVICIOS         --}}
            <br>
            <div class="row card mb-3 ">
                <div class="card-header mb-3 ">
                    Servicios
                </div>
                <div class="row">

                    <div class="col-12 form-group">
                        <label for="">Servicio</label>
                        <input type="" class="form-control mayuscula" id="nombre_servicio" placeholder="Servicio"
                            name="" value="">
                    </div>
                    <div class="col-12 form-group" id="">
                        <table class="table table-hover">
                            <tbody id="tableservicios"></tbody>
                        </table>
                    </div>


                    <div>
                        <table class="table2 table-hover">
                            <thead class="bg-light">
                                <th scope="col">Servicios</th>
                                <th scope="col">Descripcion</th>
                                <th scope="col">cantidad</th>
                                <th scope="col">Neto</th>
                                {{-- <th scope="col">Descuento</th> --}}
                                <th scope="col">Total</th>

                                <th scope="col">Acciones</th>


                            </thead>

                            <tbody id="tabla_servicios_selecionados">

                            </tbody>
                        </table>
                        <input type="text" hidden id="arrayDatosTabla" name="arrayDatosTabla">
                    </div>

                </div>{{-- fin del row --}}
            </div>{{-- fin del card --}}



            {{-- DATOS DE REPUESTOS         --}}

            <div class="row card mb-3 ">
                <div class="card-header mb-3 ">
                    Repuestos
                </div>
                <div class="row">

                    <div class="col-12 form-group">
                        <label for="">Repuestos solicitados</label>
                        <input type="" class="form-control mayuscula" id="nombre_repuesto"
                            placeholder="Repuestos solicitados" name="" value="">
                    </div>
                    <div class="col-12 form-group" id="">
                        <table class="table table-hover">
                            <tbody id="tablerepuestos"></tbody>
                        </table>
                    </div>


                    <div>
                        <table class="table table-hover">
                            <thead class="bg-light">
                                <th scope="col">Repuesto</th>
                                <th scope="col">Categoria</th>
                                <th scope="col">cantidad</th>


                                <th scope="col">Acciones</th>


                            </thead>

                            <tbody id="tabla_repuesto_selecionados">

                            </tbody>
                        </table>
                        <input type="" hidden  id="arrayDatosTablaRepuestos" name="arrayDatosTablaRepuestos">
                    </div>

                </div>{{-- fin del row --}}
            </div>{{-- fin del card --}}


            {{-- DATOS DE PAGO        --}}

            <div class="row card mb-3 ">
                <div class="card-header mb-3 ">
                    Datos Pago
                </div>
                <div class="row">


                    <div>
                        <strong> <label for="">Neto:</label> </strong> <label for=""
                            id="l_neto"></label>
                    </div>

                    <div>
                        <strong>
                            <label for="">Descuento(%):
                                <a data-bs-toggle="modal" data-bs-target="#modalDescuento" >
                                    <span class="material-symbols-outlined">
                                        edit
                                    </span>
                                </a>

                            </label>
                        </strong>
                        <label for="" id="l_descuento"></label>
                    </div>
                    <div>
                        <strong> <label for="">Descuento total:</label> </strong> <label for=""
                            id="l_descuentoTotal"></label>
                    </div>
                    <div>
                        <strong>
                            <label for="">Abono:</label>
                            <a data-bs-toggle="modal" data-bs-target="#modalAbono" >
                                <span class="material-symbols-outlined">
                                    edit
                                </span>
                            </a>
                        </strong>
                        <label for="" id="l_abono"></label>
                    </div>

                    <div>
                        <strong> <label for="">Total:</label> </strong> <label for=""
                            id="l_total"></label>
                    </div>
                </div>{{-- fin del row --}}
            </div>{{-- fin del card --}}



            <div style="text-align: right">
                <button type="submit" class="btn btn-danger">Volver</button>

                <button type="submit" class="btn btn-success">Guardar</button>
            </div>

        {{-- DATOS POR ENVIAR --}}
        <input type="text" hidden name="input_abono" id="input_abono">
        <input type="text" hidden name="input_descuento" id="input_descuento">
        <input type="text" hidden name="input_metodopago" id="input_metodopago">


        </form>{{-- INICIO FORMULARIO --}}







    </div> {{-- FIN container --}}

    {{-- MODAL --}}



    <!-- Modal Descuento -->
<div class="modal" id="modalDescuento">
    <div class="modal-dialog">
      <div class="modal-content">

        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Descuento Porcentaje</h4>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <!-- Modal body -->
        <div class="modal-body">
         <div class="m-2">
            <input type="number" class="form-control" value="" id="porcentajeAplicado">

         </div>
         <div class="m-2" style="text-align: right">
            <button type="button" class="btn btn-success" data-bs-dismiss="modal" onclick="aplicarDescuento();" >Aplicar</button>

         </div>
        </div>
      </div>
    </div>
  </div>
{{-- MODAL ABONO --}}
  <div class="modal" id="modalAbono">
    <div class="modal-dialog">
      <div class="modal-content">

        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Abono</h4>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <!-- Modal body -->
        <div class="modal-body">
         <div class="m-2">
            <label for="">Total</label>

            <input type="number" class="form-control" value="" id="abono">

         </div>
         <div class="m-2">
            <label for="">Medio de pago</label>
            <select name="" class="form-control" id="mediosPagosSelect">
                <option value="">Seleccionar</option>
                @if (!empty($medios_pagos))
                    @foreach ($medios_pagos as $data)
                        <option value="{{ $data->id }}"
                            {{ old('operario') == $data->id ? 'selected' : '' }}>{{ $data->descripcion }}
                            {{ $data->apellido }}</option>
                    @endforeach
                @endif
            </select>

         </div>
         <div class="m-2" style="text-align: right">
            <button type="button" class="btn btn-success" data-bs-dismiss="modal" onclick="aplicarAbono();" >Aplicar</button>

         </div>
        </div>



      </div>
    </div>
  </div>
   <!-- Modal Modelo -->
   <div class="modal" id="modaladdequipo">
    <div class="modal-dialog">
      <div class="modal-content">
        {{-- // id	descripcion	modelo	marca	motor	ano	serie	combustible_id	clientes_id	 --}}

        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">Nuevo equipo</h4>
          <button type="button" class="btn-close"  onclick="cerrarmodalModel();"></button>
        </div>
        <form action="{{ route('equipos.store') }}" method="POST">
            @csrf

        <!-- Modal body -->
        <div class="modal-body">


         <div class="m-2">
            <label for="">Descripcion</label>
            <input type="text" required name="descripcion" class="form-control" value="" id="">
         </div>
         <div class="m-2">
            <label for="">Modelo</label>
            <input type="text" required name="modelo" class="form-control" value="" id="">
         </div>
         <div class="m-2">
            <label for=""> Marca</label>
            <input type="text" required name="marca" class="form-control" value="" id="">
         </div>
         <div class="m-2">
            <label for="">Motor</label>
            <input type="text" required name="motor" class="form-control" value="" id="">
         </div>
         <div class="m-2">
            <label for="">Año</label>
            <input type="number" required name="ano" class="form-control" value="" id="">
         </div>
         <div class="m-2">
            <label for="">Serie</label>
            <input type="text" required name="serie" class="form-control" value="" id="">
         </div>
         <div class="m-2">
            <label for="">combustible</label>
            <select  class="form-control mayuscula" required name="combustible" id="combustible">
                <option value="">Seleccionar</option>
                @if (!empty($combustibles))
                    @foreach ($combustibles as $data)
                        <option value="{{ $data->id }}" >
                            {{ $data->nombre }}</option>
                    @endforeach
                @endif
            </select>       
          </div>
          <div class="m-2">
 
            <input type="text" required name="idcliente" class="form-control" value="" id="idclientes">
         </div>

         <div class="m-2" style="text-align: right">
            <button type="submit" class="btn btn-success" data-bs-dismiss="modal" onclick="aplicarDescuento();" >Guardar</button>

         </div>

       

         </form>
        </div>
      </div>
    </div>
  </div>

    <script>
        //VARIABLES GLOBALES
        var resultadoServicios = "";
        var resultadoServiciosSeleccionados = [];
        var resultadoRepuestos = "";
        var resultadoRepuestosSeleccionados = [];
        var totalNetoCompra=0;
        var TotalCompra=0;
        var TotalPorcentajeCompra =0;
        var TotalPorcentajeDescuento=0;
        var totalAbono=0;
        var metodoDePago="";


        function addModelo(idcliente){
            $("#idclientes").val(idcliente);
            $('#modaladdequipo').show();

            
        }
        function cerrarmodalModel(){
            $('#modaladdequipo').hide();


            
        }

        function filtrarElementosQueComienzanConA(elemento) {
            return elemento.nombre.startsWith('a');
        }

        $(document).ready(function() {

            $("#mediosPagosSelect").change(function () {
            // Obtener el valor seleccionado
            metodoDePago = $(this).val();

            // Realizar alguna acción con el valor seleccionado
            // console.log("Valor seleccionado: " + selectedValue);
            // Puedes hacer lo que necesites con el valor seleccionado aquí
        });

            // Agrega un manejador de eventos para el evento keyup
            $('#nombre_repuesto').on('keyup', function() {
                // Obtiene el valor del campo de entrada
                var valorIngresado = $(this).val();

                var data = @json($repuestos);


                // Obtener el texto de búsqueda por teclado
                // var valorIngresado = prompt("Ingrese una letra para buscar servicios:");

                // Filtrar los elementos por nombre o SKU que contengan la letra ingresada
                resultadoRepuestos = $.grep(data, function(servicio) {
                    // Comparar el nombre y el SKU en minúsculas para que la búsqueda sea insensible a mayúsculas/minúsculas
                    var nombreLowerCase = servicio.nombre.toLowerCase();
                    var skuLowerCase = servicio.categoria.toLowerCase();
                    var letraBusqueda = valorIngresado.toLowerCase();

                    return nombreLowerCase.includes(letraBusqueda) || skuLowerCase.includes(
                        letraBusqueda);
                });


                $('#tabla_repuesto_selecionados').empty();

                if (valorIngresado != "") {

                    $(resultadoRepuestos).each(function(i, v) {
                        $('#tabla_repuesto_selecionados').append(
                            '<tr><td class="agregar" onclick="agregarRepuesto(' + v.id + ')">' +
                            v
                            .nombre + '</td></tr');
                    })
                } else {
                    $('#tabla_repuesto_selecionados').empty();

                }
                // console.log(resultadoServicios);


            });

            /// mostrar los servivios


            // Agrega un manejador de eventos para el evento keyup
            $('#nombre_servicio').on('keyup', function() {
                // Obtiene el valor del campo de entrada
                var valorIngresado = $(this).val();

                var data = @json($servicios);


                // Obtener el texto de búsqueda por teclado
                // var valorIngresado = prompt("Ingrese una letra para buscar servicios:");

                // Filtrar los elementos por nombre o SKU que contengan la letra ingresada
                resultadoServicios = $.grep(data, function(servicio) {
                    // Comparar el nombre y el SKU en minúsculas para que la búsqueda sea insensible a mayúsculas/minúsculas
                    var nombreLowerCase = servicio.nombre_servicio.toLowerCase();
                    var skuLowerCase = servicio.sku.toLowerCase();
                    var letraBusqueda = valorIngresado.toLowerCase();

                    return nombreLowerCase.includes(letraBusqueda) || skuLowerCase.includes(
                        letraBusqueda);
                });

                $('#tableservicios').empty();

                if (valorIngresado != "") {

                    $(resultadoServicios).each(function(i, v) {
                        $('#tableservicios').append(
                            '<tr><td class="agregar" onclick="agregar2(' + v.id + ')">' + v
                            .nombre_servicio + '</td></tr');
                    })
                } else {
                    $('#tableservicios').empty();

                }
                // console.log(resultadoServicios);


            });





        });

        function eliminarFilaRepuesto(dataId) {
            const buscarRepuesto = resultadoRepuestosSeleccionados.findIndex(objeto => objeto.id === dataId);

            if (buscarRepuesto !== -1) {
                // Si el objeto con "id" 5 existe, eliminarlo
                resultadoRepuestosSeleccionados.splice(buscarRepuesto, 1);
                calcularTotalTableRepuestos();
            }
        }

        function eliminarFilaServicio(dataId) {
            const buscarServicio = resultadoServiciosSeleccionados.findIndex(objeto => objeto.id === dataId);

            if (buscarServicio !== -1) {
                // Si el objeto con "id" 5 existe, eliminarlo
                resultadoServiciosSeleccionados.splice(buscarServicio, 1);
                calcularTotalTable();
            }
        }


        function agregarRepuesto(data) {

            $('#tablerepuestos').empty();
            $('#nombre_repuesto').val("");




            // console.log(resultadoServicios);
            const repuestoSeleccionado = resultadoRepuestos.find(objeto => objeto.id === data);

            repuestoSeleccionado.cantidad = 1;
            // servicioSeleccionado.total= servicioSeleccionado.precio_neto * 1;
            //guardamos en un array

            console.log("aaaaa Revisar::");
            console.log(repuestoSeleccionado.id);

            const buscarRepuesto = resultadoRepuestosSeleccionados.find(objeto => objeto.id === repuestoSeleccionado.id);

            if (buscarRepuesto) {

                buscarRepuesto.cantidad = buscarRepuesto.cantidad + 1;
            } else {
                resultadoRepuestosSeleccionados.push(repuestoSeleccionado);

            }

            calcularTotalTableRepuestos();
            // $('#tabla_servicios_selecionados').append('<tr><td>' + servicioSeleccionado.nombre_servicio + '</td></tr>');

            //console.log(repuestoSeleccionado);
        }


        function agregar2(data) {
            $('#tableservicios').empty();
            $('#nombre_servicio').val("");




            console.log(resultadoServicios);
            const servicioSeleccionado = resultadoServicios.find(objeto => objeto.id === data);

            servicioSeleccionado.cantidad = 1;
            // servicioSeleccionado.total= servicioSeleccionado.precio_neto * 1;
            //guardamos en un array

            const buscarServicio = resultadoServiciosSeleccionados.find(objeto => objeto.id === servicioSeleccionado.id);

            if (buscarServicio) {

                buscarServicio.cantidad = buscarServicio.cantidad + 1;
            } else {
                resultadoServiciosSeleccionados.push(servicioSeleccionado);

            }
            // resultadoServiciosSeleccionados.push(servicioSeleccionado);

            calcularTotalTable();
            // $('#tabla_servicios_selecionados').append('<tr><td>' + servicioSeleccionado.nombre_servicio + '</td></tr>');

            console.log(servicioSeleccionado);
        }


        function sumar_repuesto(data) {
            $.each(resultadoRepuestosSeleccionados, function(index, objeto) {
                if (objeto.id === data) {
                    objeto.cantidad = objeto.cantidad +
                        1; // Puedes establecer cualquier valor inicial para "cantidad"
                }
            });


            calcularTotalTableRepuestos();
        }

        function restar_repuesto(data) {
            $.each(resultadoRepuestosSeleccionados, function(index, objeto) {
                if (objeto.id === data) {

                    if (objeto.cantidad > 1) {
                        objeto.cantidad = objeto.cantidad - 1;
                    }
                    // Puedes establecer cualquier valor inicial para "cantidad"
                }
            });
            calcularTotalTableRepuestos();

        }

        //servicios
        function sumar(data) {
            $.each(resultadoServiciosSeleccionados, function(index, objeto) {
                if (objeto.id === data) {
                    objeto.cantidad = objeto.cantidad +
                        1; // Puedes establecer cualquier valor inicial para "cantidad"
                }
            });


            calcularTotalTable();
        }

        function restar(data) {
            $.each(resultadoServiciosSeleccionados, function(index, objeto) {
                if (objeto.id === data) {

                    if (objeto.cantidad > 1) {
                        objeto.cantidad = objeto.cantidad - 1;
                    }
                    // Puedes establecer cualquier valor inicial para "cantidad"
                }
            });
            calcularTotalTable();

        }

        function calcularTotalTableRepuestos() {
            $('#tabla_repuesto_selecionados').empty();

            console.log("resultadoRepuestosSeleccionados");
            console.log(resultadoRepuestosSeleccionados);

            $.each(resultadoRepuestosSeleccionados, function(index, objeto) {





                var tr = "<tr>";
                tr += "<td>" + objeto.nombre + "</td>";
                tr += "<td>" + objeto.categoria + "</td>";
                tr += "<td>" + "<input type='button' value='-'  onclick='restar_repuesto(" + objeto.id + ")' >" +
                    "<input type='text' class='narrow-input' value='" + objeto.cantidad +
                    "' id='valores_repuestos" + objeto
                    .id + "'>" + "<input type='button' onclick='sumar_repuesto(" + objeto.id + ")'  value='+'>" +
                    "</td>";

                tr += "<td>" + '<a  onclick="eliminarFilaRepuesto(' + objeto.id + ')"  >' + "Eliminar" + "</a>" +
                    "</td>";
                tr += "</tr>";

                $('#tabla_repuesto_selecionados').append(tr);

            });
            $('#arrayDatosTablaRepuestos').val(JSON.stringify(resultadoRepuestosSeleccionados));



        }

//CALCULOS

    function   aplicarAbono(){

        totalAbono=  $("#abono").val();
                // $("#l_descuento").text(descuentoPorcentaje+"%");
                calcularTotalTable();

            }

            function   aplicarDescuento(){

                 TotalPorcentajeDescuento=  $("#porcentajeAplicado").val();
                // $("#l_descuento").text(descuentoPorcentaje+"%");
                calcularTotalTable();

            }
        function calcularTotalTable() {
            $('#tabla_servicios_selecionados').empty();
            var total = 0;
            var neto = 0;


            $.each(resultadoServiciosSeleccionados, function(index, objeto) {


                objeto.total = objeto.precio_neto * objeto.cantidad;

                total = total + objeto.total;
                neto = neto + objeto.precio_neto * objeto.cantidad;



                var tr = "<tr>";
                tr += "<td>" + objeto.nombre_servicio + "</td>";
                tr += "<td>" + objeto.descripcion + "</td>";
                tr += "<td>" + "<input type='button' value='-'  onclick='restar(" + objeto.id + ")' >" +
                    "<input type='text' class='narrow-input' value='" + objeto.cantidad + "' id='valores" + objeto
                    .id + "'>" + "<input type='button' onclick='sumar(" + objeto.id + ")'  value='+'>" + "</td>";
                tr += "<td>" + objeto.precio_neto + "</td>";
                //  tr += "<td>" + 2+"</td>";
                tr += "<td>" + objeto.total + "</td>";
                tr += "<td>" + '<a  onclick="eliminarFilaServicio(' + objeto.id + ')"  >' + "Eliminar" + "</a>" +
                    "</td>";
                tr += "</tr>";

                $('#tabla_servicios_selecionados').append(tr);

            });
            $('#arrayDatosTabla').val(JSON.stringify(resultadoServiciosSeleccionados));




            //calculamos los totales

            // Calcular el descuento
            var descuento = (neto * TotalPorcentajeDescuento) / 100;


            // Calcular el nuevo precio después del descuento totalAbono
            var precioConDescuento = neto - descuento;


            //completamos los Label
            $("#l_neto").text(neto);

             $("#l_descuento").text(TotalPorcentajeDescuento+"%");
             $("#l_descuentoTotal").text(descuento);
             $("#l_abono").text(totalAbono);


             totalMenosDescuentos = total -  descuento  - totalAbono;
             $("#l_total").text(totalMenosDescuentos);

             //setiamos los pagos para enviarlos por el formulario
             $("#input_abono").val(totalAbono);
             $("#input_descuento").val(TotalPorcentajeDescuento);
             $("#input_metodopago").val(metodoDePago);

            // console.log(resultadoServiciosSeleccionados);

        }
    </script>
@endsection
