{{-- @extends('layouts.app') --}}
@extends('layouts.sidebar')

@section('content')
 <!-- content -->
<div class="titulos"> 
    <h2>Clientes</h2>
    <hr />

</div>

@if(session('mensaje'))
    <div class="alert alert-success">
        {{ session('mensaje') }}
    </div>
@endif
 <div class="container-fluid botones-extremo " >
    <div class="d-flex justify-content-between">
        <a href="{{ route('clientes.crear') }}" class=" btn  btn-success" title="" >Nuevo</a>
       
    </div>
</div>

 <div class="container-fluid table-responsive">
    <div class="row">
        <div class="col bttn-buscar">
            <input type="text" class="form-control" id="buscarData" placeholder="Buscar">
        </div>
    </div><br>
    
    {{--INICIO TABLA --}}
    <div class="table-responsive mb-5">
        <table class="table table-striped table-hover" id="mitable">
          <thead class="color-head">
          
            <tr>
              <th class="th-subhead border-th">Razón Social / Nombre</th>
              <th class="th-subhead border-th separador-v">RUT</th>
              <th class="th-subhead border-th">Teléfono</th>
              {{-- <th class="th-subhead border-th separador-v">Correo</th> --}}
              <th class="th-subhead border-th separador-v">Calle</th>

              <th class="th-subhead border-th">Región</th>
              <th class="th-subhead border-th">Comuna</th>
              <th class="th-head border-th" colspan="1"><span class="material-icons">Acciones</span></th>

            </tr> 
          </thead>
          <tbody id="tableClientes"></tbody>
          <tbody id="tableClientesGeneral">
            
             @foreach ($clientes as $los_datos)
              <tr>
                <td class="td-val">{{$los_datos->razon_social}}</td>
                <td class="td-val">{{$los_datos->rut}}</td>
                <td class="td-val">{{$los_datos->telefono}}</td>
                {{-- <td class="td-val">{{$los_datos->giro}}</td> --}}
                {{-- <td class="td-val">{{$los_datos->correo}}</td> --}}
                <td class="td-val">{{$los_datos->nombre_direccion}}</td>
                <td class="td-val">{{$los_datos->des_region}}</td>
                <td class="td-val">{{$los_datos->des_comuna}}</td>
                <td class="td-val">
                  {{-- href="{{route('ver.cliente',Crypt::encryptString($los_datos->id_cliente))}} " --}}
                  {{-- <a href="{{ route('ordendetrabajo.crear',Crypt::encryptString($los_datos->id_cliente))}}" style="cursor: pointer">
                    <span class="material-symbols-outlined" >
                      add
                      </span>
                         
                  </a> --}}
                  {{-- <a href="#">
                  <span class="material-symbols-outlined" >
                      sync
                  </span>
                  </a> --}}

                  <a href="{{ route('clientes.misservicios', ['id' => $los_datos->id_cliente,'opciones' => "CLIENTES"]) }}" >
                    <span class="material-symbols-outlined">
                      visibility
                      </span>
                </a>
                <a href="{{ route('clienteseditar', ['id' => $los_datos->id_cliente]) }}" >
                  <span class="material-symbols-outlined">
                    edit
                    </span>
              </a>

                  <a>
                    <span class="material-symbols-outlined" onclick="abrirModalEliminar({{$los_datos->id_cliente}})">
                      delete
                      </span>
                    </a>


                    
                
                                
                </td>
                

                
              </tr>
            @endforeach 

          </tbody>
        </table>
        {{ $clientes->links('pagination::bootstrap-4') }}

      </div>

    {{-- FIN TABLA --}}




</div>

<!-- The Modal -->
<div class="modal" id="modalEliminar">
  <div class="modal-dialog">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">Eliminar</h4>
        <button type="button" class="btn-close" data-bs-dismiss="modal" onclick="cerrarModal()"></button>
      </div>

      <!-- Modal body -->
      <div class="modal-body" style="text-align: center">

        <h3>
       ¿Esta seguro que desea eliminar el registro?

        </h3>

      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <form action="{{ route('clientes.delet') }}" method="POST">

          @csrf
              <input type="text" hidden  name="idcliente" value="" id="idcliente" >
             <button type="submit" class="btn btn-success" onclick="cerrarModal()">Eliminar</button>

            </form>

        <button type="button" class="btn btn-danger" onclick="cerrarModal()">Cerrar</button>
      </div>

    </div>
  </div>
</div>
<script>


function abrirModalEliminar(idcliente){

$("#idcliente").val(idcliente);
$("#modalEliminar").show();

}
function cerrarModal(){

$("#modalEliminar").hide();

}

  $(document).ready(function() {

      $('#buscarData').on('keyup', function() {
          var valorIngresado = $(this).val();
          var data = @json($todosLosClientesAll);
          console.log("data");

          console.log(data);

          resultadoServicios = $.grep(data, function(getdata) {
              // Comparar el nombre y el SKU en minúsculas para que la búsqueda sea insensible a mayúsculas/minúsculas
              
              razonSocial =  getdata.razon_social ?? "sin datos";
              rut =  getdata.rut ?? "sin datos";

              
              var nombreLowerCase = razonSocial.toLowerCase();
              var skuLowerCase = rut.toLowerCase();
              var letraBusqueda = valorIngresado.toLowerCase();

              return nombreLowerCase.includes(letraBusqueda) || skuLowerCase.includes(
                  letraBusqueda);
          }).slice(0, 20);;

          $('#tableClientes').empty();
          $('#tableClientesGeneral').css("display","none");
          if (valorIngresado != "") {
            console.log("resultadoServicios");
            console.log(resultadoServicios);

              $(resultadoServicios).each(function(i, v) {
                  $('#tableClientes').append(
                      '<tr><td>'  + v.razon_social.toUpperCase()  + '</td>'
                      +'<td>'+v.rut+'</td>'  
                      +'<td>'+v.telefono+'</td>'  
                      // +'<td>'+v.correo+'</td>'  
                      +'<td>'+v.nombre_direccion+'</td>'  
                      +'<td>'+v.des_region+'</td>'  
                      +'<td>'+v.des_comuna+'</td>'  
                      + '<td>' 
                      
                        + '<a  style="cursor:pointer" onclick="irmisordenes('+"'"+v.id_cliente+"'"+')"><span class="material-symbols-outlined">visibility</span></a>' 
                       + '<a  style="cursor:pointer" onclick="editarBuscador('+"'"+v.id_cliente+"'"+')"><span class="material-symbols-outlined">edit</span></a>' 

                      
                      +  '<a  style="cursor:pointer"  onclick="abrirModalEliminar('+"'"+v.id_cliente+"'"+')"><span class="material-symbols-outlined">delete</span></a>'  



                      +'</td>'  



                //       <a href="{{ route('clientes.misservicios', ['id' => $los_datos->id_cliente,'opciones' => "clientes"]) }}" >
                //     <span class="material-symbols-outlined">
                //       visibility
                //       </span>
                // </a>      
                      
                      +'</tr>');
              })
          } else {
          $("#tableClientesGeneral").css("display","");

              $('#tableClientes').empty();

          }

      });

      // Nombre	sku	Precio neto	impuesto	Categoria

  });

  
  function irmisordenes(idcliente){


// Reemplaza esto con tu lógica para obtener el ID del usuario
   var urlEditarcliente = @json(route('clientes.misservicios')) + '/' + idcliente+"?opciones=clientes";

   // Redirige a la URL generada en la misma pantalla
   window.location.href = urlEditarcliente;
}
  function editarBuscador(idcliente){


// Reemplaza esto con tu lógica para obtener el ID del usuario
   var urlEditarcliente = @json(route('clienteseditar')) + '/' + idcliente;

   // Redirige a la URL generada en la misma pantalla
   window.location.href = urlEditarcliente;
}
</script>
@endsection
