{{-- @extends('layouts.app') --}}
@extends('layouts.sidebar')

@section('content')
 <!-- content -->
<div class="titulos"> 
    <h2>Nuevo Servicio</h2>
    <hr />

</div>

<div class="container">
     
  <form action="{{route('servicios.store')}}" method="POST">  
    @csrf
    
     <div class="row card">
            <div class="card-header">
              Datos Servicio
            </div>
            {{-- datos personales --}}
        <div class="row">
            <div class="mb-3 col-6" >
              <label for="nombre" class="form-label">Nombre</label>
              <input type="text" required class="form-control" id="nombre" placeholder="" name="nombre">
              @error('nombre')
              <div class="alert alert-danger">{{ $message }}</div>
              @enderror
            </div>
            <div class="mb-3 col-6" >
              <label for="categoria" class="form-label">Categoria</label>
              <select required class="form-control mayuscula" name="categorias" id="categorias">


              @if(!empty($categorias))

              @foreach($categorias as $data)

            

                   
                         <option  value="{{$data->id}}" {{(old('categorias')==$data->id)? 'selected':''}}>{{$data->nombre}}</option>
                 
                  
              @endforeach
          @endif             
        </select>      
         @error('categoria')
              <div class="alert alert-danger">{{ $message }}</div>
              @enderror
            </div>
            <div class="mb-3 col-6" >
              
              <label for="precio" class="form-label">Precio</label>
              <input type="text" required class="form-control" id="precio" placeholder="" name="precio">
              @error('precio')
              <div class="alert alert-danger">{{ $message }}</div>
              @enderror
            </div>
           

            <div class="mb-3 col-6" >
              <label for="sku" class="form-label">Sku</label>
              <input type="text" required class="form-control" id="sku" placeholder="" name="sku">
              @error('sku')
              <div class="alert alert-danger">{{ $message }}</div>
              @enderror
            </div>



          
          <div class="mb-3 col-12" >
            <label for="descripcion" class="form-label">Descripcion</label>
            <textarea name="descripcion" id="" required cols="7" class="form-control" rows="7"></textarea>
            @error('descripcion')
            <div class="alert alert-danger">{{ $message }}</div>
            @enderror            
          </div>
         
       
        </div>          {{-- fin del row --}}

      </div>            {{-- fin del card --}}



        

        

        
          <div style="text-align: right">
            <button type="submit"  class="btn btn-danger">Volver</button>

            <button type="submit"  class="btn btn-success">Guardar</button>
          </div>
    
        </form>{{--INICIO FORMULARIO --}}
 
    
    
   

   

</div> {{-- FIN container --}}


<script>
  $(document).ready(function(){
    $(document).ready(function() {
      permitirSoloNumeros("#precio");
        });
      //traemos las comunas de la region seleccionada
   $("#correo").change(function(){
        validarCorreo();
    });



   //traemos las comunas de la region seleccionada
   $("#region").change(function(){
        buscar_comuna($("#region option:selected").val(),"#comuna");
    });

//Validar rut
$("#rut").change(function(){
    //esta funcion (checkRut) se encuentra en funciones.js
      var resultado = checkRut( $("#rut").val());
        if(resultado == "Rut incorrecto"){
            $("#rut").val('');
            $("#rut_span").css("display","")
        }else{
            $("#rut_span").css("display","none")
            validar_rut_usuarios($("#rut").val());
        }
    });

    //agregar digito al rut
    $('#rut').on('input', function() {
         $("#rut").val(add_guion_rut($("#rut").val()));
     });
     $('#rut_empresa').on('input', function() {
         $("#rut_empresa").val(add_guion_rut($("#rut_empresa").val()));
     });

  });
// Funciones normales
//validaCorreofunction 
function validarCorreo(){

  var correo = $("#correo").val();
  $.ajax({
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            url: "{{ route('validarcorreo.usuarios') }}",
            data: { 'correo': correo },
            success: function(data) {
               //1 rut existe
               console.log("existecorreouser");
               console.log(data);
               if(data == 1){
                  //   $("#rut").val('');
                    // $("#rut_span").css("display","")
                }else{
                    //$("#rut_span").css("display","none")
                }
            },
            error: function(xhr, status) {
                alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
            }
        });

}
    //buscar comuna
    function buscar_comuna(id_region, id_comunas, direccion = "") {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            url: "{{ route('buscar_comunas') }}",
            data: { 'id_region': id_region },
            success: function(data) {
              
                $(id_comunas).empty();
                $.each(data, function(id, comuna_nombre_array) {
                $(id_comunas).append('<option value=' + comuna_nombre_array.id + '>' + comuna_nombre_array.des_comuna + '</option>');
                });
            },
            error: function(xhr, status) {
                alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
            }
        });

    }

       //validar rut
       function validar_rut_usuarios(rut) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            type: 'GET',
            url: "{{ route('validarrut.usuarios') }}",
            data: { 'rut': rut },
            success: function(data) {
               //1 rut existe
               console.log("existerutuser");
               console.log(data);
               if(data == 1){
                     $("#rut").val('');
                     $("#rut_span").css("display","")
                }else{
                    $("#rut_span").css("display","none")
                }
            },
            error: function(xhr, status) {
                alert('Disculpe, Ha ocurrido un problema, Intente mas tarde');
            }
        });
    }

</script>

@endsection
